/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
**	void debug(fmt, args...)
**
**	causes the program to issue the
**	formatted (printf-style) write to stderr.
*/
#include <stdio.h>
#include <varargs.h>

/*VARARGS*/
void debug(va_alist)
va_dcl
{
	va_list		args;
	char		*fmt;
	extern char	*progname;
	extern int	DEBUG;

	if( DEBUG ) {
		if (progname != NULL)
		if (fprintf(stderr, "%s: ", progname) < 0)
			exit(7);
		va_start(args);
		fmt = va_arg(args, char *);
		(void) vfprintf(stderr, fmt, args);
		va_end(args);
	} /* if */
} /* debug */
