/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
**  system identification utility
**
**  issystem		(with no arguments) writes a generic system type name
**			to stdout and returns 0.  Generic types are
**			    sun
**			    cray
**			If no generic type is defined for this system,
**			nothing is written out and 1 is returned.
**
**  - this is how things used to work at BP. If we were on a Sun architecture
**    the machine was defined as a master. Anything else was a slave. This
**    has been modified in FreeUSP to incorporate the environment variable
**    SHADOWTYPE to define particular systems. Optimally, this could
**    define multiple values, requiring some parsing. For now, though, the
**    simple definition of 'master' on the system containing the master copy
**    of the source is sufficient.		- Joe M. Wade - 07/13/01

**  issystem keyword	returns 0 if keyword applies to the present system
**			and 1 if it does not.  (The current keyword-system
**			mapping is primitive and is completely controlled
**			by symbols defined in cpp(1).)  The current scheme
**			and the relevant cpp variables are:
**
**			    master  true if 'sun'
**			    remote  true if 'CRAY2'
**			    remote  true if '_HPUX'
**			    sun	    true if 'sun'
**			    sun3    true if 'sun' and 'mc68000'
**			    sun4    true if 'sun' and 'sparc'
**			    cray    true if 'CRAY2'
**			    cray    true if 'CRAYYMP'
**			    cray    true if 'CRAYXMP'
**			    cray    true if 'CRAYYEL'
**			    cray    true if 'CRAYXEA'
**			    cray2   true if 'CRAY2'
**			    crayymp true if 'CRAYYMP'
**			    crayxmp true if 'CRAYXMP'
**			    crayyel true if 'CRAYYEL'
**			    crayxea true if 'CRAYXEA'
**			    hp      true if 'HPUXSYSTEM' * from <localsys.h> *
**			    hpux    true if 'HPUXSYSTEM' 
*/
#include <stdio.h>
#include <localsys.h>

static char *genericsystem =
#ifdef sun
    "sun";
#else
#ifdef CRAYSYSTEM
    "cray";
#else
#ifdef HPUXSYSTEM
    "hp";
#else
#ifdef LINUXSYSTEM
    "linux";
#else
    "";
#endif
#endif
#endif
#endif

static char *keywords[] = {
#ifdef CRAYXMP
    "cray",
    "crayxmp",
    "remote",
#endif
#ifdef CRAYXEA
    "cray",
    "crayxea",
    "remote",
#endif
#ifdef CRAYYMP
    "cray",
    "crayymp",
    "remote",
#endif
#ifdef CRAYYEL
    "cray",
    "crayyel",
    "remote",
#endif
#ifdef CRAY2
    "cray",
    "cray2",
    "remote",
#endif
#ifdef HPUXSYSTEM
    "hp",
    "hpux",
    "remote",
#endif
#ifdef sun
#ifdef sparc
    "sun4",
#endif
#ifdef mc68000
    "sun3",
#endif
    "sun",
/*    "master",	*/	/* dropped in FreeUSP to use environment definition */
#endif
#ifdef LINUXSYSTEM
    "i686",
#endif
    NULL
};

int main(argc, argv)
int argc;
char *argv[];
{
    int i;
    char *keyword;

    if(argc < 2) {
	printf("%s\n", genericsystem);
	return (strlen(genericsystem) > 0 ? 0 : 1);
    }
    keyword  = (char *)getenv("SHADOWTYPE");
    if (keyword != NULL) {
	if (strcmp(argv[1],keyword) == 0) return 0;
	}

    for(i = 0; keywords[i] != NULL; i++)
	if(strcmp(argv[1], keywords[i]) == 0)
		return 0;
    return 1;
}
