/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
**	void curerror(rcode, fmt, args...)
**
**	causes the program to exit(rcode) after issuing the
**	formatted (printf-style) write to stderr.
*/
#include <stdio.h>
#include <varargs.h>
void exit();

/*VARARGS*/
void cuerror(va_alist)
va_dcl
{
    va_list         args;
    int             r;
    char           *fmt;
    extern char    *progname;

    if (progname != NULL)
	if (fprintf(stderr, "%s: ", progname) < 0)
	    exit(7);
    va_start(args);
    r = va_arg(args, int);
    fmt = va_arg(args, char *);
    (void) vfprintf(stderr, fmt, args);	/* use vfprintf, not just fprintf */
    va_end(args);
    exit(r);
}
