/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
**	void cumsg(fmt, args...)
**
**	causes the program to issue a
**	formatted (printf-style) write to stderr,
**	prepending progname, if it is available.
*/
#include <stdio.h>
#include <varargs.h>

/*VARARGS*/
void cumsg(va_alist)
va_dcl
{
    va_list         args;
    char           *fmt;
    extern char    *progname;

    if (progname != NULL)
	if (fprintf(stderr, "%s: ", progname) < 0)
	    exit(7);
    va_start(args);
    fmt = va_arg(args, char *);
    (void) vfprintf(stderr, fmt, args);	/* use vfprintf, not just fprintf */
    va_end(args);
}
