/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
**  return the total cpu time
**
**  doesn't currently account for child times.
*/
#include <cu.h>
#ifdef SUNSYSTEM
#include <sys/time.h>
#include <sys/resource.h>
#else
#ifdef CRAYSYSTEM
#include <sys/types.h>
#include <sys/times.h>
#include <sys/param.h>
#endif
#endif

double elapsedtime()
{
#if defined (SUNSYSTEM) && !defined (SOLARIS) 

    struct rusage use;
    getrusage(RUSAGE_SELF, &use);
    return		(use.ru_utime.tv_sec  + use.ru_stime.tv_sec )
	    + 1.0e-6 *	(use.ru_utime.tv_usec + use.ru_stime.tv_usec);

#else
#ifdef CRAYSYSTEM

    struct tms use;
    times(&use);
/*
   the cray c90 doesn't have HZ defined..
*/
#ifdef HZ
    return (use.tms_utime + use.tms_stime)/HZ;
#else
#ifdef HZ
    return (use.tms_utime + use.tms_stime)/OS_HZ;
#endif
#endif

#else
    cuerror(1, "elapsedtime: not implemented here.\n");
    return 0.0;
#endif
#endif
}
