/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
**	list structures and manifests - martin smith, 7/3/88
*/
#include <usystype.h>
/*
**	the list item value type: a list's entries can be either
**		pointers (untyped) or longs.  The latter is a
**		possible foolish concession to packing efficiency.
*/
typedef union {
	long longitem;
	VPTR ptritem;
} itemvalue_t;
/*
**	the list item: an ID (long) and a value (above).
**		ID's are unique in a list.  The list items
**		are stored in order of ascending ID.  This
**		ordering isd always maintained.
*/
typedef struct {
	long		itemid;
	itemvalue_t	itemvalue;
} listitem_t;
/*
**	the list type: includes
**		- a leading magic number
**		- a parent list pointer (or NULL)
**		- a private pointer for the application.
**
**	- itemtype is either ITEM_LONG or ITEM_POINTER.
**	- listtype is assigned and interpreted by the application.
**	- slots space is alloc'd in chunks.
*/
typedef struct list_t_struct {
	long			lsmagic;
	long			itemtype;
	long			listtype;
	struct list_t_struct	*parent;
	VPTR			unique;
	long			listlength;
	long			listslots;
	listitem_t		*listitems;
} list_t;

#include <list.h>
#define LIST_MAGIC (0xbaddab)
