/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
**	portable fork
**
**	if possible, this function should flush all output buffers
**	before forking.
*/
#include <localsys.h>
#include <fu_defs.h>

#ifdef SUNSYSTEM
/*
**	on the suns we just call their fortran-callable version
*/
long F_FORKFU()
{
	long fork_();
	return fork_();
}
#else
/*
**	on other systems we call plain old fork(2):
**		don't know what this will do to pending i/o.
*/
int F_FORKFU()
{
	int fork();
/*
**	should flush all i/o here:
*/
	return fork();
}
#endif
