/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/
/*
**	fortran integer function isenvfu( name )
**
**	returns 0 if name is not in the program's environment
**	returns 1 if it is.
**
**	note that this does not pass back a value string
**	which may be associated with name
*/
/*
        changed long declarations to int; these are NOT the same!
                                                - joe m. wade 5/26/95
*/
#include <stdio.h>
#include <localsys.h>
#include <fu_defs.h>

#ifndef CRAYSYSTEM

int F_ISENVFU( fname, flen )
char *fname;
int flen;
{
	char *getenv(), *u0f2cstr();
	char *name, *result;

	name = u0f2cstr( fname, flen );
	result = getenv( name );
	free( name );
	return ( name == NULL ) ? 0 : 1;
}

#else

#include <fortran.h>

int F_ISENVFU( fname )
_fcd fname;
{
	char *getenv(), *u0f2cstr();
	char *name, *result;

	name = u0f2cstr( fname );
	result = getenv( name );
	free( name );
	return ( name == NULL ) ? 0 : 1;
}
#endif
