c***********************************************************************
c                 copyright 2001, Amoco Production Company             *
c                             All Rights Reserved                      *
c                     an affiliate of BP America Inc.                  *
c***********************************************************************
c
#include <f77/localsys.h>
c
c	decode a real beginning at character first
c
c	on return
c	1 ==>	successful decode.  rval has the interpreted value
c		and next points to the first unused character
c		or one past the end of the string.
c	0 ==>	not a double value.  next and rval are unaltered.
c
#ifdef DEBUG
#ifdef HPSYSTEM
#define LER 7
#else
#define LER 0
#endif
#endif
	integer function isreal( s, first, next, rval )
	character*(*) s
	integer first, next
	real rval

	integer u0stodpr
	integer used
	double precision dtemp

#ifdef DEBUG
	write(LER,*) 'enter isreal'
#endif
	if( first .le. len( s ) ) then
		used = u0stodpr( s(first:), dtemp )
		if( used .gt. 0 ) then
#ifdef DEBUG
	write(LER,*) 'in isreal: used = ',used,', len = ',len(s)
#endif
			next = first + used
			rval = dtemp
#ifdef DEBUG
	write(LER,*) 'in isreal: arg is a number; value = ',dtemp
	write(LER,*) '                       real value = ',rval
#endif
			isreal = 1
		else
#ifdef DEBUG
	write(LER,*) 'in isreal: arg is not a number'
#endif
			isreal = 0
		end if
	else
#ifdef DEBUG
	write(LER,*) 'in isreal: arg is not a number'
#endif
		isreal = 0
	end if
#ifdef DEBUG
	write(LER,*) 'return from isreal'
#endif
	return
	end

