/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/

/*
**	portable fortran access to putenv(3)
*/
#include <usystype.h>
#include <fu_defs.h>

#ifndef CRAYSYSTEM

void F_PUTENVFU( fname, fnl )
char *fname;
long fnl;

#else

#include <fortran.h>

void F_PUTENVFU( fname )
_fcd fname;
#endif
{
	char *u0f2cstr(), *name;
	int putenv();
	char *emsg = "Putenv failed: out of memory?\n";

#ifndef CRAYSYSTEM
	name = u0f2cstr( fname, fnl );
#else
	name = u0f2cstr( fname );
#endif
	if( putenv( name ) != 0 ) {
		while( *emsg != '\0' )
			write( 2, emsg++, 1 );
	}
	return;
}
