/***********************************************************************
 *                copyright 2001, Amoco Production Company             *
 *                            All Rights Reserved                      *
 *                    an affiliate of BP America Inc.                  *
 ***********************************************************************/

/*
**	portable wait
**
**	we use the sun convention:
**		integer waitfu( status ) returns -
**			a positive pid as it's value and the child's
**				exit status in 'status'
**		or
**			the negative value of a (positive) system error
**				code as it's value and 'status' is 
**				not changed.
*/
/*
	changed long declarations to int; these are NOT the same!
						- joe m. wade 5/26/95
*/
#include <localsys.h>
#include <fu_defs.h>
#ifdef SUNSYSTEM
int F_WAITFU( statusp )
int *statusp;
/*
**	on the suns we just call their fortran-callable version
*/
{
	int wait_(), lstat, lret;
	lret = wait_( &lstat );
	if( lret >= 0 )
		*statusp = lstat;
	return lret;
}
#else

/*
 *	all non-sun machines...
 */ 
int F_WAITFU(statusp)
int *statusp;
{
	int wait(), lstat, lret;
	lret = wait( &lstat);
	if( lret >= 0 )
		*statusp = lstat;
	return lret;
}
#endif
