*#**********************************************************************

      SUBROUTINE CGECO(A,LDA,N,IPVT,RCOND,Z)                            00000010

      INTEGER LDA,N,IPVT(1)                                             00000020
      COMPLEX A(LDA,1),Z(1)                                             00000030
      REAL RCOND                                                        00000040
C                                                                       00000050
C     CGECO FACTORS A COMPLEX MATRIX BY GAUSSIAN ELIMINATION            00000060
C     AND ESTIMATES THE CONDITION OF THE MATRIX.                        00000070
C                                                                       00000080
C     IF  RCOND  IS NOT NEEDED, CGEFA IS SLIGHTLY FASTER.               00000090
C     TO SOLVE  A*X = B , FOLLOW CGECO BY CGESL.                        00000100
C     TO COMPUTE  INVERSE(A)*C , FOLLOW CGECO BY CGESL.                 00000110
C     TO COMPUTE  DETERMINANT(A) , FOLLOW CGECO BY CGEDI.               00000120
C     TO COMPUTE  INVERSE(A) , FOLLOW CGECO BY CGEDI.                   00000130
C                                                                       00000140
C     ON ENTRY                                                          00000150
C                                                                       00000160
C        A       COMPLEX(LDA, N)                                        00000170
C                THE MATRIX TO BE FACTORED.                             00000180
C                                                                       00000190
C        LDA     INTEGER                                                00000200
C                THE LEADING DIMENSION OF THE ARRAY  A .                00000210
C                                                                       00000220
C        N       INTEGER                                                00000230
C                THE ORDER OF THE MATRIX  A .                           00000240
C                                                                       00000250
C     ON RETURN                                                         00000260
C                                                                       00000270
C        A       AN UPPER TRIANGULAR MATRIX AND THE MULTIPLIERS         00000280
C                WHICH WERE USED TO OBTAIN IT.                          00000290
C                THE FACTORIZATION CAN BE WRITTEN  A = L*U  WHERE       00000300
C                L  IS A PRODUCT OF PERMUTATION AND UNIT LOWER          00000310
C                TRIANGULAR MATRICES AND  U  IS UPPER TRIANGULAR.       00000320
C                                                                       00000330
C        IPVT    INTEGER(N)                                             00000340
C                AN INTEGER VECTOR OF PIVOT INDICES.                    00000350
C                                                                       00000360
C        RCOND   REAL                                                   00000370
C                AN ESTIMATE OF THE RECIPROCAL CONDITION OF  A .        00000380
C                FOR THE SYSTEM  A*X = B , RELATIVE PERTURBATIONS       00000390
C                IN  A  AND  B  OF SIZE  EPSILON  MAY CAUSE             00000400
C                RELATIVE PERTURBATIONS IN  X  OF SIZE  EPSILON/RCOND . 00000410
C                IF  RCOND  IS SO SMALL THAT THE LOGICAL EXPRESSION     00000420
C                           1.0 + RCOND .EQ. 1.0                        00000430
C                IS TRUE, THEN  A  MAY BE SINGULAR TO WORKING           00000440
C                PRECISION.  IN PARTICULAR,  RCOND  IS ZERO  IF         00000450
C                EXACT SINGULARITY IS DETECTED OR THE ESTIMATE          00000460
C                UNDERFLOWS.                                            00000470
C                                                                       00000480
C        Z       COMPLEX(N)                                             00000490
C                A WORK VECTOR WHOSE CONTENTS ARE USUALLY UNIMPORTANT.  00000500
C                IF  A  IS CLOSE TO A SINGULAR MATRIX, THEN  Z  IS      00000510
C                AN APPROXIMATE NULL VECTOR IN THE SENSE THAT           00000520
C                NORM(A*Z) = RCOND*NORM(A)*NORM(Z) .                    00000530
C                                                                       00000540
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000550
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000560
C                                                                       00000570
C     SUBROUTINES AND FUNCTIONS                                         00000580
C                                                                       00000590
C     LINPACK CGEFA                                                     00000600
C     BLAS CAXPY,CDOTC,CSSCAL,SCASUM                                    00000610
C     FORTRAN ABS,AIMAG,AMAX1,CMPLX,CONJG,REAL                          00000620
C                                                                       00000630
C     INTERNAL VARIABLES                                                00000640
C                                                                       00000650
      COMPLEX CDOTC,EK,T,WK,WKM                                         00000660
      REAL ANORM,S,SCASUM,SM,YNORM                                      00000670
      INTEGER INFO,J,K,KB,KP1,L                                         00000680
C                                                                       00000690
      COMPLEX ZDUM,ZDUM1,ZDUM2,CSIGN1                                   00000700
      REAL CABS1                                                        00000710
      CABS1(ZDUM) = ABS(REAL(ZDUM)) + ABS(AIMAG(ZDUM))                  00000720
      CSIGN1(ZDUM1,ZDUM2) = CABS1(ZDUM1)*(ZDUM2/CABS1(ZDUM2))           00000730
C                                                                       00000740
C     COMPUTE 1-NORM OF A                                               00000750
C                                                                       00000760
      ANORM = 0.0E0                                                     00000770
      DO 10 J = 1, N                                                    00000780
         ANORM = AMAX1(ANORM,SCASUM(N,A(1,J),1))                        00000790
   10 CONTINUE                                                          00000800
C                                                                       00000810
C     FACTOR                                                            00000820
C                                                                       00000830
      CALL CGEFA(A,LDA,N,IPVT,INFO)                                     00000840
C                                                                       00000850
C     RCOND = 1/(NORM(A)*(ESTIMATE OF NORM(INVERSE(A)))) .              00000860
C     ESTIMATE = NORM(Z)/NORM(Y) WHERE  A*Z = Y  AND  CTRANS(A)*Y = E . 00000870
C     CTRANS(A)  IS THE CONJUGATE TRANSPOSE OF A .                      00000880
C     THE COMPONENTS OF  E  ARE CHOSEN TO CAUSE MAXIMUM LOCAL           00000890
C     GROWTH IN THE ELEMENTS OF W  WHERE  CTRANS(U)*W = E .             00000900
C     THE VECTORS ARE FREQUENTLY RESCALED TO AVOID OVERFLOW.            00000910
C                                                                       00000920
C     SOLVE CTRANS(U)*W = E                                             00000930
C                                                                       00000940
      EK = (1.0E0,0.0E0)                                                00000950
      DO 20 J = 1, N                                                    00000960
         Z(J) = (0.0E0,0.0E0)                                           00000970
   20 CONTINUE                                                          00000980
      DO 100 K = 1, N                                                   00000990
         IF (CABS1(Z(K)) .NE. 0.0E0) EK = CSIGN1(EK,-Z(K))              00001000
         IF (CABS1(EK-Z(K)) .LE. CABS1(A(K,K))) GO TO 30                00001010
            S = CABS1(A(K,K))/CABS1(EK-Z(K))                            00001020
            CALL CSSCAL(N,S,Z,1)                                        00001030
            EK = CMPLX(S,0.0E0)*EK                                      00001040
   30    CONTINUE                                                       00001050
         WK = EK - Z(K)                                                 00001060
         WKM = -EK - Z(K)                                               00001070
         S = CABS1(WK)                                                  00001080
         SM = CABS1(WKM)                                                00001090
         IF (CABS1(A(K,K)) .EQ. 0.0E0) GO TO 40                         00001100
            WK = WK/CONJG(A(K,K))                                       00001110
            WKM = WKM/CONJG(A(K,K))                                     00001120
         GO TO 50                                                       00001130
   40    CONTINUE                                                       00001140
            WK = (1.0E0,0.0E0)                                          00001150
            WKM = (1.0E0,0.0E0)                                         00001160
   50    CONTINUE                                                       00001170
         KP1 = K + 1                                                    00001180
         IF (KP1 .GT. N) GO TO 90                                       00001190
            DO 60 J = KP1, N                                            00001200
               SM = SM + CABS1(Z(J)+WKM*CONJG(A(K,J)))                  00001210
               Z(J) = Z(J) + WK*CONJG(A(K,J))                           00001220
               S = S + CABS1(Z(J))                                      00001230
   60       CONTINUE                                                    00001240
            IF (S .GE. SM) GO TO 80                                     00001250
               T = WKM - WK                                             00001260
               WK = WKM                                                 00001270
               DO 70 J = KP1, N                                         00001280
                  Z(J) = Z(J) + T*CONJG(A(K,J))                         00001290
   70          CONTINUE                                                 00001300
   80       CONTINUE                                                    00001310
   90    CONTINUE                                                       00001320
         Z(K) = WK                                                      00001330
  100 CONTINUE                                                          00001340
      S = 1.0E0/SCASUM(N,Z,1)                                           00001350
      CALL CSSCAL(N,S,Z,1)                                              00001360
C                                                                       00001370
C     SOLVE CTRANS(L)*Y = W                                             00001380
C                                                                       00001390
      DO 120 KB = 1, N                                                  00001400
         K = N + 1 - KB                                                 00001410
         IF (K .LT. N) Z(K) = Z(K) + CDOTC(N-K,A(K+1,K),1,Z(K+1),1)     00001420
         IF (CABS1(Z(K)) .LE. 1.0E0) GO TO 110                          00001430
            S = 1.0E0/CABS1(Z(K))                                       00001440
            CALL CSSCAL(N,S,Z,1)                                        00001450
  110    CONTINUE                                                       00001460
         L = IPVT(K)                                                    00001470
         T = Z(L)                                                       00001480
         Z(L) = Z(K)                                                    00001490
         Z(K) = T                                                       00001500
  120 CONTINUE                                                          00001510
      S = 1.0E0/SCASUM(N,Z,1)                                           00001520
      CALL CSSCAL(N,S,Z,1)                                              00001530
C                                                                       00001540
      YNORM = 1.0E0                                                     00001550
C                                                                       00001560
C     SOLVE L*V = Y                                                     00001570
C                                                                       00001580
      DO 140 K = 1, N                                                   00001590
         L = IPVT(K)                                                    00001600
         T = Z(L)                                                       00001610
         Z(L) = Z(K)                                                    00001620
         Z(K) = T                                                       00001630
         IF (K .LT. N) CALL CAXPY(N-K,T,A(K+1,K),1,Z(K+1),1)            00001640
         IF (CABS1(Z(K)) .LE. 1.0E0) GO TO 130                          00001650
            S = 1.0E0/CABS1(Z(K))                                       00001660
            CALL CSSCAL(N,S,Z,1)                                        00001670
            YNORM = S*YNORM                                             00001680
  130    CONTINUE                                                       00001690
  140 CONTINUE                                                          00001700
      S = 1.0E0/SCASUM(N,Z,1)                                           00001710
      CALL CSSCAL(N,S,Z,1)                                              00001720
      YNORM = S*YNORM                                                   00001730
C                                                                       00001740
C     SOLVE  U*Z = V                                                    00001750
C                                                                       00001760
      DO 160 KB = 1, N                                                  00001770
         K = N + 1 - KB                                                 00001780
         IF (CABS1(Z(K)) .LE. CABS1(A(K,K))) GO TO 150                  00001790
            S = CABS1(A(K,K))/CABS1(Z(K))                               00001800
            CALL CSSCAL(N,S,Z,1)                                        00001810
            YNORM = S*YNORM                                             00001820
  150    CONTINUE                                                       00001830
         IF (CABS1(A(K,K)) .NE. 0.0E0) Z(K) = Z(K)/A(K,K)               00001840
         IF (CABS1(A(K,K)) .EQ. 0.0E0) Z(K) = (1.0E0,0.0E0)             00001850
         T = -Z(K)                                                      00001860
         CALL CAXPY(K-1,T,A(1,K),1,Z(1),1)                              00001870
  160 CONTINUE                                                          00001880
C     MAKE ZNORM = 1.0                                                  00001890
      S = 1.0E0/SCASUM(N,Z,1)                                           00001900
      CALL CSSCAL(N,S,Z,1)                                              00001910
      YNORM = S*YNORM                                                   00001920
C                                                                       00001930
      IF (ANORM .NE. 0.0E0) RCOND = YNORM/ANORM                         00001940
      IF (ANORM .EQ. 0.0E0) RCOND = 0.0E0                               00001950
      RETURN                                                            00001960
      END                                                               00001970
