*#**********************************************************************

      SUBROUTINE CHIFA(A,LDA,N,KPVT,INFO)                               00000010

      INTEGER LDA,N,KPVT(1),INFO                                        00000020
      COMPLEX A(LDA,1)                                                  00000030
C                                                                       00000040
C     CHIFA FACTORS A COMPLEX HERMITIAN MATRIX BY ELIMINATION           00000050
C     WITH SYMMETRIC PIVOTING.                                          00000060
C                                                                       00000070
C     TO SOLVE  A*X = B , FOLLOW CHIFA BY CHISL.                        00000080
C     TO COMPUTE  INVERSE(A)*C , FOLLOW CHIFA BY CHISL.                 00000090
C     TO COMPUTE  DETERMINANT(A) , FOLLOW CHIFA BY CHIDI.               00000100
C     TO COMPUTE  INERTIA(A) , FOLLOW CHIFA BY CHIDI.                   00000110
C     TO COMPUTE  INVERSE(A) , FOLLOW CHIFA BY CHIDI.                   00000120
C                                                                       00000130
C     ON ENTRY                                                          00000140
C                                                                       00000150
C        A       COMPLEX(LDA,N)                                         00000160
C                THE HERMITIAN MATRIX TO BE FACTORED.                   00000170
C                ONLY THE DIAGONAL AND UPPER TRIANGLE ARE USED.         00000180
C                                                                       00000190
C        LDA     INTEGER                                                00000200
C                THE LEADING DIMENSION OF THE ARRAY  A .                00000210
C                                                                       00000220
C        N       INTEGER                                                00000230
C                THE ORDER OF THE MATRIX  A .                           00000240
C                                                                       00000250
C     ON RETURN                                                         00000260
C                                                                       00000270
C        A       A BLOCK DIAGONAL MATRIX AND THE MULTIPLIERS WHICH      00000280
C                WERE USED TO OBTAIN IT.                                00000290
C                THE FACTORIZATION CAN BE WRITTEN  A = U*D*CTRANS(U)    00000300
C                WHERE  U  IS A PRODUCT OF PERMUTATION AND UNIT         00000310
C                UPPER TRIANGULAR MATRICES , CTRANS(U) IS THE           00000320
C                CONJUGATE TRANSPOSE OF  U , AND  D  IS BLOCK DIAGONAL  00000330
C                WITH 1 BY 1 AND 2 BY 2 BLOCKS.                         00000340
C                                                                       00000350
C        KPVT    INTEGER(N)                                             00000360
C                AN INTEGER VECTOR OF PIVOT INDICES.                    00000370
C                                                                       00000380
C        INFO    INTEGER                                                00000390
C                = 0  NORMAL VALUE.                                     00000400
C                = K  IF THE K-TH PIVOT BLOCK IS SINGULAR. THIS IS      00000410
C                     NOT AN ERROR CONDITION FOR THIS SUBROUTINE,       00000420
C                     BUT IT DOES INDICATE THAT CHISL OR CHIDI MAY      00000430
C                     DIVIDE BY ZERO IF CALLED.                         00000440
C                                                                       00000450
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000460
C     JAMES BUNCH, UNIV. CALIF. SAN DIEGO, ARGONNE NAT. LAB.            00000470
C                                                                       00000480
C     SUBROUTINES AND FUNCTIONS                                         00000490
C                                                                       00000500
C     BLAS CAXPY,CSWAP,ICAMAX                                           00000510
C     FORTRAN ABS,AIMAG,AMAX1,CMPLX,CONJG,REAL,SQRT                     00000520
C                                                                       00000530
C     INTERNAL VARIABLES                                                00000540
C                                                                       00000550
      COMPLEX AK,AKM1,BK,BKM1,DENOM,MULK,MULKM1,T                       00000560
      REAL ABSAKK,ALPHA,COLMAX,ROWMAX                                   00000570
      INTEGER IMAX,IMAXP1,J,JJ,JMAX,K,KM1,KM2,KSTEP,ICAMAX              00000580
      LOGICAL SWAP                                                      00000590
C                                                                       00000600
      COMPLEX ZDUM                                                      00000610
      REAL CABS1                                                        00000620
      CABS1(ZDUM) = ABS(REAL(ZDUM)) + ABS(AIMAG(ZDUM))                  00000630
C                                                                       00000640
C     INITIALIZE                                                        00000650
C                                                                       00000660
C     ALPHA IS USED IN CHOOSING PIVOT BLOCK SIZE.                       00000670
      ALPHA = (1.0E0 + SQRT(17.0E0))/8.0E0                              00000680
C                                                                       00000690
      INFO = 0                                                          00000700
C                                                                       00000710
C     MAIN LOOP ON K, WHICH GOES FROM N TO 1.                           00000720
C                                                                       00000730
      K = N                                                             00000740
   10 CONTINUE                                                          00000750
C                                                                       00000760
C        LEAVE THE LOOP IF K=0 OR K=1.                                  00000770
C                                                                       00000780
C     ...EXIT                                                           00000790
         IF (K .EQ. 0) GO TO 200                                        00000800
         IF (K .GT. 1) GO TO 20                                         00000810
            KPVT(1) = 1                                                 00000820
            IF (CABS1(A(1,1)) .EQ. 0.0E0) INFO = 1                      00000830
C     ......EXIT                                                        00000840
            GO TO 200                                                   00000850
   20    CONTINUE                                                       00000860
C                                                                       00000870
C        THIS SECTION OF CODE DETERMINES THE KIND OF                    00000880
C        ELIMINATION TO BE PERFORMED.  WHEN IT IS COMPLETED,            00000890
C        KSTEP WILL BE SET TO THE SIZE OF THE PIVOT BLOCK, AND          00000900
C        SWAP WILL BE SET TO .TRUE. IF AN INTERCHANGE IS                00000910
C        REQUIRED.                                                      00000920
C                                                                       00000930
         KM1 = K - 1                                                    00000940
         ABSAKK = CABS1(A(K,K))                                         00000950
C                                                                       00000960
C        DETERMINE THE LARGEST OFF-DIAGONAL ELEMENT IN                  00000970
C        COLUMN K.                                                      00000980
C                                                                       00000990
         IMAX = ICAMAX(K-1,A(1,K),1)                                    00001000
         COLMAX = CABS1(A(IMAX,K))                                      00001010
         IF (ABSAKK .LT. ALPHA*COLMAX) GO TO 30                         00001020
            KSTEP = 1                                                   00001030
            SWAP = .FALSE.                                              00001040
         GO TO 90                                                       00001050
   30    CONTINUE                                                       00001060
C                                                                       00001070
C           DETERMINE THE LARGEST OFF-DIAGONAL ELEMENT IN               00001080
C           ROW IMAX.                                                   00001090
C                                                                       00001100
            ROWMAX = 0.0E0                                              00001110
            IMAXP1 = IMAX + 1                                           00001120
            DO 40 J = IMAXP1, K                                         00001130
               ROWMAX = AMAX1(ROWMAX,CABS1(A(IMAX,J)))                  00001140
   40       CONTINUE                                                    00001150
            IF (IMAX .EQ. 1) GO TO 50                                   00001160
               JMAX = ICAMAX(IMAX-1,A(1,IMAX),1)                        00001170
               ROWMAX = AMAX1(ROWMAX,CABS1(A(JMAX,IMAX)))               00001180
   50       CONTINUE                                                    00001190
            IF (CABS1(A(IMAX,IMAX)) .LT. ALPHA*ROWMAX) GO TO 60         00001200
               KSTEP = 1                                                00001210
               SWAP = .TRUE.                                            00001220
            GO TO 80                                                    00001230
   60       CONTINUE                                                    00001240
            IF (ABSAKK .LT. ALPHA*COLMAX*(COLMAX/ROWMAX)) GO TO 70      00001250
               KSTEP = 1                                                00001260
               SWAP = .FALSE.                                           00001270
            GO TO 80                                                    00001280
   70       CONTINUE                                                    00001290
               KSTEP = 2                                                00001300
               SWAP = IMAX .NE. KM1                                     00001310
   80       CONTINUE                                                    00001320
   90    CONTINUE                                                       00001330
         IF (AMAX1(ABSAKK,COLMAX) .NE. 0.0E0) GO TO 100                 00001340
C                                                                       00001350
C           COLUMN K IS ZERO.  SET INFO AND ITERATE THE LOOP.           00001360
C                                                                       00001370
            KPVT(K) = K                                                 00001380
            INFO = K                                                    00001390
         GO TO 190                                                      00001400
  100    CONTINUE                                                       00001410
         IF (KSTEP .EQ. 2) GO TO 140                                    00001420
C                                                                       00001430
C           1 X 1 PIVOT BLOCK.                                          00001440
C                                                                       00001450
            IF (.NOT.SWAP) GO TO 120                                    00001460
C                                                                       00001470
C              PERFORM AN INTERCHANGE.                                  00001480
C                                                                       00001490
               CALL CSWAP(IMAX,A(1,IMAX),1,A(1,K),1)                    00001500
               DO 110 JJ = IMAX, K                                      00001510
                  J = K + IMAX - JJ                                     00001520
                  T = CONJG(A(J,K))                                     00001530
                  A(J,K) = CONJG(A(IMAX,J))                             00001540
                  A(IMAX,J) = T                                         00001550
  110          CONTINUE                                                 00001560
  120       CONTINUE                                                    00001570
C                                                                       00001580
C           PERFORM THE ELIMINATION.                                    00001590
C                                                                       00001600
            DO 130 JJ = 1, KM1                                          00001610
               J = K - JJ                                               00001620
               MULK = -A(J,K)/A(K,K)                                    00001630
               T = CONJG(MULK)                                          00001640
               CALL CAXPY(J,T,A(1,K),1,A(1,J),1)                        00001650
               A(J,J) = CMPLX(REAL(A(J,J)),0.0E0)                       00001660
               A(J,K) = MULK                                            00001670
  130       CONTINUE                                                    00001680
C                                                                       00001690
C           SET THE PIVOT ARRAY.                                        00001700
C                                                                       00001710
            KPVT(K) = K                                                 00001720
            IF (SWAP) KPVT(K) = IMAX                                    00001730
         GO TO 190                                                      00001740
  140    CONTINUE                                                       00001750
C                                                                       00001760
C           2 X 2 PIVOT BLOCK.                                          00001770
C                                                                       00001780
            IF (.NOT.SWAP) GO TO 160                                    00001790
C                                                                       00001800
C              PERFORM AN INTERCHANGE.                                  00001810
C                                                                       00001820
               CALL CSWAP(IMAX,A(1,IMAX),1,A(1,K-1),1)                  00001830
               DO 150 JJ = IMAX, KM1                                    00001840
                  J = KM1 + IMAX - JJ                                   00001850
                  T = CONJG(A(J,K-1))                                   00001860
                  A(J,K-1) = CONJG(A(IMAX,J))                           00001870
                  A(IMAX,J) = T                                         00001880
  150          CONTINUE                                                 00001890
               T = A(K-1,K)                                             00001900
               A(K-1,K) = A(IMAX,K)                                     00001910
               A(IMAX,K) = T                                            00001920
  160       CONTINUE                                                    00001930
C                                                                       00001940
C           PERFORM THE ELIMINATION.                                    00001950
C                                                                       00001960
            KM2 = K - 2                                                 00001970
            IF (KM2 .EQ. 0) GO TO 180                                   00001980
               AK = A(K,K)/A(K-1,K)                                     00001990
               AKM1 = A(K-1,K-1)/CONJG(A(K-1,K))                        00002000
               DENOM = 1.0E0 - AK*AKM1                                  00002010
               DO 170 JJ = 1, KM2                                       00002020
                  J = KM1 - JJ                                          00002030
                  BK = A(J,K)/A(K-1,K)                                  00002040
                  BKM1 = A(J,K-1)/CONJG(A(K-1,K))                       00002050
                  MULK = (AKM1*BK - BKM1)/DENOM                         00002060
                  MULKM1 = (AK*BKM1 - BK)/DENOM                         00002070
                  T = CONJG(MULK)                                       00002080
                  CALL CAXPY(J,T,A(1,K),1,A(1,J),1)                     00002090
                  T = CONJG(MULKM1)                                     00002100
                  CALL CAXPY(J,T,A(1,K-1),1,A(1,J),1)                   00002110
                  A(J,K) = MULK                                         00002120
                  A(J,K-1) = MULKM1                                     00002130
                  A(J,J) = CMPLX(REAL(A(J,J)),0.0E0)                    00002140
  170          CONTINUE                                                 00002150
  180       CONTINUE                                                    00002160
C                                                                       00002170
C           SET THE PIVOT ARRAY.                                        00002180
C                                                                       00002190
            KPVT(K) = 1 - K                                             00002200
            IF (SWAP) KPVT(K) = -IMAX                                   00002210
            KPVT(K-1) = KPVT(K)                                         00002220
  190    CONTINUE                                                       00002230
         K = K - KSTEP                                                  00002240
      GO TO 10                                                          00002250
  200 CONTINUE                                                          00002260
      RETURN                                                            00002270
      END                                                               00002280
