*#**********************************************************************

      SUBROUTINE CHPFA(AP,N,KPVT,INFO)                                  00000010

      INTEGER N,KPVT(1),INFO                                            00000020
      COMPLEX AP(1)                                                     00000030
C                                                                       00000040
C     CHPFA FACTORS A COMPLEX HERMITIAN MATRIX STORED IN                00000050
C     PACKED FORM BY ELIMINATION WITH SYMMETRIC PIVOTING.               00000060
C                                                                       00000070
C     TO SOLVE  A*X = B , FOLLOW CHPFA BY CHPSL.                        00000080
C     TO COMPUTE  INVERSE(A)*C , FOLLOW CHPFA BY CHPSL.                 00000090
C     TO COMPUTE  DETERMINANT(A) , FOLLOW CHPFA BY CHPDI.               00000100
C     TO COMPUTE  INERTIA(A) , FOLLOW CHPFA BY CHPDI.                   00000110
C     TO COMPUTE  INVERSE(A) , FOLLOW CHPFA BY CHPDI.                   00000120
C                                                                       00000130
C     ON ENTRY                                                          00000140
C                                                                       00000150
C        AP      COMPLEX (N*(N+1)/2)                                    00000160
C                THE PACKED FORM OF A HERMITIAN MATRIX  A .  THE        00000170
C                COLUMNS OF THE UPPER TRIANGLE ARE STORED SEQUENTIALLY  00000180
C                IN A ONE-DIMENSIONAL ARRAY OF LENGTH  N*(N+1)/2 .      00000190
C                SEE COMMENTS BELOW FOR DETAILS.                        00000200
C                                                                       00000210
C        N       INTEGER                                                00000220
C                THE ORDER OF THE MATRIX  A .                           00000230
C                                                                       00000240
C     OUTPUT                                                            00000250
C                                                                       00000260
C        AP      A BLOCK DIAGONAL MATRIX AND THE MULTIPLIERS WHICH      00000270
C                WERE USED TO OBTAIN IT STORED IN PACKED FORM.          00000280
C                THE FACTORIZATION CAN BE WRITTEN  A = U*D*CTRANS(U)    00000290
C                WHERE  U  IS A PRODUCT OF PERMUTATION AND UNIT         00000300
C                UPPER TRIANGULAR MATRICES , CTRANS(U) IS THE           00000310
C                CONJUGATE TRANSPOSE OF  U , AND  D  IS BLOCK DIAGONAL  00000320
C                WITH 1 BY 1 AND 2 BY 2 BLOCKS.                         00000330
C                                                                       00000340
C        KPVT    INTEGER(N)                                             00000350
C                AN INTEGER VECTOR OF PIVOT INDICES.                    00000360
C                                                                       00000370
C        INFO    INTEGER                                                00000380
C                = 0  NORMAL VALUE.                                     00000390
C                = K  IF THE K-TH PIVOT BLOCK IS SINGULAR. THIS IS      00000400
C                     NOT AN ERROR CONDITION FOR THIS SUBROUTINE,       00000410
C                     BUT IT DOES INDICATE THAT CHPSL OR CHPDI MAY      00000420
C                     DIVIDE BY ZERO IF CALLED.                         00000430
C                                                                       00000440
C     PACKED STORAGE                                                    00000450
C                                                                       00000460
C          THE FOLLOWING PROGRAM SEGMENT WILL PACK THE UPPER            00000470
C          TRIANGLE OF A HERMITIAN MATRIX.                              00000480
C                                                                       00000490
C                K = 0                                                  00000500
C                DO 20 J = 1, N                                         00000510
C                   DO 10 I = 1, J                                      00000520
C                      K = K + 1                                        00000530
C                      AP(K)  = A(I,J)                                  00000540
C             10    CONTINUE                                            00000550
C             20 CONTINUE                                               00000560
C                                                                       00000570
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000580
C     JAMES BUNCH, UNIV. CALIF. SAN DIEGO, ARGONNE NAT. LAB.            00000590
C                                                                       00000600
C     SUBROUTINES AND FUNCTIONS                                         00000610
C                                                                       00000620
C     BLAS CAXPY,CSWAP,ICAMAX                                           00000630
C     FORTRAN ABS,AIMAG,AMAX1,CMPLX,CONJG,REAL,SQRT                     00000640
C                                                                       00000650
C     INTERNAL VARIABLES                                                00000660
C                                                                       00000670
      COMPLEX AK,AKM1,BK,BKM1,DENOM,MULK,MULKM1,T                       00000680
      REAL ABSAKK,ALPHA,COLMAX,ROWMAX                                   00000690
      INTEGER ICAMAX,IJ,IJJ,IK,IKM1,IM,IMAX,IMAXP1,IMIM,IMJ,IMK         00000700
      INTEGER J,JJ,JK,JKM1,JMAX,JMIM,K,KK,KM1,KM1K,KM1KM1,KM2,KSTEP     00000710
      LOGICAL SWAP                                                      00000720
C                                                                       00000730
      COMPLEX ZDUM                                                      00000740
      REAL CABS1                                                        00000750
      CABS1(ZDUM) = ABS(REAL(ZDUM)) + ABS(AIMAG(ZDUM))                  00000760
C                                                                       00000770
C     INITIALIZE                                                        00000780
C                                                                       00000790
C     ALPHA IS USED IN CHOOSING PIVOT BLOCK SIZE.                       00000800
      ALPHA = (1.0E0 + SQRT(17.0E0))/8.0E0                              00000810
C                                                                       00000820
      INFO = 0                                                          00000830
C                                                                       00000840
C     MAIN LOOP ON K, WHICH GOES FROM N TO 1.                           00000850
C                                                                       00000860
      K = N                                                             00000870
      IK = (N*(N - 1))/2                                                00000880
   10 CONTINUE                                                          00000890
C                                                                       00000900
C        LEAVE THE LOOP IF K=0 OR K=1.                                  00000910
C                                                                       00000920
C     ...EXIT                                                           00000930
         IF (K .EQ. 0) GO TO 200                                        00000940
         IF (K .GT. 1) GO TO 20                                         00000950
            KPVT(1) = 1                                                 00000960
            IF (CABS1(AP(1)) .EQ. 0.0E0) INFO = 1                       00000970
C     ......EXIT                                                        00000980
            GO TO 200                                                   00000990
   20    CONTINUE                                                       00001000
C                                                                       00001010
C        THIS SECTION OF CODE DETERMINES THE KIND OF                    00001020
C        ELIMINATION TO BE PERFORMED.  WHEN IT IS COMPLETED,            00001030
C        KSTEP WILL BE SET TO THE SIZE OF THE PIVOT BLOCK, AND          00001040
C        SWAP WILL BE SET TO .TRUE. IF AN INTERCHANGE IS                00001050
C        REQUIRED.                                                      00001060
C                                                                       00001070
         KM1 = K - 1                                                    00001080
         KK = IK + K                                                    00001090
         ABSAKK = CABS1(AP(KK))                                         00001100
C                                                                       00001110
C        DETERMINE THE LARGEST OFF-DIAGONAL ELEMENT IN                  00001120
C        COLUMN K.                                                      00001130
C                                                                       00001140
         IMAX = ICAMAX(K-1,AP(IK+1),1)                                  00001150
         IMK = IK + IMAX                                                00001160
         COLMAX = CABS1(AP(IMK))                                        00001170
         IF (ABSAKK .LT. ALPHA*COLMAX) GO TO 30                         00001180
            KSTEP = 1                                                   00001190
            SWAP = .FALSE.                                              00001200
         GO TO 90                                                       00001210
   30    CONTINUE                                                       00001220
C                                                                       00001230
C           DETERMINE THE LARGEST OFF-DIAGONAL ELEMENT IN               00001240
C           ROW IMAX.                                                   00001250
C                                                                       00001260
            ROWMAX = 0.0E0                                              00001270
            IMAXP1 = IMAX + 1                                           00001280
            IM = IMAX*(IMAX - 1)/2                                      00001290
            IMJ = IM + 2*IMAX                                           00001300
            DO 40 J = IMAXP1, K                                         00001310
               ROWMAX = AMAX1(ROWMAX,CABS1(AP(IMJ)))                    00001320
               IMJ = IMJ + J                                            00001330
   40       CONTINUE                                                    00001340
            IF (IMAX .EQ. 1) GO TO 50                                   00001350
               JMAX = ICAMAX(IMAX-1,AP(IM+1),1)                         00001360
               JMIM = JMAX + IM                                         00001370
               ROWMAX = AMAX1(ROWMAX,CABS1(AP(JMIM)))                   00001380
   50       CONTINUE                                                    00001390
            IMIM = IMAX + IM                                            00001400
            IF (CABS1(AP(IMIM)) .LT. ALPHA*ROWMAX) GO TO 60             00001410
               KSTEP = 1                                                00001420
               SWAP = .TRUE.                                            00001430
            GO TO 80                                                    00001440
   60       CONTINUE                                                    00001450
            IF (ABSAKK .LT. ALPHA*COLMAX*(COLMAX/ROWMAX)) GO TO 70      00001460
               KSTEP = 1                                                00001470
               SWAP = .FALSE.                                           00001480
            GO TO 80                                                    00001490
   70       CONTINUE                                                    00001500
               KSTEP = 2                                                00001510
               SWAP = IMAX .NE. KM1                                     00001520
   80       CONTINUE                                                    00001530
   90    CONTINUE                                                       00001540
         IF (AMAX1(ABSAKK,COLMAX) .NE. 0.0E0) GO TO 100                 00001550
C                                                                       00001560
C           COLUMN K IS ZERO.  SET INFO AND ITERATE THE LOOP.           00001570
C                                                                       00001580
            KPVT(K) = K                                                 00001590
            INFO = K                                                    00001600
         GO TO 190                                                      00001610
  100    CONTINUE                                                       00001620
         IF (KSTEP .EQ. 2) GO TO 140                                    00001630
C                                                                       00001640
C           1 X 1 PIVOT BLOCK.                                          00001650
C                                                                       00001660
            IF (.NOT.SWAP) GO TO 120                                    00001670
C                                                                       00001680
C              PERFORM AN INTERCHANGE.                                  00001690
C                                                                       00001700
               CALL CSWAP(IMAX,AP(IM+1),1,AP(IK+1),1)                   00001710
               IMJ = IK + IMAX                                          00001720
               DO 110 JJ = IMAX, K                                      00001730
                  J = K + IMAX - JJ                                     00001740
                  JK = IK + J                                           00001750
                  T = CONJG(AP(JK))                                     00001760
                  AP(JK) = CONJG(AP(IMJ))                               00001770
                  AP(IMJ) = T                                           00001780
                  IMJ = IMJ - (J - 1)                                   00001790
  110          CONTINUE                                                 00001800
  120       CONTINUE                                                    00001810
C                                                                       00001820
C           PERFORM THE ELIMINATION.                                    00001830
C                                                                       00001840
            IJ = IK - (K - 1)                                           00001850
            DO 130 JJ = 1, KM1                                          00001860
               J = K - JJ                                               00001870
               JK = IK + J                                              00001880
               MULK = -AP(JK)/AP(KK)                                    00001890
               T = CONJG(MULK)                                          00001900
               CALL CAXPY(J,T,AP(IK+1),1,AP(IJ+1),1)                    00001910
               IJJ = IJ + J                                             00001920
               AP(IJJ) = CMPLX(REAL(AP(IJJ)),0.0E0)                     00001930
               AP(JK) = MULK                                            00001940
               IJ = IJ - (J - 1)                                        00001950
  130       CONTINUE                                                    00001960
C                                                                       00001970
C           SET THE PIVOT ARRAY.                                        00001980
C                                                                       00001990
            KPVT(K) = K                                                 00002000
            IF (SWAP) KPVT(K) = IMAX                                    00002010
         GO TO 190                                                      00002020
  140    CONTINUE                                                       00002030
C                                                                       00002040
C           2 X 2 PIVOT BLOCK.                                          00002050
C                                                                       00002060
            KM1K = IK + K - 1                                           00002070
            IKM1 = IK - (K - 1)                                         00002080
            IF (.NOT.SWAP) GO TO 160                                    00002090
C                                                                       00002100
C              PERFORM AN INTERCHANGE.                                  00002110
C                                                                       00002120
               CALL CSWAP(IMAX,AP(IM+1),1,AP(IKM1+1),1)                 00002130
               IMJ = IKM1 + IMAX                                        00002140
               DO 150 JJ = IMAX, KM1                                    00002150
                  J = KM1 + IMAX - JJ                                   00002160
                  JKM1 = IKM1 + J                                       00002170
                  T = CONJG(AP(JKM1))                                   00002180
                  AP(JKM1) = CONJG(AP(IMJ))                             00002190
                  AP(IMJ) = T                                           00002200
                  IMJ = IMJ - (J - 1)                                   00002210
  150          CONTINUE                                                 00002220
               T = AP(KM1K)                                             00002230
               AP(KM1K) = AP(IMK)                                       00002240
               AP(IMK) = T                                              00002250
  160       CONTINUE                                                    00002260
C                                                                       00002270
C           PERFORM THE ELIMINATION.                                    00002280
C                                                                       00002290
            KM2 = K - 2                                                 00002300
            IF (KM2 .EQ. 0) GO TO 180                                   00002310
               AK = AP(KK)/AP(KM1K)                                     00002320
               KM1KM1 = IKM1 + K - 1                                    00002330
               AKM1 = AP(KM1KM1)/CONJG(AP(KM1K))                        00002340
               DENOM = 1.0E0 - AK*AKM1                                  00002350
               IJ = IK - (K - 1) - (K - 2)                              00002360
               DO 170 JJ = 1, KM2                                       00002370
                  J = KM1 - JJ                                          00002380
                  JK = IK + J                                           00002390
                  BK = AP(JK)/AP(KM1K)                                  00002400
                  JKM1 = IKM1 + J                                       00002410
                  BKM1 = AP(JKM1)/CONJG(AP(KM1K))                       00002420
                  MULK = (AKM1*BK - BKM1)/DENOM                         00002430
                  MULKM1 = (AK*BKM1 - BK)/DENOM                         00002440
                  T = CONJG(MULK)                                       00002450
                  CALL CAXPY(J,T,AP(IK+1),1,AP(IJ+1),1)                 00002460
                  T = CONJG(MULKM1)                                     00002470
                  CALL CAXPY(J,T,AP(IKM1+1),1,AP(IJ+1),1)               00002480
                  AP(JK) = MULK                                         00002490
                  AP(JKM1) = MULKM1                                     00002500
                  IJJ = IJ + J                                          00002510
                  AP(IJJ) = CMPLX(REAL(AP(IJJ)),0.0E0)                  00002520
                  IJ = IJ - (J - 1)                                     00002530
  170          CONTINUE                                                 00002540
  180       CONTINUE                                                    00002550
C                                                                       00002560
C           SET THE PIVOT ARRAY.                                        00002570
C                                                                       00002580
            KPVT(K) = 1 - K                                             00002590
            IF (SWAP) KPVT(K) = -IMAX                                   00002600
            KPVT(K-1) = KPVT(K)                                         00002610
  190    CONTINUE                                                       00002620
         IK = IK - (K - 1)                                              00002630
         IF (KSTEP .EQ. 2) IK = IK - (K - 2)                            00002640
         K = K - KSTEP                                                  00002650
      GO TO 10                                                          00002660
  200 CONTINUE                                                          00002670
      RETURN                                                            00002680
      END                                                               00002690
