*#**********************************************************************

      SUBROUTINE CQRDC(X,LDX,N,P,QRAUX,JPVT,WORK,JOB)                   00000010

      INTEGER LDX,N,P,JOB,JJ                                            00000020
      INTEGER JPVT(1)                                                   00000030
      COMPLEX X(LDX,1),QRAUX(1),WORK(1)                                 00000040
C                                                                       00000050
C     CQRDC USES HOUSEHOLDER TRANSFORMATIONS TO COMPUTE THE QR          00000060
C     FACTORIZATION OF AN N BY P MATRIX X.  COLUMN PIVOTING             00000070
C     BASED ON THE 2-NORMS OF THE REDUCED COLUMNS MAY BE                00000080
C     PERFORMED AT THE USERS OPTION.                                    00000090
C                                                                       00000100
C     ON ENTRY                                                          00000110
C                                                                       00000120
C        X       COMPLEX(LDX,P), WHERE LDX .GE. N.                      00000130
C                X CONTAINS THE MATRIX WHOSE DECOMPOSITION IS TO BE     00000140
C                COMPUTED.                                              00000150
C                                                                       00000160
C        LDX     INTEGER.                                               00000170
C                LDX IS THE LEADING DIMENSION OF THE ARRAY X.           00000180
C                                                                       00000190
C        N       INTEGER.                                               00000200
C                N IS THE NUMBER OF ROWS OF THE MATRIX X.               00000210
C                                                                       00000220
C        P       INTEGER.                                               00000230
C                P IS THE NUMBER OF COLUMNS OF THE MATRIX X.            00000240
C                                                                       00000250
C        JPVT    INTEGER(P).                                            00000260
C                JPVT CONTAINS INTEGERS THAT CONTROL THE SELECTION      00000270
C                OF THE PIVOT COLUMNS.  THE K-TH COLUMN X(K) OF X       00000280
C                IS PLACED IN ONE OF THREE CLASSES ACCORDING TO THE     00000290
C                VALUE OF JPVT(K).                                      00000300
C                                                                       00000310
C                   IF JPVT(K) .GT. 0, THEN X(K) IS AN INITIAL          00000320
C                                      COLUMN.                          00000330
C                                                                       00000340
C                   IF JPVT(K) .EQ. 0, THEN X(K) IS A FREE COLUMN.      00000350
C                                                                       00000360
C                   IF JPVT(K) .LT. 0, THEN X(K) IS A FINAL COLUMN.     00000370
C                                                                       00000380
C                BEFORE THE DECOMPOSITION IS COMPUTED, INITIAL COLUMNS  00000390
C                ARE MOVED TO THE BEGINNING OF THE ARRAY X AND FINAL    00000400
C                COLUMNS TO THE END.  BOTH INITIAL AND FINAL COLUMNS    00000410
C                ARE FROZEN IN PLACE DURING THE COMPUTATION AND ONLY    00000420
C                FREE COLUMNS ARE MOVED.  AT THE K-TH STAGE OF THE      00000430
C                REDUCTION, IF X(K) IS OCCUPIED BY A FREE COLUMN        00000440
C                IT IS INTERCHANGED WITH THE FREE COLUMN OF LARGEST     00000450
C                REDUCED NORM.  JPVT IS NOT REFERENCED IF               00000460
C                JOB .EQ. 0.                                            00000470
C                                                                       00000480
C        WORK    COMPLEX(P).                                            00000490
C                WORK IS A WORK ARRAY.  WORK IS NOT REFERENCED IF       00000500
C                JOB .EQ. 0.                                            00000510
C                                                                       00000520
C        JOB     INTEGER.                                               00000530
C                JOB IS AN INTEGER THAT INITIATES COLUMN PIVOTING.      00000540
C                IF JOB .EQ. 0, NO PIVOTING IS DONE.                    00000550
C                IF JOB .NE. 0, PIVOTING IS DONE.                       00000560
C                                                                       00000570
C     ON RETURN                                                         00000580
C                                                                       00000590
C        X       X CONTAINS IN ITS UPPER TRIANGLE THE UPPER             00000600
C                TRIANGULAR MATRIX R OF THE QR FACTORIZATION.           00000610
C                BELOW ITS DIAGONAL X CONTAINS INFORMATION FROM         00000620
C                WHICH THE UNITARY PART OF THE DECOMPOSITION            00000630
C                CAN BE RECOVERED.  NOTE THAT IF PIVOTING HAS           00000640
C                BEEN REQUESTED, THE DECOMPOSITION IS NOT THAT          00000650
C                OF THE ORIGINAL MATRIX X BUT THAT OF X                 00000660
C                WITH ITS COLUMNS PERMUTED AS DESCRIBED BY JPVT.        00000670
C                                                                       00000680
C        QRAUX   COMPLEX(P).                                            00000690
C                QRAUX CONTAINS FURTHER INFORMATION REQUIRED TO RECOVER 00000700
C                THE UNITARY PART OF THE DECOMPOSITION.                 00000710
C                                                                       00000720
C        JPVT    JPVT(K) CONTAINS THE INDEX OF THE COLUMN OF THE        00000730
C                ORIGINAL MATRIX THAT HAS BEEN INTERCHANGED INTO        00000740
C                THE K-TH COLUMN, IF PIVOTING WAS REQUESTED.            00000750
C                                                                       00000760
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000770
C     G.W. STEWART, UNIVERSITY OF MARYLAND, ARGONNE NATIONAL LAB.       00000780
C                                                                       00000790
C     CQRDC USES THE FOLLOWING FUNCTIONS AND SUBPROGRAMS.               00000800
C                                                                       00000810
C     BLAS CAXPY,CDOTC,CSCAL,CSWAP,SCNRM2                               00000820
C     FORTRAN ABS,AIMAG,AMAX1,CABS,CMPLX,CSQRT,MIN0,REAL                00000830
C                                                                       00000840
C     INTERNAL VARIABLES                                                00000850
C                                                                       00000860
      INTEGER J,JP,L,LP1,LUP,MAXJ,PL,PU                                 00000870
      REAL MAXNRM,SCNRM2,TT                                             00000880
      COMPLEX CDOTC,NRMXL,T                                             00000890
      LOGICAL NEGJ,SWAPJ                                                00000900
C                                                                       00000910
      COMPLEX CSIGN,ZDUM,ZDUM1,ZDUM2                                    00000920
      REAL CABS1                                                        00000930
      CSIGN(ZDUM1,ZDUM2) = CABS(ZDUM1)*(ZDUM2/CABS(ZDUM2))              00000940
      CABS1(ZDUM) = ABS(REAL(ZDUM)) + ABS(AIMAG(ZDUM))                  00000950
C                                                                       00000960
      PL = 1                                                            00000970
      PU = 0                                                            00000980
      IF (JOB .EQ. 0) GO TO 60                                          00000990
C                                                                       00001000
C        PIVOTING HAS BEEN REQUESTED.  REARRANGE THE COLUMNS            00001010
C        ACCORDING TO JPVT.                                             00001020
C                                                                       00001030
         DO 20 J = 1, P                                                 00001040
            SWAPJ = JPVT(J) .GT. 0                                      00001050
            NEGJ = JPVT(J) .LT. 0                                       00001060
            JPVT(J) = J                                                 00001070
            IF (NEGJ) JPVT(J) = -J                                      00001080
            IF (.NOT.SWAPJ) GO TO 10                                    00001090
               IF (J .NE. PL) CALL CSWAP(N,X(1,PL),1,X(1,J),1)          00001100
               JPVT(J) = JPVT(PL)                                       00001110
               JPVT(PL) = J                                             00001120
               PL = PL + 1                                              00001130
   10       CONTINUE                                                    00001140
   20    CONTINUE                                                       00001150
         PU = P                                                         00001160
         DO 50 JJ = 1, P                                                00001170
            J = P - JJ + 1                                              00001180
            IF (JPVT(J) .GE. 0) GO TO 40                                00001190
               JPVT(J) = -JPVT(J)                                       00001200
               IF (J .EQ. PU) GO TO 30                                  00001210
                  CALL CSWAP(N,X(1,PU),1,X(1,J),1)                      00001220
                  JP = JPVT(PU)                                         00001230
                  JPVT(PU) = JPVT(J)                                    00001240
                  JPVT(J) = JP                                          00001250
   30          CONTINUE                                                 00001260
               PU = PU - 1                                              00001270
   40       CONTINUE                                                    00001280
   50    CONTINUE                                                       00001290
   60 CONTINUE                                                          00001300
C                                                                       00001310
C     COMPUTE THE NORMS OF THE FREE COLUMNS.                            00001320
C                                                                       00001330
      IF (PU .LT. PL) GO TO 80                                          00001340
      DO 70 J = PL, PU                                                  00001350
         QRAUX(J) = CMPLX(SCNRM2(N,X(1,J),1),0.0E0)                     00001360
         WORK(J) = QRAUX(J)                                             00001370
   70 CONTINUE                                                          00001380
   80 CONTINUE                                                          00001390
C                                                                       00001400
C     PERFORM THE HOUSEHOLDER REDUCTION OF X.                           00001410
C                                                                       00001420
      LUP = MIN0(N,P)                                                   00001430
      DO 200 L = 1, LUP                                                 00001440
         IF (L .LT. PL .OR. L .GE. PU) GO TO 120                        00001450
C                                                                       00001460
C           LOCATE THE COLUMN OF LARGEST NORM AND BRING IT              00001470
C           INTO THE PIVOT POSITION.                                    00001480
C                                                                       00001490
            MAXNRM = 0.0E0                                              00001500
            MAXJ = L                                                    00001510
            DO 100 J = L, PU                                            00001520
               IF (REAL(QRAUX(J)) .LE. MAXNRM) GO TO 90                 00001530
                  MAXNRM = REAL(QRAUX(J))                               00001540
                  MAXJ = J                                              00001550
   90          CONTINUE                                                 00001560
  100       CONTINUE                                                    00001570
            IF (MAXJ .EQ. L) GO TO 110                                  00001580
               CALL CSWAP(N,X(1,L),1,X(1,MAXJ),1)                       00001590
               QRAUX(MAXJ) = QRAUX(L)                                   00001600
               WORK(MAXJ) = WORK(L)                                     00001610
               JP = JPVT(MAXJ)                                          00001620
               JPVT(MAXJ) = JPVT(L)                                     00001630
               JPVT(L) = JP                                             00001640
  110       CONTINUE                                                    00001650
  120    CONTINUE                                                       00001660
         QRAUX(L) = (0.0E0,0.0E0)                                       00001670
         IF (L .EQ. N) GO TO 190                                        00001680
C                                                                       00001690
C           COMPUTE THE HOUSEHOLDER TRANSFORMATION FOR COLUMN L.        00001700
C                                                                       00001710
            NRMXL = CMPLX(SCNRM2(N-L+1,X(L,L),1),0.0E0)                 00001720
            IF (CABS1(NRMXL) .EQ. 0.0E0) GO TO 180                      00001730
               IF (CABS1(X(L,L)) .NE. 0.0E0)                            00001740
     *            NRMXL = CSIGN(NRMXL,X(L,L))                           00001750
               CALL CSCAL(N-L+1,(1.0E0,0.0E0)/NRMXL,X(L,L),1)           00001760
               X(L,L) = (1.0E0,0.0E0) + X(L,L)                          00001770
C                                                                       00001780
C              APPLY THE TRANSFORMATION TO THE REMAINING COLUMNS,       00001790
C              UPDATING THE NORMS.                                      00001800
C                                                                       00001810
               LP1 = L + 1                                              00001820
               IF (P .LT. LP1) GO TO 170                                00001830
               DO 160 J = LP1, P                                        00001840
                  T = -CDOTC(N-L+1,X(L,L),1,X(L,J),1)/X(L,L)            00001850
                  CALL CAXPY(N-L+1,T,X(L,L),1,X(L,J),1)                 00001860
                  IF (J .LT. PL .OR. J .GT. PU) GO TO 150               00001870
                  IF (CABS1(QRAUX(J)) .EQ. 0.0E0) GO TO 150             00001880
                     TT = 1.0E0 - (CABS(X(L,J))/REAL(QRAUX(J)))**2      00001890
                     TT = AMAX1(TT,0.0E0)                               00001900
                     T = CMPLX(TT,0.0E0)                                00001910
                     TT = 1.0E0                                         00001920
     *                    + 0.05E0*TT*(REAL(QRAUX(J))/REAL(WORK(J)))**2 00001930
                     IF (TT .EQ. 1.0E0) GO TO 130                       00001940
                        QRAUX(J) = QRAUX(J)*CSQRT(T)                    00001950
                     GO TO 140                                          00001960
  130                CONTINUE                                           00001970
                        QRAUX(J) = CMPLX(SCNRM2(N-L,X(L+1,J),1),0.0E0)  00001980
                        WORK(J) = QRAUX(J)                              00001990
  140                CONTINUE                                           00002000
  150             CONTINUE                                              00002010
  160          CONTINUE                                                 00002020
  170          CONTINUE                                                 00002030
C                                                                       00002040
C              SAVE THE TRANSFORMATION.                                 00002050
C                                                                       00002060
               QRAUX(L) = X(L,L)                                        00002070
               X(L,L) = -NRMXL                                          00002080
  180       CONTINUE                                                    00002090
  190    CONTINUE                                                       00002100
  200 CONTINUE                                                          00002110
      RETURN                                                            00002120
      END                                                               00002130
