*#**********************************************************************

      SUBROUTINE CQRSL(X,LDX,N,K,QRAUX,Y,QY,QTY,B,RSD,XB,JOB,INFO)      00000010

      INTEGER LDX,N,K,JOB,INFO                                          00000020
      COMPLEX X(LDX,1),QRAUX(1),Y(1),QY(1),QTY(1),B(1),RSD(1),XB(1)     00000030
C                                                                       00000040
C     CQRSL APPLIES THE OUTPUT OF CQRDC TO COMPUTE COORDINATE           00000050
C     TRANSFORMATIONS, PROJECTIONS, AND LEAST SQUARES SOLUTIONS.        00000060
C     FOR K .LE. MIN(N,P), LET XK BE THE MATRIX                         00000070
C                                                                       00000080
C            XK = (X(JPVT(1)),X(JPVT(2)), ... ,X(JPVT(K)))              00000090
C                                                                       00000100
C     FORMED FROM COLUMNNS JPVT(1), ... ,JPVT(K) OF THE ORIGINAL        00000110
C     N X P MATRIX X THAT WAS INPUT TO CQRDC (IF NO PIVOTING WAS        00000120
C     DONE, XK CONSISTS OF THE FIRST K COLUMNS OF X IN THEIR            00000130
C     ORIGINAL ORDER).  CQRDC PRODUCES A FACTORED UNITARY MATRIX Q      00000140
C     AND AN UPPER TRIANGULAR MATRIX R SUCH THAT                        00000150
C                                                                       00000160
C              XK = Q * (R)                                             00000170
C                       (0)                                             00000180
C                                                                       00000190
C     THIS INFORMATION IS CONTAINED IN CODED FORM IN THE ARRAYS         00000200
C     X AND QRAUX.                                                      00000210
C                                                                       00000220
C     ON ENTRY                                                          00000230
C                                                                       00000240
C        X      COMPLEX(LDX,P).                                         00000250
C               X CONTAINS THE OUTPUT OF CQRDC.                         00000260
C                                                                       00000270
C        LDX    INTEGER.                                                00000280
C               LDX IS THE LEADING DIMENSION OF THE ARRAY X.            00000290
C                                                                       00000300
C        N      INTEGER.                                                00000310
C               N IS THE NUMBER OF ROWS OF THE MATRIX XK.  IT MUST      00000320
C               HAVE THE SAME VALUE AS N IN CQRDC.                      00000330
C                                                                       00000340
C        K      INTEGER.                                                00000350
C               K IS THE NUMBER OF COLUMNS OF THE MATRIX XK.  K         00000360
C               MUST NNOT BE GREATER THAN MIN(N,P), WHERE P IS THE      00000370
C               SAME AS IN THE CALLING SEQUENCE TO CQRDC.               00000380
C                                                                       00000390
C        QRAUX  COMPLEX(P).                                             00000400
C               QRAUX CONTAINS THE AUXILIARY OUTPUT FROM CQRDC.         00000410
C                                                                       00000420
C        Y      COMPLEX(N)                                              00000430
C               Y CONTAINS AN N-VECTOR THAT IS TO BE MANIPULATED        00000440
C               BY CQRSL.                                               00000450
C                                                                       00000460
C        JOB    INTEGER.                                                00000470
C               JOB SPECIFIES WHAT IS TO BE COMPUTED.  JOB HAS          00000480
C               THE DECIMAL EXPANSION ABCDE, WITH THE FOLLOWING         00000490
C               MEANING.                                                00000500
C                                                                       00000510
C                    IF A.NE.0, COMPUTE QY.                             00000520
C                    IF B,C,D, OR E .NE. 0, COMPUTE QTY.                00000530
C                    IF C.NE.0, COMPUTE B.                              00000540
C                    IF D.NE.0, COMPUTE RSD.                            00000550
C                    IF E.NE.0, COMPUTE XB.                             00000560
C                                                                       00000570
C               NOTE THAT A REQUEST TO COMPUTE B, RSD, OR XB            00000580
C               AUTOMATICALLY TRIGGERS THE COMPUTATION OF QTY, FOR      00000590
C               WHICH AN ARRAY MUST BE PROVIDED IN THE CALLING          00000600
C               SEQUENCE.                                               00000610
C                                                                       00000620
C     ON RETURN                                                         00000630
C                                                                       00000640
C        QY     COMPLEX(N).                                             00000650
C               QY CONNTAINS Q*Y, IF ITS COMPUTATION HAS BEEN           00000660
C               REQUESTED.                                              00000670
C                                                                       00000680
C        QTY    COMPLEX(N).                                             00000690
C               QTY CONTAINS CTRANS(Q)*Y, IF ITS COMPUTATION HAS        00000700
C               BEEN REQUESTED.  HERE CTRANS(Q) IS THE CONJUGATE        00000710
C               TRANSPOSE OF THE MATRIX Q.                              00000720
C                                                                       00000730
C        B      COMPLEX(K)                                              00000740
C               B CONTAINS THE SOLUTION OF THE LEAST SQUARES PROBLEM    00000750
C                                                                       00000760
C                    MINIMIZE NORM2(Y - XK*B),                          00000770
C                                                                       00000780
C               IF ITS COMPUTATION HAS BEEN REQUESTED.  (NOTE THAT      00000790
C               IF PIVOTING WAS REQUESTED IN CQRDC, THE J-TH            00000800
C               COMPONENT OF B WILL BE ASSOCIATED WITH COLUMN JPVT(J)   00000810
C               OF THE ORIGINAL MATRIX X THAT WAS INPUT INTO CQRDC.)    00000820
C                                                                       00000830
C        RSD    COMPLEX(N).                                             00000840
C               RSD CONTAINS THE LEAST SQUARES RESIDUAL Y - XK*B,       00000850
C               IF ITS COMPUTATION HAS BEEN REQUESTED.  RSD IS          00000860
C               ALSO THE ORTHOGONAL PROJECTION OF Y ONTO THE            00000870
C               ORTHOGONAL COMPLEMENT OF THE COLUMN SPACE OF XK.        00000880
C                                                                       00000890
C        XB     COMPLEX(N).                                             00000900
C               XB CONTAINS THE LEAST SQUARES APPROXIMATION XK*B,       00000910
C               IF ITS COMPUTATION HAS BEEN REQUESTED.  XB IS ALSO      00000920
C               THE ORTHOGONAL PROJECTION OF Y ONTO THE COLUMN SPACE    00000930
C               OF X.                                                   00000940
C                                                                       00000950
C        INFO   INTEGER.                                                00000960
C               INFO IS ZERO UNLESS THE COMPUTATION OF B HAS            00000970
C               BEEN REQUESTED AND R IS EXACTLY SINGULAR.  IN           00000980
C               THIS CASE, INFO IS THE INDEX OF THE FIRST ZERO          00000990
C               DIAGONAL ELEMENT OF R AND B IS LEFT UNALTERED.          00001000
C                                                                       00001010
C     THE PARAMETERS QY, QTY, B, RSD, AND XB ARE NOT REFERENCED         00001020
C     IF THEIR COMPUTATION IS NOT REQUESTED AND IN THIS CASE            00001030
C     CAN BE REPLACED BY DUMMY VARIABLES IN THE CALLING PROGRAM.        00001040
C     TO SAVE STORAGE, THE USER MAY IN SOME CASES USE THE SAME          00001050
C     ARRAY FOR DIFFERENT PARAMETERS IN THE CALLING SEQUENCE.  A        00001060
C     FREQUENTLY OCCURING EXAMPLE IS WHEN ONE WISHES TO COMPUTE         00001070
C     ANY OF B, RSD, OR XB AND DOES NOT NEED Y OR QTY.  IN THIS         00001080
C     CASE ONE MAY IDENTIFY Y, QTY, AND ONE OF B, RSD, OR XB, WHILE     00001090
C     PROVIDING SEPARATE ARRAYS FOR ANYTHING ELSE THAT IS TO BE         00001100
C     COMPUTED.  THUS THE CALLING SEQUENCE                              00001110
C                                                                       00001120
C          CALL CQRSL(X,LDX,N,K,QRAUX,Y,DUM,Y,B,Y,DUM,110,INFO)         00001130
C                                                                       00001140
C     WILL RESULT IN THE COMPUTATION OF B AND RSD, WITH RSD             00001150
C     OVERWRITING Y.  MORE GENERALLY, EACH ITEM IN THE FOLLOWING        00001160
C     LIST CONTAINS GROUPS OF PERMISSIBLE IDENTIFICATIONS FOR           00001170
C     A SINGLE CALLINNG SEQUENCE.                                       00001180
C                                                                       00001190
C          1. (Y,QTY,B) (RSD) (XB) (QY)                                 00001200
C                                                                       00001210
C          2. (Y,QTY,RSD) (B) (XB) (QY)                                 00001220
C                                                                       00001230
C          3. (Y,QTY,XB) (B) (RSD) (QY)                                 00001240
C                                                                       00001250
C          4. (Y,QY) (QTY,B) (RSD) (XB)                                 00001260
C                                                                       00001270
C          5. (Y,QY) (QTY,RSD) (B) (XB)                                 00001280
C                                                                       00001290
C          6. (Y,QY) (QTY,XB) (B) (RSD)                                 00001300
C                                                                       00001310
C     IN ANY GROUP THE VALUE RETURNED IN THE ARRAY ALLOCATED TO         00001320
C     THE GROUP CORRESPONDS TO THE LAST MEMBER OF THE GROUP.            00001330
C                                                                       00001340
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00001350
C     G.W. STEWART, UNIVERSITY OF MARYLAND, ARGONNE NATIONAL LAB.       00001360
C                                                                       00001370
C     CQRSL USES THE FOLLOWING FUNCTIONS AND SUBPROGRAMS.               00001380
C                                                                       00001390
C     BLAS CAXPY,CCOPY,CDOTC                                            00001400
C     FORTRAN ABS,AIMAG,MIN0,MOD,REAL                                   00001410
C                                                                       00001420
C     INTERNAL VARIABLES                                                00001430
C                                                                       00001440
      INTEGER I,J,JJ,JU,KP1                                             00001450
      COMPLEX CDOTC,T,TEMP                                              00001460
      LOGICAL CB,CQY,CQTY,CR,CXB                                        00001470
C                                                                       00001480
      COMPLEX ZDUM                                                      00001490
      REAL CABS1                                                        00001500
      CABS1(ZDUM) = ABS(REAL(ZDUM)) + ABS(AIMAG(ZDUM))                  00001510
C                                                                       00001520
C     SET INFO FLAG.                                                    00001530
C                                                                       00001540
      INFO = 0                                                          00001550
C                                                                       00001560
C     DETERMINE WHAT IS TO BE COMPUTED.                                 00001570
C                                                                       00001580
      CQY = JOB/10000 .NE. 0                                            00001590
      CQTY = MOD(JOB,10000) .NE. 0                                      00001600
      CB = MOD(JOB,1000)/100 .NE. 0                                     00001610
      CR = MOD(JOB,100)/10 .NE. 0                                       00001620
      CXB = MOD(JOB,10) .NE. 0                                          00001630
      JU = MIN0(K,N-1)                                                  00001640
C                                                                       00001650
C     SPECIAL ACTION WHEN N=1.                                          00001660
C                                                                       00001670
      IF (JU .NE. 0) GO TO 40                                           00001680
         IF (CQY) QY(1) = Y(1)                                          00001690
         IF (CQTY) QTY(1) = Y(1)                                        00001700
         IF (CXB) XB(1) = Y(1)                                          00001710
         IF (.NOT.CB) GO TO 30                                          00001720
            IF (CABS1(X(1,1)) .NE. 0.0E0) GO TO 10                      00001730
               INFO = 1                                                 00001740
            GO TO 20                                                    00001750
   10       CONTINUE                                                    00001760
               B(1) = Y(1)/X(1,1)                                       00001770
   20       CONTINUE                                                    00001780
   30    CONTINUE                                                       00001790
         IF (CR) RSD(1) = (0.0E0,0.0E0)                                 00001800
      GO TO 250                                                         00001810
   40 CONTINUE                                                          00001820
C                                                                       00001830
C        SET UP TO COMPUTE QY OR QTY.                                   00001840
C                                                                       00001850
         IF (CQY) CALL CCOPY(N,Y,1,QY,1)                                00001860
         IF (CQTY) CALL CCOPY(N,Y,1,QTY,1)                              00001870
         IF (.NOT.CQY) GO TO 70                                         00001880
C                                                                       00001890
C           COMPUTE QY.                                                 00001900
C                                                                       00001910
            DO 60 JJ = 1, JU                                            00001920
               J = JU - JJ + 1                                          00001930
               IF (CABS1(QRAUX(J)) .EQ. 0.0E0) GO TO 50                 00001940
                  TEMP = X(J,J)                                         00001950
                  X(J,J) = QRAUX(J)                                     00001960
                  T = -CDOTC(N-J+1,X(J,J),1,QY(J),1)/X(J,J)             00001970
                  CALL CAXPY(N-J+1,T,X(J,J),1,QY(J),1)                  00001980
                  X(J,J) = TEMP                                         00001990
   50          CONTINUE                                                 00002000
   60       CONTINUE                                                    00002010
   70    CONTINUE                                                       00002020
         IF (.NOT.CQTY) GO TO 100                                       00002030
C                                                                       00002040
C           COMPUTE CTRANS(Q)*Y.                                        00002050
C                                                                       00002060
            DO 90 J = 1, JU                                             00002070
               IF (CABS1(QRAUX(J)) .EQ. 0.0E0) GO TO 80                 00002080
                  TEMP = X(J,J)                                         00002090
                  X(J,J) = QRAUX(J)                                     00002100
                  T = -CDOTC(N-J+1,X(J,J),1,QTY(J),1)/X(J,J)            00002110
                  CALL CAXPY(N-J+1,T,X(J,J),1,QTY(J),1)                 00002120
                  X(J,J) = TEMP                                         00002130
   80          CONTINUE                                                 00002140
   90       CONTINUE                                                    00002150
  100    CONTINUE                                                       00002160
C                                                                       00002170
C        SET UP TO COMPUTE B, RSD, OR XB.                               00002180
C                                                                       00002190
         IF (CB) CALL CCOPY(K,QTY,1,B,1)                                00002200
         KP1 = K + 1                                                    00002210
         IF (CXB) CALL CCOPY(K,QTY,1,XB,1)                              00002220
         IF (CR .AND. K .LT. N) CALL CCOPY(N-K,QTY(KP1),1,RSD(KP1),1)   00002230
         IF (.NOT.CXB .OR. KP1 .GT. N) GO TO 120                        00002240
            DO 110 I = KP1, N                                           00002250
               XB(I) = (0.0E0,0.0E0)                                    00002260
  110       CONTINUE                                                    00002270
  120    CONTINUE                                                       00002280
         IF (.NOT.CR) GO TO 140                                         00002290
            DO 130 I = 1, K                                             00002300
               RSD(I) = (0.0E0,0.0E0)                                   00002310
  130       CONTINUE                                                    00002320
  140    CONTINUE                                                       00002330
         IF (.NOT.CB) GO TO 190                                         00002340
C                                                                       00002350
C           COMPUTE B.                                                  00002360
C                                                                       00002370
            DO 170 JJ = 1, K                                            00002380
               J = K - JJ + 1                                           00002390
               IF (CABS1(X(J,J)) .NE. 0.0E0) GO TO 150                  00002400
                  INFO = J                                              00002410
C           ......EXIT                                                  00002420
                  GO TO 180                                             00002430
  150          CONTINUE                                                 00002440
               B(J) = B(J)/X(J,J)                                       00002450
               IF (J .EQ. 1) GO TO 160                                  00002460
                  T = -B(J)                                             00002470
                  CALL CAXPY(J-1,T,X(1,J),1,B,1)                        00002480
  160          CONTINUE                                                 00002490
  170       CONTINUE                                                    00002500
  180       CONTINUE                                                    00002510
  190    CONTINUE                                                       00002520
         IF (.NOT.CR .AND. .NOT.CXB) GO TO 240                          00002530
C                                                                       00002540
C           COMPUTE RSD OR XB AS REQUIRED.                              00002550
C                                                                       00002560
            DO 230 JJ = 1, JU                                           00002570
               J = JU - JJ + 1                                          00002580
               IF (CABS1(QRAUX(J)) .EQ. 0.0E0) GO TO 220                00002590
                  TEMP = X(J,J)                                         00002600
                  X(J,J) = QRAUX(J)                                     00002610
                  IF (.NOT.CR) GO TO 200                                00002620
                     T = -CDOTC(N-J+1,X(J,J),1,RSD(J),1)/X(J,J)         00002630
                     CALL CAXPY(N-J+1,T,X(J,J),1,RSD(J),1)              00002640
  200             CONTINUE                                              00002650
                  IF (.NOT.CXB) GO TO 210                               00002660
                     T = -CDOTC(N-J+1,X(J,J),1,XB(J),1)/X(J,J)          00002670
                     CALL CAXPY(N-J+1,T,X(J,J),1,XB(J),1)               00002680
  210             CONTINUE                                              00002690
                  X(J,J) = TEMP                                         00002700
  220          CONTINUE                                                 00002710
  230       CONTINUE                                                    00002720
  240    CONTINUE                                                       00002730
  250 CONTINUE                                                          00002740
      RETURN                                                            00002750
      END                                                               00002760
