*#**********************************************************************

      SUBROUTINE CSICO(A,LDA,N,KPVT,RCOND,Z)                            00000010

      INTEGER LDA,N,KPVT(1)                                             00000020
      COMPLEX A(LDA,1),Z(1)                                             00000030
      REAL RCOND                                                        00000040
C                                                                       00000050
C     CSICO FACTORS A COMPLEX SYMMETRIC MATRIX BY ELIMINATION WITH      00000060
C     SYMMETRIC PIVOTING AND ESTIMATES THE CONDITION OF THE MATRIX.     00000070
C                                                                       00000080
C     IF  RCOND  IS NOT NEEDED, CSIFA IS SLIGHTLY FASTER.               00000090
C     TO SOLVE  A*X = B , FOLLOW CSICO BY CSISL.                        00000100
C     TO COMPUTE  INVERSE(A)*C , FOLLOW CSICO BY CSISL.                 00000110
C     TO COMPUTE  INVERSE(A) , FOLLOW CSICO BY CSIDI.                   00000120
C     TO COMPUTE  DETERMINANT(A) , FOLLOW CSICO BY CSIDI.               00000130
C                                                                       00000140
C     ON ENTRY                                                          00000150
C                                                                       00000160
C        A       COMPLEX(LDA, N)                                        00000170
C                THE SYMMETRIC MATRIX TO BE FACTORED.                   00000180
C                ONLY THE DIAGONAL AND UPPER TRIANGLE ARE USED.         00000190
C                                                                       00000200
C        LDA     INTEGER                                                00000210
C                THE LEADING DIMENSION OF THE ARRAY  A .                00000220
C                                                                       00000230
C        N       INTEGER                                                00000240
C                THE ORDER OF THE MATRIX  A .                           00000250
C                                                                       00000260
C     ON RETURN                                                         00000270
C                                                                       00000280
C        A       A BLOCK DIAGONAL MATRIX AND THE MULTIPLIERS WHICH      00000290
C                WERE USED TO OBTAIN IT.                                00000300
C                THE FACTORIZATION CAN BE WRITTEN  A = U*D*TRANS(U)     00000310
C                WHERE  U  IS A PRODUCT OF PERMUTATION AND UNIT         00000320
C                UPPER TRIANGULAR MATRICES , TRANS(U) IS THE            00000330
C                TRANSPOSE OF  U , AND  D  IS BLOCK DIAGONAL            00000340
C                WITH 1 BY 1 AND 2 BY 2 BLOCKS.                         00000350
C                                                                       00000360
C        KPVT    INTEGER(N)                                             00000370
C                AN INTEGER VECTOR OF PIVOT INDICES.                    00000380
C                                                                       00000390
C        RCOND   REAL                                                   00000400
C                AN ESTIMATE OF THE RECIPROCAL CONDITION OF  A .        00000410
C                FOR THE SYSTEM  A*X = B , RELATIVE PERTURBATIONS       00000420
C                IN  A  AND  B  OF SIZE  EPSILON  MAY CAUSE             00000430
C                RELATIVE PERTURBATIONS IN  X  OF SIZE  EPSILON/RCOND . 00000440
C                IF  RCOND  IS SO SMALL THAT THE LOGICAL EXPRESSION     00000450
C                           1.0 + RCOND .EQ. 1.0                        00000460
C                IS TRUE, THEN  A  MAY BE SINGULAR TO WORKING           00000470
C                PRECISION.  IN PARTICULAR,  RCOND  IS ZERO  IF         00000480
C                EXACT SINGULARITY IS DETECTED OR THE ESTIMATE          00000490
C                UNDERFLOWS.                                            00000500
C                                                                       00000510
C        Z       COMPLEX(N)                                             00000520
C                A WORK VECTOR WHOSE CONTENTS ARE USUALLY UNIMPORTANT.  00000530
C                IF  A  IS CLOSE TO A SINGULAR MATRIX, THEN  Z  IS      00000540
C                AN APPROXIMATE NULL VECTOR IN THE SENSE THAT           00000550
C                NORM(A*Z) = RCOND*NORM(A)*NORM(Z) .                    00000560
C                                                                       00000570
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000580
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000590
C                                                                       00000600
C     SUBROUTINES AND FUNCTIONS                                         00000610
C                                                                       00000620
C     LINPACK CSIFA                                                     00000630
C     BLAS CAXPY,CDOTU,CSSCAL,SCASUM                                    00000640
C     FORTRAN ABS,AIMAG,AMAX1,CMPLX,IABS,REAL                           00000650
C                                                                       00000660
C     INTERNAL VARIABLES                                                00000670
C                                                                       00000680
      COMPLEX AK,AKM1,BK,BKM1,CDOTU,DENOM,EK,T                          00000690
      REAL ANORM,S,SCASUM,YNORM                                         00000700
      INTEGER I,INFO,J,JM1,K,KP,KPS,KS                                  00000710
C                                                                       00000720
      COMPLEX ZDUM,ZDUM2,CSIGN1                                         00000730
      REAL CABS1                                                        00000740
      CABS1(ZDUM) = ABS(REAL(ZDUM)) + ABS(AIMAG(ZDUM))                  00000750
      CSIGN1(ZDUM,ZDUM2) = CABS1(ZDUM)*(ZDUM2/CABS1(ZDUM2))             00000760
C                                                                       00000770
C     FIND NORM OF A USING ONLY UPPER HALF                              00000780
C                                                                       00000790
      DO 30 J = 1, N                                                    00000800
         Z(J) = CMPLX(SCASUM(J,A(1,J),1),0.0E0)                         00000810
         JM1 = J - 1                                                    00000820
         IF (JM1 .LT. 1) GO TO 20                                       00000830
         DO 10 I = 1, JM1                                               00000840
            Z(I) = CMPLX(REAL(Z(I))+CABS1(A(I,J)),0.0E0)                00000850
   10    CONTINUE                                                       00000860
   20    CONTINUE                                                       00000870
   30 CONTINUE                                                          00000880
      ANORM = 0.0E0                                                     00000890
      DO 40 J = 1, N                                                    00000900
         ANORM = AMAX1(ANORM,REAL(Z(J)))                                00000910
   40 CONTINUE                                                          00000920
C                                                                       00000930
C     FACTOR                                                            00000940
C                                                                       00000950
      CALL CSIFA(A,LDA,N,KPVT,INFO)                                     00000960
C                                                                       00000970
C     RCOND = 1/(NORM(A)*(ESTIMATE OF NORM(INVERSE(A)))) .              00000980
C     ESTIMATE = NORM(Z)/NORM(Y) WHERE  A*Z = Y  AND  A*Y = E .         00000990
C     THE COMPONENTS OF  E  ARE CHOSEN TO CAUSE MAXIMUM LOCAL           00001000
C     GROWTH IN THE ELEMENTS OF W  WHERE  U*D*W = E .                   00001010
C     THE VECTORS ARE FREQUENTLY RESCALED TO AVOID OVERFLOW.            00001020
C                                                                       00001030
C     SOLVE U*D*W = E                                                   00001040
C                                                                       00001050
      EK = (1.0E0,0.0E0)                                                00001060
      DO 50 J = 1, N                                                    00001070
         Z(J) = (0.0E0,0.0E0)                                           00001080
   50 CONTINUE                                                          00001090
      K = N                                                             00001100
   60 IF (K .EQ. 0) GO TO 120                                           00001110
         KS = 1                                                         00001120
         IF (KPVT(K) .LT. 0) KS = 2                                     00001130
         KP = IABS(KPVT(K))                                             00001140
         KPS = K + 1 - KS                                               00001150
         IF (KP .EQ. KPS) GO TO 70                                      00001160
            T = Z(KPS)                                                  00001170
            Z(KPS) = Z(KP)                                              00001180
            Z(KP) = T                                                   00001190
   70    CONTINUE                                                       00001200
         IF (CABS1(Z(K)) .NE. 0.0E0) EK = CSIGN1(EK,Z(K))               00001210
         Z(K) = Z(K) + EK                                               00001220
         CALL CAXPY(K-KS,Z(K),A(1,K),1,Z(1),1)                          00001230
         IF (KS .EQ. 1) GO TO 80                                        00001240
            IF (CABS1(Z(K-1)) .NE. 0.0E0) EK = CSIGN1(EK,Z(K-1))        00001250
            Z(K-1) = Z(K-1) + EK                                        00001260
            CALL CAXPY(K-KS,Z(K-1),A(1,K-1),1,Z(1),1)                   00001270
   80    CONTINUE                                                       00001280
         IF (KS .EQ. 2) GO TO 100                                       00001290
            IF (CABS1(Z(K)) .LE. CABS1(A(K,K))) GO TO 90                00001300
               S = CABS1(A(K,K))/CABS1(Z(K))                            00001310
               CALL CSSCAL(N,S,Z,1)                                     00001320
               EK = CMPLX(S,0.0E0)*EK                                   00001330
   90       CONTINUE                                                    00001340
            IF (CABS1(A(K,K)) .NE. 0.0E0) Z(K) = Z(K)/A(K,K)            00001350
            IF (CABS1(A(K,K)) .EQ. 0.0E0) Z(K) = (1.0E0,0.0E0)          00001360
         GO TO 110                                                      00001370
  100    CONTINUE                                                       00001380
            AK = A(K,K)/A(K-1,K)                                        00001390
            AKM1 = A(K-1,K-1)/A(K-1,K)                                  00001400
            BK = Z(K)/A(K-1,K)                                          00001410
            BKM1 = Z(K-1)/A(K-1,K)                                      00001420
            DENOM = AK*AKM1 - 1.0E0                                     00001430
            Z(K) = (AKM1*BK - BKM1)/DENOM                               00001440
            Z(K-1) = (AK*BKM1 - BK)/DENOM                               00001450
  110    CONTINUE                                                       00001460
         K = K - KS                                                     00001470
      GO TO 60                                                          00001480
  120 CONTINUE                                                          00001490
      S = 1.0E0/SCASUM(N,Z,1)                                           00001500
      CALL CSSCAL(N,S,Z,1)                                              00001510
C                                                                       00001520
C     SOLVE TRANS(U)*Y = W                                              00001530
C                                                                       00001540
      K = 1                                                             00001550
  130 IF (K .GT. N) GO TO 160                                           00001560
         KS = 1                                                         00001570
         IF (KPVT(K) .LT. 0) KS = 2                                     00001580
         IF (K .EQ. 1) GO TO 150                                        00001590
            Z(K) = Z(K) + CDOTU(K-1,A(1,K),1,Z(1),1)                    00001600
            IF (KS .EQ. 2)                                              00001610
     *         Z(K+1) = Z(K+1) + CDOTU(K-1,A(1,K+1),1,Z(1),1)           00001620
            KP = IABS(KPVT(K))                                          00001630
            IF (KP .EQ. K) GO TO 140                                    00001640
               T = Z(K)                                                 00001650
               Z(K) = Z(KP)                                             00001660
               Z(KP) = T                                                00001670
  140       CONTINUE                                                    00001680
  150    CONTINUE                                                       00001690
         K = K + KS                                                     00001700
      GO TO 130                                                         00001710
  160 CONTINUE                                                          00001720
      S = 1.0E0/SCASUM(N,Z,1)                                           00001730
      CALL CSSCAL(N,S,Z,1)                                              00001740
C                                                                       00001750
      YNORM = 1.0E0                                                     00001760
C                                                                       00001770
C     SOLVE U*D*V = Y                                                   00001780
C                                                                       00001790
      K = N                                                             00001800
  170 IF (K .EQ. 0) GO TO 230                                           00001810
         KS = 1                                                         00001820
         IF (KPVT(K) .LT. 0) KS = 2                                     00001830
         IF (K .EQ. KS) GO TO 190                                       00001840
            KP = IABS(KPVT(K))                                          00001850
            KPS = K + 1 - KS                                            00001860
            IF (KP .EQ. KPS) GO TO 180                                  00001870
               T = Z(KPS)                                               00001880
               Z(KPS) = Z(KP)                                           00001890
               Z(KP) = T                                                00001900
  180       CONTINUE                                                    00001910
            CALL CAXPY(K-KS,Z(K),A(1,K),1,Z(1),1)                       00001920
            IF (KS .EQ. 2) CALL CAXPY(K-KS,Z(K-1),A(1,K-1),1,Z(1),1)    00001930
  190    CONTINUE                                                       00001940
         IF (KS .EQ. 2) GO TO 210                                       00001950
            IF (CABS1(Z(K)) .LE. CABS1(A(K,K))) GO TO 200               00001960
               S = CABS1(A(K,K))/CABS1(Z(K))                            00001970
               CALL CSSCAL(N,S,Z,1)                                     00001980
               YNORM = S*YNORM                                          00001990
  200       CONTINUE                                                    00002000
            IF (CABS1(A(K,K)) .NE. 0.0E0) Z(K) = Z(K)/A(K,K)            00002010
            IF (CABS1(A(K,K)) .EQ. 0.0E0) Z(K) = (1.0E0,0.0E0)          00002020
         GO TO 220                                                      00002030
  210    CONTINUE                                                       00002040
            AK = A(K,K)/A(K-1,K)                                        00002050
            AKM1 = A(K-1,K-1)/A(K-1,K)                                  00002060
            BK = Z(K)/A(K-1,K)                                          00002070
            BKM1 = Z(K-1)/A(K-1,K)                                      00002080
            DENOM = AK*AKM1 - 1.0E0                                     00002090
            Z(K) = (AKM1*BK - BKM1)/DENOM                               00002100
            Z(K-1) = (AK*BKM1 - BK)/DENOM                               00002110
  220    CONTINUE                                                       00002120
         K = K - KS                                                     00002130
      GO TO 170                                                         00002140
  230 CONTINUE                                                          00002150
      S = 1.0E0/SCASUM(N,Z,1)                                           00002160
      CALL CSSCAL(N,S,Z,1)                                              00002170
      YNORM = S*YNORM                                                   00002180
C                                                                       00002190
C     SOLVE TRANS(U)*Z = V                                              00002200
C                                                                       00002210
      K = 1                                                             00002220
  240 IF (K .GT. N) GO TO 270                                           00002230
         KS = 1                                                         00002240
         IF (KPVT(K) .LT. 0) KS = 2                                     00002250
         IF (K .EQ. 1) GO TO 260                                        00002260
            Z(K) = Z(K) + CDOTU(K-1,A(1,K),1,Z(1),1)                    00002270
            IF (KS .EQ. 2)                                              00002280
     *         Z(K+1) = Z(K+1) + CDOTU(K-1,A(1,K+1),1,Z(1),1)           00002290
            KP = IABS(KPVT(K))                                          00002300
            IF (KP .EQ. K) GO TO 250                                    00002310
               T = Z(K)                                                 00002320
               Z(K) = Z(KP)                                             00002330
               Z(KP) = T                                                00002340
  250       CONTINUE                                                    00002350
  260    CONTINUE                                                       00002360
         K = K + KS                                                     00002370
      GO TO 240                                                         00002380
  270 CONTINUE                                                          00002390
C     MAKE ZNORM = 1.0                                                  00002400
      S = 1.0E0/SCASUM(N,Z,1)                                           00002410
      CALL CSSCAL(N,S,Z,1)                                              00002420
      YNORM = S*YNORM                                                   00002430
C                                                                       00002440
      IF (ANORM .NE. 0.0E0) RCOND = YNORM/ANORM                         00002450
      IF (ANORM .EQ. 0.0E0) RCOND = 0.0E0                               00002460
      RETURN                                                            00002470
      END                                                               00002480
