*#**********************************************************************

      SUBROUTINE CSIDI(A,LDA,N,KPVT,DET,WORK,JOB)                       00000010

      INTEGER LDA,N,JOB                                                 00000020
      COMPLEX A(LDA,1),DET(2),WORK(1)                                   00000030
      INTEGER KPVT(1)                                                   00000040
C                                                                       00000050
C     CSIDI COMPUTES THE DETERMINANT AND INVERSE                        00000060
C     OF A COMPLEX SYMMETRIC MATRIX USING THE FACTORS FROM CSIFA.       00000070
C                                                                       00000080
C     ON ENTRY                                                          00000090
C                                                                       00000100
C        A       COMPLEX(LDA,N)                                         00000110
C                THE OUTPUT FROM CSIFA.                                 00000120
C                                                                       00000130
C        LDA     INTEGER                                                00000140
C                THE LEADING DIMENSION OF THE ARRAY A.                  00000150
C                                                                       00000160
C        N       INTEGER                                                00000170
C                THE ORDER OF THE MATRIX A.                             00000180
C                                                                       00000190
C        KPVT    INTEGER(N)                                             00000200
C                THE PIVOT VECTOR FROM CSIFA.                           00000210
C                                                                       00000220
C        WORK    COMPLEX(N)                                             00000230
C                WORK VECTOR.  CONTENTS DESTROYED.                      00000240
C                                                                       00000250
C        JOB     INTEGER                                                00000260
C                JOB HAS THE DECIMAL EXPANSION  AB  WHERE               00000270
C                   IF  B .NE. 0, THE INVERSE IS COMPUTED,              00000280
C                   IF  A .NE. 0, THE DETERMINANT IS COMPUTED,          00000290
C                                                                       00000300
C                FOR EXAMPLE, JOB = 11  GIVES BOTH.                     00000310
C                                                                       00000320
C     ON RETURN                                                         00000330
C                                                                       00000340
C        VARIABLES NOT REQUESTED BY JOB ARE NOT USED.                   00000350
C                                                                       00000360
C        A      CONTAINS THE UPPER TRIANGLE OF THE INVERSE OF           00000370
C               THE ORIGINAL MATRIX.  THE STRICT LOWER TRIANGLE         00000380
C               IS NEVER REFERENCED.                                    00000390
C                                                                       00000400
C        DET    COMPLEX(2)                                              00000410
C               DETERMINANT OF ORIGINAL MATRIX.                         00000420
C               DETERMINANT = DET(1) * 10.0**DET(2)                     00000430
C               WITH 1.0 .LE. ABS(DET(1)) .LT. 10.0                     00000440
C               OR DET(1) = 0.0.                                        00000450
C                                                                       00000460
C     ERROR CONDITION                                                   00000470
C                                                                       00000480
C        A DIVISION BY ZERO MAY OCCUR IF THE INVERSE IS REQUESTED       00000490
C        AND  CSICO  HAS SET RCOND .EQ. 0.0                             00000500
C        OR  CSIFA  HAS SET  INFO .NE. 0 .                              00000510
C                                                                       00000520
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000530
C     JAMES BUNCH, UNIV. CALIF. SAN DIEGO, ARGONNE NAT. LAB             00000540
C                                                                       00000550
C     SUBROUTINES AND FUNCTIONS                                         00000560
C                                                                       00000570
C     BLAS CAXPY,CCOPY,CDOTU,CSWAP                                      00000580
C     FORTRAN ABS,CMPLX,IABS,MOD,REAL                                   00000590
C                                                                       00000600
C     INTERNAL VARIABLES.                                               00000610
C                                                                       00000620
      COMPLEX AK,AKP1,AKKP1,CDOTU,D,T,TEMP                              00000630
      REAL TEN                                                          00000640
      INTEGER J,JB,K,KM1,KS,KSTEP                                       00000650
      LOGICAL NOINV,NODET                                               00000660
C                                                                       00000670
      COMPLEX ZDUM                                                      00000680
      REAL CABS1                                                        00000690
      CABS1(ZDUM) = ABS(REAL(ZDUM)) + ABS(AIMAG(ZDUM))                  00000700
C                                                                       00000710
      NOINV = MOD(JOB,10) .EQ. 0                                        00000720
      NODET = MOD(JOB,100)/10 .EQ. 0                                    00000730
C                                                                       00000740
      IF (NODET) GO TO 100                                              00000750
         DET(1) = (1.0E0,0.0E0)                                         00000760
         DET(2) = (0.0E0,0.0E0)                                         00000770
         TEN = 10.0E0                                                   00000780
         T = (0.0E0,0.0E0)                                              00000790
         DO 90 K = 1, N                                                 00000800
            D = A(K,K)                                                  00000810
C                                                                       00000820
C           CHECK IF 1 BY 1                                             00000830
C                                                                       00000840
            IF (KPVT(K) .GT. 0) GO TO 30                                00000850
C                                                                       00000860
C              2 BY 2 BLOCK                                             00000870
C              USE DET (D  T)  =  (D/T * C - T) * T                     00000880
C                      (T  C)                                           00000890
C              TO AVOID UNDERFLOW/OVERFLOW TROUBLES.                    00000900
C              TAKE TWO PASSES THROUGH SCALING.  USE  T  FOR FLAG.      00000910
C                                                                       00000920
               IF (CABS1(T) .NE. 0.0E0) GO TO 10                        00000930
                  T = A(K,K+1)                                          00000940
                  D = (D/T)*A(K+1,K+1) - T                              00000950
               GO TO 20                                                 00000960
   10          CONTINUE                                                 00000970
                  D = T                                                 00000980
                  T = (0.0E0,0.0E0)                                     00000990
   20          CONTINUE                                                 00001000
   30       CONTINUE                                                    00001010
C                                                                       00001020
            DET(1) = D*DET(1)                                           00001030
            IF (CABS1(DET(1)) .EQ. 0.0E0) GO TO 80                      00001040
   40          IF (CABS1(DET(1)) .GE. 1.0E0) GO TO 50                   00001050
                  DET(1) = CMPLX(TEN,0.0E0)*DET(1)                      00001060
                  DET(2) = DET(2) - (1.0E0,0.0E0)                       00001070
               GO TO 40                                                 00001080
   50          CONTINUE                                                 00001090
   60          IF (CABS1(DET(1)) .LT. TEN) GO TO 70                     00001100
                  DET(1) = DET(1)/CMPLX(TEN,0.0E0)                      00001110
                  DET(2) = DET(2) + (1.0E0,0.0E0)                       00001120
               GO TO 60                                                 00001130
   70          CONTINUE                                                 00001140
   80       CONTINUE                                                    00001150
   90    CONTINUE                                                       00001160
  100 CONTINUE                                                          00001170
C                                                                       00001180
C     COMPUTE INVERSE(A)                                                00001190
C                                                                       00001200
      IF (NOINV) GO TO 230                                              00001210
         K = 1                                                          00001220
  110    IF (K .GT. N) GO TO 220                                        00001230
            KM1 = K - 1                                                 00001240
            IF (KPVT(K) .LT. 0) GO TO 140                               00001250
C                                                                       00001260
C              1 BY 1                                                   00001270
C                                                                       00001280
               A(K,K) = (1.0E0,0.0E0)/A(K,K)                            00001290
               IF (KM1 .LT. 1) GO TO 130                                00001300
                  CALL CCOPY(KM1,A(1,K),1,WORK,1)                       00001310
                  DO 120 J = 1, KM1                                     00001320
                     A(J,K) = CDOTU(J,A(1,J),1,WORK,1)                  00001330
                     CALL CAXPY(J-1,WORK(J),A(1,J),1,A(1,K),1)          00001340
  120             CONTINUE                                              00001350
                  A(K,K) = A(K,K) + CDOTU(KM1,WORK,1,A(1,K),1)          00001360
  130          CONTINUE                                                 00001370
               KSTEP = 1                                                00001380
            GO TO 180                                                   00001390
  140       CONTINUE                                                    00001400
C                                                                       00001410
C              2 BY 2                                                   00001420
C                                                                       00001430
               T = A(K,K+1)                                             00001440
               AK = A(K,K)/T                                            00001450
               AKP1 = A(K+1,K+1)/T                                      00001460
               AKKP1 = A(K,K+1)/T                                       00001470
               D = T*(AK*AKP1 - (1.0E0,0.0E0))                          00001480
               A(K,K) = AKP1/D                                          00001490
               A(K+1,K+1) = AK/D                                        00001500
               A(K,K+1) = -AKKP1/D                                      00001510
               IF (KM1 .LT. 1) GO TO 170                                00001520
                  CALL CCOPY(KM1,A(1,K+1),1,WORK,1)                     00001530
                  DO 150 J = 1, KM1                                     00001540
                     A(J,K+1) = CDOTU(J,A(1,J),1,WORK,1)                00001550
                     CALL CAXPY(J-1,WORK(J),A(1,J),1,A(1,K+1),1)        00001560
  150             CONTINUE                                              00001570
                  A(K+1,K+1) = A(K+1,K+1)                               00001580
     *                         + CDOTU(KM1,WORK,1,A(1,K+1),1)           00001590
                  A(K,K+1) = A(K,K+1) + CDOTU(KM1,A(1,K),1,A(1,K+1),1)  00001600
                  CALL CCOPY(KM1,A(1,K),1,WORK,1)                       00001610
                  DO 160 J = 1, KM1                                     00001620
                     A(J,K) = CDOTU(J,A(1,J),1,WORK,1)                  00001630
                     CALL CAXPY(J-1,WORK(J),A(1,J),1,A(1,K),1)          00001640
  160             CONTINUE                                              00001650
                  A(K,K) = A(K,K) + CDOTU(KM1,WORK,1,A(1,K),1)          00001660
  170          CONTINUE                                                 00001670
               KSTEP = 2                                                00001680
  180       CONTINUE                                                    00001690
C                                                                       00001700
C           SWAP                                                        00001710
C                                                                       00001720
            KS = IABS(KPVT(K))                                          00001730
            IF (KS .EQ. K) GO TO 210                                    00001740
               CALL CSWAP(KS,A(1,KS),1,A(1,K),1)                        00001750
               DO 190 JB = KS, K                                        00001760
                  J = K + KS - JB                                       00001770
                  TEMP = A(J,K)                                         00001780
                  A(J,K) = A(KS,J)                                      00001790
                  A(KS,J) = TEMP                                        00001800
  190          CONTINUE                                                 00001810
               IF (KSTEP .EQ. 1) GO TO 200                              00001820
                  TEMP = A(KS,K+1)                                      00001830
                  A(KS,K+1) = A(K,K+1)                                  00001840
                  A(K,K+1) = TEMP                                       00001850
  200          CONTINUE                                                 00001860
  210       CONTINUE                                                    00001870
            K = K + KSTEP                                               00001880
         GO TO 110                                                      00001890
  220    CONTINUE                                                       00001900
  230 CONTINUE                                                          00001910
      RETURN                                                            00001920
      END                                                               00001930
