*#**********************************************************************

      SUBROUTINE CTRCO(T,LDT,N,RCOND,Z,JOB)                             00000010

      INTEGER LDT,N,JOB                                                 00000020
      COMPLEX T(LDT,1),Z(1)                                             00000030
      REAL RCOND                                                        00000040
C                                                                       00000050
C     CTRCO ESTIMATES THE CONDITION OF A COMPLEX TRIANGULAR MATRIX.     00000060
C                                                                       00000070
C     ON ENTRY                                                          00000080
C                                                                       00000090
C        T       COMPLEX(LDT,N)                                         00000100
C                T CONTAINS THE TRIANGULAR MATRIX. THE ZERO             00000110
C                ELEMENTS OF THE MATRIX ARE NOT REFERENCED, AND         00000120
C                THE CORRESPONDING ELEMENTS OF THE ARRAY CAN BE         00000130
C                USED TO STORE OTHER INFORMATION.                       00000140
C                                                                       00000150
C        LDT     INTEGER                                                00000160
C                LDT IS THE LEADING DIMENSION OF THE ARRAY T.           00000170
C                                                                       00000180
C        N       INTEGER                                                00000190
C                N IS THE ORDER OF THE SYSTEM.                          00000200
C                                                                       00000210
C        JOB     INTEGER                                                00000220
C                = 0         T  IS LOWER TRIANGULAR.                    00000230
C                = NONZERO   T  IS UPPER TRIANGULAR.                    00000240
C                                                                       00000250
C     ON RETURN                                                         00000260
C                                                                       00000270
C        RCOND   REAL                                                   00000280
C                AN ESTIMATE OF THE RECIPROCAL CONDITION OF  T .        00000290
C                FOR THE SYSTEM  T*X = B , RELATIVE PERTURBATIONS       00000300
C                IN  T  AND  B  OF SIZE  EPSILON  MAY CAUSE             00000310
C                RELATIVE PERTURBATIONS IN  X  OF SIZE  EPSILON/RCOND . 00000320
C                IF  RCOND  IS SO SMALL THAT THE LOGICAL EXPRESSION     00000330
C                           1.0 + RCOND .EQ. 1.0                        00000340
C                IS TRUE, THEN  T  MAY BE SINGULAR TO WORKING           00000350
C                PRECISION.  IN PARTICULAR,  RCOND  IS ZERO  IF         00000360
C                EXACT SINGULARITY IS DETECTED OR THE ESTIMATE          00000370
C                UNDERFLOWS.                                            00000380
C                                                                       00000390
C        Z       COMPLEX(N)                                             00000400
C                A WORK VECTOR WHOSE CONTENTS ARE USUALLY UNIMPORTANT.  00000410
C                IF  T  IS CLOSE TO A SINGULAR MATRIX, THEN  Z  IS      00000420
C                AN APPROXIMATE NULL VECTOR IN THE SENSE THAT           00000430
C                NORM(A*Z) = RCOND*NORM(A)*NORM(Z) .                    00000440
C                                                                       00000450
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000460
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000470
C                                                                       00000480
C     SUBROUTINES AND FUNCTIONS                                         00000490
C                                                                       00000500
C     BLAS CAXPY,CSSCAL,SCASUM                                          00000510
C     FORTRAN ABS,AIMAG,AMAX1,CMPLX,CONJG,REAL                          00000520
C                                                                       00000530
C     INTERNAL VARIABLES                                                00000540
C                                                                       00000550
      COMPLEX W,WK,WKM,EK                                               00000560
      REAL TNORM,YNORM,S,SM,SCASUM                                      00000570
      INTEGER I1,J,J1,J2,K,KK,L                                         00000580
      LOGICAL LOWER                                                     00000590
      COMPLEX ZDUM,ZDUM1,ZDUM2,CSIGN1                                   00000600
      REAL CABS1                                                        00000610
      CABS1(ZDUM) = ABS(REAL(ZDUM)) + ABS(AIMAG(ZDUM))                  00000620
      CSIGN1(ZDUM1,ZDUM2) = CABS1(ZDUM1)*(ZDUM2/CABS1(ZDUM2))           00000630
C                                                                       00000640
      LOWER = JOB .EQ. 0                                                00000650
C                                                                       00000660
C     COMPUTE 1-NORM OF T                                               00000670
C                                                                       00000680
      TNORM = 0.0E0                                                     00000690
      DO 10 J = 1, N                                                    00000700
         L = J                                                          00000710
         IF (LOWER) L = N + 1 - J                                       00000720
         I1 = 1                                                         00000730
         IF (LOWER) I1 = J                                              00000740
         TNORM = AMAX1(TNORM,SCASUM(L,T(I1,J),1))                       00000750
   10 CONTINUE                                                          00000760
C                                                                       00000770
C     RCOND = 1/(NORM(T)*(ESTIMATE OF NORM(INVERSE(T)))) .              00000780
C     ESTIMATE = NORM(Z)/NORM(Y) WHERE  T*Z = Y  AND  CTRANS(T)*Y = E . 00000790
C     CTRANS(T)  IS THE CONJUGATE TRANSPOSE OF T .                      00000800
C     THE COMPONENTS OF  E  ARE CHOSEN TO CAUSE MAXIMUM LOCAL           00000810
C     GROWTH IN THE ELEMENTS OF Y .                                     00000820
C     THE VECTORS ARE FREQUENTLY RESCALED TO AVOID OVERFLOW.            00000830
C                                                                       00000840
C     SOLVE CTRANS(T)*Y = E                                             00000850
C                                                                       00000860
      EK = (1.0E0,0.0E0)                                                00000870
      DO 20 J = 1, N                                                    00000880
         Z(J) = (0.0E0,0.0E0)                                           00000890
   20 CONTINUE                                                          00000900
      DO 100 KK = 1, N                                                  00000910
         K = KK                                                         00000920
         IF (LOWER) K = N + 1 - KK                                      00000930
         IF (CABS1(Z(K)) .NE. 0.0E0) EK = CSIGN1(EK,-Z(K))              00000940
         IF (CABS1(EK-Z(K)) .LE. CABS1(T(K,K))) GO TO 30                00000950
            S = CABS1(T(K,K))/CABS1(EK-Z(K))                            00000960
            CALL CSSCAL(N,S,Z,1)                                        00000970
            EK = CMPLX(S,0.0E0)*EK                                      00000980
   30    CONTINUE                                                       00000990
         WK = EK - Z(K)                                                 00001000
         WKM = -EK - Z(K)                                               00001010
         S = CABS1(WK)                                                  00001020
         SM = CABS1(WKM)                                                00001030
         IF (CABS1(T(K,K)) .EQ. 0.0E0) GO TO 40                         00001040
            WK = WK/CONJG(T(K,K))                                       00001050
            WKM = WKM/CONJG(T(K,K))                                     00001060
         GO TO 50                                                       00001070
   40    CONTINUE                                                       00001080
            WK = (1.0E0,0.0E0)                                          00001090
            WKM = (1.0E0,0.0E0)                                         00001100
   50    CONTINUE                                                       00001110
         IF (KK .EQ. N) GO TO 90                                        00001120
            J1 = K + 1                                                  00001130
            IF (LOWER) J1 = 1                                           00001140
            J2 = N                                                      00001150
            IF (LOWER) J2 = K - 1                                       00001160
            DO 60 J = J1, J2                                            00001170
               SM = SM + CABS1(Z(J)+WKM*CONJG(T(K,J)))                  00001180
               Z(J) = Z(J) + WK*CONJG(T(K,J))                           00001190
               S = S + CABS1(Z(J))                                      00001200
   60       CONTINUE                                                    00001210
            IF (S .GE. SM) GO TO 80                                     00001220
               W = WKM - WK                                             00001230
               WK = WKM                                                 00001240
               DO 70 J = J1, J2                                         00001250
                  Z(J) = Z(J) + W*CONJG(T(K,J))                         00001260
   70          CONTINUE                                                 00001270
   80       CONTINUE                                                    00001280
   90    CONTINUE                                                       00001290
         Z(K) = WK                                                      00001300
  100 CONTINUE                                                          00001310
      S = 1.0E0/SCASUM(N,Z,1)                                           00001320
      CALL CSSCAL(N,S,Z,1)                                              00001330
C                                                                       00001340
      YNORM = 1.0E0                                                     00001350
C                                                                       00001360
C     SOLVE T*Z = Y                                                     00001370
C                                                                       00001380
      DO 130 KK = 1, N                                                  00001390
         K = N + 1 - KK                                                 00001400
         IF (LOWER) K = KK                                              00001410
         IF (CABS1(Z(K)) .LE. CABS1(T(K,K))) GO TO 110                  00001420
            S = CABS1(T(K,K))/CABS1(Z(K))                               00001430
            CALL CSSCAL(N,S,Z,1)                                        00001440
            YNORM = S*YNORM                                             00001450
  110    CONTINUE                                                       00001460
         IF (CABS1(T(K,K)) .NE. 0.0E0) Z(K) = Z(K)/T(K,K)               00001470
         IF (CABS1(T(K,K)) .EQ. 0.0E0) Z(K) = (1.0E0,0.0E0)             00001480
         I1 = 1                                                         00001490
         IF (LOWER) I1 = K + 1                                          00001500
         IF (KK .GE. N) GO TO 120                                       00001510
            W = -Z(K)                                                   00001520
            CALL CAXPY(N-KK,W,T(I1,K),1,Z(I1),1)                        00001530
  120    CONTINUE                                                       00001540
  130 CONTINUE                                                          00001550
C     MAKE ZNORM = 1.0                                                  00001560
      S = 1.0E0/SCASUM(N,Z,1)                                           00001570
      CALL CSSCAL(N,S,Z,1)                                              00001580
      YNORM = S*YNORM                                                   00001590
C                                                                       00001600
      IF (TNORM .NE. 0.0E0) RCOND = YNORM/TNORM                         00001610
      IF (TNORM .EQ. 0.0E0) RCOND = 0.0E0                               00001620
      RETURN                                                            00001630
      END                                                               00001640
