*#**********************************************************************

      SUBROUTINE DCHUD(R,LDR,P,X,Z,LDZ,NZ,Y,RHO,C,S)                    00000010

      INTEGER LDR,P,LDZ,NZ                                              00000020
      DOUBLE PRECISION RHO(1),C(1)                                      00000030
      DOUBLE PRECISION R(LDR,1),X(1),Z(LDZ,1),Y(1),S(1)                 00000040
C                                                                       00000050
C     DCHUD UPDATES AN AUGMENTED CHOLESKY DECOMPOSITION OF THE          00000060
C     TRIANGULAR PART OF AN AUGMENTED QR DECOMPOSITION.  SPECIFICALLY,  00000070
C     GIVEN AN UPPER TRIANGULAR MATRIX R OF ORDER P, A ROW VECTOR       00000080
C     X, A COLUMN VECTOR Z, AND A SCALAR Y, DCHUD DETERMINES A          00000090
C     UNTIARY MATRIX U AND A SCALAR ZETA SUCH THAT                      00000100
C                                                                       00000110
C                                                                       00000120
C                              (R  Z)     (RR   ZZ )                    00000130
C                         U  * (    )  =  (        ) ,                  00000140
C                              (X  Y)     ( 0  ZETA)                    00000150
C                                                                       00000160
C     WHERE RR IS UPPER TRIANGULAR.  IF R AND Z HAVE BEEN               00000170
C     OBTAINED FROM THE FACTORIZATION OF A LEAST SQUARES                00000180
C     PROBLEM, THEN RR AND ZZ ARE THE FACTORS CORRESPONDING TO          00000190
C     THE PROBLEM WITH THE OBSERVATION (X,Y) APPENDED.  IN THIS         00000200
C     CASE, IF RHO IS THE NORM OF THE RESIDUAL VECTOR, THEN THE         00000210
C     NORM OF THE RESIDUAL VECTOR OF THE UPDATED PROBLEM IS             00000220
C     DSQRT(RHO**2 + ZETA**2).  DCHUD WILL SIMULTANEOUSLY UPDATE        00000230
C     SEVERAL TRIPLETS (Z,Y,RHO).                                       00000240
C     FOR A LESS TERSE DESCRIPTION OF WHAT DCHUD DOES AND HOW           00000250
C     IT MAY BE APPLIED, SEE THE LINPACK GUIDE.                         00000260
C                                                                       00000270
C     THE MATRIX U IS DETERMINED AS THE PRODUCT U(P)*...*U(1),          00000280
C     WHERE U(I) IS A ROTATION IN THE (I,P+1) PLANE OF THE              00000290
C     FORM                                                              00000300
C                                                                       00000310
C                       (     C(I)      S(I) )                          00000320
C                       (                    ) .                        00000330
C                       (    -S(I)      C(I) )                          00000340
C                                                                       00000350
C     THE ROTATIONS ARE CHOSEN SO THAT C(I) IS DOUBLE PRECISION.        00000360
C                                                                       00000370
C     ON ENTRY                                                          00000380
C                                                                       00000390
C         R      DOUBLE PRECISION(LDR,P), WHERE LDR .GE. P.             00000400
C                R CONTAINS THE UPPER TRIANGULAR MATRIX                 00000410
C                THAT IS TO BE UPDATED.  THE PART OF R                  00000420
C                BELOW THE DIAGONAL IS NOT REFERENCED.                  00000430
C                                                                       00000440
C         LDR    INTEGER.                                               00000450
C                LDR IS THE LEADING DIMENSION OF THE ARRAY R.           00000460
C                                                                       00000470
C         P      INTEGER.                                               00000480
C                P IS THE ORDER OF THE MATRIX R.                        00000490
C                                                                       00000500
C         X      DOUBLE PRECISION(P).                                   00000510
C                X CONTAINS THE ROW TO BE ADDED TO R.  X IS             00000520
C                NOT ALTERED BY DCHUD.                                  00000530
C                                                                       00000540
C         Z      DOUBLE PRECISION(LDZ,NZ), WHERE LDZ .GE. P.            00000550
C                Z IS AN ARRAY CONTAINING NZ P-VECTORS TO               00000560
C                BE UPDATED WITH R.                                     00000570
C                                                                       00000580
C         LDZ    INTEGER.                                               00000590
C                LDZ IS THE LEADING DIMENSION OF THE ARRAY Z.           00000600
C                                                                       00000610
C         NZ     INTEGER.                                               00000620
C                NZ IS THE NUMBER OF VECTORS TO BE UPDATED              00000630
C                NZ MAY BE ZERO, IN WHICH CASE Z, Y, AND RHO            00000640
C                ARE NOT REFERENCED.                                    00000650
C                                                                       00000660
C         Y      DOUBLE PRECISION(NZ).                                  00000670
C                Y CONTAINS THE SCALARS FOR UPDATING THE VECTORS        00000680
C                Z.  Y IS NOT ALTERED BY DCHUD.                         00000690
C                                                                       00000700
C         RHO    DOUBLE PRECISION(NZ).                                  00000710
C                RHO CONTAINS THE NORMS OF THE RESIDUAL                 00000720
C                VECTORS THAT ARE TO BE UPDATED.  IF RHO(J)             00000730
C                IS NEGATIVE, IT IS LEFT UNALTERED.                     00000740
C                                                                       00000750
C     ON RETURN                                                         00000760
C                                                                       00000770
C         RC                                                            00000780
C         RHO    CONTAIN THE UPDATED QUANTITIES.                        00000790
C         Z                                                             00000800
C                                                                       00000810
C         C      DOUBLE PRECISION(P).                                   00000820
C                C CONTAINS THE COSINES OF THE TRANSFORMING             00000830
C                ROTATIONS.                                             00000840
C                                                                       00000850
C         S      DOUBLE PRECISION(P).                                   00000860
C                S CONTAINS THE SINES OF THE TRANSFORMING               00000870
C                ROTATIONS.                                             00000880
C                                                                       00000890
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000900
C     G.W. STEWART, UNIVERSITY OF MARYLAND, ARGONNE NATIONAL LAB.       00000910
C                                                                       00000920
C     DCHUD USES THE FOLLOWING FUNCTIONS AND SUBROUTINES.               00000930
C                                                                       00000940
C     EXTENDED BLAS DROTG                                               00000950
C     FORTRAN DSQRT                                                     00000960
C                                                                       00000970
      INTEGER I,J,JM1                                                   00000980
      DOUBLE PRECISION AZETA,SCALE                                      00000990
      DOUBLE PRECISION T,XJ,ZETA                                        00001000
C                                                                       00001010
C     UPDATE R.                                                         00001020
C                                                                       00001030
      DO 30 J = 1, P                                                    00001040
         XJ = X(J)                                                      00001050
C                                                                       00001060
C        APPLY THE PREVIOUS ROTATIONS.                                  00001070
C                                                                       00001080
         JM1 = J - 1                                                    00001090
         IF (JM1 .LT. 1) GO TO 20                                       00001100
         DO 10 I = 1, JM1                                               00001110
            T = C(I)*R(I,J) + S(I)*XJ                                   00001120
            XJ = C(I)*XJ - S(I)*R(I,J)                                  00001130
            R(I,J) = T                                                  00001140
   10    CONTINUE                                                       00001150
   20    CONTINUE                                                       00001160
C                                                                       00001170
C        COMPUTE THE NEXT ROTATION.                                     00001180
C                                                                       00001190
         CALL DROTG(R(J,J),XJ,C(J),S(J))                                00001200
   30 CONTINUE                                                          00001210
C                                                                       00001220
C     IF REQUIRED, UPDATE Z AND RHO.                                    00001230
C                                                                       00001240
      IF (NZ .LT. 1) GO TO 70                                           00001250
      DO 60 J = 1, NZ                                                   00001260
         ZETA = Y(J)                                                    00001270
         DO 40 I = 1, P                                                 00001280
            T = C(I)*Z(I,J) + S(I)*ZETA                                 00001290
            ZETA = C(I)*ZETA - S(I)*Z(I,J)                              00001300
            Z(I,J) = T                                                  00001310
   40    CONTINUE                                                       00001320
         AZETA = DABS(ZETA)                                             00001330
         IF (AZETA .EQ. 0.0D0 .OR. RHO(J) .LT. 0.0D0) GO TO 50          00001340
            SCALE = AZETA + RHO(J)                                      00001350
            RHO(J) = SCALE*DSQRT((AZETA/SCALE)**2+(RHO(J)/SCALE)**2)    00001360
   50    CONTINUE                                                       00001370
   60 CONTINUE                                                          00001380
   70 CONTINUE                                                          00001390
      RETURN                                                            00001400
      END                                                               00001410
