*#**********************************************************************

      SUBROUTINE DSIDI(A,LDA,N,KPVT,DET,INERT,WORK,JOB)                 00000010

      INTEGER LDA,N,JOB                                                 00000020
      DOUBLE PRECISION A(LDA,1),WORK(1)                                 00000030
      DOUBLE PRECISION DET(2)                                           00000040
      INTEGER KPVT(1),INERT(3)                                          00000050
C                                                                       00000060
C     DSIDI COMPUTES THE DETERMINANT, INERTIA AND INVERSE               00000070
C     OF A DOUBLE PRECISION SYMMETRIC MATRIX USING THE FACTORS FROM     00000080
C     DSIFA.                                                            00000090
C                                                                       00000100
C     ON ENTRY                                                          00000110
C                                                                       00000120
C        A       DOUBLE PRECISION(LDA,N)                                00000130
C                THE OUTPUT FROM DSIFA.                                 00000140
C                                                                       00000150
C        LDA     INTEGER                                                00000160
C                THE LEADING DIMENSION OF THE ARRAY A.                  00000170
C                                                                       00000180
C        N       INTEGER                                                00000190
C                THE ORDER OF THE MATRIX A.                             00000200
C                                                                       00000210
C        KPVT    INTEGER(N)                                             00000220
C                THE PIVOT VECTOR FROM DSIFA.                           00000230
C                                                                       00000240
C        WORK    DOUBLE PRECISION(N)                                    00000250
C                WORK VECTOR.  CONTENTS DESTROYED.                      00000260
C                                                                       00000270
C        JOB     INTEGER                                                00000280
C                JOB HAS THE DECIMAL EXPANSION  ABC  WHERE              00000290
C                   IF  C .NE. 0, THE INVERSE IS COMPUTED,              00000300
C                   IF  B .NE. 0, THE DETERMINANT IS COMPUTED,          00000310
C                   IF  A .NE. 0, THE INERTIA IS COMPUTED.              00000320
C                                                                       00000330
C                FOR EXAMPLE, JOB = 111  GIVES ALL THREE.               00000340
C                                                                       00000350
C     ON RETURN                                                         00000360
C                                                                       00000370
C        VARIABLES NOT REQUESTED BY JOB ARE NOT USED.                   00000380
C                                                                       00000390
C        A      CONTAINS THE UPPER TRIANGLE OF THE INVERSE OF           00000400
C               THE ORIGINAL MATRIX.  THE STRICT LOWER TRIANGLE         00000410
C               IS NEVER REFERENCED.                                    00000420
C                                                                       00000430
C        DET    DOUBLE PRECISION(2)                                     00000440
C               DETERMINANT OF ORIGINAL MATRIX.                         00000450
C               DETERMINANT = DET(1) * 10.0**DET(2)                     00000460
C               WITH 1.0 .LE. DABS(DET(1)) .LT. 10.0                    00000470
C               OR DET(1) = 0.0.                                        00000480
C                                                                       00000490
C        INERT  INTEGER(3)                                              00000500
C               THE INERTIA OF THE ORIGINAL MATRIX.                     00000510
C               INERT(1)  =  NUMBER OF POSITIVE EIGENVALUES.            00000520
C               INERT(2)  =  NUMBER OF NEGATIVE EIGENVALUES.            00000530
C               INERT(3)  =  NUMBER OF ZERO EIGENVALUES.                00000540
C                                                                       00000550
C     ERROR CONDITION                                                   00000560
C                                                                       00000570
C        A DIVISION BY ZERO MAY OCCUR IF THE INVERSE IS REQUESTED       00000580
C        AND  DSICO  HAS SET RCOND .EQ. 0.0                             00000590
C        OR  DSIFA  HAS SET  INFO .NE. 0 .                              00000600
C                                                                       00000610
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000620
C     JAMES BUNCH, UNIV. CALIF. SAN DIEGO, ARGONNE NAT. LAB             00000630
C                                                                       00000640
C     SUBROUTINES AND FUNCTIONS                                         00000650
C                                                                       00000660
C     BLAS DAXPY,DCOPY,DDOT,DSWAP                                       00000670
C     FORTRAN DABS,IABS,MOD                                             00000680
C                                                                       00000690
C     INTERNAL VARIABLES.                                               00000700
C                                                                       00000710
      DOUBLE PRECISION AKKP1,DDOT,TEMP                                  00000720
      DOUBLE PRECISION TEN,D,T,AK,AKP1                                  00000730
      INTEGER J,JB,K,KM1,KS,KSTEP                                       00000740
      LOGICAL NOINV,NODET,NOERT                                         00000750
C                                                                       00000760
      NOINV = MOD(JOB,10) .EQ. 0                                        00000770
      NODET = MOD(JOB,100)/10 .EQ. 0                                    00000780
      NOERT = MOD(JOB,1000)/100 .EQ. 0                                  00000790
C                                                                       00000800
      IF (NODET .AND. NOERT) GO TO 140                                  00000810
         IF (NOERT) GO TO 10                                            00000820
            INERT(1) = 0                                                00000830
            INERT(2) = 0                                                00000840
            INERT(3) = 0                                                00000850
   10    CONTINUE                                                       00000860
         IF (NODET) GO TO 20                                            00000870
            DET(1) = 1.0D0                                              00000880
            DET(2) = 0.0D0                                              00000890
            TEN = 10.0D0                                                00000900
   20    CONTINUE                                                       00000910
         T = 0.0D0                                                      00000920
         DO 130 K = 1, N                                                00000930
            D = A(K,K)                                                  00000940
C                                                                       00000950
C           CHECK IF 1 BY 1                                             00000960
C                                                                       00000970
            IF (KPVT(K) .GT. 0) GO TO 50                                00000980
C                                                                       00000990
C              2 BY 2 BLOCK                                             00001000
C              USE DET (D  S)  =  (D/T * C - T) * T  ,  T = DABS(S)     00001010
C                      (S  C)                                           00001020
C              TO AVOID UNDERFLOW/OVERFLOW TROUBLES.                    00001030
C              TAKE TWO PASSES THROUGH SCALING.  USE  T  FOR FLAG.      00001040
C                                                                       00001050
               IF (T .NE. 0.0D0) GO TO 30                               00001060
                  T = DABS(A(K,K+1))                                    00001070
                  D = (D/T)*A(K+1,K+1) - T                              00001080
               GO TO 40                                                 00001090
   30          CONTINUE                                                 00001100
                  D = T                                                 00001110
                  T = 0.0D0                                             00001120
   40          CONTINUE                                                 00001130
   50       CONTINUE                                                    00001140
C                                                                       00001150
            IF (NOERT) GO TO 60                                         00001160
               IF (D .GT. 0.0D0) INERT(1) = INERT(1) + 1                00001170
               IF (D .LT. 0.0D0) INERT(2) = INERT(2) + 1                00001180
               IF (D .EQ. 0.0D0) INERT(3) = INERT(3) + 1                00001190
   60       CONTINUE                                                    00001200
C                                                                       00001210
            IF (NODET) GO TO 120                                        00001220
               DET(1) = D*DET(1)                                        00001230
               IF (DET(1) .EQ. 0.0D0) GO TO 110                         00001240
   70             IF (DABS(DET(1)) .GE. 1.0D0) GO TO 80                 00001250
                     DET(1) = TEN*DET(1)                                00001260
                     DET(2) = DET(2) - 1.0D0                            00001270
                  GO TO 70                                              00001280
   80             CONTINUE                                              00001290
   90             IF (DABS(DET(1)) .LT. TEN) GO TO 100                  00001300
                     DET(1) = DET(1)/TEN                                00001310
                     DET(2) = DET(2) + 1.0D0                            00001320
                  GO TO 90                                              00001330
  100             CONTINUE                                              00001340
  110          CONTINUE                                                 00001350
  120       CONTINUE                                                    00001360
  130    CONTINUE                                                       00001370
  140 CONTINUE                                                          00001380
C                                                                       00001390
C     COMPUTE INVERSE(A)                                                00001400
C                                                                       00001410
      IF (NOINV) GO TO 270                                              00001420
         K = 1                                                          00001430
  150    IF (K .GT. N) GO TO 260                                        00001440
            KM1 = K - 1                                                 00001450
            IF (KPVT(K) .LT. 0) GO TO 180                               00001460
C                                                                       00001470
C              1 BY 1                                                   00001480
C                                                                       00001490
               A(K,K) = 1.0D0/A(K,K)                                    00001500
               IF (KM1 .LT. 1) GO TO 170                                00001510
                  CALL DCOPY(KM1,A(1,K),1,WORK,1)                       00001520
                  DO 160 J = 1, KM1                                     00001530
                     A(J,K) = DDOT(J,A(1,J),1,WORK,1)                   00001540
                     CALL DAXPY(J-1,WORK(J),A(1,J),1,A(1,K),1)          00001550
  160             CONTINUE                                              00001560
                  A(K,K) = A(K,K) + DDOT(KM1,WORK,1,A(1,K),1)           00001570
  170          CONTINUE                                                 00001580
               KSTEP = 1                                                00001590
            GO TO 220                                                   00001600
  180       CONTINUE                                                    00001610
C                                                                       00001620
C              2 BY 2                                                   00001630
C                                                                       00001640
               T = DABS(A(K,K+1))                                       00001650
               AK = A(K,K)/T                                            00001660
               AKP1 = A(K+1,K+1)/T                                      00001670
               AKKP1 = A(K,K+1)/T                                       00001680
               D = T*(AK*AKP1 - 1.0D0)                                  00001690
               A(K,K) = AKP1/D                                          00001700
               A(K+1,K+1) = AK/D                                        00001710
               A(K,K+1) = -AKKP1/D                                      00001720
               IF (KM1 .LT. 1) GO TO 210                                00001730
                  CALL DCOPY(KM1,A(1,K+1),1,WORK,1)                     00001740
                  DO 190 J = 1, KM1                                     00001750
                     A(J,K+1) = DDOT(J,A(1,J),1,WORK,1)                 00001760
                     CALL DAXPY(J-1,WORK(J),A(1,J),1,A(1,K+1),1)        00001770
  190             CONTINUE                                              00001780
                  A(K+1,K+1) = A(K+1,K+1) + DDOT(KM1,WORK,1,A(1,K+1),1) 00001790
                  A(K,K+1) = A(K,K+1) + DDOT(KM1,A(1,K),1,A(1,K+1),1)   00001800
                  CALL DCOPY(KM1,A(1,K),1,WORK,1)                       00001810
                  DO 200 J = 1, KM1                                     00001820
                     A(J,K) = DDOT(J,A(1,J),1,WORK,1)                   00001830
                     CALL DAXPY(J-1,WORK(J),A(1,J),1,A(1,K),1)          00001840
  200             CONTINUE                                              00001850
                  A(K,K) = A(K,K) + DDOT(KM1,WORK,1,A(1,K),1)           00001860
  210          CONTINUE                                                 00001870
               KSTEP = 2                                                00001880
  220       CONTINUE                                                    00001890
C                                                                       00001900
C           SWAP                                                        00001910
C                                                                       00001920
            KS = IABS(KPVT(K))                                          00001930
            IF (KS .EQ. K) GO TO 250                                    00001940
               CALL DSWAP(KS,A(1,KS),1,A(1,K),1)                        00001950
               DO 230 JB = KS, K                                        00001960
                  J = K + KS - JB                                       00001970
                  TEMP = A(J,K)                                         00001980
                  A(J,K) = A(KS,J)                                      00001990
                  A(KS,J) = TEMP                                        00002000
  230          CONTINUE                                                 00002010
               IF (KSTEP .EQ. 1) GO TO 240                              00002020
                  TEMP = A(KS,K+1)                                      00002030
                  A(KS,K+1) = A(K,K+1)                                  00002040
                  A(K,K+1) = TEMP                                       00002050
  240          CONTINUE                                                 00002060
  250       CONTINUE                                                    00002070
            K = K + KSTEP                                               00002080
         GO TO 150                                                      00002090
  260    CONTINUE                                                       00002100
  270 CONTINUE                                                          00002110
      RETURN                                                            00002120
      END                                                               00002130
