*#**********************************************************************

      SUBROUTINE DSIFA(A,LDA,N,KPVT,INFO)                               00000010

      INTEGER LDA,N,KPVT(1),INFO                                        00000020
      DOUBLE PRECISION A(LDA,1)                                         00000030
C                                                                       00000040
C     DSIFA FACTORS A DOUBLE PRECISION SYMMETRIC MATRIX BY ELIMINATION  00000050
C     WITH SYMMETRIC PIVOTING.                                          00000060
C                                                                       00000070
C     TO SOLVE  A*X = B , FOLLOW DSIFA BY DSISL.                        00000080
C     TO COMPUTE  INVERSE(A)*C , FOLLOW DSIFA BY DSISL.                 00000090
C     TO COMPUTE  DETERMINANT(A) , FOLLOW DSIFA BY DSIDI.               00000100
C     TO COMPUTE  INERTIA(A) , FOLLOW DSIFA BY DSIDI.                   00000110
C     TO COMPUTE  INVERSE(A) , FOLLOW DSIFA BY DSIDI.                   00000120
C                                                                       00000130
C     ON ENTRY                                                          00000140
C                                                                       00000150
C        A       DOUBLE PRECISION(LDA,N)                                00000160
C                THE SYMMETRIC MATRIX TO BE FACTORED.                   00000170
C                ONLY THE DIAGONAL AND UPPER TRIANGLE ARE USED.         00000180
C                                                                       00000190
C        LDA     INTEGER                                                00000200
C                THE LEADING DIMENSION OF THE ARRAY  A .                00000210
C                                                                       00000220
C        N       INTEGER                                                00000230
C                THE ORDER OF THE MATRIX  A .                           00000240
C                                                                       00000250
C     ON RETURN                                                         00000260
C                                                                       00000270
C        A       A BLOCK DIAGONAL MATRIX AND THE MULTIPLIERS WHICH      00000280
C                WERE USED TO OBTAIN IT.                                00000290
C                THE FACTORIZATION CAN BE WRITTEN  A = U*D*TRANS(U)     00000300
C                WHERE  U  IS A PRODUCT OF PERMUTATION AND UNIT         00000310
C                UPPER TRIANGULAR MATRICES , TRANS(U) IS THE            00000320
C                TRANSPOSE OF  U , AND  D  IS BLOCK DIAGONAL            00000330
C                WITH 1 BY 1 AND 2 BY 2 BLOCKS.                         00000340
C                                                                       00000350
C        KPVT    INTEGER(N)                                             00000360
C                AN INTEGER VECTOR OF PIVOT INDICES.                    00000370
C                                                                       00000380
C        INFO    INTEGER                                                00000390
C                = 0  NORMAL VALUE.                                     00000400
C                = K  IF THE K-TH PIVOT BLOCK IS SINGULAR. THIS IS      00000410
C                     NOT AN ERROR CONDITION FOR THIS SUBROUTINE,       00000420
C                     BUT IT DOES INDICATE THAT DSISL OR DSIDI MAY      00000430
C                     DIVIDE BY ZERO IF CALLED.                         00000440
C                                                                       00000450
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000460
C     JAMES BUNCH, UNIV. CALIF. SAN DIEGO, ARGONNE NAT. LAB.            00000470
C                                                                       00000480
C     SUBROUTINES AND FUNCTIONS                                         00000490
C                                                                       00000500
C     BLAS DAXPY,DSWAP,IDAMAX                                           00000510
C     FORTRAN DABS,DMAX1,DSQRT                                          00000520
C                                                                       00000530
C     INTERNAL VARIABLES                                                00000540
C                                                                       00000550
      DOUBLE PRECISION AK,AKM1,BK,BKM1,DENOM,MULK,MULKM1,T              00000560
      DOUBLE PRECISION ABSAKK,ALPHA,COLMAX,ROWMAX                       00000570
      INTEGER IMAX,IMAXP1,J,JJ,JMAX,K,KM1,KM2,KSTEP,IDAMAX              00000580
      LOGICAL SWAP                                                      00000590
C                                                                       00000600
C                                                                       00000610
C     INITIALIZE                                                        00000620
C                                                                       00000630
C     ALPHA IS USED IN CHOOSING PIVOT BLOCK SIZE.                       00000640
      ALPHA = (1.0D0 + DSQRT(17.0D0))/8.0D0                             00000650
C                                                                       00000660
      INFO = 0                                                          00000670
C                                                                       00000680
C     MAIN LOOP ON K, WHICH GOES FROM N TO 1.                           00000690
C                                                                       00000700
      K = N                                                             00000710
   10 CONTINUE                                                          00000720
C                                                                       00000730
C        LEAVE THE LOOP IF K=0 OR K=1.                                  00000740
C                                                                       00000750
C     ...EXIT                                                           00000760
         IF (K .EQ. 0) GO TO 200                                        00000770
         IF (K .GT. 1) GO TO 20                                         00000780
            KPVT(1) = 1                                                 00000790
            IF (A(1,1) .EQ. 0.0D0) INFO = 1                             00000800
C     ......EXIT                                                        00000810
            GO TO 200                                                   00000820
   20    CONTINUE                                                       00000830
C                                                                       00000840
C        THIS SECTION OF CODE DETERMINES THE KIND OF                    00000850
C        ELIMINATION TO BE PERFORMED.  WHEN IT IS COMPLETED,            00000860
C        KSTEP WILL BE SET TO THE SIZE OF THE PIVOT BLOCK, AND          00000870
C        SWAP WILL BE SET TO .TRUE. IF AN INTERCHANGE IS                00000880
C        REQUIRED.                                                      00000890
C                                                                       00000900
         KM1 = K - 1                                                    00000910
         ABSAKK = DABS(A(K,K))                                          00000920
C                                                                       00000930
C        DETERMINE THE LARGEST OFF-DIAGONAL ELEMENT IN                  00000940
C        COLUMN K.                                                      00000950
C                                                                       00000960
         IMAX = IDAMAX(K-1,A(1,K),1)                                    00000970
         COLMAX = DABS(A(IMAX,K))                                       00000980
         IF (ABSAKK .LT. ALPHA*COLMAX) GO TO 30                         00000990
            KSTEP = 1                                                   00001000
            SWAP = .FALSE.                                              00001010
         GO TO 90                                                       00001020
   30    CONTINUE                                                       00001030
C                                                                       00001040
C           DETERMINE THE LARGEST OFF-DIAGONAL ELEMENT IN               00001050
C           ROW IMAX.                                                   00001060
C                                                                       00001070
            ROWMAX = 0.0D0                                              00001080
            IMAXP1 = IMAX + 1                                           00001090
            DO 40 J = IMAXP1, K                                         00001100
               ROWMAX = DMAX1(ROWMAX,DABS(A(IMAX,J)))                   00001110
   40       CONTINUE                                                    00001120
            IF (IMAX .EQ. 1) GO TO 50                                   00001130
               JMAX = IDAMAX(IMAX-1,A(1,IMAX),1)                        00001140
               ROWMAX = DMAX1(ROWMAX,DABS(A(JMAX,IMAX)))                00001150
   50       CONTINUE                                                    00001160
            IF (DABS(A(IMAX,IMAX)) .LT. ALPHA*ROWMAX) GO TO 60          00001170
               KSTEP = 1                                                00001180
               SWAP = .TRUE.                                            00001190
            GO TO 80                                                    00001200
   60       CONTINUE                                                    00001210
            IF (ABSAKK .LT. ALPHA*COLMAX*(COLMAX/ROWMAX)) GO TO 70      00001220
               KSTEP = 1                                                00001230
               SWAP = .FALSE.                                           00001240
            GO TO 80                                                    00001250
   70       CONTINUE                                                    00001260
               KSTEP = 2                                                00001270
               SWAP = IMAX .NE. KM1                                     00001280
   80       CONTINUE                                                    00001290
   90    CONTINUE                                                       00001300
         IF (DMAX1(ABSAKK,COLMAX) .NE. 0.0D0) GO TO 100                 00001310
C                                                                       00001320
C           COLUMN K IS ZERO.  SET INFO AND ITERATE THE LOOP.           00001330
C                                                                       00001340
            KPVT(K) = K                                                 00001350
            INFO = K                                                    00001360
         GO TO 190                                                      00001370
  100    CONTINUE                                                       00001380
         IF (KSTEP .EQ. 2) GO TO 140                                    00001390
C                                                                       00001400
C           1 X 1 PIVOT BLOCK.                                          00001410
C                                                                       00001420
            IF (.NOT.SWAP) GO TO 120                                    00001430
C                                                                       00001440
C              PERFORM AN INTERCHANGE.                                  00001450
C                                                                       00001460
               CALL DSWAP(IMAX,A(1,IMAX),1,A(1,K),1)                    00001470
               DO 110 JJ = IMAX, K                                      00001480
                  J = K + IMAX - JJ                                     00001490
                  T = A(J,K)                                            00001500
                  A(J,K) = A(IMAX,J)                                    00001510
                  A(IMAX,J) = T                                         00001520
  110          CONTINUE                                                 00001530
  120       CONTINUE                                                    00001540
C                                                                       00001550
C           PERFORM THE ELIMINATION.                                    00001560
C                                                                       00001570
            DO 130 JJ = 1, KM1                                          00001580
               J = K - JJ                                               00001590
               MULK = -A(J,K)/A(K,K)                                    00001600
               T = MULK                                                 00001610
               CALL DAXPY(J,T,A(1,K),1,A(1,J),1)                        00001620
               A(J,K) = MULK                                            00001630
  130       CONTINUE                                                    00001640
C                                                                       00001650
C           SET THE PIVOT ARRAY.                                        00001660
C                                                                       00001670
            KPVT(K) = K                                                 00001680
            IF (SWAP) KPVT(K) = IMAX                                    00001690
         GO TO 190                                                      00001700
  140    CONTINUE                                                       00001710
C                                                                       00001720
C           2 X 2 PIVOT BLOCK.                                          00001730
C                                                                       00001740
            IF (.NOT.SWAP) GO TO 160                                    00001750
C                                                                       00001760
C              PERFORM AN INTERCHANGE.                                  00001770
C                                                                       00001780
               CALL DSWAP(IMAX,A(1,IMAX),1,A(1,K-1),1)                  00001790
               DO 150 JJ = IMAX, KM1                                    00001800
                  J = KM1 + IMAX - JJ                                   00001810
                  T = A(J,K-1)                                          00001820
                  A(J,K-1) = A(IMAX,J)                                  00001830
                  A(IMAX,J) = T                                         00001840
  150          CONTINUE                                                 00001850
               T = A(K-1,K)                                             00001860
               A(K-1,K) = A(IMAX,K)                                     00001870
               A(IMAX,K) = T                                            00001880
  160       CONTINUE                                                    00001890
C                                                                       00001900
C           PERFORM THE ELIMINATION.                                    00001910
C                                                                       00001920
            KM2 = K - 2                                                 00001930
            IF (KM2 .EQ. 0) GO TO 180                                   00001940
               AK = A(K,K)/A(K-1,K)                                     00001950
               AKM1 = A(K-1,K-1)/A(K-1,K)                               00001960
               DENOM = 1.0D0 - AK*AKM1                                  00001970
               DO 170 JJ = 1, KM2                                       00001980
                  J = KM1 - JJ                                          00001990
                  BK = A(J,K)/A(K-1,K)                                  00002000
                  BKM1 = A(J,K-1)/A(K-1,K)                              00002010
                  MULK = (AKM1*BK - BKM1)/DENOM                         00002020
                  MULKM1 = (AK*BKM1 - BK)/DENOM                         00002030
                  T = MULK                                              00002040
                  CALL DAXPY(J,T,A(1,K),1,A(1,J),1)                     00002050
                  T = MULKM1                                            00002060
                  CALL DAXPY(J,T,A(1,K-1),1,A(1,J),1)                   00002070
                  A(J,K) = MULK                                         00002080
                  A(J,K-1) = MULKM1                                     00002090
  170          CONTINUE                                                 00002100
  180       CONTINUE                                                    00002110
C                                                                       00002120
C           SET THE PIVOT ARRAY.                                        00002130
C                                                                       00002140
            KPVT(K) = 1 - K                                             00002150
            IF (SWAP) KPVT(K) = -IMAX                                   00002160
            KPVT(K-1) = KPVT(K)                                         00002170
  190    CONTINUE                                                       00002180
         K = K - KSTEP                                                  00002190
      GO TO 10                                                          00002200
  200 CONTINUE                                                          00002210
      RETURN                                                            00002220
      END                                                               00002230
