*#**********************************************************************

      SUBROUTINE SPODI(A,LDA,N,DET,JOB)                                 00000010

      INTEGER LDA,N,JOB                                                 00000020
      REAL A(LDA,1)                                                     00000030
      REAL DET(2)                                                       00000040
C                                                                       00000050
C     SPODI COMPUTES THE DETERMINANT AND INVERSE OF A CERTAIN           00000060
C     REAL SYMMETRIC POSITIVE DEFINITE MATRIX (SEE BELOW)               00000070
C     USING THE FACTORS COMPUTED BY SPOCO, SPOFA OR SQRDC.              00000080
C                                                                       00000090
C     ON ENTRY                                                          00000100
C                                                                       00000110
C        A       REAL(LDA, N)                                           00000120
C                THE OUTPUT  A  FROM SPOCO OR SPOFA                     00000130
C                OR THE OUTPUT  X  FROM SQRDC.                          00000140
C                                                                       00000150
C        LDA     INTEGER                                                00000160
C                THE LEADING DIMENSION OF THE ARRAY  A .                00000170
C                                                                       00000180
C        N       INTEGER                                                00000190
C                THE ORDER OF THE MATRIX  A .                           00000200
C                                                                       00000210
C        JOB     INTEGER                                                00000220
C                = 11   BOTH DETERMINANT AND INVERSE.                   00000230
C                = 01   INVERSE ONLY.                                   00000240
C                = 10   DETERMINANT ONLY.                               00000250
C                                                                       00000260
C     ON RETURN                                                         00000270
C                                                                       00000280
C        A       IF SPOCO OR SPOFA WAS USED TO FACTOR  A  THEN          00000290
C                SPODI PRODUCES THE UPPER HALF OF INVERSE(A) .          00000300
C                IF SQRDC WAS USED TO DECOMPOSE  X  THEN                00000310
C                SPODI PRODUCES THE UPPER HALF OF INVERSE(TRANS(X)*X)   00000320
C                WHERE TRANS(X) IS THE TRANSPOSE.                       00000330
C                ELEMENTS OF  A  BELOW THE DIAGONAL ARE UNCHANGED.      00000340
C                IF THE UNITS DIGIT OF JOB IS ZERO,  A  IS UNCHANGED.   00000350
C                                                                       00000360
C        DET     REAL(2)                                                00000370
C                DETERMINANT OF  A  OR OF  TRANS(X)*X  IF REQUESTED.    00000380
C                OTHERWISE NOT REFERENCED.                              00000390
C                DETERMINANT = DET(1) * 10.0**DET(2)                    00000400
C                WITH  1.0 .LE. DET(1) .LT. 10.0                        00000410
C                OR  DET(1) .EQ. 0.0 .                                  00000420
C                                                                       00000430
C     ERROR CONDITION                                                   00000440
C                                                                       00000450
C        A DIVISION BY ZERO WILL OCCUR IF THE INPUT FACTOR CONTAINS     00000460
C        A ZERO ON THE DIAGONAL AND THE INVERSE IS REQUESTED.           00000470
C        IT WILL NOT OCCUR IF THE SUBROUTINES ARE CALLED CORRECTLY      00000480
C        AND IF SPOCO OR SPOFA HAS SET INFO .EQ. 0 .                    00000490
C                                                                       00000500
C     LINPACK.  THIS VERSION DATED 08/14/78 .                           00000510
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000520
C                                                                       00000530
C     SUBROUTINES AND FUNCTIONS                                         00000540
C                                                                       00000550
C     BLAS SAXPY,SSCAL                                                  00000560
C     FORTRAN MOD                                                       00000570
C                                                                       00000580
C     INTERNAL VARIABLES                                                00000590
C                                                                       00000600
      REAL T                                                            00000610
      REAL S                                                            00000620
      INTEGER I,J,JM1,K,KP1                                             00000630
C                                                                       00000640
C     COMPUTE DETERMINANT                                               00000650
C                                                                       00000660
      IF (JOB/10 .EQ. 0) GO TO 70                                       00000670
         DET(1) = 1.0E0                                                 00000680
         DET(2) = 0.0E0                                                 00000690
         S = 10.0E0                                                     00000700
         DO 50 I = 1, N                                                 00000710
            DET(1) = A(I,I)**2*DET(1)                                   00000720
C        ...EXIT                                                        00000730
            IF (DET(1) .EQ. 0.0E0) GO TO 60                             00000740
   10       IF (DET(1) .GE. 1.0E0) GO TO 20                             00000750
               DET(1) = S*DET(1)                                        00000760
               DET(2) = DET(2) - 1.0E0                                  00000770
            GO TO 10                                                    00000780
   20       CONTINUE                                                    00000790
   30       IF (DET(1) .LT. S) GO TO 40                                 00000800
               DET(1) = DET(1)/S                                        00000810
               DET(2) = DET(2) + 1.0E0                                  00000820
            GO TO 30                                                    00000830
   40       CONTINUE                                                    00000840
   50    CONTINUE                                                       00000850
   60    CONTINUE                                                       00000860
   70 CONTINUE                                                          00000870
C                                                                       00000880
C     COMPUTE INVERSE(R)                                                00000890
C                                                                       00000900
      IF (MOD(JOB,10) .EQ. 0) GO TO 140                                 00000910
         DO 100 K = 1, N                                                00000920
            A(K,K) = 1.0E0/A(K,K)                                       00000930
            T = -A(K,K)                                                 00000940
            CALL SSCAL(K-1,T,A(1,K),1)                                  00000950
            KP1 = K + 1                                                 00000960
            IF (N .LT. KP1) GO TO 90                                    00000970
            DO 80 J = KP1, N                                            00000980
               T = A(K,J)                                               00000990
               A(K,J) = 0.0E0                                           00001000
               CALL SAXPY(K,T,A(1,K),1,A(1,J),1)                        00001010
   80       CONTINUE                                                    00001020
   90       CONTINUE                                                    00001030
  100    CONTINUE                                                       00001040
C                                                                       00001050
C        FORM  INVERSE(R) * TRANS(INVERSE(R))                           00001060
C                                                                       00001070
         DO 130 J = 1, N                                                00001080
            JM1 = J - 1                                                 00001090
            IF (JM1 .LT. 1) GO TO 120                                   00001100
            DO 110 K = 1, JM1                                           00001110
               T = A(K,J)                                               00001120
               CALL SAXPY(K,T,A(1,J),1,A(1,K),1)                        00001130
  110       CONTINUE                                                    00001140
  120       CONTINUE                                                    00001150
            T = A(J,J)                                                  00001160
            CALL SSCAL(J,T,A(1,J),1)                                    00001170
  130    CONTINUE                                                       00001180
  140 CONTINUE                                                          00001190
      RETURN                                                            00001200
      END                                                               00001210
