*#**********************************************************************

      SUBROUTINE SSIDI(A,LDA,N,KPVT,DET,INERT,WORK,JOB)                 00000010

      INTEGER LDA,N,JOB                                                 00000020
      REAL A(LDA,1),WORK(1)                                             00000030
      REAL DET(2)                                                       00000040
      INTEGER KPVT(1),INERT(3)                                          00000050
C                                                                       00000060
C     SSIDI COMPUTES THE DETERMINANT, INERTIA AND INVERSE               00000070
C     OF A REAL SYMMETRIC MATRIX USING THE FACTORS FROM SSIFA.          00000080
C                                                                       00000090
C     ON ENTRY                                                          00000100
C                                                                       00000110
C        A       REAL(LDA,N)                                            00000120
C                THE OUTPUT FROM SSIFA.                                 00000130
C                                                                       00000140
C        LDA     INTEGER                                                00000150
C                THE LEADING DIMENSION OF THE ARRAY A.                  00000160
C                                                                       00000170
C        N       INTEGER                                                00000180
C                THE ORDER OF THE MATRIX A.                             00000190
C                                                                       00000200
C        KPVT    INTEGER(N)                                             00000210
C                THE PIVOT VECTOR FROM SSIFA.                           00000220
C                                                                       00000230
C        WORK    REAL(N)                                                00000240
C                WORK VECTOR.  CONTENTS DESTROYED.                      00000250
C                                                                       00000260
C        JOB     INTEGER                                                00000270
C                JOB HAS THE DECIMAL EXPANSION  ABC  WHERE              00000280
C                   IF  C .NE. 0, THE INVERSE IS COMPUTED,              00000290
C                   IF  B .NE. 0, THE DETERMINANT IS COMPUTED,          00000300
C                   IF  A .NE. 0, THE INERTIA IS COMPUTED.              00000310
C                                                                       00000320
C                FOR EXAMPLE, JOB = 111  GIVES ALL THREE.               00000330
C                                                                       00000340
C     ON RETURN                                                         00000350
C                                                                       00000360
C        VARIABLES NOT REQUESTED BY JOB ARE NOT USED.                   00000370
C                                                                       00000380
C        A      CONTAINS THE UPPER TRIANGLE OF THE INVERSE OF           00000390
C               THE ORIGINAL MATRIX.  THE STRICT LOWER TRIANGLE         00000400
C               IS NEVER REFERENCED.                                    00000410
C                                                                       00000420
C        DET    REAL(2)                                                 00000430
C               DETERMINANT OF ORIGINAL MATRIX.                         00000440
C               DETERMINANT = DET(1) * 10.0**DET(2)                     00000450
C               WITH 1.0 .LE. ABS(DET(1)) .LT. 10.0                     00000460
C               OR DET(1) = 0.0.                                        00000470
C                                                                       00000480
C        INERT  INTEGER(3)                                              00000490
C               THE INERTIA OF THE ORIGINAL MATRIX.                     00000500
C               INERT(1)  =  NUMBER OF POSITIVE EIGENVALUES.            00000510
C               INERT(2)  =  NUMBER OF NEGATIVE EIGENVALUES.            00000520
C               INERT(3)  =  NUMBER OF ZERO EIGENVALUES.                00000530
C                                                                       00000540
C     ERROR CONDITION                                                   00000550
C                                                                       00000560
C        A DIVISION BY ZERO MAY OCCUR IF THE INVERSE IS REQUESTED       00000570
C        AND  SSICO  HAS SET RCOND .EQ. 0.0                             00000580
C        OR  SSIFA  HAS SET  INFO .NE. 0 .                              00000590
C                                                                       00000600
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000610
C     JAMES BUNCH, UNIV. CALIF. SAN DIEGO, ARGONNE NAT. LAB             00000620
C                                                                       00000630
C     SUBROUTINES AND FUNCTIONS                                         00000640
C                                                                       00000650
C     BLAS SAXPY,SCOPY,SDOT,SSWAP                                       00000660
C     FORTRAN ABS,IABS,MOD                                              00000670
C                                                                       00000680
C     INTERNAL VARIABLES.                                               00000690
C                                                                       00000700
      REAL AKKP1,SDOT,TEMP                                              00000710
      REAL TEN,D,T,AK,AKP1                                              00000720
      INTEGER J,JB,K,KM1,KS,KSTEP                                       00000730
      LOGICAL NOINV,NODET,NOERT                                         00000740
C                                                                       00000750
      NOINV = MOD(JOB,10) .EQ. 0                                        00000760
      NODET = MOD(JOB,100)/10 .EQ. 0                                    00000770
      NOERT = MOD(JOB,1000)/100 .EQ. 0                                  00000780
C                                                                       00000790
      IF (NODET .AND. NOERT) GO TO 140                                  00000800
         IF (NOERT) GO TO 10                                            00000810
            INERT(1) = 0                                                00000820
            INERT(2) = 0                                                00000830
            INERT(3) = 0                                                00000840
   10    CONTINUE                                                       00000850
         IF (NODET) GO TO 20                                            00000860
            DET(1) = 1.0E0                                              00000870
            DET(2) = 0.0E0                                              00000880
            TEN = 10.0E0                                                00000890
   20    CONTINUE                                                       00000900
         T = 0.0E0                                                      00000910
         DO 130 K = 1, N                                                00000920
            D = A(K,K)                                                  00000930
C                                                                       00000940
C           CHECK IF 1 BY 1                                             00000950
C                                                                       00000960
            IF (KPVT(K) .GT. 0) GO TO 50                                00000970
C                                                                       00000980
C              2 BY 2 BLOCK                                             00000990
C              USE DET (D  S)  =  (D/T * C - T) * T  ,  T = ABS(S)      00001000
C                      (S  C)                                           00001010
C              TO AVOID UNDERFLOW/OVERFLOW TROUBLES.                    00001020
C              TAKE TWO PASSES THROUGH SCALING.  USE  T  FOR FLAG.      00001030
C                                                                       00001040
               IF (T .NE. 0.0E0) GO TO 30                               00001050
                  T = ABS(A(K,K+1))                                     00001060
                  D = (D/T)*A(K+1,K+1) - T                              00001070
               GO TO 40                                                 00001080
   30          CONTINUE                                                 00001090
                  D = T                                                 00001100
                  T = 0.0E0                                             00001110
   40          CONTINUE                                                 00001120
   50       CONTINUE                                                    00001130
C                                                                       00001140
            IF (NOERT) GO TO 60                                         00001150
               IF (D .GT. 0.0E0) INERT(1) = INERT(1) + 1                00001160
               IF (D .LT. 0.0E0) INERT(2) = INERT(2) + 1                00001170
               IF (D .EQ. 0.0E0) INERT(3) = INERT(3) + 1                00001180
   60       CONTINUE                                                    00001190
C                                                                       00001200
            IF (NODET) GO TO 120                                        00001210
               DET(1) = D*DET(1)                                        00001220
               IF (DET(1) .EQ. 0.0E0) GO TO 110                         00001230
   70             IF (ABS(DET(1)) .GE. 1.0E0) GO TO 80                  00001240
                     DET(1) = TEN*DET(1)                                00001250
                     DET(2) = DET(2) - 1.0E0                            00001260
                  GO TO 70                                              00001270
   80             CONTINUE                                              00001280
   90             IF (ABS(DET(1)) .LT. TEN) GO TO 100                   00001290
                     DET(1) = DET(1)/TEN                                00001300
                     DET(2) = DET(2) + 1.0E0                            00001310
                  GO TO 90                                              00001320
  100             CONTINUE                                              00001330
  110          CONTINUE                                                 00001340
  120       CONTINUE                                                    00001350
  130    CONTINUE                                                       00001360
  140 CONTINUE                                                          00001370
C                                                                       00001380
C     COMPUTE INVERSE(A)                                                00001390
C                                                                       00001400
      IF (NOINV) GO TO 270                                              00001410
         K = 1                                                          00001420
  150    IF (K .GT. N) GO TO 260                                        00001430
            KM1 = K - 1                                                 00001440
            IF (KPVT(K) .LT. 0) GO TO 180                               00001450
C                                                                       00001460
C              1 BY 1                                                   00001470
C                                                                       00001480
               A(K,K) = 1.0E0/A(K,K)                                    00001490
               IF (KM1 .LT. 1) GO TO 170                                00001500
                  CALL SCOPY(KM1,A(1,K),1,WORK,1)                       00001510
                  DO 160 J = 1, KM1                                     00001520
                     A(J,K) = SDOT(J,A(1,J),1,WORK,1)                   00001530
                     CALL SAXPY(J-1,WORK(J),A(1,J),1,A(1,K),1)          00001540
  160             CONTINUE                                              00001550
                  A(K,K) = A(K,K) + SDOT(KM1,WORK,1,A(1,K),1)           00001560
  170          CONTINUE                                                 00001570
               KSTEP = 1                                                00001580
            GO TO 220                                                   00001590
  180       CONTINUE                                                    00001600
C                                                                       00001610
C              2 BY 2                                                   00001620
C                                                                       00001630
               T = ABS(A(K,K+1))                                        00001640
               AK = A(K,K)/T                                            00001650
               AKP1 = A(K+1,K+1)/T                                      00001660
               AKKP1 = A(K,K+1)/T                                       00001670
               D = T*(AK*AKP1 - 1.0E0)                                  00001680
               A(K,K) = AKP1/D                                          00001690
               A(K+1,K+1) = AK/D                                        00001700
               A(K,K+1) = -AKKP1/D                                      00001710
               IF (KM1 .LT. 1) GO TO 210                                00001720
                  CALL SCOPY(KM1,A(1,K+1),1,WORK,1)                     00001730
                  DO 190 J = 1, KM1                                     00001740
                     A(J,K+1) = SDOT(J,A(1,J),1,WORK,1)                 00001750
                     CALL SAXPY(J-1,WORK(J),A(1,J),1,A(1,K+1),1)        00001760
  190             CONTINUE                                              00001770
                  A(K+1,K+1) = A(K+1,K+1) + SDOT(KM1,WORK,1,A(1,K+1),1) 00001780
                  A(K,K+1) = A(K,K+1) + SDOT(KM1,A(1,K),1,A(1,K+1),1)   00001790
                  CALL SCOPY(KM1,A(1,K),1,WORK,1)                       00001800
                  DO 200 J = 1, KM1                                     00001810
                     A(J,K) = SDOT(J,A(1,J),1,WORK,1)                   00001820
                     CALL SAXPY(J-1,WORK(J),A(1,J),1,A(1,K),1)          00001830
  200             CONTINUE                                              00001840
                  A(K,K) = A(K,K) + SDOT(KM1,WORK,1,A(1,K),1)           00001850
  210          CONTINUE                                                 00001860
               KSTEP = 2                                                00001870
  220       CONTINUE                                                    00001880
C                                                                       00001890
C           SWAP                                                        00001900
C                                                                       00001910
            KS = IABS(KPVT(K))                                          00001920
            IF (KS .EQ. K) GO TO 250                                    00001930
               CALL SSWAP(KS,A(1,KS),1,A(1,K),1)                        00001940
               DO 230 JB = KS, K                                        00001950
                  J = K + KS - JB                                       00001960
                  TEMP = A(J,K)                                         00001970
                  A(J,K) = A(KS,J)                                      00001980
                  A(KS,J) = TEMP                                        00001990
  230          CONTINUE                                                 00002000
               IF (KSTEP .EQ. 1) GO TO 240                              00002010
                  TEMP = A(KS,K+1)                                      00002020
                  A(KS,K+1) = A(K,K+1)                                  00002030
                  A(K,K+1) = TEMP                                       00002040
  240          CONTINUE                                                 00002050
  250       CONTINUE                                                    00002060
            K = K + KSTEP                                               00002070
         GO TO 150                                                      00002080
  260    CONTINUE                                                       00002090
  270 CONTINUE                                                          00002100
      RETURN                                                            00002110
      END                                                               00002120
