*#**********************************************************************

      SUBROUTINE SSPCO(AP,N,KPVT,RCOND,Z)                               00000010

      INTEGER N,KPVT(1)                                                 00000020
      REAL AP(1),Z(1)                                                   00000030
      REAL RCOND                                                        00000040
C                                                                       00000050
C     SSPCO FACTORS A REAL SYMMETRIC MATRIX STORED IN PACKED            00000060
C     FORM BY ELIMINATION WITH SYMMETRIC PIVOTING AND ESTIMATES         00000070
C     THE CONDITION OF THE MATRIX.                                      00000080
C                                                                       00000090
C     IF  RCOND  IS NOT NEEDED, SSPFA IS SLIGHTLY FASTER.               00000100
C     TO SOLVE  A*X = B , FOLLOW SSPCO BY SSPSL.                        00000110
C     TO COMPUTE  INVERSE(A)*C , FOLLOW SSPCO BY SSPSL.                 00000120
C     TO COMPUTE  INVERSE(A) , FOLLOW SSPCO BY SSPDI.                   00000130
C     TO COMPUTE  DETERMINANT(A) , FOLLOW SSPCO BY SSPDI.               00000140
C     TO COMPUTE  INERTIA(A), FOLLOW SSPCO BY SSPDI.                    00000150
C                                                                       00000160
C     ON ENTRY                                                          00000170
C                                                                       00000180
C        AP      REAL (N*(N+1)/2)                                       00000190
C                THE PACKED FORM OF A SYMMETRIC MATRIX  A .  THE        00000200
C                COLUMNS OF THE UPPER TRIANGLE ARE STORED SEQUENTIALLY  00000210
C                IN A ONE-DIMENSIONAL ARRAY OF LENGTH  N*(N+1)/2 .      00000220
C                SEE COMMENTS BELOW FOR DETAILS.                        00000230
C                                                                       00000240
C        N       INTEGER                                                00000250
C                THE ORDER OF THE MATRIX  A .                           00000260
C                                                                       00000270
C     OUTPUT                                                            00000280
C                                                                       00000290
C        AP      A BLOCK DIAGONAL MATRIX AND THE MULTIPLIERS WHICH      00000300
C                WERE USED TO OBTAIN IT STORED IN PACKED FORM.          00000310
C                THE FACTORIZATION CAN BE WRITTEN  A = U*D*TRANS(U)     00000320
C                WHERE  U  IS A PRODUCT OF PERMUTATION AND UNIT         00000330
C                UPPER TRIANGULAR MATRICES , TRANS(U) IS THE            00000340
C                TRANSPOSE OF  U , AND  D  IS BLOCK DIAGONAL            00000350
C                WITH 1 BY 1 AND 2 BY 2 BLOCKS.                         00000360
C                                                                       00000370
C        KPVT    INTEGER(N)                                             00000380
C                AN INTEGER VECTOR OF PIVOT INDICES.                    00000390
C                                                                       00000400
C        RCOND   REAL                                                   00000410
C                AN ESTIMATE OF THE RECIPROCAL CONDITION OF  A .        00000420
C                FOR THE SYSTEM  A*X = B , RELATIVE PERTURBATIONS       00000430
C                IN  A  AND  B  OF SIZE  EPSILON  MAY CAUSE             00000440
C                RELATIVE PERTURBATIONS IN  X  OF SIZE  EPSILON/RCOND . 00000450
C                IF  RCOND  IS SO SMALL THAT THE LOGICAL EXPRESSION     00000460
C                           1.0 + RCOND .EQ. 1.0                        00000470
C                IS TRUE, THEN  A  MAY BE SINGULAR TO WORKING           00000480
C                PRECISION.  IN PARTICULAR,  RCOND  IS ZERO  IF         00000490
C                EXACT SINGULARITY IS DETECTED OR THE ESTIMATE          00000500
C                UNDERFLOWS.                                            00000510
C                                                                       00000520
C        Z       REAL(N)                                                00000530
C                A WORK VECTOR WHOSE CONTENTS ARE USUALLY UNIMPORTANT.  00000540
C                IF  A  IS CLOSE TO A SINGULAR MATRIX, THEN  Z  IS      00000550
C                AN APPROXIMATE NULL VECTOR IN THE SENSE THAT           00000560
C                NORM(A*Z) = RCOND*NORM(A)*NORM(Z) .                    00000570
C                                                                       00000580
C     PACKED STORAGE                                                    00000590
C                                                                       00000600
C          THE FOLLOWING PROGRAM SEGMENT WILL PACK THE UPPER            00000610
C          TRIANGLE OF A SYMMETRIC MATRIX.                              00000620
C                                                                       00000630
C                K = 0                                                  00000640
C                DO 20 J = 1, N                                         00000650
C                   DO 10 I = 1, J                                      00000660
C                      K = K + 1                                        00000670
C                      AP(K) = A(I,J)                                   00000680
C             10    CONTINUE                                            00000690
C             20 CONTINUE                                               00000700
C                                                                       00000710
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000720
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000730
C                                                                       00000740
C     SUBROUTINES AND FUNCTIONS                                         00000750
C                                                                       00000760
C     LINPACK SSPFA                                                     00000770
C     BLAS SAXPY,SDOT,SSCAL,SASUM                                       00000780
C     FORTRAN ABS,AMAX1,IABS,SIGN                                       00000790
C                                                                       00000800
C     INTERNAL VARIABLES                                                00000810
C                                                                       00000820
      REAL AK,AKM1,BK,BKM1,SDOT,DENOM,EK,T                              00000830
      REAL ANORM,S,SASUM,YNORM                                          00000840
      INTEGER I,IJ,IK,IKM1,IKP1,INFO,J,JM1,J1                           00000850
      INTEGER K,KK,KM1K,KM1KM1,KP,KPS,KS                                00000860
C                                                                       00000870
C                                                                       00000880
C     FIND NORM OF A USING ONLY UPPER HALF                              00000890
C                                                                       00000900
      J1 = 1                                                            00000910
      DO 30 J = 1, N                                                    00000920
         Z(J) = SASUM(J,AP(J1),1)                                       00000930
         IJ = J1                                                        00000940
         J1 = J1 + J                                                    00000950
         JM1 = J - 1                                                    00000960
         IF (JM1 .LT. 1) GO TO 20                                       00000970
         DO 10 I = 1, JM1                                               00000980
            Z(I) = Z(I) + ABS(AP(IJ))                                   00000990
            IJ = IJ + 1                                                 00001000
   10    CONTINUE                                                       00001010
   20    CONTINUE                                                       00001020
   30 CONTINUE                                                          00001030
      ANORM = 0.0E0                                                     00001040
      DO 40 J = 1, N                                                    00001050
         ANORM = AMAX1(ANORM,Z(J))                                      00001060
   40 CONTINUE                                                          00001070
C                                                                       00001080
C     FACTOR                                                            00001090
C                                                                       00001100
      CALL SSPFA(AP,N,KPVT,INFO)                                        00001110
C                                                                       00001120
C     RCOND = 1/(NORM(A)*(ESTIMATE OF NORM(INVERSE(A)))) .              00001130
C     ESTIMATE = NORM(Z)/NORM(Y) WHERE  A*Z = Y  AND  A*Y = E .         00001140
C     THE COMPONENTS OF  E  ARE CHOSEN TO CAUSE MAXIMUM LOCAL           00001150
C     GROWTH IN THE ELEMENTS OF W  WHERE  U*D*W = E .                   00001160
C     THE VECTORS ARE FREQUENTLY RESCALED TO AVOID OVERFLOW.            00001170
C                                                                       00001180
C     SOLVE U*D*W = E                                                   00001190
C                                                                       00001200
      EK = 1.0E0                                                        00001210
      DO 50 J = 1, N                                                    00001220
         Z(J) = 0.0E0                                                   00001230
   50 CONTINUE                                                          00001240
      K = N                                                             00001250
      IK = (N*(N - 1))/2                                                00001260
   60 IF (K .EQ. 0) GO TO 120                                           00001270
         KK = IK + K                                                    00001280
         IKM1 = IK - (K - 1)                                            00001290
         KS = 1                                                         00001300
         IF (KPVT(K) .LT. 0) KS = 2                                     00001310
         KP = IABS(KPVT(K))                                             00001320
         KPS = K + 1 - KS                                               00001330
         IF (KP .EQ. KPS) GO TO 70                                      00001340
            T = Z(KPS)                                                  00001350
            Z(KPS) = Z(KP)                                              00001360
            Z(KP) = T                                                   00001370
   70    CONTINUE                                                       00001380
         IF (Z(K) .NE. 0.0E0) EK = SIGN(EK,Z(K))                        00001390
         Z(K) = Z(K) + EK                                               00001400
         CALL SAXPY(K-KS,Z(K),AP(IK+1),1,Z(1),1)                        00001410
         IF (KS .EQ. 1) GO TO 80                                        00001420
            IF (Z(K-1) .NE. 0.0E0) EK = SIGN(EK,Z(K-1))                 00001430
            Z(K-1) = Z(K-1) + EK                                        00001440
            CALL SAXPY(K-KS,Z(K-1),AP(IKM1+1),1,Z(1),1)                 00001450
   80    CONTINUE                                                       00001460
         IF (KS .EQ. 2) GO TO 100                                       00001470
            IF (ABS(Z(K)) .LE. ABS(AP(KK))) GO TO 90                    00001480
               S = ABS(AP(KK))/ABS(Z(K))                                00001490
               CALL SSCAL(N,S,Z,1)                                      00001500
               EK = S*EK                                                00001510
   90       CONTINUE                                                    00001520
            IF (AP(KK) .NE. 0.0E0) Z(K) = Z(K)/AP(KK)                   00001530
            IF (AP(KK) .EQ. 0.0E0) Z(K) = 1.0E0                         00001540
         GO TO 110                                                      00001550
  100    CONTINUE                                                       00001560
            KM1K = IK + K - 1                                           00001570
            KM1KM1 = IKM1 + K - 1                                       00001580
            AK = AP(KK)/AP(KM1K)                                        00001590
            AKM1 = AP(KM1KM1)/AP(KM1K)                                  00001600
            BK = Z(K)/AP(KM1K)                                          00001610
            BKM1 = Z(K-1)/AP(KM1K)                                      00001620
            DENOM = AK*AKM1 - 1.0E0                                     00001630
            Z(K) = (AKM1*BK - BKM1)/DENOM                               00001640
            Z(K-1) = (AK*BKM1 - BK)/DENOM                               00001650
  110    CONTINUE                                                       00001660
         K = K - KS                                                     00001670
         IK = IK - K                                                    00001680
         IF (KS .EQ. 2) IK = IK - (K + 1)                               00001690
      GO TO 60                                                          00001700
  120 CONTINUE                                                          00001710
      S = 1.0E0/SASUM(N,Z,1)                                            00001720
      CALL SSCAL(N,S,Z,1)                                               00001730
C                                                                       00001740
C     SOLVE TRANS(U)*Y = W                                              00001750
C                                                                       00001760
      K = 1                                                             00001770
      IK = 0                                                            00001780
  130 IF (K .GT. N) GO TO 160                                           00001790
         KS = 1                                                         00001800
         IF (KPVT(K) .LT. 0) KS = 2                                     00001810
         IF (K .EQ. 1) GO TO 150                                        00001820
            Z(K) = Z(K) + SDOT(K-1,AP(IK+1),1,Z(1),1)                   00001830
            IKP1 = IK + K                                               00001840
            IF (KS .EQ. 2)                                              00001850
     *         Z(K+1) = Z(K+1) + SDOT(K-1,AP(IKP1+1),1,Z(1),1)          00001860
            KP = IABS(KPVT(K))                                          00001870
            IF (KP .EQ. K) GO TO 140                                    00001880
               T = Z(K)                                                 00001890
               Z(K) = Z(KP)                                             00001900
               Z(KP) = T                                                00001910
  140       CONTINUE                                                    00001920
  150    CONTINUE                                                       00001930
         IK = IK + K                                                    00001940
         IF (KS .EQ. 2) IK = IK + (K + 1)                               00001950
         K = K + KS                                                     00001960
      GO TO 130                                                         00001970
  160 CONTINUE                                                          00001980
      S = 1.0E0/SASUM(N,Z,1)                                            00001990
      CALL SSCAL(N,S,Z,1)                                               00002000
C                                                                       00002010
      YNORM = 1.0E0                                                     00002020
C                                                                       00002030
C     SOLVE U*D*V = Y                                                   00002040
C                                                                       00002050
      K = N                                                             00002060
      IK = N*(N - 1)/2                                                  00002070
  170 IF (K .EQ. 0) GO TO 230                                           00002080
         KK = IK + K                                                    00002090
         IKM1 = IK - (K - 1)                                            00002100
         KS = 1                                                         00002110
         IF (KPVT(K) .LT. 0) KS = 2                                     00002120
         IF (K .EQ. KS) GO TO 190                                       00002130
            KP = IABS(KPVT(K))                                          00002140
            KPS = K + 1 - KS                                            00002150
            IF (KP .EQ. KPS) GO TO 180                                  00002160
               T = Z(KPS)                                               00002170
               Z(KPS) = Z(KP)                                           00002180
               Z(KP) = T                                                00002190
  180       CONTINUE                                                    00002200
            CALL SAXPY(K-KS,Z(K),AP(IK+1),1,Z(1),1)                     00002210
            IF (KS .EQ. 2) CALL SAXPY(K-KS,Z(K-1),AP(IKM1+1),1,Z(1),1)  00002220
  190    CONTINUE                                                       00002230
         IF (KS .EQ. 2) GO TO 210                                       00002240
            IF (ABS(Z(K)) .LE. ABS(AP(KK))) GO TO 200                   00002250
               S = ABS(AP(KK))/ABS(Z(K))                                00002260
               CALL SSCAL(N,S,Z,1)                                      00002270
               YNORM = S*YNORM                                          00002280
  200       CONTINUE                                                    00002290
            IF (AP(KK) .NE. 0.0E0) Z(K) = Z(K)/AP(KK)                   00002300
            IF (AP(KK) .EQ. 0.0E0) Z(K) = 1.0E0                         00002310
         GO TO 220                                                      00002320
  210    CONTINUE                                                       00002330
            KM1K = IK + K - 1                                           00002340
            KM1KM1 = IKM1 + K - 1                                       00002350
            AK = AP(KK)/AP(KM1K)                                        00002360
            AKM1 = AP(KM1KM1)/AP(KM1K)                                  00002370
            BK = Z(K)/AP(KM1K)                                          00002380
            BKM1 = Z(K-1)/AP(KM1K)                                      00002390
            DENOM = AK*AKM1 - 1.0E0                                     00002400
            Z(K) = (AKM1*BK - BKM1)/DENOM                               00002410
            Z(K-1) = (AK*BKM1 - BK)/DENOM                               00002420
  220    CONTINUE                                                       00002430
         K = K - KS                                                     00002440
         IK = IK - K                                                    00002450
         IF (KS .EQ. 2) IK = IK - (K + 1)                               00002460
      GO TO 170                                                         00002470
  230 CONTINUE                                                          00002480
      S = 1.0E0/SASUM(N,Z,1)                                            00002490
      CALL SSCAL(N,S,Z,1)                                               00002500
      YNORM = S*YNORM                                                   00002510
C                                                                       00002520
C     SOLVE TRANS(U)*Z = V                                              00002530
C                                                                       00002540
      K = 1                                                             00002550
      IK = 0                                                            00002560
  240 IF (K .GT. N) GO TO 270                                           00002570
         KS = 1                                                         00002580
         IF (KPVT(K) .LT. 0) KS = 2                                     00002590
         IF (K .EQ. 1) GO TO 260                                        00002600
            Z(K) = Z(K) + SDOT(K-1,AP(IK+1),1,Z(1),1)                   00002610
            IKP1 = IK + K                                               00002620
            IF (KS .EQ. 2)                                              00002630
     *         Z(K+1) = Z(K+1) + SDOT(K-1,AP(IKP1+1),1,Z(1),1)          00002640
            KP = IABS(KPVT(K))                                          00002650
            IF (KP .EQ. K) GO TO 250                                    00002660
               T = Z(K)                                                 00002670
               Z(K) = Z(KP)                                             00002680
               Z(KP) = T                                                00002690
  250       CONTINUE                                                    00002700
  260    CONTINUE                                                       00002710
         IK = IK + K                                                    00002720
         IF (KS .EQ. 2) IK = IK + (K + 1)                               00002730
         K = K + KS                                                     00002740
      GO TO 240                                                         00002750
  270 CONTINUE                                                          00002760
C     MAKE ZNORM = 1.0                                                  00002770
      S = 1.0E0/SASUM(N,Z,1)                                            00002780
      CALL SSCAL(N,S,Z,1)                                               00002790
      YNORM = S*YNORM                                                   00002800
C                                                                       00002810
      IF (ANORM .NE. 0.0E0) RCOND = YNORM/ANORM                         00002820
      IF (ANORM .EQ. 0.0E0) RCOND = 0.0E0                               00002830
      RETURN                                                            00002840
      END                                                               00002850
