*#**********************************************************************

      SUBROUTINE STRCO(T,LDT,N,RCOND,Z,JOB)                             00000010

      INTEGER LDT,N,JOB                                                 00000020
      REAL T(LDT,1),Z(1)                                                00000030
      REAL RCOND                                                        00000040
C                                                                       00000050
C     STRCO ESTIMATES THE CONDITION OF A REAL TRIANGULAR MATRIX.        00000060
C                                                                       00000070
C     ON ENTRY                                                          00000080
C                                                                       00000090
C        T       REAL(LDT,N)                                            00000100
C                T CONTAINS THE TRIANGULAR MATRIX. THE ZERO             00000110
C                ELEMENTS OF THE MATRIX ARE NOT REFERENCED, AND         00000120
C                THE CORRESPONDING ELEMENTS OF THE ARRAY CAN BE         00000130
C                USED TO STORE OTHER INFORMATION.                       00000140
C                                                                       00000150
C        LDT     INTEGER                                                00000160
C                LDT IS THE LEADING DIMENSION OF THE ARRAY T.           00000170
C                                                                       00000180
C        N       INTEGER                                                00000190
C                N IS THE ORDER OF THE SYSTEM.                          00000200
C                                                                       00000210
C        JOB     INTEGER                                                00000220
C                = 0         T  IS LOWER TRIANGULAR.                    00000230
C                = NONZERO   T  IS UPPER TRIANGULAR.                    00000240
C                                                                       00000250
C     ON RETURN                                                         00000260
C                                                                       00000270
C        RCOND   REAL                                                   00000280
C                AN ESTIMATE OF THE RECIPROCAL CONDITION OF  T .        00000290
C                FOR THE SYSTEM  T*X = B , RELATIVE PERTURBATIONS       00000300
C                IN  T  AND  B  OF SIZE  EPSILON  MAY CAUSE             00000310
C                RELATIVE PERTURBATIONS IN  X  OF SIZE  EPSILON/RCOND . 00000320
C                IF  RCOND  IS SO SMALL THAT THE LOGICAL EXPRESSION     00000330
C                           1.0 + RCOND .EQ. 1.0                        00000340
C                IS TRUE, THEN  T  MAY BE SINGULAR TO WORKING           00000350
C                PRECISION.  IN PARTICULAR,  RCOND  IS ZERO  IF         00000360
C                EXACT SINGULARITY IS DETECTED OR THE ESTIMATE          00000370
C                UNDERFLOWS.                                            00000380
C                                                                       00000390
C        Z       REAL(N)                                                00000400
C                A WORK VECTOR WHOSE CONTENTS ARE USUALLY UNIMPORTANT.  00000410
C                IF  T  IS CLOSE TO A SINGULAR MATRIX, THEN  Z  IS      00000420
C                AN APPROXIMATE NULL VECTOR IN THE SENSE THAT           00000430
C                NORM(A*Z) = RCOND*NORM(A)*NORM(Z) .                    00000440
C                                                                       00000450
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000460
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000470
C                                                                       00000480
C     SUBROUTINES AND FUNCTIONS                                         00000490
C                                                                       00000500
C     BLAS SAXPY,SSCAL,SASUM                                            00000510
C     FORTRAN ABS,AMAX1,SIGN                                            00000520
C                                                                       00000530
C     INTERNAL VARIABLES                                                00000540
C                                                                       00000550
      REAL W,WK,WKM,EK                                                  00000560
      REAL TNORM,YNORM,S,SM,SASUM                                       00000570
      INTEGER I1,J,J1,J2,K,KK,L                                         00000580
      LOGICAL LOWER                                                     00000590
C                                                                       00000600
      LOWER = JOB .EQ. 0                                                00000610
C                                                                       00000620
C     COMPUTE 1-NORM OF T                                               00000630
C                                                                       00000640
      TNORM = 0.0E0                                                     00000650
      DO 10 J = 1, N                                                    00000660
         L = J                                                          00000670
         IF (LOWER) L = N + 1 - J                                       00000680
         I1 = 1                                                         00000690
         IF (LOWER) I1 = J                                              00000700
         TNORM = AMAX1(TNORM,SASUM(L,T(I1,J),1))                        00000710
   10 CONTINUE                                                          00000720
C                                                                       00000730
C     RCOND = 1/(NORM(T)*(ESTIMATE OF NORM(INVERSE(T)))) .              00000740
C     ESTIMATE = NORM(Z)/NORM(Y) WHERE  T*Z = Y  AND  TRANS(T)*Y = E .  00000750
C     TRANS(T)  IS THE TRANSPOSE OF T .                                 00000760
C     THE COMPONENTS OF  E  ARE CHOSEN TO CAUSE MAXIMUM LOCAL           00000770
C     GROWTH IN THE ELEMENTS OF Y .                                     00000780
C     THE VECTORS ARE FREQUENTLY RESCALED TO AVOID OVERFLOW.            00000790
C                                                                       00000800
C     SOLVE TRANS(T)*Y = E                                              00000810
C                                                                       00000820
      EK = 1.0E0                                                        00000830
      DO 20 J = 1, N                                                    00000840
         Z(J) = 0.0E0                                                   00000850
   20 CONTINUE                                                          00000860
      DO 100 KK = 1, N                                                  00000870
         K = KK                                                         00000880
         IF (LOWER) K = N + 1 - KK                                      00000890
         IF (Z(K) .NE. 0.0E0) EK = SIGN(EK,-Z(K))                       00000900
         IF (ABS(EK-Z(K)) .LE. ABS(T(K,K))) GO TO 30                    00000910
            S = ABS(T(K,K))/ABS(EK-Z(K))                                00000920
            CALL SSCAL(N,S,Z,1)                                         00000930
            EK = S*EK                                                   00000940
   30    CONTINUE                                                       00000950
         WK = EK - Z(K)                                                 00000960
         WKM = -EK - Z(K)                                               00000970
         S = ABS(WK)                                                    00000980
         SM = ABS(WKM)                                                  00000990
         IF (T(K,K) .EQ. 0.0E0) GO TO 40                                00001000
            WK = WK/T(K,K)                                              00001010
            WKM = WKM/T(K,K)                                            00001020
         GO TO 50                                                       00001030
   40    CONTINUE                                                       00001040
            WK = 1.0E0                                                  00001050
            WKM = 1.0E0                                                 00001060
   50    CONTINUE                                                       00001070
         IF (KK .EQ. N) GO TO 90                                        00001080
            J1 = K + 1                                                  00001090
            IF (LOWER) J1 = 1                                           00001100
            J2 = N                                                      00001110
            IF (LOWER) J2 = K - 1                                       00001120
            DO 60 J = J1, J2                                            00001130
               SM = SM + ABS(Z(J)+WKM*T(K,J))                           00001140
               Z(J) = Z(J) + WK*T(K,J)                                  00001150
               S = S + ABS(Z(J))                                        00001160
   60       CONTINUE                                                    00001170
            IF (S .GE. SM) GO TO 80                                     00001180
               W = WKM - WK                                             00001190
               WK = WKM                                                 00001200
               DO 70 J = J1, J2                                         00001210
                  Z(J) = Z(J) + W*T(K,J)                                00001220
   70          CONTINUE                                                 00001230
   80       CONTINUE                                                    00001240
   90    CONTINUE                                                       00001250
         Z(K) = WK                                                      00001260
  100 CONTINUE                                                          00001270
      S = 1.0E0/SASUM(N,Z,1)                                            00001280
      CALL SSCAL(N,S,Z,1)                                               00001290
C                                                                       00001300
      YNORM = 1.0E0                                                     00001310
C                                                                       00001320
C     SOLVE T*Z = Y                                                     00001330
C                                                                       00001340
      DO 130 KK = 1, N                                                  00001350
         K = N + 1 - KK                                                 00001360
         IF (LOWER) K = KK                                              00001370
         IF (ABS(Z(K)) .LE. ABS(T(K,K))) GO TO 110                      00001380
            S = ABS(T(K,K))/ABS(Z(K))                                   00001390
            CALL SSCAL(N,S,Z,1)                                         00001400
            YNORM = S*YNORM                                             00001410
  110    CONTINUE                                                       00001420
         IF (T(K,K) .NE. 0.0E0) Z(K) = Z(K)/T(K,K)                      00001430
         IF (T(K,K) .EQ. 0.0E0) Z(K) = 1.0E0                            00001440
         I1 = 1                                                         00001450
         IF (LOWER) I1 = K + 1                                          00001460
         IF (KK .GE. N) GO TO 120                                       00001470
            W = -Z(K)                                                   00001480
            CALL SAXPY(N-KK,W,T(I1,K),1,Z(I1),1)                        00001490
  120    CONTINUE                                                       00001500
  130 CONTINUE                                                          00001510
C     MAKE ZNORM = 1.0                                                  00001520
      S = 1.0E0/SASUM(N,Z,1)                                            00001530
      CALL SSCAL(N,S,Z,1)                                               00001540
      YNORM = S*YNORM                                                   00001550
C                                                                       00001560
      IF (TNORM .NE. 0.0E0) RCOND = YNORM/TNORM                         00001570
      IF (TNORM .EQ. 0.0E0) RCOND = 0.0E0                               00001580
      RETURN                                                            00001590
      END                                                               00001600
