*#**********************************************************************

      SUBROUTINE ZCHDC(A,LDA,P,WORK,JPVT,JOB,INFO)                      00000010

      INTEGER LDA,P,JPVT(1),JOB,INFO                                    00000020
      COMPLEX*16 A(LDA,1),WORK(1)                                       00000030
C                                                                       00000040
C     ZCHDC COMPUTES THE CHOLESKY DECOMPOSITION OF A POSITIVE DEFINITE  00000050
C     MATRIX.  A PIVOTING OPTION ALLOWS THE USER TO ESTIMATE THE        00000060
C     CONDITION OF A POSITIVE DEFINITE MATRIX OR DETERMINE THE RANK     00000070
C     OF A POSITIVE SEMIDEFINITE MATRIX.                                00000080
C                                                                       00000090
C     ON ENTRY                                                          00000100
C                                                                       00000110
C         A      COMPLEX*16(LDA,P).                                     00000120
C                A CONTAINS THE MATRIX WHOSE DECOMPOSITION IS TO        00000130
C                BE COMPUTED.  ONLT THE UPPER HALF OF A NEED BE STORED. 00000140
C                THE LOWER PART OF THE ARRAY A IS NOT REFERENCED.       00000150
C                                                                       00000160
C         LDA    INTEGER.                                               00000170
C                LDA IS THE LEADING DIMENSION OF THE ARRAY A.           00000180
C                                                                       00000190
C         P      INTEGER.                                               00000200
C                P IS THE ORDER OF THE MATRIX.                          00000210
C                                                                       00000220
C         WORK   COMPLEX*16.                                            00000230
C                WORK IS A WORK ARRAY.                                  00000240
C                                                                       00000250
C         JPVT   INTEGER(P).                                            00000260
C                JPVT CONTAINS INTEGERS THAT CONTROL THE SELECTION      00000270
C                OF THE PIVOT ELEMENTS, IF PIVOTING HAS BEEN REQUESTED. 00000280
C                EACH DIAGONAL ELEMENT A(K,K)                           00000290
C                IS PLACED IN ONE OF THREE CLASSES ACCORDING TO THE     00000300
C                VALUE OF JPVT(K).                                      00000310
C                                                                       00000320
C                   IF JPVT(K) .GT. 0, THEN X(K) IS AN INITIAL          00000330
C                                      ELEMENT.                         00000340
C                                                                       00000350
C                   IF JPVT(K) .EQ. 0, THEN X(K) IS A FREE ELEMENT.     00000360
C                                                                       00000370
C                   IF JPVT(K) .LT. 0, THEN X(K) IS A FINAL ELEMENT.    00000380
C                                                                       00000390
C                BEFORE THE DECOMPOSITION IS COMPUTED, INITIAL ELEMENTS 00000400
C                ARE MOVED BY SYMMETRIC ROW AND COLUMN INTERCHANGES TO  00000410
C                THE BEGINNING OF THE ARRAY A AND FINAL                 00000420
C                ELEMENTS TO THE END.  BOTH INITIAL AND FINAL ELEMENTS  00000430
C                ARE FROZEN IN PLACE DURING THE COMPUTATION AND ONLY    00000440
C                FREE ELEMENTS ARE MOVED.  AT THE K-TH STAGE OF THE     00000450
C                REDUCTION, IF A(K,K) IS OCCUPIED BY A FREE ELEMENT     00000460
C                IT IS INTERCHANGED WITH THE LARGEST FREE ELEMENT       00000470
C                A(L,L) WITH L .GE. K.  JPVT IS NOT REFERENCED IF       00000480
C                JOB .EQ. 0.                                            00000490
C                                                                       00000500
C        JOB     INTEGER.                                               00000510
C                JOB IS AN INTEGER THAT INITIATES COLUMN PIVOTING.      00000520
C                IF JOB .EQ. 0, NO PIVOTING IS DONE.                    00000530
C                IF JOB .NE. 0, PIVOTING IS DONE.                       00000540
C                                                                       00000550
C     ON RETURN                                                         00000560
C                                                                       00000570
C         A      A CONTAINS IN ITS UPPER HALF THE CHOLESKY FACTOR       00000580
C                OF THE MATRIX A AS IT HAS BEEN PERMUTED BY PIVOTING.   00000590
C                                                                       00000600
C         JPVT   JPVT(J) CONTAINS THE INDEX OF THE DIAGONAL ELEMENT     00000610
C                OF A THAT WAS MOVED INTO THE J-TH POSITION,            00000620
C                PROVIDED PIVOTING WAS REQUESTED.                       00000630
C                                                                       00000640
C         INFO   CONTAINS THE INDEX OF THE LAST POSITIVE DIAGONAL       00000650
C                ELEMENT OF THE CHOLESKY FACTOR.                        00000660
C                                                                       00000670
C     FOR POSITIVE DEFINITE MATRICES INFO = P IS THE NORMAL RETURN.     00000680
C     FOR PIVOTING WITH POSITIVE SEMIDEFINITE MATRICES INFO WILL        00000690
C     IN GENERAL BE LESS THAN P.  HOWEVER, INFO MAY BE GREATER THAN     00000700
C     THE RANK OF A, SINCE ROUNDING ERROR CAN CAUSE AN OTHERWISE ZERO   00000710
C     ELEMENT TO BE POSITIVE. INDEFINITE SYSTEMS WILL ALWAYS CAUSE      00000720
C     INFO TO BE LESS THAN P.                                           00000730
C                                                                       00000740
C     LINPACK. THIS VERSION DATED 03/19/79 .                            00000750
C     J.J. DONGARRA AND G.W. STEWART, ARGONNE NATIONAL LABORATORY AND   00000760
C     UNIVERSITY OF MARYLAND.                                           00000770
C                                                                       00000780
C                                                                       00000790
C     BLAS ZAXPY,ZSWAP                                                  00000800
C     FORTRAN DSQRT,DCONJG                                              00000810
C                                                                       00000820
C     INTERNAL VARIABLES                                                00000830
C                                                                       00000840
      INTEGER PU,PL,PLP1,I,J,JP,JT,K,KB,KM1,KP1,L,MAXL                  00000850
      COMPLEX*16 TEMP                                                   00000860
      DOUBLE PRECISION MAXDIA                                           00000870
      LOGICAL SWAPK,NEGK                                                00000880
      DOUBLE PRECISION DREAL                                            00000890
      COMPLEX*16 ZDUMR                                                  00000900
      DREAL(ZDUMR) = ZDUMR                                              00000910
C                                                                       00000920
      PL = 1                                                            00000930
      PU = 0                                                            00000940
      INFO = P                                                          00000950
      IF (JOB .EQ. 0) GO TO 160                                         00000960
C                                                                       00000970
C        PIVOTING HAS BEEN REQUESTED. REARRANGE THE                     00000980
C        THE ELEMENTS ACCORDING TO JPVT.                                00000990
C                                                                       00001000
         DO 70 K = 1, P                                                 00001010
            SWAPK = JPVT(K) .GT. 0                                      00001020
            NEGK = JPVT(K) .LT. 0                                       00001030
            JPVT(K) = K                                                 00001040
            IF (NEGK) JPVT(K) = -JPVT(K)                                00001050
            IF (.NOT.SWAPK) GO TO 60                                    00001060
               IF (K .EQ. PL) GO TO 50                                  00001070
                  CALL ZSWAP(PL-1,A(1,K),1,A(1,PL),1)                   00001080
                  TEMP = A(K,K)                                         00001090
                  A(K,K) = A(PL,PL)                                     00001100
                  A(PL,PL) = TEMP                                       00001110
                  A(PL,K) = DCONJG(A(PL,K))                             00001120
                  PLP1 = PL + 1                                         00001130
                  IF (P .LT. PLP1) GO TO 40                             00001140
                  DO 30 J = PLP1, P                                     00001150
                     IF (J .GE. K) GO TO 10                             00001160
                        TEMP = DCONJG(A(PL,J))                          00001170
                        A(PL,J) = DCONJG(A(J,K))                        00001180
                        A(J,K) = TEMP                                   00001190
                     GO TO 20                                           00001200
   10                CONTINUE                                           00001210
                     IF (J .EQ. K) GO TO 20                             00001220
                        TEMP = A(K,J)                                   00001230
                        A(K,J) = A(PL,J)                                00001240
                        A(PL,J) = TEMP                                  00001250
   20                CONTINUE                                           00001260
   30             CONTINUE                                              00001270
   40             CONTINUE                                              00001280
                  JPVT(K) = JPVT(PL)                                    00001290
                  JPVT(PL) = K                                          00001300
   50          CONTINUE                                                 00001310
               PL = PL + 1                                              00001320
   60       CONTINUE                                                    00001330
   70    CONTINUE                                                       00001340
         PU = P                                                         00001350
         IF (P .LT. PL) GO TO 150                                       00001360
         DO 140 KB = PL, P                                              00001370
            K = P - KB + PL                                             00001380
            IF (JPVT(K) .GE. 0) GO TO 130                               00001390
               JPVT(K) = -JPVT(K)                                       00001400
               IF (PU .EQ. K) GO TO 120                                 00001410
                  CALL ZSWAP(K-1,A(1,K),1,A(1,PU),1)                    00001420
                  TEMP = A(K,K)                                         00001430
                  A(K,K) = A(PU,PU)                                     00001440
                  A(PU,PU) = TEMP                                       00001450
                  A(K,PU) = DCONJG(A(K,PU))                             00001460
                  KP1 = K + 1                                           00001470
                  IF (P .LT. KP1) GO TO 110                             00001480
                  DO 100 J = KP1, P                                     00001490
                     IF (J .GE. PU) GO TO 80                            00001500
                        TEMP = DCONJG(A(K,J))                           00001510
                        A(K,J) = DCONJG(A(J,PU))                        00001520
                        A(J,PU) = TEMP                                  00001530
                     GO TO 90                                           00001540
   80                CONTINUE                                           00001550
                     IF (J .EQ. PU) GO TO 90                            00001560
                        TEMP = A(K,J)                                   00001570
                        A(K,J) = A(PU,J)                                00001580
                        A(PU,J) = TEMP                                  00001590
   90                CONTINUE                                           00001600
  100             CONTINUE                                              00001610
  110             CONTINUE                                              00001620
                  JT = JPVT(K)                                          00001630
                  JPVT(K) = JPVT(PU)                                    00001640
                  JPVT(PU) = JT                                         00001650
  120          CONTINUE                                                 00001660
               PU = PU - 1                                              00001670
  130       CONTINUE                                                    00001680
  140    CONTINUE                                                       00001690
  150    CONTINUE                                                       00001700
  160 CONTINUE                                                          00001710
      DO 270 K = 1, P                                                   00001720
C                                                                       00001730
C        REDUCTION LOOP.                                                00001740
C                                                                       00001750
         MAXDIA = DREAL(A(K,K))                                         00001760
         KP1 = K + 1                                                    00001770
         MAXL = K                                                       00001780
C                                                                       00001790
C        DETERMINE THE PIVOT ELEMENT.                                   00001800
C                                                                       00001810
         IF (K .LT. PL .OR. K .GE. PU) GO TO 190                        00001820
            DO 180 L = KP1, PU                                          00001830
               IF (DREAL(A(L,L)) .LE. MAXDIA) GO TO 170                 00001840
                  MAXDIA = DREAL(A(L,L))                                00001850
                  MAXL = L                                              00001860
  170          CONTINUE                                                 00001870
  180       CONTINUE                                                    00001880
  190    CONTINUE                                                       00001890
C                                                                       00001900
C        QUIT IF THE PIVOT ELEMENT IS NOT POSITIVE.                     00001910
C                                                                       00001920
         IF (MAXDIA .GT. 0.0D0) GO TO 200                               00001930
            INFO = K - 1                                                00001940
C     ......EXIT                                                        00001950
            GO TO 280                                                   00001960
  200    CONTINUE                                                       00001970
         IF (K .EQ. MAXL) GO TO 210                                     00001980
C                                                                       00001990
C           START THE PIVOTING AND UPDATE JPVT.                         00002000
C                                                                       00002010
            KM1 = K - 1                                                 00002020
            CALL ZSWAP(KM1,A(1,K),1,A(1,MAXL),1)                        00002030
            A(MAXL,MAXL) = A(K,K)                                       00002040
            A(K,K) = DCMPLX(MAXDIA,0.0D0)                               00002050
            JP = JPVT(MAXL)                                             00002060
            JPVT(MAXL) = JPVT(K)                                        00002070
            JPVT(K) = JP                                                00002080
            A(K,MAXL) = DCONJG(A(K,MAXL))                               00002090
  210    CONTINUE                                                       00002100
C                                                                       00002110
C        REDUCTION STEP. PIVOTING IS CONTAINED ACROSS THE ROWS.         00002120
C                                                                       00002130
         WORK(K) = DCMPLX(DSQRT(DREAL(A(K,K))),0.0D0)                   00002140
         A(K,K) = WORK(K)                                               00002150
         IF (P .LT. KP1) GO TO 260                                      00002160
         DO 250 J = KP1, P                                              00002170
            IF (K .EQ. MAXL) GO TO 240                                  00002180
               IF (J .GE. MAXL) GO TO 220                               00002190
                  TEMP = DCONJG(A(K,J))                                 00002200
                  A(K,J) = DCONJG(A(J,MAXL))                            00002210
                  A(J,MAXL) = TEMP                                      00002220
               GO TO 230                                                00002230
  220          CONTINUE                                                 00002240
               IF (J .EQ. MAXL) GO TO 230                               00002250
                  TEMP = A(K,J)                                         00002260
                  A(K,J) = A(MAXL,J)                                    00002270
                  A(MAXL,J) = TEMP                                      00002280
  230          CONTINUE                                                 00002290
  240       CONTINUE                                                    00002300
            A(K,J) = A(K,J)/WORK(K)                                     00002310
            WORK(J) = DCONJG(A(K,J))                                    00002320
            TEMP = -A(K,J)                                              00002330
            CALL ZAXPY(J-K,TEMP,WORK(KP1),1,A(KP1,J),1)                 00002340
  250    CONTINUE                                                       00002350
  260    CONTINUE                                                       00002360
  270 CONTINUE                                                          00002370
  280 CONTINUE                                                          00002380
      RETURN                                                            00002390
      END                                                               00002400
