*#**********************************************************************

      SUBROUTINE ZCHEX(R,LDR,P,K,L,Z,LDZ,NZ,C,S,JOB)                    00000010

      INTEGER LDR,P,K,L,LDZ,NZ,JOB                                      00000020
      COMPLEX*16 R(LDR,1),Z(LDZ,1),S(1)                                 00000030
      DOUBLE PRECISION C(1)                                             00000040
C                                                                       00000050
C     ZCHEX UPDATES THE CHOLESKY FACTORIZATION                          00000060
C                                                                       00000070
C                   A = CTRANS(R)*R                                     00000080
C                                                                       00000090
C     OF A POSITIVE DEFINITE MATRIX A OF ORDER P UNDER DIAGONAL         00000100
C     PERMUTATIONS OF THE FORM                                          00000110
C                                                                       00000120
C                   TRANS(E)*A*E                                        00000130
C                                                                       00000140
C     WHERE E IS A PERMUTATION MATRIX.  SPECIFICALLY, GIVEN             00000150
C     AN UPPER TRIANGULAR MATRIX R AND A PERMUTATION MATRIX             00000160
C     E (WHICH IS SPECIFIED BY K, L, AND JOB), ZCHEX DETERMINES         00000170
C     A UNITARY MATRIX U SUCH THAT                                      00000180
C                                                                       00000190
C                           U*R*E = RR,                                 00000200
C                                                                       00000210
C     WHERE RR IS UPPER TRIANGULAR.  AT THE USERS OPTION, THE           00000220
C     TRANSFORMATION U WILL BE MULTIPLIED INTO THE ARRAY Z.             00000230
C     IF A = CTRANS(X)*X, SO THAT R IS THE TRIANGULAR PART OF THE       00000240
C     QR FACTORIZATION OF X, THEN RR IS THE TRIANGULAR PART OF THE      00000250
C     QR FACTORIZATION OF X*E, I.E. X WITH ITS COLUMNS PERMUTED.        00000260
C     FOR A LESS TERSE DESCRIPTION OF WHAT ZCHEX DOES AND HOW           00000270
C     IT MAY BE APPLIED, SEE THE LINPACK GUIDE.                         00000280
C                                                                       00000290
C     THE MATRIX Q IS DETERMINED AS THE PRODUCT U(L-K)*...*U(1)         00000300
C     OF PLANE ROTATIONS OF THE FORM                                    00000310
C                                                                       00000320
C                           (    C(I)       S(I) )                      00000330
C                           (                    ) ,                    00000340
C                           ( -DCONJG(S(I))  C(I) )                     00000350
C                                                                       00000360
C     WHERE C(I) IS DOUBLE PRECISION, THE ROWS THESE ROTATIONS OPERATE  00000370
C     ON ARE DESCRIBED BELOW.                                           00000380
C                                                                       00000390
C     THERE ARE TWO TYPES OF PERMUTATIONS, WHICH ARE DETERMINED         00000400
C     BY THE VALUE OF JOB.                                              00000410
C                                                                       00000420
C     1. RIGHT CIRCULAR SHIFT (JOB = 1).                                00000430
C                                                                       00000440
C         THE COLUMNS ARE REARRANGED IN THE FOLLOWING ORDER.            00000450
C                                                                       00000460
C                1,...,K-1,L,K,K+1,...,L-1,L+1,...,P.                   00000470
C                                                                       00000480
C         U IS THE PRODUCT OF L-K ROTATIONS U(I), WHERE U(I)            00000490
C         ACTS IN THE (L-I,L-I+1)-PLANE.                                00000500
C                                                                       00000510
C     2. LEFT CIRCULAR SHIFT (JOB = 2).                                 00000520
C         THE COLUMNS ARE REARRANGED IN THE FOLLOWING ORDER             00000530
C                                                                       00000540
C                1,...,K-1,K+1,K+2,...,L,K,L+1,...,P.                   00000550
C                                                                       00000560
C         U IS THE PRODUCT OF L-K ROTATIONS U(I), WHERE U(I)            00000570
C         ACTS IN THE (K+I-1,K+I)-PLANE.                                00000580
C                                                                       00000590
C     ON ENTRY                                                          00000600
C                                                                       00000610
C         R      COMPLEX*16(LDR,P), WHERE LDR.GE.P.                     00000620
C                R CONTAINS THE UPPER TRIANGULAR FACTOR                 00000630
C                THAT IS TO BE UPDATED.  ELEMENTS OF R                  00000640
C                BELOW THE DIAGONAL ARE NOT REFERENCED.                 00000650
C                                                                       00000660
C         LDR    INTEGER.                                               00000670
C                LDR IS THE LEADING DIMENSION OF THE ARRAY R.           00000680
C                                                                       00000690
C         P      INTEGER.                                               00000700
C                P IS THE ORDER OF THE MATRIX R.                        00000710
C                                                                       00000720
C         K      INTEGER.                                               00000730
C                K IS THE FIRST COLUMN TO BE PERMUTED.                  00000740
C                                                                       00000750
C         L      INTEGER.                                               00000760
C                L IS THE LAST COLUMN TO BE PERMUTED.                   00000770
C                L MUST BE STRICTLY GREATER THAN K.                     00000780
C                                                                       00000790
C         Z      COMPLEX*16(LDZ,NZ), WHERE LDZ.GE.P.                    00000800
C                Z IS AN ARRAY OF NZ P-VECTORS INTO WHICH THE           00000810
C                TRANSFORMATION U IS MULTIPLIED.  Z IS                  00000820
C                NOT REFERENCED IF NZ = 0.                              00000830
C                                                                       00000840
C         LDZ    INTEGER.                                               00000850
C                LDZ IS THE LEADING DIMENSION OF THE ARRAY Z.           00000860
C                                                                       00000870
C         NZ     INTEGER.                                               00000880
C                NZ IS THE NUMBER OF COLUMNS OF THE MATRIX Z.           00000890
C                                                                       00000900
C         JOB    INTEGER.                                               00000910
C                JOB DETERMINES THE TYPE OF PERMUTATION.                00000920
C                       JOB = 1  RIGHT CIRCULAR SHIFT.                  00000930
C                       JOB = 2  LEFT CIRCULAR SHIFT.                   00000940
C                                                                       00000950
C     ON RETURN                                                         00000960
C                                                                       00000970
C         R      CONTAINS THE UPDATED FACTOR.                           00000980
C                                                                       00000990
C         Z      CONTAINS THE UPDATED MATRIX Z.                         00001000
C                                                                       00001010
C         C      DOUBLE PRECISION(P).                                   00001020
C                C CONTAINS THE COSINES OF THE TRANSFORMING ROTATIONS.  00001030
C                                                                       00001040
C         S      COMPLEX*16(P).                                         00001050
C                S CONTAINS THE SINES OF THE TRANSFORMING ROTATIONS.    00001060
C                                                                       00001070
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00001080
C     G.W. STEWART, UNIVERSITY OF MARYLAND, ARGONNE NATIONAL LAB.       00001090
C                                                                       00001100
C     ZCHEX USES THE FOLLOWING FUNCTIONS AND SUBROUTINES.               00001110
C                                                                       00001120
C     EXTENDED BLAS ZROTG                                               00001130
C     FORTRAN MIN0                                                      00001140
C                                                                       00001150
      INTEGER I,II,IL,IU,J,JJ,KM1,KP1,LMK,LM1                           00001160
      COMPLEX*16 RJP1J,T                                                00001170
      DOUBLE PRECISION DREAL,DIMAG                                      00001180
      COMPLEX*16 ZDUMR,ZDUMI                                            00001190
      DREAL(ZDUMR) = ZDUMR                                              00001200
      DIMAG(ZDUMI) = (0.0D0,-1.0D0)*ZDUMI                               00001210
C                                                                       00001220
C     INITIALIZE                                                        00001230
C                                                                       00001240
      KM1 = K - 1                                                       00001250
      KP1 = K + 1                                                       00001260
      LMK = L - K                                                       00001270
      LM1 = L - 1                                                       00001280
C                                                                       00001290
C     PERFORM THE APPROPRIATE TASK.                                     00001300
C                                                                       00001310
      GO TO (10,130), JOB                                               00001320
C                                                                       00001330
C     RIGHT CIRCULAR SHIFT.                                             00001340
C                                                                       00001350
   10 CONTINUE                                                          00001360
C                                                                       00001370
C        REORDER THE COLUMNS.                                           00001380
C                                                                       00001390
         DO 20 I = 1, L                                                 00001400
            II = L - I + 1                                              00001410
            S(I) = R(II,L)                                              00001420
   20    CONTINUE                                                       00001430
         DO 40 JJ = K, LM1                                              00001440
            J = LM1 - JJ + K                                            00001450
            DO 30 I = 1, J                                              00001460
               R(I,J+1) = R(I,J)                                        00001470
   30       CONTINUE                                                    00001480
            R(J+1,J+1) = (0.0D0,0.0D0)                                  00001490
   40    CONTINUE                                                       00001500
         IF (K .EQ. 1) GO TO 60                                         00001510
            DO 50 I = 1, KM1                                            00001520
               II = L - I + 1                                           00001530
               R(I,K) = S(II)                                           00001540
   50       CONTINUE                                                    00001550
   60    CONTINUE                                                       00001560
C                                                                       00001570
C        CALCULATE THE ROTATIONS.                                       00001580
C                                                                       00001590
         T = S(1)                                                       00001600
         DO 70 I = 1, LMK                                               00001610
            CALL ZROTG(S(I+1),T,C(I),S(I))                              00001620
            T = S(I+1)                                                  00001630
   70    CONTINUE                                                       00001640
         R(K,K) = T                                                     00001650
         DO 90 J = KP1, P                                               00001660
            IL = MAX0(1,L-J+1)                                          00001670
            DO 80 II = IL, LMK                                          00001680
               I = L - II                                               00001690
               T = C(II)*R(I,J) + S(II)*R(I+1,J)                        00001700
               R(I+1,J) = C(II)*R(I+1,J) - DCONJG(S(II))*R(I,J)         00001710
               R(I,J) = T                                               00001720
   80       CONTINUE                                                    00001730
   90    CONTINUE                                                       00001740
C                                                                       00001750
C        IF REQUIRED, APPLY THE TRANSFORMATIONS TO Z.                   00001760
C                                                                       00001770
         IF (NZ .LT. 1) GO TO 120                                       00001780
         DO 110 J = 1, NZ                                               00001790
            DO 100 II = 1, LMK                                          00001800
               I = L - II                                               00001810
               T = C(II)*Z(I,J) + S(II)*Z(I+1,J)                        00001820
               Z(I+1,J) = C(II)*Z(I+1,J) - DCONJG(S(II))*Z(I,J)         00001830
               Z(I,J) = T                                               00001840
  100       CONTINUE                                                    00001850
  110    CONTINUE                                                       00001860
  120    CONTINUE                                                       00001870
      GO TO 260                                                         00001880
C                                                                       00001890
C     LEFT CIRCULAR SHIFT                                               00001900
C                                                                       00001910
  130 CONTINUE                                                          00001920
C                                                                       00001930
C        REORDER THE COLUMNS                                            00001940
C                                                                       00001950
         DO 140 I = 1, K                                                00001960
            II = LMK + I                                                00001970
            S(II) = R(I,K)                                              00001980
  140    CONTINUE                                                       00001990
         DO 160 J = K, LM1                                              00002000
            DO 150 I = 1, J                                             00002010
               R(I,J) = R(I,J+1)                                        00002020
  150       CONTINUE                                                    00002030
            JJ = J - KM1                                                00002040
            S(JJ) = R(J+1,J+1)                                          00002050
  160    CONTINUE                                                       00002060
         DO 170 I = 1, K                                                00002070
            II = LMK + I                                                00002080
            R(I,L) = S(II)                                              00002090
  170    CONTINUE                                                       00002100
         DO 180 I = KP1, L                                              00002110
            R(I,L) = (0.0D0,0.0D0)                                      00002120
  180    CONTINUE                                                       00002130
C                                                                       00002140
C        REDUCTION LOOP.                                                00002150
C                                                                       00002160
         DO 220 J = K, P                                                00002170
            IF (J .EQ. K) GO TO 200                                     00002180
C                                                                       00002190
C              APPLY THE ROTATIONS.                                     00002200
C                                                                       00002210
               IU = MIN0(J-1,L-1)                                       00002220
               DO 190 I = K, IU                                         00002230
                  II = I - K + 1                                        00002240
                  T = C(II)*R(I,J) + S(II)*R(I+1,J)                     00002250
                  R(I+1,J) = C(II)*R(I+1,J) - DCONJG(S(II))*R(I,J)      00002260
                  R(I,J) = T                                            00002270
  190          CONTINUE                                                 00002280
  200       CONTINUE                                                    00002290
            IF (J .GE. L) GO TO 210                                     00002300
               JJ = J - K + 1                                           00002310
               T = S(JJ)                                                00002320
               CALL ZROTG(R(J,J),T,C(JJ),S(JJ))                         00002330
  210       CONTINUE                                                    00002340
  220    CONTINUE                                                       00002350
C                                                                       00002360
C        APPLY THE ROTATIONS TO Z.                                      00002370
C                                                                       00002380
         IF (NZ .LT. 1) GO TO 250                                       00002390
         DO 240 J = 1, NZ                                               00002400
            DO 230 I = K, LM1                                           00002410
               II = I - KM1                                             00002420
               T = C(II)*Z(I,J) + S(II)*Z(I+1,J)                        00002430
               Z(I+1,J) = C(II)*Z(I+1,J) - DCONJG(S(II))*Z(I,J)         00002440
               Z(I,J) = T                                               00002450
  230       CONTINUE                                                    00002460
  240    CONTINUE                                                       00002470
  250    CONTINUE                                                       00002480
  260 CONTINUE                                                          00002490
      RETURN                                                            00002500
      END                                                               00002510
