*#**********************************************************************

      SUBROUTINE ZGBCO(ABD,LDA,N,ML,MU,IPVT,RCOND,Z)                    00000010

      INTEGER LDA,N,ML,MU,IPVT(1)                                       00000020
      COMPLEX*16 ABD(LDA,1),Z(1)                                        00000030
      DOUBLE PRECISION RCOND                                            00000040
C                                                                       00000050
C     ZGBCO FACTORS A COMPLEX*16 BAND MATRIX BY GAUSSIAN                00000060
C     ELIMINATION AND ESTIMATES THE CONDITION OF THE MATRIX.            00000070
C                                                                       00000080
C     IF  RCOND  IS NOT NEEDED, ZGBFA IS SLIGHTLY FASTER.               00000090
C     TO SOLVE  A*X = B , FOLLOW ZGBCO BY ZGBSL.                        00000100
C     TO COMPUTE  INVERSE(A)*C , FOLLOW ZGBCO BY ZGBSL.                 00000110
C     TO COMPUTE  DETERMINANT(A) , FOLLOW ZGBCO BY ZGBDI.               00000120
C                                                                       00000130
C     ON ENTRY                                                          00000140
C                                                                       00000150
C        ABD     COMPLEX*16(LDA, N)                                     00000160
C                CONTAINS THE MATRIX IN BAND STORAGE.  THE COLUMNS      00000170
C                OF THE MATRIX ARE STORED IN THE COLUMNS OF  ABD  AND   00000180
C                THE DIAGONALS OF THE MATRIX ARE STORED IN ROWS         00000190
C                ML+1 THROUGH 2*ML+MU+1 OF  ABD .                       00000200
C                SEE THE COMMENTS BELOW FOR DETAILS.                    00000210
C                                                                       00000220
C        LDA     INTEGER                                                00000230
C                THE LEADING DIMENSION OF THE ARRAY  ABD .              00000240
C                LDA MUST BE .GE. 2*ML + MU + 1 .                       00000250
C                                                                       00000260
C        N       INTEGER                                                00000270
C                THE ORDER OF THE ORIGINAL MATRIX.                      00000280
C                                                                       00000290
C        ML      INTEGER                                                00000300
C                NUMBER OF DIAGONALS BELOW THE MAIN DIAGONAL.           00000310
C                0 .LE. ML .LT. N .                                     00000320
C                                                                       00000330
C        MU      INTEGER                                                00000340
C                NUMBER OF DIAGONALS ABOVE THE MAIN DIAGONAL.           00000350
C                0 .LE. MU .LT. N .                                     00000360
C                MORE EFFICIENT IF  ML .LE. MU .                        00000370
C                                                                       00000380
C     ON RETURN                                                         00000390
C                                                                       00000400
C        ABD     AN UPPER TRIANGULAR MATRIX IN BAND STORAGE AND         00000410
C                THE MULTIPLIERS WHICH WERE USED TO OBTAIN IT.          00000420
C                THE FACTORIZATION CAN BE WRITTEN  A = L*U  WHERE       00000430
C                L  IS A PRODUCT OF PERMUTATION AND UNIT LOWER          00000440
C                TRIANGULAR MATRICES AND  U  IS UPPER TRIANGULAR.       00000450
C                                                                       00000460
C        IPVT    INTEGER(N)                                             00000470
C                AN INTEGER VECTOR OF PIVOT INDICES.                    00000480
C                                                                       00000490
C        RCOND   DOUBLE PRECISION                                       00000500
C                AN ESTIMATE OF THE RECIPROCAL CONDITION OF  A .        00000510
C                FOR THE SYSTEM  A*X = B , RELATIVE PERTURBATIONS       00000520
C                IN  A  AND  B  OF SIZE  EPSILON  MAY CAUSE             00000530
C                RELATIVE PERTURBATIONS IN  X  OF SIZE  EPSILON/RCOND . 00000540
C                IF  RCOND  IS SO SMALL THAT THE LOGICAL EXPRESSION     00000550
C                           1.0 + RCOND .EQ. 1.0                        00000560
C                IS TRUE, THEN  A  MAY BE SINGULAR TO WORKING           00000570
C                PRECISION.  IN PARTICULAR,  RCOND  IS ZERO  IF         00000580
C                EXACT SINGULARITY IS DETECTED OR THE ESTIMATE          00000590
C                UNDERFLOWS.                                            00000600
C                                                                       00000610
C        Z       COMPLEX*16(N)                                          00000620
C                A WORK VECTOR WHOSE CONTENTS ARE USUALLY UNIMPORTANT.  00000630
C                IF  A  IS CLOSE TO A SINGULAR MATRIX, THEN  Z  IS      00000640
C                AN APPROXIMATE NULL VECTOR IN THE SENSE THAT           00000650
C                NORM(A*Z) = RCOND*NORM(A)*NORM(Z) .                    00000660
C                                                                       00000670
C     BAND STORAGE                                                      00000680
C                                                                       00000690
C           IF  A  IS A BAND MATRIX, THE FOLLOWING PROGRAM SEGMENT      00000700
C           WILL SET UP THE INPUT.                                      00000710
C                                                                       00000720
C                   ML = (BAND WIDTH BELOW THE DIAGONAL)                00000730
C                   MU = (BAND WIDTH ABOVE THE DIAGONAL)                00000740
C                   M = ML + MU + 1                                     00000750
C                   DO 20 J = 1, N                                      00000760
C                      I1 = MAX0(1, J-MU)                               00000770
C                      I2 = MIN0(N, J+ML)                               00000780
C                      DO 10 I = I1, I2                                 00000790
C                         K = I - J + M                                 00000800
C                         ABD(K,J) = A(I,J)                             00000810
C                10    CONTINUE                                         00000820
C                20 CONTINUE                                            00000830
C                                                                       00000840
C           THIS USES ROWS  ML+1  THROUGH  2*ML+MU+1  OF  ABD .         00000850
C           IN ADDITION, THE FIRST  ML  ROWS IN  ABD  ARE USED FOR      00000860
C           ELEMENTS GENERATED DURING THE TRIANGULARIZATION.            00000870
C           THE TOTAL NUMBER OF ROWS NEEDED IN  ABD  IS  2*ML+MU+1 .    00000880
C           THE  ML+MU BY ML+MU  UPPER LEFT TRIANGLE AND THE            00000890
C           ML BY ML  LOWER RIGHT TRIANGLE ARE NOT REFERENCED.          00000900
C                                                                       00000910
C     EXAMPLE..  IF THE ORIGINAL MATRIX IS                              00000920
C                                                                       00000930
C           11 12 13  0  0  0                                           00000940
C           21 22 23 24  0  0                                           00000950
C            0 32 33 34 35  0                                           00000960
C            0  0 43 44 45 46                                           00000970
C            0  0  0 54 55 56                                           00000980
C            0  0  0  0 65 66                                           00000990
C                                                                       00001000
C      THEN  N = 6, ML = 1, MU = 2, LDA .GE. 5  AND ABD SHOULD CONTAIN  00001010
C                                                                       00001020
C            *  *  *  +  +  +  , * = NOT USED                           00001030
C            *  * 13 24 35 46  , + = USED FOR PIVOTING                  00001040
C            * 12 23 34 45 56                                           00001050
C           11 22 33 44 55 66                                           00001060
C           21 32 43 54 65  *                                           00001070
C                                                                       00001080
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00001090
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00001100
C                                                                       00001110
C     SUBROUTINES AND FUNCTIONS                                         00001120
C                                                                       00001130
C     LINPACK ZGBFA                                                     00001140
C     BLAS ZAXPY,ZDOTC,ZDSCAL,DZASUM                                    00001150
C     FORTRAN DABS,DMAX1,DCMPLX,DCONJG,MAX0,MIN0                        00001160
C                                                                       00001170
C     INTERNAL VARIABLES                                                00001180
C                                                                       00001190
      COMPLEX*16 ZDOTC,EK,T,WK,WKM                                      00001200
      DOUBLE PRECISION ANORM,S,DZASUM,SM,YNORM                          00001210
      INTEGER IS,INFO,J,JU,K,KB,KP1,L,LA,LM,LZ,M,MM                     00001220
C                                                                       00001230
      COMPLEX*16 ZDUM,ZDUM1,ZDUM2,CSIGN1                                00001240
      DOUBLE PRECISION CABS1                                            00001250
      DOUBLE PRECISION DREAL,DIMAG                                      00001260
      COMPLEX*16 ZDUMR,ZDUMI                                            00001270
      DREAL(ZDUMR) = ZDUMR                                              00001280
      DIMAG(ZDUMI) = (0.0D0,-1.0D0)*ZDUMI                               00001290
      CABS1(ZDUM) = DABS(DREAL(ZDUM)) + DABS(DIMAG(ZDUM))               00001300
      CSIGN1(ZDUM1,ZDUM2) = CABS1(ZDUM1)*(ZDUM2/CABS1(ZDUM2))           00001310
C                                                                       00001320
C     COMPUTE 1-NORM OF A                                               00001330
C                                                                       00001340
      ANORM = 0.0D0                                                     00001350
      L = ML + 1                                                        00001360
      IS = L + MU                                                       00001370
      DO 10 J = 1, N                                                    00001380
         ANORM = DMAX1(ANORM,DZASUM(L,ABD(IS,J),1))                     00001390
         IF (IS .GT. ML + 1) IS = IS - 1                                00001400
         IF (J .LE. MU) L = L + 1                                       00001410
         IF (J .GE. N - ML) L = L - 1                                   00001420
   10 CONTINUE                                                          00001430
C                                                                       00001440
C     FACTOR                                                            00001450
C                                                                       00001460
      CALL ZGBFA(ABD,LDA,N,ML,MU,IPVT,INFO)                             00001470
C                                                                       00001480
C     RCOND = 1/(NORM(A)*(ESTIMATE OF NORM(INVERSE(A)))) .              00001490
C     ESTIMATE = NORM(Z)/NORM(Y) WHERE  A*Z = Y  AND  CTRANS(A)*Y = E . 00001500
C     CTRANS(A)  IS THE CONJUGATE TRANSPOSE OF A .                      00001510
C     THE COMPONENTS OF  E  ARE CHOSEN TO CAUSE MAXIMUM LOCAL           00001520
C     GROWTH IN THE ELEMENTS OF W  WHERE  CTRANS(U)*W = E .             00001530
C     THE VECTORS ARE FREQUENTLY RESCALED TO AVOID OVERFLOW.            00001540
C                                                                       00001550
C     SOLVE CTRANS(U)*W = E                                             00001560
C                                                                       00001570
      EK = (1.0D0,0.0D0)                                                00001580
      DO 20 J = 1, N                                                    00001590
         Z(J) = (0.0D0,0.0D0)                                           00001600
   20 CONTINUE                                                          00001610
      M = ML + MU + 1                                                   00001620
      JU = 0                                                            00001630
      DO 100 K = 1, N                                                   00001640
         IF (CABS1(Z(K)) .NE. 0.0D0) EK = CSIGN1(EK,-Z(K))              00001650
         IF (CABS1(EK-Z(K)) .LE. CABS1(ABD(M,K))) GO TO 30              00001660
            S = CABS1(ABD(M,K))/CABS1(EK-Z(K))                          00001670
            CALL ZDSCAL(N,S,Z,1)                                        00001680
            EK = DCMPLX(S,0.0D0)*EK                                     00001690
   30    CONTINUE                                                       00001700
         WK = EK - Z(K)                                                 00001710
         WKM = -EK - Z(K)                                               00001720
         S = CABS1(WK)                                                  00001730
         SM = CABS1(WKM)                                                00001740
         IF (CABS1(ABD(M,K)) .EQ. 0.0D0) GO TO 40                       00001750
            WK = WK/DCONJG(ABD(M,K))                                    00001760
            WKM = WKM/DCONJG(ABD(M,K))                                  00001770
         GO TO 50                                                       00001780
   40    CONTINUE                                                       00001790
            WK = (1.0D0,0.0D0)                                          00001800
            WKM = (1.0D0,0.0D0)                                         00001810
   50    CONTINUE                                                       00001820
         KP1 = K + 1                                                    00001830
         JU = MIN0(MAX0(JU,MU+IPVT(K)),N)                               00001840
         MM = M                                                         00001850
         IF (KP1 .GT. JU) GO TO 90                                      00001860
            DO 60 J = KP1, JU                                           00001870
               MM = MM - 1                                              00001880
               SM = SM + CABS1(Z(J)+WKM*DCONJG(ABD(MM,J)))              00001890
               Z(J) = Z(J) + WK*DCONJG(ABD(MM,J))                       00001900
               S = S + CABS1(Z(J))                                      00001910
   60       CONTINUE                                                    00001920
            IF (S .GE. SM) GO TO 80                                     00001930
               T = WKM - WK                                             00001940
               WK = WKM                                                 00001950
               MM = M                                                   00001960
               DO 70 J = KP1, JU                                        00001970
                  MM = MM - 1                                           00001980
                  Z(J) = Z(J) + T*DCONJG(ABD(MM,J))                     00001990
   70          CONTINUE                                                 00002000
   80       CONTINUE                                                    00002010
   90    CONTINUE                                                       00002020
         Z(K) = WK                                                      00002030
  100 CONTINUE                                                          00002040
      S = 1.0D0/DZASUM(N,Z,1)                                           00002050
      CALL ZDSCAL(N,S,Z,1)                                              00002060
C                                                                       00002070
C     SOLVE CTRANS(L)*Y = W                                             00002080
C                                                                       00002090
      DO 120 KB = 1, N                                                  00002100
         K = N + 1 - KB                                                 00002110
         LM = MIN0(ML,N-K)                                              00002120
         IF (K .LT. N) Z(K) = Z(K) + ZDOTC(LM,ABD(M+1,K),1,Z(K+1),1)    00002130
         IF (CABS1(Z(K)) .LE. 1.0D0) GO TO 110                          00002140
            S = 1.0D0/CABS1(Z(K))                                       00002150
            CALL ZDSCAL(N,S,Z,1)                                        00002160
  110    CONTINUE                                                       00002170
         L = IPVT(K)                                                    00002180
         T = Z(L)                                                       00002190
         Z(L) = Z(K)                                                    00002200
         Z(K) = T                                                       00002210
  120 CONTINUE                                                          00002220
      S = 1.0D0/DZASUM(N,Z,1)                                           00002230
      CALL ZDSCAL(N,S,Z,1)                                              00002240
C                                                                       00002250
      YNORM = 1.0D0                                                     00002260
C                                                                       00002270
C     SOLVE L*V = Y                                                     00002280
C                                                                       00002290
      DO 140 K = 1, N                                                   00002300
         L = IPVT(K)                                                    00002310
         T = Z(L)                                                       00002320
         Z(L) = Z(K)                                                    00002330
         Z(K) = T                                                       00002340
         LM = MIN0(ML,N-K)                                              00002350
         IF (K .LT. N) CALL ZAXPY(LM,T,ABD(M+1,K),1,Z(K+1),1)           00002360
         IF (CABS1(Z(K)) .LE. 1.0D0) GO TO 130                          00002370
            S = 1.0D0/CABS1(Z(K))                                       00002380
            CALL ZDSCAL(N,S,Z,1)                                        00002390
            YNORM = S*YNORM                                             00002400
  130    CONTINUE                                                       00002410
  140 CONTINUE                                                          00002420
      S = 1.0D0/DZASUM(N,Z,1)                                           00002430
      CALL ZDSCAL(N,S,Z,1)                                              00002440
      YNORM = S*YNORM                                                   00002450
C                                                                       00002460
C     SOLVE  U*Z = W                                                    00002470
C                                                                       00002480
      DO 160 KB = 1, N                                                  00002490
         K = N + 1 - KB                                                 00002500
         IF (CABS1(Z(K)) .LE. CABS1(ABD(M,K))) GO TO 150                00002510
            S = CABS1(ABD(M,K))/CABS1(Z(K))                             00002520
            CALL ZDSCAL(N,S,Z,1)                                        00002530
            YNORM = S*YNORM                                             00002540
  150    CONTINUE                                                       00002550
         IF (CABS1(ABD(M,K)) .NE. 0.0D0) Z(K) = Z(K)/ABD(M,K)           00002560
         IF (CABS1(ABD(M,K)) .EQ. 0.0D0) Z(K) = (1.0D0,0.0D0)           00002570
         LM = MIN0(K,M) - 1                                             00002580
         LA = M - LM                                                    00002590
         LZ = K - LM                                                    00002600
         T = -Z(K)                                                      00002610
         CALL ZAXPY(LM,T,ABD(LA,K),1,Z(LZ),1)                           00002620
  160 CONTINUE                                                          00002630
C     MAKE ZNORM = 1.0                                                  00002640
      S = 1.0D0/DZASUM(N,Z,1)                                           00002650
      CALL ZDSCAL(N,S,Z,1)                                              00002660
      YNORM = S*YNORM                                                   00002670
C                                                                       00002680
      IF (ANORM .NE. 0.0D0) RCOND = YNORM/ANORM                         00002690
      IF (ANORM .EQ. 0.0D0) RCOND = 0.0D0                               00002700
      RETURN                                                            00002710
      END                                                               00002720
