*#**********************************************************************

      SUBROUTINE ZGESL(A,LDA,N,IPVT,B,JOB)                              00000010

      INTEGER LDA,N,IPVT(1),JOB                                         00000020
      COMPLEX*16 A(LDA,1),B(1)                                          00000030
C                                                                       00000040
C     ZGESL SOLVES THE COMPLEX*16 SYSTEM                                00000050
C     A * X = B  OR  CTRANS(A) * X = B                                  00000060
C     USING THE FACTORS COMPUTED BY ZGECO OR ZGEFA.                     00000070
C                                                                       00000080
C     ON ENTRY                                                          00000090
C                                                                       00000100
C        A       COMPLEX*16(LDA, N)                                     00000110
C                THE OUTPUT FROM ZGECO OR ZGEFA.                        00000120
C                                                                       00000130
C        LDA     INTEGER                                                00000140
C                THE LEADING DIMENSION OF THE ARRAY  A .                00000150
C                                                                       00000160
C        N       INTEGER                                                00000170
C                THE ORDER OF THE MATRIX  A .                           00000180
C                                                                       00000190
C        IPVT    INTEGER(N)                                             00000200
C                THE PIVOT VECTOR FROM ZGECO OR ZGEFA.                  00000210
C                                                                       00000220
C        B       COMPLEX*16(N)                                          00000230
C                THE RIGHT HAND SIDE VECTOR.                            00000240
C                                                                       00000250
C        JOB     INTEGER                                                00000260
C                = 0         TO SOLVE  A*X = B ,                        00000270
C                = NONZERO   TO SOLVE  CTRANS(A)*X = B  WHERE           00000280
C                            CTRANS(A)  IS THE CONJUGATE TRANSPOSE.     00000290
C                                                                       00000300
C     ON RETURN                                                         00000310
C                                                                       00000320
C        B       THE SOLUTION VECTOR  X .                               00000330
C                                                                       00000340
C     ERROR CONDITION                                                   00000350
C                                                                       00000360
C        A DIVISION BY ZERO WILL OCCUR IF THE INPUT FACTOR CONTAINS A   00000370
C        ZERO ON THE DIAGONAL.  TECHNICALLY THIS INDICATES SINGULARITY  00000380
C        BUT IT IS OFTEN CAUSED BY IMPROPER ARGUMENTS OR IMPROPER       00000390
C        SETTING OF LDA .  IT WILL NOT OCCUR IF THE SUBROUTINES ARE     00000400
C        CALLED CORRECTLY AND IF ZGECO HAS SET RCOND .GT. 0.0           00000410
C        OR ZGEFA HAS SET INFO .EQ. 0 .                                 00000420
C                                                                       00000430
C     TO COMPUTE  INVERSE(A) * C  WHERE  C  IS A MATRIX                 00000440
C     WITH  P  COLUMNS                                                  00000450
C           CALL ZGECO(A,LDA,N,IPVT,RCOND,Z)                            00000460
C           IF (RCOND IS TOO SMALL) GO TO ...                           00000470
C           DO 10 J = 1, P                                              00000480
C              CALL ZGESL(A,LDA,N,IPVT,C(1,J),0)                        00000490
C        10 CONTINUE                                                    00000500
C                                                                       00000510
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000520
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000530
C                                                                       00000540
C     SUBROUTINES AND FUNCTIONS                                         00000550
C                                                                       00000560
C     BLAS ZAXPY,ZDOTC                                                  00000570
C     FORTRAN DCONJG                                                    00000580
C                                                                       00000590
C     INTERNAL VARIABLES                                                00000600
C                                                                       00000610
      COMPLEX*16 ZDOTC,T                                                00000620
      INTEGER K,KB,L,NM1                                                00000630
      DOUBLE PRECISION DREAL,DIMAG                                      00000640
      COMPLEX*16 ZDUMR,ZDUMI                                            00000650
      DREAL(ZDUMR) = ZDUMR                                              00000660
      DIMAG(ZDUMI) = (0.0D0,-1.0D0)*ZDUMI                               00000670
C                                                                       00000680
      NM1 = N - 1                                                       00000690
      IF (JOB .NE. 0) GO TO 50                                          00000700
C                                                                       00000710
C        JOB = 0 , SOLVE  A * X = B                                     00000720
C        FIRST SOLVE  L*Y = B                                           00000730
C                                                                       00000740
         IF (NM1 .LT. 1) GO TO 30                                       00000750
         DO 20 K = 1, NM1                                               00000760
            L = IPVT(K)                                                 00000770
            T = B(L)                                                    00000780
            IF (L .EQ. K) GO TO 10                                      00000790
               B(L) = B(K)                                              00000800
               B(K) = T                                                 00000810
   10       CONTINUE                                                    00000820
            CALL ZAXPY(N-K,T,A(K+1,K),1,B(K+1),1)                       00000830
   20    CONTINUE                                                       00000840
   30    CONTINUE                                                       00000850
C                                                                       00000860
C        NOW SOLVE  U*X = Y                                             00000870
C                                                                       00000880
         DO 40 KB = 1, N                                                00000890
            K = N + 1 - KB                                              00000900
            B(K) = B(K)/A(K,K)                                          00000910
            T = -B(K)                                                   00000920
            CALL ZAXPY(K-1,T,A(1,K),1,B(1),1)                           00000930
   40    CONTINUE                                                       00000940
      GO TO 100                                                         00000950
   50 CONTINUE                                                          00000960
C                                                                       00000970
C        JOB = NONZERO, SOLVE  CTRANS(A) * X = B                        00000980
C        FIRST SOLVE  CTRANS(U)*Y = B                                   00000990
C                                                                       00001000
         DO 60 K = 1, N                                                 00001010
            T = ZDOTC(K-1,A(1,K),1,B(1),1)                              00001020
            B(K) = (B(K) - T)/DCONJG(A(K,K))                            00001030
   60    CONTINUE                                                       00001040
C                                                                       00001050
C        NOW SOLVE CTRANS(L)*X = Y                                      00001060
C                                                                       00001070
         IF (NM1 .LT. 1) GO TO 90                                       00001080
         DO 80 KB = 1, NM1                                              00001090
            K = N - KB                                                  00001100
            B(K) = B(K) + ZDOTC(N-K,A(K+1,K),1,B(K+1),1)                00001110
            L = IPVT(K)                                                 00001120
            IF (L .EQ. K) GO TO 70                                      00001130
               T = B(L)                                                 00001140
               B(L) = B(K)                                              00001150
               B(K) = T                                                 00001160
   70       CONTINUE                                                    00001170
   80    CONTINUE                                                       00001180
   90    CONTINUE                                                       00001190
  100 CONTINUE                                                          00001200
      RETURN                                                            00001210
      END                                                               00001220
