*#**********************************************************************

      SUBROUTINE ZHIFA(A,LDA,N,KPVT,INFO)                               00000010

      INTEGER LDA,N,KPVT(1),INFO                                        00000020
      COMPLEX*16 A(LDA,1)                                               00000030
C                                                                       00000040
C     ZHIFA FACTORS A COMPLEX*16 HERMITIAN MATRIX BY ELIMINATION        00000050
C     WITH SYMMETRIC PIVOTING.                                          00000060
C                                                                       00000070
C     TO SOLVE  A*X = B , FOLLOW ZHIFA BY ZHISL.                        00000080
C     TO COMPUTE  INVERSE(A)*C , FOLLOW ZHIFA BY ZHISL.                 00000090
C     TO COMPUTE  DETERMINANT(A) , FOLLOW ZHIFA BY ZHIDI.               00000100
C     TO COMPUTE  INERTIA(A) , FOLLOW ZHIFA BY ZHIDI.                   00000110
C     TO COMPUTE  INVERSE(A) , FOLLOW ZHIFA BY ZHIDI.                   00000120
C                                                                       00000130
C     ON ENTRY                                                          00000140
C                                                                       00000150
C        A       COMPLEX*16(LDA,N)                                      00000160
C                THE HERMITIAN MATRIX TO BE FACTORED.                   00000170
C                ONLY THE DIAGONAL AND UPPER TRIANGLE ARE USED.         00000180
C                                                                       00000190
C        LDA     INTEGER                                                00000200
C                THE LEADING DIMENSION OF THE ARRAY  A .                00000210
C                                                                       00000220
C        N       INTEGER                                                00000230
C                THE ORDER OF THE MATRIX  A .                           00000240
C                                                                       00000250
C     ON RETURN                                                         00000260
C                                                                       00000270
C        A       A BLOCK DIAGONAL MATRIX AND THE MULTIPLIERS WHICH      00000280
C                WERE USED TO OBTAIN IT.                                00000290
C                THE FACTORIZATION CAN BE WRITTEN  A = U*D*CTRANS(U)    00000300
C                WHERE  U  IS A PRODUCT OF PERMUTATION AND UNIT         00000310
C                UPPER TRIANGULAR MATRICES , CTRANS(U) IS THE           00000320
C                CONJUGATE TRANSPOSE OF  U , AND  D  IS BLOCK DIAGONAL  00000330
C                WITH 1 BY 1 AND 2 BY 2 BLOCKS.                         00000340
C                                                                       00000350
C        KPVT    INTEGER(N)                                             00000360
C                AN INTEGER VECTOR OF PIVOT INDICES.                    00000370
C                                                                       00000380
C        INFO    INTEGER                                                00000390
C                = 0  NORMAL VALUE.                                     00000400
C                = K  IF THE K-TH PIVOT BLOCK IS SINGULAR. THIS IS      00000410
C                     NOT AN ERROR CONDITION FOR THIS SUBROUTINE,       00000420
C                     BUT IT DOES INDICATE THAT ZHISL OR ZHIDI MAY      00000430
C                     DIVIDE BY ZERO IF CALLED.                         00000440
C                                                                       00000450
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000460
C     JAMES BUNCH, UNIV. CALIF. SAN DIEGO, ARGONNE NAT. LAB.            00000470
C                                                                       00000480
C     SUBROUTINES AND FUNCTIONS                                         00000490
C                                                                       00000500
C     BLAS ZAXPY,ZSWAP,IZAMAX                                           00000510
C     FORTRAN DABS,DMAX1,DCMPLX,DCONJG,DSQRT                            00000520
C                                                                       00000530
C     INTERNAL VARIABLES                                                00000540
C                                                                       00000550
      COMPLEX*16 AK,AKM1,BK,BKM1,DENOM,MULK,MULKM1,T                    00000560
      DOUBLE PRECISION ABSAKK,ALPHA,COLMAX,ROWMAX                       00000570
      INTEGER IMAX,IMAXP1,J,JJ,JMAX,K,KM1,KM2,KSTEP,IZAMAX              00000580
      LOGICAL SWAP                                                      00000590
C                                                                       00000600
      COMPLEX*16 ZDUM                                                   00000610
      DOUBLE PRECISION CABS1                                            00000620
      DOUBLE PRECISION DREAL,DIMAG                                      00000630
      COMPLEX*16 ZDUMR,ZDUMI                                            00000640
      DREAL(ZDUMR) = ZDUMR                                              00000650
      DIMAG(ZDUMI) = (0.0D0,-1.0D0)*ZDUMI                               00000660
      CABS1(ZDUM) = DABS(DREAL(ZDUM)) + DABS(DIMAG(ZDUM))               00000670
C                                                                       00000680
C     INITIALIZE                                                        00000690
C                                                                       00000700
C     ALPHA IS USED IN CHOOSING PIVOT BLOCK SIZE.                       00000710
      ALPHA = (1.0D0 + DSQRT(17.0D0))/8.0D0                             00000720
C                                                                       00000730
      INFO = 0                                                          00000740
C                                                                       00000750
C     MAIN LOOP ON K, WHICH GOES FROM N TO 1.                           00000760
C                                                                       00000770
      K = N                                                             00000780
   10 CONTINUE                                                          00000790
C                                                                       00000800
C        LEAVE THE LOOP IF K=0 OR K=1.                                  00000810
C                                                                       00000820
C     ...EXIT                                                           00000830
         IF (K .EQ. 0) GO TO 200                                        00000840
         IF (K .GT. 1) GO TO 20                                         00000850
            KPVT(1) = 1                                                 00000860
            IF (CABS1(A(1,1)) .EQ. 0.0D0) INFO = 1                      00000870
C     ......EXIT                                                        00000880
            GO TO 200                                                   00000890
   20    CONTINUE                                                       00000900
C                                                                       00000910
C        THIS SECTION OF CODE DETERMINES THE KIND OF                    00000920
C        ELIMINATION TO BE PERFORMED.  WHEN IT IS COMPLETED,            00000930
C        KSTEP WILL BE SET TO THE SIZE OF THE PIVOT BLOCK, AND          00000940
C        SWAP WILL BE SET TO .TRUE. IF AN INTERCHANGE IS                00000950
C        REQUIRED.                                                      00000960
C                                                                       00000970
         KM1 = K - 1                                                    00000980
         ABSAKK = CABS1(A(K,K))                                         00000990
C                                                                       00001000
C        DETERMINE THE LARGEST OFF-DIAGONAL ELEMENT IN                  00001010
C        COLUMN K.                                                      00001020
C                                                                       00001030
         IMAX = IZAMAX(K-1,A(1,K),1)                                    00001040
         COLMAX = CABS1(A(IMAX,K))                                      00001050
         IF (ABSAKK .LT. ALPHA*COLMAX) GO TO 30                         00001060
            KSTEP = 1                                                   00001070
            SWAP = .FALSE.                                              00001080
         GO TO 90                                                       00001090
   30    CONTINUE                                                       00001100
C                                                                       00001110
C           DETERMINE THE LARGEST OFF-DIAGONAL ELEMENT IN               00001120
C           ROW IMAX.                                                   00001130
C                                                                       00001140
            ROWMAX = 0.0D0                                              00001150
            IMAXP1 = IMAX + 1                                           00001160
            DO 40 J = IMAXP1, K                                         00001170
               ROWMAX = DMAX1(ROWMAX,CABS1(A(IMAX,J)))                  00001180
   40       CONTINUE                                                    00001190
            IF (IMAX .EQ. 1) GO TO 50                                   00001200
               JMAX = IZAMAX(IMAX-1,A(1,IMAX),1)                        00001210
               ROWMAX = DMAX1(ROWMAX,CABS1(A(JMAX,IMAX)))               00001220
   50       CONTINUE                                                    00001230
            IF (CABS1(A(IMAX,IMAX)) .LT. ALPHA*ROWMAX) GO TO 60         00001240
               KSTEP = 1                                                00001250
               SWAP = .TRUE.                                            00001260
            GO TO 80                                                    00001270
   60       CONTINUE                                                    00001280
            IF (ABSAKK .LT. ALPHA*COLMAX*(COLMAX/ROWMAX)) GO TO 70      00001290
               KSTEP = 1                                                00001300
               SWAP = .FALSE.                                           00001310
            GO TO 80                                                    00001320
   70       CONTINUE                                                    00001330
               KSTEP = 2                                                00001340
               SWAP = IMAX .NE. KM1                                     00001350
   80       CONTINUE                                                    00001360
   90    CONTINUE                                                       00001370
         IF (DMAX1(ABSAKK,COLMAX) .NE. 0.0D0) GO TO 100                 00001380
C                                                                       00001390
C           COLUMN K IS ZERO.  SET INFO AND ITERATE THE LOOP.           00001400
C                                                                       00001410
            KPVT(K) = K                                                 00001420
            INFO = K                                                    00001430
         GO TO 190                                                      00001440
  100    CONTINUE                                                       00001450
         IF (KSTEP .EQ. 2) GO TO 140                                    00001460
C                                                                       00001470
C           1 X 1 PIVOT BLOCK.                                          00001480
C                                                                       00001490
            IF (.NOT.SWAP) GO TO 120                                    00001500
C                                                                       00001510
C              PERFORM AN INTERCHANGE.                                  00001520
C                                                                       00001530
               CALL ZSWAP(IMAX,A(1,IMAX),1,A(1,K),1)                    00001540
               DO 110 JJ = IMAX, K                                      00001550
                  J = K + IMAX - JJ                                     00001560
                  T = DCONJG(A(J,K))                                    00001570
                  A(J,K) = DCONJG(A(IMAX,J))                            00001580
                  A(IMAX,J) = T                                         00001590
  110          CONTINUE                                                 00001600
  120       CONTINUE                                                    00001610
C                                                                       00001620
C           PERFORM THE ELIMINATION.                                    00001630
C                                                                       00001640
            DO 130 JJ = 1, KM1                                          00001650
               J = K - JJ                                               00001660
               MULK = -A(J,K)/A(K,K)                                    00001670
               T = DCONJG(MULK)                                         00001680
               CALL ZAXPY(J,T,A(1,K),1,A(1,J),1)                        00001690
               A(J,J) = DCMPLX(DREAL(A(J,J)),0.0D0)                     00001700
               A(J,K) = MULK                                            00001710
  130       CONTINUE                                                    00001720
C                                                                       00001730
C           SET THE PIVOT ARRAY.                                        00001740
C                                                                       00001750
            KPVT(K) = K                                                 00001760
            IF (SWAP) KPVT(K) = IMAX                                    00001770
         GO TO 190                                                      00001780
  140    CONTINUE                                                       00001790
C                                                                       00001800
C           2 X 2 PIVOT BLOCK.                                          00001810
C                                                                       00001820
            IF (.NOT.SWAP) GO TO 160                                    00001830
C                                                                       00001840
C              PERFORM AN INTERCHANGE.                                  00001850
C                                                                       00001860
               CALL ZSWAP(IMAX,A(1,IMAX),1,A(1,K-1),1)                  00001870
               DO 150 JJ = IMAX, KM1                                    00001880
                  J = KM1 + IMAX - JJ                                   00001890
                  T = DCONJG(A(J,K-1))                                  00001900
                  A(J,K-1) = DCONJG(A(IMAX,J))                          00001910
                  A(IMAX,J) = T                                         00001920
  150          CONTINUE                                                 00001930
               T = A(K-1,K)                                             00001940
               A(K-1,K) = A(IMAX,K)                                     00001950
               A(IMAX,K) = T                                            00001960
  160       CONTINUE                                                    00001970
C                                                                       00001980
C           PERFORM THE ELIMINATION.                                    00001990
C                                                                       00002000
            KM2 = K - 2                                                 00002010
            IF (KM2 .EQ. 0) GO TO 180                                   00002020
               AK = A(K,K)/A(K-1,K)                                     00002030
               AKM1 = A(K-1,K-1)/DCONJG(A(K-1,K))                       00002040
               DENOM = 1.0D0 - AK*AKM1                                  00002050
               DO 170 JJ = 1, KM2                                       00002060
                  J = KM1 - JJ                                          00002070
                  BK = A(J,K)/A(K-1,K)                                  00002080
                  BKM1 = A(J,K-1)/DCONJG(A(K-1,K))                      00002090
                  MULK = (AKM1*BK - BKM1)/DENOM                         00002100
                  MULKM1 = (AK*BKM1 - BK)/DENOM                         00002110
                  T = DCONJG(MULK)                                      00002120
                  CALL ZAXPY(J,T,A(1,K),1,A(1,J),1)                     00002130
                  T = DCONJG(MULKM1)                                    00002140
                  CALL ZAXPY(J,T,A(1,K-1),1,A(1,J),1)                   00002150
                  A(J,K) = MULK                                         00002160
                  A(J,K-1) = MULKM1                                     00002170
                  A(J,J) = DCMPLX(DREAL(A(J,J)),0.0D0)                  00002180
  170          CONTINUE                                                 00002190
  180       CONTINUE                                                    00002200
C                                                                       00002210
C           SET THE PIVOT ARRAY.                                        00002220
C                                                                       00002230
            KPVT(K) = 1 - K                                             00002240
            IF (SWAP) KPVT(K) = -IMAX                                   00002250
            KPVT(K-1) = KPVT(K)                                         00002260
  190    CONTINUE                                                       00002270
         K = K - KSTEP                                                  00002280
      GO TO 10                                                          00002290
  200 CONTINUE                                                          00002300
      RETURN                                                            00002310
      END                                                               00002320
