*#**********************************************************************

      SUBROUTINE ZPBCO(ABD,LDA,N,M,RCOND,Z,INFO)                        00000010

      INTEGER LDA,N,M,INFO                                              00000020
      COMPLEX*16 ABD(LDA,1),Z(1)                                        00000030
      DOUBLE PRECISION RCOND                                            00000040
C                                                                       00000050
C     ZPBCO FACTORS A COMPLEX*16 HERMITIAN POSITIVE DEFINITE MATRIX     00000060
C     STORED IN BAND FORM AND ESTIMATES THE CONDITION OF THE MATRIX.    00000070
C                                                                       00000080
C     IF  RCOND  IS NOT NEEDED, ZPBFA IS SLIGHTLY FASTER.               00000090
C     TO SOLVE  A*X = B , FOLLOW ZPBCO BY ZPBSL.                        00000100
C     TO COMPUTE  INVERSE(A)*C , FOLLOW ZPBCO BY ZPBSL.                 00000110
C     TO COMPUTE  DETERMINANT(A) , FOLLOW ZPBCO BY ZPBDI.               00000120
C                                                                       00000130
C     ON ENTRY                                                          00000140
C                                                                       00000150
C        ABD     COMPLEX*16(LDA, N)                                     00000160
C                THE MATRIX TO BE FACTORED.  THE COLUMNS OF THE UPPER   00000170
C                TRIANGLE ARE STORED IN THE COLUMNS OF ABD AND THE      00000180
C                DIAGONALS OF THE UPPER TRIANGLE ARE STORED IN THE      00000190
C                ROWS OF ABD .  SEE THE COMMENTS BELOW FOR DETAILS.     00000200
C                                                                       00000210
C        LDA     INTEGER                                                00000220
C                THE LEADING DIMENSION OF THE ARRAY  ABD .              00000230
C                LDA MUST BE .GE. M + 1 .                               00000240
C                                                                       00000250
C        N       INTEGER                                                00000260
C                THE ORDER OF THE MATRIX  A .                           00000270
C                                                                       00000280
C        M       INTEGER                                                00000290
C                THE NUMBER OF DIAGONALS ABOVE THE MAIN DIAGONAL.       00000300
C                0 .LE. M .LT. N .                                      00000310
C                                                                       00000320
C     ON RETURN                                                         00000330
C                                                                       00000340
C        ABD     AN UPPER TRIANGULAR MATRIX  R , STORED IN BAND         00000350
C                FORM, SO THAT  A = CTRANS(R)*R .                       00000360
C                IF  INFO .NE. 0 , THE FACTORIZATION IS NOT COMPLETE.   00000370
C                                                                       00000380
C        RCOND   DOUBLE PRECISION                                       00000390
C                AN ESTIMATE OF THE RECIPROCAL CONDITION OF  A .        00000400
C                FOR THE SYSTEM  A*X = B , RELATIVE PERTURBATIONS       00000410
C                IN  A  AND  B  OF SIZE  EPSILON  MAY CAUSE             00000420
C                RELATIVE PERTURBATIONS IN  X  OF SIZE  EPSILON/RCOND . 00000430
C                IF  RCOND  IS SO SMALL THAT THE LOGICAL EXPRESSION     00000440
C                           1.0 + RCOND .EQ. 1.0                        00000450
C                IS TRUE, THEN  A  MAY BE SINGULAR TO WORKING           00000460
C                PRECISION.  IN PARTICULAR,  RCOND  IS ZERO  IF         00000470
C                EXACT SINGULARITY IS DETECTED OR THE ESTIMATE          00000480
C                UNDERFLOWS.  IF INFO .NE. 0 , RCOND IS UNCHANGED.      00000490
C                                                                       00000500
C        Z       COMPLEX*16(N)                                          00000510
C                A WORK VECTOR WHOSE CONTENTS ARE USUALLY UNIMPORTANT.  00000520
C                IF  A  IS SINGULAR TO WORKING PRECISION, THEN  Z  IS   00000530
C                AN APPROXIMATE NULL VECTOR IN THE SENSE THAT           00000540
C                NORM(A*Z) = RCOND*NORM(A)*NORM(Z) .                    00000550
C                IF  INFO .NE. 0 , Z  IS UNCHANGED.                     00000560
C                                                                       00000570
C        INFO    INTEGER                                                00000580
C                = 0  FOR NORMAL RETURN.                                00000590
C                = K  SIGNALS AN ERROR CONDITION.  THE LEADING MINOR    00000600
C                     OF ORDER  K  IS NOT POSITIVE DEFINITE.            00000610
C                                                                       00000620
C     BAND STORAGE                                                      00000630
C                                                                       00000640
C           IF  A  IS A HERMITIAN POSITIVE DEFINITE BAND MATRIX,        00000650
C           THE FOLLOWING PROGRAM SEGMENT WILL SET UP THE INPUT.        00000660
C                                                                       00000670
C                   M = (BAND WIDTH ABOVE DIAGONAL)                     00000680
C                   DO 20 J = 1, N                                      00000690
C                      I1 = MAX0(1, J-M)                                00000700
C                      DO 10 I = I1, J                                  00000710
C                         K = I-J+M+1                                   00000720
C                         ABD(K,J) = A(I,J)                             00000730
C                10    CONTINUE                                         00000740
C                20 CONTINUE                                            00000750
C                                                                       00000760
C           THIS USES  M + 1  ROWS OF  A , EXCEPT FOR THE  M BY M       00000770
C           UPPER LEFT TRIANGLE, WHICH IS IGNORED.                      00000780
C                                                                       00000790
C     EXAMPLE..  IF THE ORIGINAL MATRIX IS                              00000800
C                                                                       00000810
C           11 12 13  0  0  0                                           00000820
C           12 22 23 24  0  0                                           00000830
C           13 23 33 34 35  0                                           00000840
C            0 24 34 44 45 46                                           00000850
C            0  0 35 45 55 56                                           00000860
C            0  0  0 46 56 66                                           00000870
C                                                                       00000880
C     THEN  N = 6 , M = 2  AND  ABD  SHOULD CONTAIN                     00000890
C                                                                       00000900
C            *  * 13 24 35 46                                           00000910
C            * 12 23 34 45 56                                           00000920
C           11 22 33 44 55 66                                           00000930
C                                                                       00000940
C     LINPACK.  THIS VERSION DATED 08/14/78 .                           00000950
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000960
C                                                                       00000970
C     SUBROUTINES AND FUNCTIONS                                         00000980
C                                                                       00000990
C     LINPACK ZPBFA                                                     00001000
C     BLAS ZAXPY,ZDOTC,ZDSCAL,DZASUM                                    00001010
C     FORTRAN DABS,DMAX1,DCMPLX,DCONJG,MAX0,MIN0                        00001020
C                                                                       00001030
C     INTERNAL VARIABLES                                                00001040
C                                                                       00001050
      COMPLEX*16 ZDOTC,EK,T,WK,WKM                                      00001060
      DOUBLE PRECISION ANORM,S,DZASUM,SM,YNORM                          00001070
      INTEGER I,J,J2,K,KB,KP1,L,LA,LB,LM,MU                             00001080
C                                                                       00001090
      COMPLEX*16 ZDUM,ZDUM2,CSIGN1                                      00001100
      DOUBLE PRECISION CABS1                                            00001110
      DOUBLE PRECISION DREAL,DIMAG                                      00001120
      COMPLEX*16 ZDUMR,ZDUMI                                            00001130
      DREAL(ZDUMR) = ZDUMR                                              00001140
      DIMAG(ZDUMI) = (0.0D0,-1.0D0)*ZDUMI                               00001150
      CABS1(ZDUM) = DABS(DREAL(ZDUM)) + DABS(DIMAG(ZDUM))               00001160
      CSIGN1(ZDUM,ZDUM2) = CABS1(ZDUM)*(ZDUM2/CABS1(ZDUM2))             00001170
C                                                                       00001180
C     FIND NORM OF A                                                    00001190
C                                                                       00001200
      DO 30 J = 1, N                                                    00001210
         L = MIN0(J,M+1)                                                00001220
         MU = MAX0(M+2-J,1)                                             00001230
         Z(J) = DCMPLX(DZASUM(L,ABD(MU,J),1),0.0D0)                     00001240
         K = J - L                                                      00001250
         IF (M .LT. MU) GO TO 20                                        00001260
         DO 10 I = MU, M                                                00001270
            K = K + 1                                                   00001280
            Z(K) = DCMPLX(DREAL(Z(K))+CABS1(ABD(I,J)),0.0D0)            00001290
   10    CONTINUE                                                       00001300
   20    CONTINUE                                                       00001310
   30 CONTINUE                                                          00001320
      ANORM = 0.0D0                                                     00001330
      DO 40 J = 1, N                                                    00001340
         ANORM = DMAX1(ANORM,DREAL(Z(J)))                               00001350
   40 CONTINUE                                                          00001360
C                                                                       00001370
C     FACTOR                                                            00001380
C                                                                       00001390
      CALL ZPBFA(ABD,LDA,N,M,INFO)                                      00001400
      IF (INFO .NE. 0) GO TO 180                                        00001410
C                                                                       00001420
C        RCOND = 1/(NORM(A)*(ESTIMATE OF NORM(INVERSE(A)))) .           00001430
C        ESTIMATE = NORM(Z)/NORM(Y) WHERE  A*Z = Y  AND  A*Y = E .      00001440
C        THE COMPONENTS OF  E  ARE CHOSEN TO CAUSE MAXIMUM LOCAL        00001450
C        GROWTH IN THE ELEMENTS OF W  WHERE  CTRANS(R)*W = E .          00001460
C        THE VECTORS ARE FREQUENTLY RESCALED TO AVOID OVERFLOW.         00001470
C                                                                       00001480
C        SOLVE CTRANS(R)*W = E                                          00001490
C                                                                       00001500
         EK = (1.0D0,0.0D0)                                             00001510
         DO 50 J = 1, N                                                 00001520
            Z(J) = (0.0D0,0.0D0)                                        00001530
   50    CONTINUE                                                       00001540
         DO 110 K = 1, N                                                00001550
            IF (CABS1(Z(K)) .NE. 0.0D0) EK = CSIGN1(EK,-Z(K))           00001560
            IF (CABS1(EK-Z(K)) .LE. DREAL(ABD(M+1,K))) GO TO 60         00001570
               S = DREAL(ABD(M+1,K))/CABS1(EK-Z(K))                     00001580
               CALL ZDSCAL(N,S,Z,1)                                     00001590
               EK = DCMPLX(S,0.0D0)*EK                                  00001600
   60       CONTINUE                                                    00001610
            WK = EK - Z(K)                                              00001620
            WKM = -EK - Z(K)                                            00001630
            S = CABS1(WK)                                               00001640
            SM = CABS1(WKM)                                             00001650
            WK = WK/ABD(M+1,K)                                          00001660
            WKM = WKM/ABD(M+1,K)                                        00001670
            KP1 = K + 1                                                 00001680
            J2 = MIN0(K+M,N)                                            00001690
            I = M + 1                                                   00001700
            IF (KP1 .GT. J2) GO TO 100                                  00001710
               DO 70 J = KP1, J2                                        00001720
                  I = I - 1                                             00001730
                  SM = SM + CABS1(Z(J)+WKM*DCONJG(ABD(I,J)))            00001740
                  Z(J) = Z(J) + WK*DCONJG(ABD(I,J))                     00001750
                  S = S + CABS1(Z(J))                                   00001760
   70          CONTINUE                                                 00001770
               IF (S .GE. SM) GO TO 90                                  00001780
                  T = WKM - WK                                          00001790
                  WK = WKM                                              00001800
                  I = M + 1                                             00001810
                  DO 80 J = KP1, J2                                     00001820
                     I = I - 1                                          00001830
                     Z(J) = Z(J) + T*DCONJG(ABD(I,J))                   00001840
   80             CONTINUE                                              00001850
   90          CONTINUE                                                 00001860
  100       CONTINUE                                                    00001870
            Z(K) = WK                                                   00001880
  110    CONTINUE                                                       00001890
         S = 1.0D0/DZASUM(N,Z,1)                                        00001900
         CALL ZDSCAL(N,S,Z,1)                                           00001910
C                                                                       00001920
C        SOLVE  R*Y = W                                                 00001930
C                                                                       00001940
         DO 130 KB = 1, N                                               00001950
            K = N + 1 - KB                                              00001960
            IF (CABS1(Z(K)) .LE. DREAL(ABD(M+1,K))) GO TO 120           00001970
               S = DREAL(ABD(M+1,K))/CABS1(Z(K))                        00001980
               CALL ZDSCAL(N,S,Z,1)                                     00001990
  120       CONTINUE                                                    00002000
            Z(K) = Z(K)/ABD(M+1,K)                                      00002010
            LM = MIN0(K-1,M)                                            00002020
            LA = M + 1 - LM                                             00002030
            LB = K - LM                                                 00002040
            T = -Z(K)                                                   00002050
            CALL ZAXPY(LM,T,ABD(LA,K),1,Z(LB),1)                        00002060
  130    CONTINUE                                                       00002070
         S = 1.0D0/DZASUM(N,Z,1)                                        00002080
         CALL ZDSCAL(N,S,Z,1)                                           00002090
C                                                                       00002100
         YNORM = 1.0D0                                                  00002110
C                                                                       00002120
C        SOLVE CTRANS(R)*V = Y                                          00002130
C                                                                       00002140
         DO 150 K = 1, N                                                00002150
            LM = MIN0(K-1,M)                                            00002160
            LA = M + 1 - LM                                             00002170
            LB = K - LM                                                 00002180
            Z(K) = Z(K) - ZDOTC(LM,ABD(LA,K),1,Z(LB),1)                 00002190
            IF (CABS1(Z(K)) .LE. DREAL(ABD(M+1,K))) GO TO 140           00002200
               S = DREAL(ABD(M+1,K))/CABS1(Z(K))                        00002210
               CALL ZDSCAL(N,S,Z,1)                                     00002220
               YNORM = S*YNORM                                          00002230
  140       CONTINUE                                                    00002240
            Z(K) = Z(K)/ABD(M+1,K)                                      00002250
  150    CONTINUE                                                       00002260
         S = 1.0D0/DZASUM(N,Z,1)                                        00002270
         CALL ZDSCAL(N,S,Z,1)                                           00002280
         YNORM = S*YNORM                                                00002290
C                                                                       00002300
C        SOLVE  R*Z = W                                                 00002310
C                                                                       00002320
         DO 170 KB = 1, N                                               00002330
            K = N + 1 - KB                                              00002340
            IF (CABS1(Z(K)) .LE. DREAL(ABD(M+1,K))) GO TO 160           00002350
               S = DREAL(ABD(M+1,K))/CABS1(Z(K))                        00002360
               CALL ZDSCAL(N,S,Z,1)                                     00002370
               YNORM = S*YNORM                                          00002380
  160       CONTINUE                                                    00002390
            Z(K) = Z(K)/ABD(M+1,K)                                      00002400
            LM = MIN0(K-1,M)                                            00002410
            LA = M + 1 - LM                                             00002420
            LB = K - LM                                                 00002430
            T = -Z(K)                                                   00002440
            CALL ZAXPY(LM,T,ABD(LA,K),1,Z(LB),1)                        00002450
  170    CONTINUE                                                       00002460
C        MAKE ZNORM = 1.0                                               00002470
         S = 1.0D0/DZASUM(N,Z,1)                                        00002480
         CALL ZDSCAL(N,S,Z,1)                                           00002490
         YNORM = S*YNORM                                                00002500
C                                                                       00002510
         IF (ANORM .NE. 0.0D0) RCOND = YNORM/ANORM                      00002520
         IF (ANORM .EQ. 0.0D0) RCOND = 0.0D0                            00002530
  180 CONTINUE                                                          00002540
      RETURN                                                            00002550
      END                                                               00002560
