*#**********************************************************************

      SUBROUTINE ZPPDI(AP,N,DET,JOB)                                    00000010

      INTEGER N,JOB                                                     00000020
      COMPLEX*16 AP(1)                                                  00000030
      DOUBLE PRECISION DET(2)                                           00000040
C                                                                       00000050
C     ZPPDI COMPUTES THE DETERMINANT AND INVERSE                        00000060
C     OF A COMPLEX*16 HERMITIAN POSITIVE DEFINITE MATRIX                00000070
C     USING THE FACTORS COMPUTED BY ZPPCO OR ZPPFA .                    00000080
C                                                                       00000090
C     ON ENTRY                                                          00000100
C                                                                       00000110
C        AP      COMPLEX*16 (N*(N+1)/2)                                 00000120
C                THE OUTPUT FROM ZPPCO OR ZPPFA.                        00000130
C                                                                       00000140
C        N       INTEGER                                                00000150
C                THE ORDER OF THE MATRIX  A .                           00000160
C                                                                       00000170
C        JOB     INTEGER                                                00000180
C                = 11   BOTH DETERMINANT AND INVERSE.                   00000190
C                = 01   INVERSE ONLY.                                   00000200
C                = 10   DETERMINANT ONLY.                               00000210
C                                                                       00000220
C     ON RETURN                                                         00000230
C                                                                       00000240
C        AP      THE UPPER TRIANGULAR HALF OF THE INVERSE .             00000250
C                THE STRICT LOWER TRIANGLE IS UNALTERED.                00000260
C                                                                       00000270
C        DET     DOUBLE PRECISION(2)                                    00000280
C                DETERMINANT OF ORIGINAL MATRIX IF REQUESTED.           00000290
C                OTHERWISE NOT REFERENCED.                              00000300
C                DETERMINANT = DET(1) * 10.0**DET(2)                    00000310
C                WITH  1.0 .LE. DET(1) .LT. 10.0                        00000320
C                OR  DET(1) .EQ. 0.0 .                                  00000330
C                                                                       00000340
C     ERROR CONDITION                                                   00000350
C                                                                       00000360
C        A DIVISION BY ZERO WILL OCCUR IF THE INPUT FACTOR CONTAINS     00000370
C        A ZERO ON THE DIAGONAL AND THE INVERSE IS REQUESTED.           00000380
C        IT WILL NOT OCCUR IF THE SUBROUTINES ARE CALLED CORRECTLY      00000390
C        AND IF ZPOCO OR ZPOFA HAS SET INFO .EQ. 0 .                    00000400
C                                                                       00000410
C     LINPACK.  THIS VERSION DATED 08/14/78 .                           00000420
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000430
C                                                                       00000440
C     SUBROUTINES AND FUNCTIONS                                         00000450
C                                                                       00000460
C     BLAS ZAXPY,ZSCAL                                                  00000470
C     FORTRAN DCONJG,MOD                                                00000480
C                                                                       00000490
C     INTERNAL VARIABLES                                                00000500
C                                                                       00000510
      COMPLEX*16 T                                                      00000520
      DOUBLE PRECISION S                                                00000530
      INTEGER I,II,J,JJ,JM1,J1,K,KJ,KK,KP1,K1                           00000540
      DOUBLE PRECISION DREAL                                            00000550
      COMPLEX*16 ZDUMR                                                  00000560
      DREAL(ZDUMR) = ZDUMR                                              00000570
C                                                                       00000580
C     COMPUTE DETERMINANT                                               00000590
C                                                                       00000600
      IF (JOB/10 .EQ. 0) GO TO 70                                       00000610
         DET(1) = 1.0D0                                                 00000620
         DET(2) = 0.0D0                                                 00000630
         S = 10.0D0                                                     00000640
         II = 0                                                         00000650
         DO 50 I = 1, N                                                 00000660
            II = II + I                                                 00000670
            DET(1) = DREAL(AP(II))**2*DET(1)                            00000680
C        ...EXIT                                                        00000690
            IF (DET(1) .EQ. 0.0D0) GO TO 60                             00000700
   10       IF (DET(1) .GE. 1.0D0) GO TO 20                             00000710
               DET(1) = S*DET(1)                                        00000720
               DET(2) = DET(2) - 1.0D0                                  00000730
            GO TO 10                                                    00000740
   20       CONTINUE                                                    00000750
   30       IF (DET(1) .LT. S) GO TO 40                                 00000760
               DET(1) = DET(1)/S                                        00000770
               DET(2) = DET(2) + 1.0D0                                  00000780
            GO TO 30                                                    00000790
   40       CONTINUE                                                    00000800
   50    CONTINUE                                                       00000810
   60    CONTINUE                                                       00000820
   70 CONTINUE                                                          00000830
C                                                                       00000840
C     COMPUTE INVERSE(R)                                                00000850
C                                                                       00000860
      IF (MOD(JOB,10) .EQ. 0) GO TO 140                                 00000870
         KK = 0                                                         00000880
         DO 100 K = 1, N                                                00000890
            K1 = KK + 1                                                 00000900
            KK = KK + K                                                 00000910
            AP(KK) = (1.0D0,0.0D0)/AP(KK)                               00000920
            T = -AP(KK)                                                 00000930
            CALL ZSCAL(K-1,T,AP(K1),1)                                  00000940
            KP1 = K + 1                                                 00000950
            J1 = KK + 1                                                 00000960
            KJ = KK + K                                                 00000970
            IF (N .LT. KP1) GO TO 90                                    00000980
            DO 80 J = KP1, N                                            00000990
               T = AP(KJ)                                               00001000
               AP(KJ) = (0.0D0,0.0D0)                                   00001010
               CALL ZAXPY(K,T,AP(K1),1,AP(J1),1)                        00001020
               J1 = J1 + J                                              00001030
               KJ = KJ + J                                              00001040
   80       CONTINUE                                                    00001050
   90       CONTINUE                                                    00001060
  100    CONTINUE                                                       00001070
C                                                                       00001080
C        FORM  INVERSE(R) * CTRANS(INVERSE(R))                          00001090
C                                                                       00001100
         JJ = 0                                                         00001110
         DO 130 J = 1, N                                                00001120
            J1 = JJ + 1                                                 00001130
            JJ = JJ + J                                                 00001140
            JM1 = J - 1                                                 00001150
            K1 = 1                                                      00001160
            KJ = J1                                                     00001170
            IF (JM1 .LT. 1) GO TO 120                                   00001180
            DO 110 K = 1, JM1                                           00001190
               T = DCONJG(AP(KJ))                                       00001200
               CALL ZAXPY(K,T,AP(J1),1,AP(K1),1)                        00001210
               K1 = K1 + K                                              00001220
               KJ = KJ + 1                                              00001230
  110       CONTINUE                                                    00001240
  120       CONTINUE                                                    00001250
            T = DCONJG(AP(JJ))                                          00001260
            CALL ZSCAL(J,T,AP(J1),1)                                    00001270
  130    CONTINUE                                                       00001280
  140 CONTINUE                                                          00001290
      RETURN                                                            00001300
      END                                                               00001310
