*#**********************************************************************

      SUBROUTINE ZPPFA(AP,N,INFO)                                       00000010

      INTEGER N,INFO                                                    00000020
      COMPLEX*16 AP(1)                                                  00000030
C                                                                       00000040
C     ZPPFA FACTORS A COMPLEX*16 HERMITIAN POSITIVE DEFINITE MATRIX     00000050
C     STORED IN PACKED FORM.                                            00000060
C                                                                       00000070
C     ZPPFA IS USUALLY CALLED BY ZPPCO, BUT IT CAN BE CALLED            00000080
C     DIRECTLY WITH A SAVING IN TIME IF  RCOND  IS NOT NEEDED.          00000090
C     (TIME FOR ZPPCO) = (1 + 18/N)*(TIME FOR ZPPFA) .                  00000100
C                                                                       00000110
C     ON ENTRY                                                          00000120
C                                                                       00000130
C        AP      COMPLEX*16 (N*(N+1)/2)                                 00000140
C                THE PACKED FORM OF A HERMITIAN MATRIX  A .  THE        00000150
C                COLUMNS OF THE UPPER TRIANGLE ARE STORED SEQUENTIALLY  00000160
C                IN A ONE-DIMENSIONAL ARRAY OF LENGTH  N*(N+1)/2 .      00000170
C                SEE COMMENTS BELOW FOR DETAILS.                        00000180
C                                                                       00000190
C        N       INTEGER                                                00000200
C                THE ORDER OF THE MATRIX  A .                           00000210
C                                                                       00000220
C     ON RETURN                                                         00000230
C                                                                       00000240
C        AP      AN UPPER TRIANGULAR MATRIX  R , STORED IN PACKED       00000250
C                FORM, SO THAT  A = CTRANS(R)*R .                       00000260
C                                                                       00000270
C        INFO    INTEGER                                                00000280
C                = 0  FOR NORMAL RETURN.                                00000290
C                = K  IF THE LEADING MINOR OF ORDER  K  IS NOT          00000300
C                     POSITIVE DEFINITE.                                00000310
C                                                                       00000320
C                                                                       00000330
C     PACKED STORAGE                                                    00000340
C                                                                       00000350
C          THE FOLLOWING PROGRAM SEGMENT WILL PACK THE UPPER            00000360
C          TRIANGLE OF A HERMITIAN MATRIX.                              00000370
C                                                                       00000380
C                K = 0                                                  00000390
C                DO 20 J = 1, N                                         00000400
C                   DO 10 I = 1, J                                      00000410
C                      K = K + 1                                        00000420
C                      AP(K) = A(I,J)                                   00000430
C             10    CONTINUE                                            00000440
C             20 CONTINUE                                               00000450
C                                                                       00000460
C     LINPACK.  THIS VERSION DATED 08/14/78 .                           00000470
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000480
C                                                                       00000490
C     SUBROUTINES AND FUNCTIONS                                         00000500
C                                                                       00000510
C     BLAS ZDOTC                                                        00000520
C     FORTRAN DCMPLX,DCONJG,DSQRT                                       00000530
C                                                                       00000540
C     INTERNAL VARIABLES                                                00000550
C                                                                       00000560
      COMPLEX*16 ZDOTC,T                                                00000570
      DOUBLE PRECISION S                                                00000580
      INTEGER J,JJ,JM1,K,KJ,KK                                          00000590
      DOUBLE PRECISION DREAL,DIMAG                                      00000600
      COMPLEX*16 ZDUMR,ZDUMI                                            00000610
      DREAL(ZDUMR) = ZDUMR                                              00000620
      DIMAG(ZDUMI) = (0.0D0,-1.0D0)*ZDUMI                               00000630
C     BEGIN BLOCK WITH ...EXITS TO 40                                   00000640
C                                                                       00000650
C                                                                       00000660
         JJ = 0                                                         00000670
         DO 30 J = 1, N                                                 00000680
            INFO = J                                                    00000690
            S = 0.0D0                                                   00000700
            JM1 = J - 1                                                 00000710
            KJ = JJ                                                     00000720
            KK = 0                                                      00000730
            IF (JM1 .LT. 1) GO TO 20                                    00000740
            DO 10 K = 1, JM1                                            00000750
               KJ = KJ + 1                                              00000760
               T = AP(KJ) - ZDOTC(K-1,AP(KK+1),1,AP(JJ+1),1)            00000770
               KK = KK + K                                              00000780
               T = T/AP(KK)                                             00000790
               AP(KJ) = T                                               00000800
               S = S + DREAL(T*DCONJG(T))                               00000810
   10       CONTINUE                                                    00000820
   20       CONTINUE                                                    00000830
            JJ = JJ + J                                                 00000840
            S = DREAL(AP(JJ)) - S                                       00000850
C     ......EXIT                                                        00000860
            IF (S .LE. 0.0D0 .OR. DIMAG(AP(JJ)) .NE. 0.0D0) GO TO 40    00000870
            AP(JJ) = DCMPLX(DSQRT(S),0.0D0)                             00000880
   30    CONTINUE                                                       00000890
         INFO = 0                                                       00000900
   40 CONTINUE                                                          00000910
      RETURN                                                            00000920
      END                                                               00000930
