*#**********************************************************************

      SUBROUTINE ZPPSL(AP,N,B)                                          00000010

      INTEGER N                                                         00000020
      COMPLEX*16 AP(1),B(1)                                             00000030
C                                                                       00000040
C     ZPPSL SOLVES THE COMPLEX*16 HERMITIAN POSITIVE DEFINITE SYSTEM    00000050
C     A * X = B                                                         00000060
C     USING THE FACTORS COMPUTED BY ZPPCO OR ZPPFA.                     00000070
C                                                                       00000080
C     ON ENTRY                                                          00000090
C                                                                       00000100
C        AP      COMPLEX*16 (N*(N+1)/2)                                 00000110
C                THE OUTPUT FROM ZPPCO OR ZPPFA.                        00000120
C                                                                       00000130
C        N       INTEGER                                                00000140
C                THE ORDER OF THE MATRIX  A .                           00000150
C                                                                       00000160
C        B       COMPLEX*16(N)                                          00000170
C                THE RIGHT HAND SIDE VECTOR.                            00000180
C                                                                       00000190
C     ON RETURN                                                         00000200
C                                                                       00000210
C        B       THE SOLUTION VECTOR  X .                               00000220
C                                                                       00000230
C     ERROR CONDITION                                                   00000240
C                                                                       00000250
C        A DIVISION BY ZERO WILL OCCUR IF THE INPUT FACTOR CONTAINS     00000260
C        A ZERO ON THE DIAGONAL.  TECHNICALLY THIS INDICATES            00000270
C        SINGULARITY BUT IT IS USUALLY CAUSED BY IMPROPER SUBROUTINE    00000280
C        ARGUMENTS.  IT WILL NOT OCCUR IF THE SUBROUTINES ARE CALLED    00000290
C        CORRECTLY AND  INFO .EQ. 0 .                                   00000300
C                                                                       00000310
C     TO COMPUTE  INVERSE(A) * C  WHERE  C  IS A MATRIX                 00000320
C     WITH  P  COLUMNS                                                  00000330
C           CALL ZPPCO(AP,N,RCOND,Z,INFO)                               00000340
C           IF (RCOND IS TOO SMALL .OR. INFO .NE. 0) GO TO ...          00000350
C           DO 10 J = 1, P                                              00000360
C              CALL ZPPSL(AP,N,C(1,J))                                  00000370
C        10 CONTINUE                                                    00000380
C                                                                       00000390
C     LINPACK.  THIS VERSION DATED 08/14/78 .                           00000400
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000410
C                                                                       00000420
C     SUBROUTINES AND FUNCTIONS                                         00000430
C                                                                       00000440
C     BLAS ZAXPY,ZDOTC                                                  00000450
C                                                                       00000460
C     INTERNAL VARIABLES                                                00000470
C                                                                       00000480
      COMPLEX*16 ZDOTC,T                                                00000490
      INTEGER K,KB,KK                                                   00000500
      DOUBLE PRECISION DREAL,DIMAG                                      00000510
      COMPLEX*16 ZDUMR,ZDUMI                                            00000520
      DREAL(ZDUMR) = ZDUMR                                              00000530
      DIMAG(ZDUMI) = (0.0D0,-1.0D0)*ZDUMI                               00000540
C                                                                       00000550
      KK = 0                                                            00000560
      DO 10 K = 1, N                                                    00000570
         T = ZDOTC(K-1,AP(KK+1),1,B(1),1)                               00000580
         KK = KK + K                                                    00000590
         B(K) = (B(K) - T)/AP(KK)                                       00000600
   10 CONTINUE                                                          00000610
      DO 20 KB = 1, N                                                   00000620
         K = N + 1 - KB                                                 00000630
         B(K) = B(K)/AP(KK)                                             00000640
         KK = KK - K                                                    00000650
         T = -B(K)                                                      00000660
         CALL ZAXPY(K-1,T,AP(KK+1),1,B(1),1)                            00000670
   20 CONTINUE                                                          00000680
      RETURN                                                            00000690
      END                                                               00000700
