*#**********************************************************************

      SUBROUTINE ZQRDC(X,LDX,N,P,QRAUX,JPVT,WORK,JOB)                   00000010

      INTEGER LDX,N,P,JOB                                               00000020
      INTEGER JPVT(1)                                                   00000030
      COMPLEX*16 X(LDX,1),QRAUX(1),WORK(1)                              00000040
C                                                                       00000050
C     ZQRDC USES HOUSEHOLDER TRANSFORMATIONS TO COMPUTE THE QR          00000060
C     FACTORIZATION OF AN N BY P MATRIX X.  COLUMN PIVOTING             00000070
C     BASED ON THE 2-NORMS OF THE REDUCED COLUMNS MAY BE                00000080
C     PERFORMED AT THE USERS OPTION.                                    00000090
C                                                                       00000100
C     ON ENTRY                                                          00000110
C                                                                       00000120
C        X       COMPLEX*16(LDX,P), WHERE LDX .GE. N.                   00000130
C                X CONTAINS THE MATRIX WHOSE DECOMPOSITION IS TO BE     00000140
C                COMPUTED.                                              00000150
C                                                                       00000160
C        LDX     INTEGER.                                               00000170
C                LDX IS THE LEADING DIMENSION OF THE ARRAY X.           00000180
C                                                                       00000190
C        N       INTEGER.                                               00000200
C                N IS THE NUMBER OF ROWS OF THE MATRIX X.               00000210
C                                                                       00000220
C        P       INTEGER.                                               00000230
C                P IS THE NUMBER OF COLUMNS OF THE MATRIX X.            00000240
C                                                                       00000250
C        JPVT    INTEGER(P).                                            00000260
C                JPVT CONTAINS INTEGERS THAT CONTROL THE SELECTION      00000270
C                OF THE PIVOT COLUMNS.  THE K-TH COLUMN X(K) OF X       00000280
C                IS PLACED IN ONE OF THREE CLASSES ACCORDING TO THE     00000290
C                VALUE OF JPVT(K).                                      00000300
C                                                                       00000310
C                   IF JPVT(K) .GT. 0, THEN X(K) IS AN INITIAL          00000320
C                                      COLUMN.                          00000330
C                                                                       00000340
C                   IF JPVT(K) .EQ. 0, THEN X(K) IS A FREE COLUMN.      00000350
C                                                                       00000360
C                   IF JPVT(K) .LT. 0, THEN X(K) IS A FINAL COLUMN.     00000370
C                                                                       00000380
C                BEFORE THE DECOMPOSITION IS COMPUTED, INITIAL COLUMNS  00000390
C                ARE MOVED TO THE BEGINNING OF THE ARRAY X AND FINAL    00000400
C                COLUMNS TO THE END.  BOTH INITIAL AND FINAL COLUMNS    00000410
C                ARE FROZEN IN PLACE DURING THE COMPUTATION AND ONLY    00000420
C                FREE COLUMNS ARE MOVED.  AT THE K-TH STAGE OF THE      00000430
C                REDUCTION, IF X(K) IS OCCUPIED BY A FREE COLUMN        00000440
C                IT IS INTERCHANGED WITH THE FREE COLUMN OF LARGEST     00000450
C                REDUCED NORM.  JPVT IS NOT REFERENCED IF               00000460
C                JOB .EQ. 0.                                            00000470
C                                                                       00000480
C        WORK    COMPLEX*16(P).                                         00000490
C                WORK IS A WORK ARRAY.  WORK IS NOT REFERENCED IF       00000500
C                JOB .EQ. 0.                                            00000510
C                                                                       00000520
C        JOB     INTEGER.                                               00000530
C                JOB IS AN INTEGER THAT INITIATES COLUMN PIVOTING.      00000540
C                IF JOB .EQ. 0, NO PIVOTING IS DONE.                    00000550
C                IF JOB .NE. 0, PIVOTING IS DONE.                       00000560
C                                                                       00000570
C     ON RETURN                                                         00000580
C                                                                       00000590
C        X       X CONTAINS IN ITS UPPER TRIANGLE THE UPPER             00000600
C                TRIANGULAR MATRIX R OF THE QR FACTORIZATION.           00000610
C                BELOW ITS DIAGONAL X CONTAINS INFORMATION FROM         00000620
C                WHICH THE UNITARY PART OF THE DECOMPOSITION            00000630
C                CAN BE RECOVERED.  NOTE THAT IF PIVOTING HAS           00000640
C                BEEN REQUESTED, THE DECOMPOSITION IS NOT THAT          00000650
C                OF THE ORIGINAL MATRIX X BUT THAT OF X                 00000660
C                WITH ITS COLUMNS PERMUTED AS DESCRIBED BY JPVT.        00000670
C                                                                       00000680
C        QRAUX   COMPLEX*16(P).                                         00000690
C                QRAUX CONTAINS FURTHER INFORMATION REQUIRED TO RECOVER 00000700
C                THE UNITARY PART OF THE DECOMPOSITION.                 00000710
C                                                                       00000720
C        JPVT    JPVT(K) CONTAINS THE INDEX OF THE COLUMN OF THE        00000730
C                ORIGINAL MATRIX THAT HAS BEEN INTERCHANGED INTO        00000740
C                THE K-TH COLUMN, IF PIVOTING WAS REQUESTED.            00000750
C                                                                       00000760
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000770
C     G.W. STEWART, UNIVERSITY OF MARYLAND, ARGONNE NATIONAL LAB.       00000780
C                                                                       00000790
C     ZQRDC USES THE FOLLOWING FUNCTIONS AND SUBPROGRAMS.               00000800
C                                                                       00000810
C     BLAS ZAXPY,ZDOTC,ZSCAL,ZSWAP,DZNRM2                               00000820
C     FORTRAN DABS,DMAX1,CDABS,DCMPLX,CDSQRT,MIN0                       00000830
C                                                                       00000840
C     INTERNAL VARIABLES                                                00000850
C                                                                       00000860
      INTEGER J,JP,L,LP1,LUP,MAXJ,PL,PU                                 00000870
      DOUBLE PRECISION MAXNRM,DZNRM2,TT                                 00000880
      COMPLEX*16 ZDOTC,NRMXL,T                                          00000890
      LOGICAL NEGJ,SWAPJ                                                00000900
C                                                                       00000910
      COMPLEX*16 CSIGN,ZDUM,ZDUM1,ZDUM2                                 00000920
      DOUBLE PRECISION CABS1                                            00000930
      DOUBLE PRECISION DREAL,DIMAG                                      00000940
      COMPLEX*16 ZDUMR,ZDUMI                                            00000950
      DREAL(ZDUMR) = ZDUMR                                              00000960
      DIMAG(ZDUMI) = (0.0D0,-1.0D0)*ZDUMI                               00000970
      CSIGN(ZDUM1,ZDUM2) = CDABS(ZDUM1)*(ZDUM2/CDABS(ZDUM2))            00000980
      CABS1(ZDUM) = DABS(DREAL(ZDUM)) + DABS(DIMAG(ZDUM))               00000990
C                                                                       00001000
      PL = 1                                                            00001010
      PU = 0                                                            00001020
      IF (JOB .EQ. 0) GO TO 60                                          00001030
C                                                                       00001040
C        PIVOTING HAS BEEN REQUESTED.  REARRANGE THE COLUMNS            00001050
C        ACCORDING TO JPVT.                                             00001060
C                                                                       00001070
         DO 20 J = 1, P                                                 00001080
            SWAPJ = JPVT(J) .GT. 0                                      00001090
            NEGJ = JPVT(J) .LT. 0                                       00001100
            JPVT(J) = J                                                 00001110
            IF (NEGJ) JPVT(J) = -J                                      00001120
            IF (.NOT.SWAPJ) GO TO 10                                    00001130
               IF (J .NE. PL) CALL ZSWAP(N,X(1,PL),1,X(1,J),1)          00001140
               JPVT(J) = JPVT(PL)                                       00001150
               JPVT(PL) = J                                             00001160
               PL = PL + 1                                              00001170
   10       CONTINUE                                                    00001180
   20    CONTINUE                                                       00001190
         PU = P                                                         00001200
         DO 50 JJ = 1, P                                                00001210
            J = P - JJ + 1                                              00001220
            IF (JPVT(J) .GE. 0) GO TO 40                                00001230
               JPVT(J) = -JPVT(J)                                       00001240
               IF (J .EQ. PU) GO TO 30                                  00001250
                  CALL ZSWAP(N,X(1,PU),1,X(1,J),1)                      00001260
                  JP = JPVT(PU)                                         00001270
                  JPVT(PU) = JPVT(J)                                    00001280
                  JPVT(J) = JP                                          00001290
   30          CONTINUE                                                 00001300
               PU = PU - 1                                              00001310
   40       CONTINUE                                                    00001320
   50    CONTINUE                                                       00001330
   60 CONTINUE                                                          00001340
C                                                                       00001350
C     COMPUTE THE NORMS OF THE FREE COLUMNS.                            00001360
C                                                                       00001370
      IF (PU .LT. PL) GO TO 80                                          00001380
      DO 70 J = PL, PU                                                  00001390
         QRAUX(J) = DCMPLX(DZNRM2(N,X(1,J),1),0.0D0)                    00001400
         WORK(J) = QRAUX(J)                                             00001410
   70 CONTINUE                                                          00001420
   80 CONTINUE                                                          00001430
C                                                                       00001440
C     PERFORM THE HOUSEHOLDER REDUCTION OF X.                           00001450
C                                                                       00001460
      LUP = MIN0(N,P)                                                   00001470
      DO 200 L = 1, LUP                                                 00001480
         IF (L .LT. PL .OR. L .GE. PU) GO TO 120                        00001490
C                                                                       00001500
C           LOCATE THE COLUMN OF LARGEST NORM AND BRING IT              00001510
C           INTO THE PIVOT POSITION.                                    00001520
C                                                                       00001530
            MAXNRM = 0.0D0                                              00001540
            MAXJ = L                                                    00001550
            DO 100 J = L, PU                                            00001560
               IF (DREAL(QRAUX(J)) .LE. MAXNRM) GO TO 90                00001570
                  MAXNRM = DREAL(QRAUX(J))                              00001580
                  MAXJ = J                                              00001590
   90          CONTINUE                                                 00001600
  100       CONTINUE                                                    00001610
            IF (MAXJ .EQ. L) GO TO 110                                  00001620
               CALL ZSWAP(N,X(1,L),1,X(1,MAXJ),1)                       00001630
               QRAUX(MAXJ) = QRAUX(L)                                   00001640
               WORK(MAXJ) = WORK(L)                                     00001650
               JP = JPVT(MAXJ)                                          00001660
               JPVT(MAXJ) = JPVT(L)                                     00001670
               JPVT(L) = JP                                             00001680
  110       CONTINUE                                                    00001690
  120    CONTINUE                                                       00001700
         QRAUX(L) = (0.0D0,0.0D0)                                       00001710
         IF (L .EQ. N) GO TO 190                                        00001720
C                                                                       00001730
C           COMPUTE THE HOUSEHOLDER TRANSFORMATION FOR COLUMN L.        00001740
C                                                                       00001750
            NRMXL = DCMPLX(DZNRM2(N-L+1,X(L,L),1),0.0D0)                00001760
            IF (CABS1(NRMXL) .EQ. 0.0D0) GO TO 180                      00001770
               IF (CABS1(X(L,L)) .NE. 0.0D0)                            00001780
     *            NRMXL = CSIGN(NRMXL,X(L,L))                           00001790
               CALL ZSCAL(N-L+1,(1.0D0,0.0D0)/NRMXL,X(L,L),1)           00001800
               X(L,L) = (1.0D0,0.0D0) + X(L,L)                          00001810
C                                                                       00001820
C              APPLY THE TRANSFORMATION TO THE REMAINING COLUMNS,       00001830
C              UPDATING THE NORMS.                                      00001840
C                                                                       00001850
               LP1 = L + 1                                              00001860
               IF (P .LT. LP1) GO TO 170                                00001870
               DO 160 J = LP1, P                                        00001880
                  T = -ZDOTC(N-L+1,X(L,L),1,X(L,J),1)/X(L,L)            00001890
                  CALL ZAXPY(N-L+1,T,X(L,L),1,X(L,J),1)                 00001900
                  IF (J .LT. PL .OR. J .GT. PU) GO TO 150               00001910
                  IF (CABS1(QRAUX(J)) .EQ. 0.0D0) GO TO 150             00001920
                     TT = 1.0D0 - (CDABS(X(L,J))/DREAL(QRAUX(J)))**2    00001930
                     TT = DMAX1(TT,0.0D0)                               00001940
                     T = DCMPLX(TT,0.0D0)                               00001950
                     TT = 1.0D0                                         00001960
     *                    + 0.05D0*TT                                   00001970
     *                      *(DREAL(QRAUX(J))/DREAL(WORK(J)))**2        00001980
                     IF (TT .EQ. 1.0D0) GO TO 130                       00001990
                        QRAUX(J) = QRAUX(J)*CDSQRT(T)                   00002000
                     GO TO 140                                          00002010
  130                CONTINUE                                           00002020
                        QRAUX(J) = DCMPLX(DZNRM2(N-L,X(L+1,J),1),0.0D0) 00002030
                        WORK(J) = QRAUX(J)                              00002040
  140                CONTINUE                                           00002050
  150             CONTINUE                                              00002060
  160          CONTINUE                                                 00002070
  170          CONTINUE                                                 00002080
C                                                                       00002090
C              SAVE THE TRANSFORMATION.                                 00002100
C                                                                       00002110
               QRAUX(L) = X(L,L)                                        00002120
               X(L,L) = -NRMXL                                          00002130
  180       CONTINUE                                                    00002140
  190    CONTINUE                                                       00002150
  200 CONTINUE                                                          00002160
      RETURN                                                            00002170
      END                                                               00002180
