*#**********************************************************************

      SUBROUTINE ZQRSL(X,LDX,N,K,QRAUX,Y,QY,QTY,B,RSD,XB,JOB,INFO)      00000010

      INTEGER LDX,N,K,JOB,INFO                                          00000020
      COMPLEX*16 X(LDX,1),QRAUX(1),Y(1),QY(1),QTY(1),B(1),RSD(1),XB(1)  00000030
C                                                                       00000040
C     ZQRSL APPLIES THE OUTPUT OF ZQRDC TO COMPUTE COORDINATE           00000050
C     TRANSFORMATIONS, PROJECTIONS, AND LEAST SQUARES SOLUTIONS.        00000060
C     FOR K .LE. MIN(N,P), LET XK BE THE MATRIX                         00000070
C                                                                       00000080
C            XK = (X(JPVT(1)),X(JPVT(2)), ... ,X(JPVT(K)))              00000090
C                                                                       00000100
C     FORMED FROM COLUMNNS JPVT(1), ... ,JPVT(K) OF THE ORIGINAL        00000110
C     N X P MATRIX X THAT WAS INPUT TO ZQRDC (IF NO PIVOTING WAS        00000120
C     DONE, XK CONSISTS OF THE FIRST K COLUMNS OF X IN THEIR            00000130
C     ORIGINAL ORDER).  ZQRDC PRODUCES A FACTORED UNITARY MATRIX Q      00000140
C     AND AN UPPER TRIANGULAR MATRIX R SUCH THAT                        00000150
C                                                                       00000160
C              XK = Q * (R)                                             00000170
C                       (0)                                             00000180
C                                                                       00000190
C     THIS INFORMATION IS CONTAINED IN CODED FORM IN THE ARRAYS         00000200
C     X AND QRAUX.                                                      00000210
C                                                                       00000220
C     ON ENTRY                                                          00000230
C                                                                       00000240
C        X      COMPLEX*16(LDX,P).                                      00000250
C               X CONTAINS THE OUTPUT OF ZQRDC.                         00000260
C                                                                       00000270
C        LDX    INTEGER.                                                00000280
C               LDX IS THE LEADING DIMENSION OF THE ARRAY X.            00000290
C                                                                       00000300
C        N      INTEGER.                                                00000310
C               N IS THE NUMBER OF ROWS OF THE MATRIX XK.  IT MUST      00000320
C               HAVE THE SAME VALUE AS N IN ZQRDC.                      00000330
C                                                                       00000340
C        K      INTEGER.                                                00000350
C               K IS THE NUMBER OF COLUMNS OF THE MATRIX XK.  K         00000360
C               MUST NNOT BE GREATER THAN MIN(N,P), WHERE P IS THE      00000370
C               SAME AS IN THE CALLING SEQUENCE TO ZQRDC.               00000380
C                                                                       00000390
C        QRAUX  COMPLEX*16(P).                                          00000400
C               QRAUX CONTAINS THE AUXILIARY OUTPUT FROM ZQRDC.         00000410
C                                                                       00000420
C        Y      COMPLEX*16(N)                                           00000430
C               Y CONTAINS AN N-VECTOR THAT IS TO BE MANIPULATED        00000440
C               BY ZQRSL.                                               00000450
C                                                                       00000460
C        JOB    INTEGER.                                                00000470
C               JOB SPECIFIES WHAT IS TO BE COMPUTED.  JOB HAS          00000480
C               THE DECIMAL EXPANSION ABCDE, WITH THE FOLLOWING         00000490
C               MEANING.                                                00000500
C                                                                       00000510
C                    IF A.NE.0, COMPUTE QY.                             00000520
C                    IF B,C,D, OR E .NE. 0, COMPUTE QTY.                00000530
C                    IF C.NE.0, COMPUTE B.                              00000540
C                    IF D.NE.0, COMPUTE RSD.                            00000550
C                    IF E.NE.0, COMPUTE XB.                             00000560
C                                                                       00000570
C               NOTE THAT A REQUEST TO COMPUTE B, RSD, OR XB            00000580
C               AUTOMATICALLY TRIGGERS THE COMPUTATION OF QTY, FOR      00000590
C               WHICH AN ARRAY MUST BE PROVIDED IN THE CALLING          00000600
C               SEQUENCE.                                               00000610
C                                                                       00000620
C     ON RETURN                                                         00000630
C                                                                       00000640
C        QY     COMPLEX*16(N).                                          00000650
C               QY CONNTAINS Q*Y, IF ITS COMPUTATION HAS BEEN           00000660
C               REQUESTED.                                              00000670
C                                                                       00000680
C        QTY    COMPLEX*16(N).                                          00000690
C               QTY CONTAINS CTRANS(Q)*Y, IF ITS COMPUTATION HAS        00000700
C               BEEN REQUESTED.  HERE CTRANS(Q) IS THE CONJUGATE        00000710
C               TRANSPOSE OF THE MATRIX Q.                              00000720
C                                                                       00000730
C        B      COMPLEX*16(K)                                           00000740
C               B CONTAINS THE SOLUTION OF THE LEAST SQUARES PROBLEM    00000750
C                                                                       00000760
C                    MINIMIZE NORM2(Y - XK*B),                          00000770
C                                                                       00000780
C               IF ITS COMPUTATION HAS BEEN REQUESTED.  (NOTE THAT      00000790
C               IF PIVOTING WAS REQUESTED IN ZQRDC, THE J-TH            00000800
C               COMPONENT OF B WILL BE ASSOCIATED WITH COLUMN JPVT(J)   00000810
C               OF THE ORIGINAL MATRIX X THAT WAS INPUT INTO ZQRDC.)    00000820
C                                                                       00000830
C        RSD    COMPLEX*16(N).                                          00000840
C               RSD CONTAINS THE LEAST SQUARES RESIDUAL Y - XK*B,       00000850
C               IF ITS COMPUTATION HAS BEEN REQUESTED.  RSD IS          00000860
C               ALSO THE ORTHOGONAL PROJECTION OF Y ONTO THE            00000870
C               ORTHOGONAL COMPLEMENT OF THE COLUMN SPACE OF XK.        00000880
C                                                                       00000890
C        XB     COMPLEX*16(N).                                          00000900
C               XB CONTAINS THE LEAST SQUARES APPROXIMATION XK*B,       00000910
C               IF ITS COMPUTATION HAS BEEN REQUESTED.  XB IS ALSO      00000920
C               THE ORTHOGONAL PROJECTION OF Y ONTO THE COLUMN SPACE    00000930
C               OF X.                                                   00000940
C                                                                       00000950
C        INFO   INTEGER.                                                00000960
C               INFO IS ZERO UNLESS THE COMPUTATION OF B HAS            00000970
C               BEEN REQUESTED AND R IS EXACTLY SINGULAR.  IN           00000980
C               THIS CASE, INFO IS THE INDEX OF THE FIRST ZERO          00000990
C               DIAGONAL ELEMENT OF R AND B IS LEFT UNALTERED.          00001000
C                                                                       00001010
C     THE PARAMETERS QY, QTY, B, RSD, AND XB ARE NOT REFERENCED         00001020
C     IF THEIR COMPUTATION IS NOT REQUESTED AND IN THIS CASE            00001030
C     CAN BE REPLACED BY DUMMY VARIABLES IN THE CALLING PROGRAM.        00001040
C     TO SAVE STORAGE, THE USER MAY IN SOME CASES USE THE SAME          00001050
C     ARRAY FOR DIFFERENT PARAMETERS IN THE CALLING SEQUENCE.  A        00001060
C     FREQUENTLY OCCURING EXAMPLE IS WHEN ONE WISHES TO COMPUTE         00001070
C     ANY OF B, RSD, OR XB AND DOES NOT NEED Y OR QTY.  IN THIS         00001080
C     CASE ONE MAY IDENTIFY Y, QTY, AND ONE OF B, RSD, OR XB, WHILE     00001090
C     PROVIDING SEPARATE ARRAYS FOR ANYTHING ELSE THAT IS TO BE         00001100
C     COMPUTED.  THUS THE CALLING SEQUENCE                              00001110
C                                                                       00001120
C          CALL ZQRSL(X,LDX,N,K,QRAUX,Y,DUM,Y,B,Y,DUM,110,INFO)         00001130
C                                                                       00001140
C     WILL RESULT IN THE COMPUTATION OF B AND RSD, WITH RSD             00001150
C     OVERWRITING Y.  MORE GENERALLY, EACH ITEM IN THE FOLLOWING        00001160
C     LIST CONTAINS GROUPS OF PERMISSIBLE IDENTIFICATIONS FOR           00001170
C     A SINGLE CALLINNG SEQUENCE.                                       00001180
C                                                                       00001190
C          1. (Y,QTY,B) (RSD) (XB) (QY)                                 00001200
C                                                                       00001210
C          2. (Y,QTY,RSD) (B) (XB) (QY)                                 00001220
C                                                                       00001230
C          3. (Y,QTY,XB) (B) (RSD) (QY)                                 00001240
C                                                                       00001250
C          4. (Y,QY) (QTY,B) (RSD) (XB)                                 00001260
C                                                                       00001270
C          5. (Y,QY) (QTY,RSD) (B) (XB)                                 00001280
C                                                                       00001290
C          6. (Y,QY) (QTY,XB) (B) (RSD)                                 00001300
C                                                                       00001310
C     IN ANY GROUP THE VALUE RETURNED IN THE ARRAY ALLOCATED TO         00001320
C     THE GROUP CORRESPONDS TO THE LAST MEMBER OF THE GROUP.            00001330
C                                                                       00001340
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00001350
C     G.W. STEWART, UNIVERSITY OF MARYLAND, ARGONNE NATIONAL LAB.       00001360
C                                                                       00001370
C     ZQRSL USES THE FOLLOWING FUNCTIONS AND SUBPROGRAMS.               00001380
C                                                                       00001390
C     BLAS ZAXPY,ZCOPY,ZDOTC                                            00001400
C     FORTRAN DABS,MIN0,MOD                                             00001410
C                                                                       00001420
C     INTERNAL VARIABLES                                                00001430
C                                                                       00001440
      INTEGER I,J,JJ,JU,KP1                                             00001450
      COMPLEX*16 ZDOTC,T,TEMP                                           00001460
      LOGICAL CB,CQY,CQTY,CR,CXB                                        00001470
C                                                                       00001480
      COMPLEX*16 ZDUM                                                   00001490
      DOUBLE PRECISION CABS1                                            00001500
      DOUBLE PRECISION DREAL,DIMAG                                      00001510
      COMPLEX*16 ZDUMR,ZDUMI                                            00001520
      DREAL(ZDUMR) = ZDUMR                                              00001530
      DIMAG(ZDUMI) = (0.0D0,-1.0D0)*ZDUMI                               00001540
      CABS1(ZDUM) = DABS(DREAL(ZDUM)) + DABS(DIMAG(ZDUM))               00001550
C                                                                       00001560
C     SET INFO FLAG.                                                    00001570
C                                                                       00001580
      INFO = 0                                                          00001590
C                                                                       00001600
C     DETERMINE WHAT IS TO BE COMPUTED.                                 00001610
C                                                                       00001620
      CQY = JOB/10000 .NE. 0                                            00001630
      CQTY = MOD(JOB,10000) .NE. 0                                      00001640
      CB = MOD(JOB,1000)/100 .NE. 0                                     00001650
      CR = MOD(JOB,100)/10 .NE. 0                                       00001660
      CXB = MOD(JOB,10) .NE. 0                                          00001670
      JU = MIN0(K,N-1)                                                  00001680
C                                                                       00001690
C     SPECIAL ACTION WHEN N=1.                                          00001700
C                                                                       00001710
      IF (JU .NE. 0) GO TO 40                                           00001720
         IF (CQY) QY(1) = Y(1)                                          00001730
         IF (CQTY) QTY(1) = Y(1)                                        00001740
         IF (CXB) XB(1) = Y(1)                                          00001750
         IF (.NOT.CB) GO TO 30                                          00001760
            IF (CABS1(X(1,1)) .NE. 0.0D0) GO TO 10                      00001770
               INFO = 1                                                 00001780
            GO TO 20                                                    00001790
   10       CONTINUE                                                    00001800
               B(1) = Y(1)/X(1,1)                                       00001810
   20       CONTINUE                                                    00001820
   30    CONTINUE                                                       00001830
         IF (CR) RSD(1) = (0.0D0,0.0D0)                                 00001840
      GO TO 250                                                         00001850
   40 CONTINUE                                                          00001860
C                                                                       00001870
C        SET UP TO COMPUTE QY OR QTY.                                   00001880
C                                                                       00001890
         IF (CQY) CALL ZCOPY(N,Y,1,QY,1)                                00001900
         IF (CQTY) CALL ZCOPY(N,Y,1,QTY,1)                              00001910
         IF (.NOT.CQY) GO TO 70                                         00001920
C                                                                       00001930
C           COMPUTE QY.                                                 00001940
C                                                                       00001950
            DO 60 JJ = 1, JU                                            00001960
               J = JU - JJ + 1                                          00001970
               IF (CABS1(QRAUX(J)) .EQ. 0.0D0) GO TO 50                 00001980
                  TEMP = X(J,J)                                         00001990
                  X(J,J) = QRAUX(J)                                     00002000
                  T = -ZDOTC(N-J+1,X(J,J),1,QY(J),1)/X(J,J)             00002010
                  CALL ZAXPY(N-J+1,T,X(J,J),1,QY(J),1)                  00002020
                  X(J,J) = TEMP                                         00002030
   50          CONTINUE                                                 00002040
   60       CONTINUE                                                    00002050
   70    CONTINUE                                                       00002060
         IF (.NOT.CQTY) GO TO 100                                       00002070
C                                                                       00002080
C           COMPUTE CTRANS(Q)*Y.                                        00002090
C                                                                       00002100
            DO 90 J = 1, JU                                             00002110
               IF (CABS1(QRAUX(J)) .EQ. 0.0D0) GO TO 80                 00002120
                  TEMP = X(J,J)                                         00002130
                  X(J,J) = QRAUX(J)                                     00002140
                  T = -ZDOTC(N-J+1,X(J,J),1,QTY(J),1)/X(J,J)            00002150
                  CALL ZAXPY(N-J+1,T,X(J,J),1,QTY(J),1)                 00002160
                  X(J,J) = TEMP                                         00002170
   80          CONTINUE                                                 00002180
   90       CONTINUE                                                    00002190
  100    CONTINUE                                                       00002200
C                                                                       00002210
C        SET UP TO COMPUTE B, RSD, OR XB.                               00002220
C                                                                       00002230
         IF (CB) CALL ZCOPY(K,QTY,1,B,1)                                00002240
         KP1 = K + 1                                                    00002250
         IF (CXB) CALL ZCOPY(K,QTY,1,XB,1)                              00002260
         IF (CR .AND. K .LT. N) CALL ZCOPY(N-K,QTY(KP1),1,RSD(KP1),1)   00002270
         IF (.NOT.CXB .OR. KP1 .GT. N) GO TO 120                        00002280
            DO 110 I = KP1, N                                           00002290
               XB(I) = (0.0D0,0.0D0)                                    00002300
  110       CONTINUE                                                    00002310
  120    CONTINUE                                                       00002320
         IF (.NOT.CR) GO TO 140                                         00002330
            DO 130 I = 1, K                                             00002340
               RSD(I) = (0.0D0,0.0D0)                                   00002350
  130       CONTINUE                                                    00002360
  140    CONTINUE                                                       00002370
         IF (.NOT.CB) GO TO 190                                         00002380
C                                                                       00002390
C           COMPUTE B.                                                  00002400
C                                                                       00002410
            DO 170 JJ = 1, K                                            00002420
               J = K - JJ + 1                                           00002430
               IF (CABS1(X(J,J)) .NE. 0.0D0) GO TO 150                  00002440
                  INFO = J                                              00002450
C           ......EXIT                                                  00002460
                  GO TO 180                                             00002470
  150          CONTINUE                                                 00002480
               B(J) = B(J)/X(J,J)                                       00002490
               IF (J .EQ. 1) GO TO 160                                  00002500
                  T = -B(J)                                             00002510
                  CALL ZAXPY(J-1,T,X(1,J),1,B,1)                        00002520
  160          CONTINUE                                                 00002530
  170       CONTINUE                                                    00002540
  180       CONTINUE                                                    00002550
  190    CONTINUE                                                       00002560
         IF (.NOT.CR .AND. .NOT.CXB) GO TO 240                          00002570
C                                                                       00002580
C           COMPUTE RSD OR XB AS REQUIRED.                              00002590
C                                                                       00002600
            DO 230 JJ = 1, JU                                           00002610
               J = JU - JJ + 1                                          00002620
               IF (CABS1(QRAUX(J)) .EQ. 0.0D0) GO TO 220                00002630
                  TEMP = X(J,J)                                         00002640
                  X(J,J) = QRAUX(J)                                     00002650
                  IF (.NOT.CR) GO TO 200                                00002660
                     T = -ZDOTC(N-J+1,X(J,J),1,RSD(J),1)/X(J,J)         00002670
                     CALL ZAXPY(N-J+1,T,X(J,J),1,RSD(J),1)              00002680
  200             CONTINUE                                              00002690
                  IF (.NOT.CXB) GO TO 210                               00002700
                     T = -ZDOTC(N-J+1,X(J,J),1,XB(J),1)/X(J,J)          00002710
                     CALL ZAXPY(N-J+1,T,X(J,J),1,XB(J),1)               00002720
  210             CONTINUE                                              00002730
                  X(J,J) = TEMP                                         00002740
  220          CONTINUE                                                 00002750
  230       CONTINUE                                                    00002760
  240    CONTINUE                                                       00002770
  250 CONTINUE                                                          00002780
      RETURN                                                            00002790
      END                                                               00002800
