*#**********************************************************************

      SUBROUTINE ZSICO(A,LDA,N,KPVT,RCOND,Z)                            00000010

      INTEGER LDA,N,KPVT(1)                                             00000020
      COMPLEX*16 A(LDA,1),Z(1)                                          00000030
      DOUBLE PRECISION RCOND                                            00000040
C                                                                       00000050
C     ZSICO FACTORS A COMPLEX*16 SYMMETRIC MATRIX BY ELIMINATION WITH   00000060
C     SYMMETRIC PIVOTING AND ESTIMATES THE CONDITION OF THE MATRIX.     00000070
C                                                                       00000080
C     IF  RCOND  IS NOT NEEDED, ZSIFA IS SLIGHTLY FASTER.               00000090
C     TO SOLVE  A*X = B , FOLLOW ZSICO BY ZSISL.                        00000100
C     TO COMPUTE  INVERSE(A)*C , FOLLOW ZSICO BY ZSISL.                 00000110
C     TO COMPUTE  INVERSE(A) , FOLLOW ZSICO BY ZSIDI.                   00000120
C     TO COMPUTE  DETERMINANT(A) , FOLLOW ZSICO BY ZSIDI.               00000130
C                                                                       00000140
C     ON ENTRY                                                          00000150
C                                                                       00000160
C        A       COMPLEX*16(LDA, N)                                     00000170
C                THE SYMMETRIC MATRIX TO BE FACTORED.                   00000180
C                ONLY THE DIAGONAL AND UPPER TRIANGLE ARE USED.         00000190
C                                                                       00000200
C        LDA     INTEGER                                                00000210
C                THE LEADING DIMENSION OF THE ARRAY  A .                00000220
C                                                                       00000230
C        N       INTEGER                                                00000240
C                THE ORDER OF THE MATRIX  A .                           00000250
C                                                                       00000260
C     ON RETURN                                                         00000270
C                                                                       00000280
C        A       A BLOCK DIAGONAL MATRIX AND THE MULTIPLIERS WHICH      00000290
C                WERE USED TO OBTAIN IT.                                00000300
C                THE FACTORIZATION CAN BE WRITTEN  A = U*D*TRANS(U)     00000310
C                WHERE  U  IS A PRODUCT OF PERMUTATION AND UNIT         00000320
C                UPPER TRIANGULAR MATRICES , TRANS(U) IS THE            00000330
C                TRANSPOSE OF  U , AND  D  IS BLOCK DIAGONAL            00000340
C                WITH 1 BY 1 AND 2 BY 2 BLOCKS.                         00000350
C                                                                       00000360
C        KPVT    INTEGER(N)                                             00000370
C                AN INTEGER VECTOR OF PIVOT INDICES.                    00000380
C                                                                       00000390
C        RCOND   DOUBLE PRECISION                                       00000400
C                AN ESTIMATE OF THE RECIPROCAL CONDITION OF  A .        00000410
C                FOR THE SYSTEM  A*X = B , RELATIVE PERTURBATIONS       00000420
C                IN  A  AND  B  OF SIZE  EPSILON  MAY CAUSE             00000430
C                RELATIVE PERTURBATIONS IN  X  OF SIZE  EPSILON/RCOND . 00000440
C                IF  RCOND  IS SO SMALL THAT THE LOGICAL EXPRESSION     00000450
C                           1.0 + RCOND .EQ. 1.0                        00000460
C                IS TRUE, THEN  A  MAY BE SINGULAR TO WORKING           00000470
C                PRECISION.  IN PARTICULAR,  RCOND  IS ZERO  IF         00000480
C                EXACT SINGULARITY IS DETECTED OR THE ESTIMATE          00000490
C                UNDERFLOWS.                                            00000500
C                                                                       00000510
C        Z       COMPLEX*16(N)                                          00000520
C                A WORK VECTOR WHOSE CONTENTS ARE USUALLY UNIMPORTANT.  00000530
C                IF  A  IS CLOSE TO A SINGULAR MATRIX, THEN  Z  IS      00000540
C                AN APPROXIMATE NULL VECTOR IN THE SENSE THAT           00000550
C                NORM(A*Z) = RCOND*NORM(A)*NORM(Z) .                    00000560
C                                                                       00000570
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000580
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000590
C                                                                       00000600
C     SUBROUTINES AND FUNCTIONS                                         00000610
C                                                                       00000620
C     LINPACK ZSIFA                                                     00000630
C     BLAS ZAXPY,ZDOTU,ZDSCAL,DZASUM                                    00000640
C     FORTRAN DABS,DMAX1,DCMPLX,IABS                                    00000650
C                                                                       00000660
C     INTERNAL VARIABLES                                                00000670
C                                                                       00000680
      COMPLEX*16 AK,AKM1,BK,BKM1,ZDOTU,DENOM,EK,T                       00000690
      DOUBLE PRECISION ANORM,S,DZASUM,YNORM                             00000700
      INTEGER I,INFO,J,JM1,K,KP,KPS,KS                                  00000710
C                                                                       00000720
      COMPLEX*16 ZDUM,ZDUM2,CSIGN1                                      00000730
      DOUBLE PRECISION CABS1                                            00000740
      DOUBLE PRECISION DREAL,DIMAG                                      00000750
      COMPLEX*16 ZDUMR,ZDUMI                                            00000760
      DREAL(ZDUMR) = ZDUMR                                              00000770
      DIMAG(ZDUMI) = (0.0D0,-1.0D0)*ZDUMI                               00000780
      CABS1(ZDUM) = DABS(DREAL(ZDUM)) + DABS(DIMAG(ZDUM))               00000790
      CSIGN1(ZDUM,ZDUM2) = CABS1(ZDUM)*(ZDUM2/CABS1(ZDUM2))             00000800
C                                                                       00000810
C     FIND NORM OF A USING ONLY UPPER HALF                              00000820
C                                                                       00000830
      DO 30 J = 1, N                                                    00000840
         Z(J) = DCMPLX(DZASUM(J,A(1,J),1),0.0D0)                        00000850
         JM1 = J - 1                                                    00000860
         IF (JM1 .LT. 1) GO TO 20                                       00000870
         DO 10 I = 1, JM1                                               00000880
            Z(I) = DCMPLX(DREAL(Z(I))+CABS1(A(I,J)),0.0D0)              00000890
   10    CONTINUE                                                       00000900
   20    CONTINUE                                                       00000910
   30 CONTINUE                                                          00000920
      ANORM = 0.0D0                                                     00000930
      DO 40 J = 1, N                                                    00000940
         ANORM = DMAX1(ANORM,DREAL(Z(J)))                               00000950
   40 CONTINUE                                                          00000960
C                                                                       00000970
C     FACTOR                                                            00000980
C                                                                       00000990
      CALL ZSIFA(A,LDA,N,KPVT,INFO)                                     00001000
C                                                                       00001010
C     RCOND = 1/(NORM(A)*(ESTIMATE OF NORM(INVERSE(A)))) .              00001020
C     ESTIMATE = NORM(Z)/NORM(Y) WHERE  A*Z = Y  AND  A*Y = E .         00001030
C     THE COMPONENTS OF  E  ARE CHOSEN TO CAUSE MAXIMUM LOCAL           00001040
C     GROWTH IN THE ELEMENTS OF W  WHERE  U*D*W = E .                   00001050
C     THE VECTORS ARE FREQUENTLY RESCALED TO AVOID OVERFLOW.            00001060
C                                                                       00001070
C     SOLVE U*D*W = E                                                   00001080
C                                                                       00001090
      EK = (1.0D0,0.0D0)                                                00001100
      DO 50 J = 1, N                                                    00001110
         Z(J) = (0.0D0,0.0D0)                                           00001120
   50 CONTINUE                                                          00001130
      K = N                                                             00001140
   60 IF (K .EQ. 0) GO TO 120                                           00001150
         KS = 1                                                         00001160
         IF (KPVT(K) .LT. 0) KS = 2                                     00001170
         KP = IABS(KPVT(K))                                             00001180
         KPS = K + 1 - KS                                               00001190
         IF (KP .EQ. KPS) GO TO 70                                      00001200
            T = Z(KPS)                                                  00001210
            Z(KPS) = Z(KP)                                              00001220
            Z(KP) = T                                                   00001230
   70    CONTINUE                                                       00001240
         IF (CABS1(Z(K)) .NE. 0.0D0) EK = CSIGN1(EK,Z(K))               00001250
         Z(K) = Z(K) + EK                                               00001260
         CALL ZAXPY(K-KS,Z(K),A(1,K),1,Z(1),1)                          00001270
         IF (KS .EQ. 1) GO TO 80                                        00001280
            IF (CABS1(Z(K-1)) .NE. 0.0D0) EK = CSIGN1(EK,Z(K-1))        00001290
            Z(K-1) = Z(K-1) + EK                                        00001300
            CALL ZAXPY(K-KS,Z(K-1),A(1,K-1),1,Z(1),1)                   00001310
   80    CONTINUE                                                       00001320
         IF (KS .EQ. 2) GO TO 100                                       00001330
            IF (CABS1(Z(K)) .LE. CABS1(A(K,K))) GO TO 90                00001340
               S = CABS1(A(K,K))/CABS1(Z(K))                            00001350
               CALL ZDSCAL(N,S,Z,1)                                     00001360
               EK = DCMPLX(S,0.0D0)*EK                                  00001370
   90       CONTINUE                                                    00001380
            IF (CABS1(A(K,K)) .NE. 0.0D0) Z(K) = Z(K)/A(K,K)            00001390
            IF (CABS1(A(K,K)) .EQ. 0.0D0) Z(K) = (1.0D0,0.0D0)          00001400
         GO TO 110                                                      00001410
  100    CONTINUE                                                       00001420
            AK = A(K,K)/A(K-1,K)                                        00001430
            AKM1 = A(K-1,K-1)/A(K-1,K)                                  00001440
            BK = Z(K)/A(K-1,K)                                          00001450
            BKM1 = Z(K-1)/A(K-1,K)                                      00001460
            DENOM = AK*AKM1 - 1.0D0                                     00001470
            Z(K) = (AKM1*BK - BKM1)/DENOM                               00001480
            Z(K-1) = (AK*BKM1 - BK)/DENOM                               00001490
  110    CONTINUE                                                       00001500
         K = K - KS                                                     00001510
      GO TO 60                                                          00001520
  120 CONTINUE                                                          00001530
      S = 1.0D0/DZASUM(N,Z,1)                                           00001540
      CALL ZDSCAL(N,S,Z,1)                                              00001550
C                                                                       00001560
C     SOLVE TRANS(U)*Y = W                                              00001570
C                                                                       00001580
      K = 1                                                             00001590
  130 IF (K .GT. N) GO TO 160                                           00001600
         KS = 1                                                         00001610
         IF (KPVT(K) .LT. 0) KS = 2                                     00001620
         IF (K .EQ. 1) GO TO 150                                        00001630
            Z(K) = Z(K) + ZDOTU(K-1,A(1,K),1,Z(1),1)                    00001640
            IF (KS .EQ. 2)                                              00001650
     *         Z(K+1) = Z(K+1) + ZDOTU(K-1,A(1,K+1),1,Z(1),1)           00001660
            KP = IABS(KPVT(K))                                          00001670
            IF (KP .EQ. K) GO TO 140                                    00001680
               T = Z(K)                                                 00001690
               Z(K) = Z(KP)                                             00001700
               Z(KP) = T                                                00001710
  140       CONTINUE                                                    00001720
  150    CONTINUE                                                       00001730
         K = K + KS                                                     00001740
      GO TO 130                                                         00001750
  160 CONTINUE                                                          00001760
      S = 1.0D0/DZASUM(N,Z,1)                                           00001770
      CALL ZDSCAL(N,S,Z,1)                                              00001780
C                                                                       00001790
      YNORM = 1.0D0                                                     00001800
C                                                                       00001810
C     SOLVE U*D*V = Y                                                   00001820
C                                                                       00001830
      K = N                                                             00001840
  170 IF (K .EQ. 0) GO TO 230                                           00001850
         KS = 1                                                         00001860
         IF (KPVT(K) .LT. 0) KS = 2                                     00001870
         IF (K .EQ. KS) GO TO 190                                       00001880
            KP = IABS(KPVT(K))                                          00001890
            KPS = K + 1 - KS                                            00001900
            IF (KP .EQ. KPS) GO TO 180                                  00001910
               T = Z(KPS)                                               00001920
               Z(KPS) = Z(KP)                                           00001930
               Z(KP) = T                                                00001940
  180       CONTINUE                                                    00001950
            CALL ZAXPY(K-KS,Z(K),A(1,K),1,Z(1),1)                       00001960
            IF (KS .EQ. 2) CALL ZAXPY(K-KS,Z(K-1),A(1,K-1),1,Z(1),1)    00001970
  190    CONTINUE                                                       00001980
         IF (KS .EQ. 2) GO TO 210                                       00001990
            IF (CABS1(Z(K)) .LE. CABS1(A(K,K))) GO TO 200               00002000
               S = CABS1(A(K,K))/CABS1(Z(K))                            00002010
               CALL ZDSCAL(N,S,Z,1)                                     00002020
               YNORM = S*YNORM                                          00002030
  200       CONTINUE                                                    00002040
            IF (CABS1(A(K,K)) .NE. 0.0D0) Z(K) = Z(K)/A(K,K)            00002050
            IF (CABS1(A(K,K)) .EQ. 0.0D0) Z(K) = (1.0D0,0.0D0)          00002060
         GO TO 220                                                      00002070
  210    CONTINUE                                                       00002080
            AK = A(K,K)/A(K-1,K)                                        00002090
            AKM1 = A(K-1,K-1)/A(K-1,K)                                  00002100
            BK = Z(K)/A(K-1,K)                                          00002110
            BKM1 = Z(K-1)/A(K-1,K)                                      00002120
            DENOM = AK*AKM1 - 1.0D0                                     00002130
            Z(K) = (AKM1*BK - BKM1)/DENOM                               00002140
            Z(K-1) = (AK*BKM1 - BK)/DENOM                               00002150
  220    CONTINUE                                                       00002160
         K = K - KS                                                     00002170
      GO TO 170                                                         00002180
  230 CONTINUE                                                          00002190
      S = 1.0D0/DZASUM(N,Z,1)                                           00002200
      CALL ZDSCAL(N,S,Z,1)                                              00002210
      YNORM = S*YNORM                                                   00002220
C                                                                       00002230
C     SOLVE TRANS(U)*Z = V                                              00002240
C                                                                       00002250
      K = 1                                                             00002260
  240 IF (K .GT. N) GO TO 270                                           00002270
         KS = 1                                                         00002280
         IF (KPVT(K) .LT. 0) KS = 2                                     00002290
         IF (K .EQ. 1) GO TO 260                                        00002300
            Z(K) = Z(K) + ZDOTU(K-1,A(1,K),1,Z(1),1)                    00002310
            IF (KS .EQ. 2)                                              00002320
     *         Z(K+1) = Z(K+1) + ZDOTU(K-1,A(1,K+1),1,Z(1),1)           00002330
            KP = IABS(KPVT(K))                                          00002340
            IF (KP .EQ. K) GO TO 250                                    00002350
               T = Z(K)                                                 00002360
               Z(K) = Z(KP)                                             00002370
               Z(KP) = T                                                00002380
  250       CONTINUE                                                    00002390
  260    CONTINUE                                                       00002400
         K = K + KS                                                     00002410
      GO TO 240                                                         00002420
  270 CONTINUE                                                          00002430
C     MAKE ZNORM = 1.0                                                  00002440
      S = 1.0D0/DZASUM(N,Z,1)                                           00002450
      CALL ZDSCAL(N,S,Z,1)                                              00002460
      YNORM = S*YNORM                                                   00002470
C                                                                       00002480
      IF (ANORM .NE. 0.0D0) RCOND = YNORM/ANORM                         00002490
      IF (ANORM .EQ. 0.0D0) RCOND = 0.0D0                               00002500
      RETURN                                                            00002510
      END                                                               00002520
