*#**********************************************************************

      SUBROUTINE ZSIDI(A,LDA,N,KPVT,DET,WORK,JOB)                       00000010

      INTEGER LDA,N,JOB                                                 00000020
      COMPLEX*16 A(LDA,1),DET(2),WORK(1)                                00000030
      INTEGER KPVT(1)                                                   00000040
C                                                                       00000050
C     ZSIDI COMPUTES THE DETERMINANT AND INVERSE                        00000060
C     OF A COMPLEX*16 SYMMETRIC MATRIX USING THE FACTORS FROM ZSIFA.    00000070
C                                                                       00000080
C     ON ENTRY                                                          00000090
C                                                                       00000100
C        A       COMPLEX*16(LDA,N)                                      00000110
C                THE OUTPUT FROM ZSIFA.                                 00000120
C                                                                       00000130
C        LDA     INTEGER                                                00000140
C                THE LEADING DIMENSION OF THE ARRAY A.                  00000150
C                                                                       00000160
C        N       INTEGER                                                00000170
C                THE ORDER OF THE MATRIX A.                             00000180
C                                                                       00000190
C        KPVT    INTEGER(N)                                             00000200
C                THE PIVOT VECTOR FROM ZSIFA.                           00000210
C                                                                       00000220
C        WORK    COMPLEX*16(N)                                          00000230
C                WORK VECTOR.  CONTENTS DESTROYED.                      00000240
C                                                                       00000250
C        JOB     INTEGER                                                00000260
C                JOB HAS THE DECIMAL EXPANSION  AB  WHERE               00000270
C                   IF  B .NE. 0, THE INVERSE IS COMPUTED,              00000280
C                   IF  A .NE. 0, THE DETERMINANT IS COMPUTED,          00000290
C                                                                       00000300
C                FOR EXAMPLE, JOB = 11  GIVES BOTH.                     00000310
C                                                                       00000320
C     ON RETURN                                                         00000330
C                                                                       00000340
C        VARIABLES NOT REQUESTED BY JOB ARE NOT USED.                   00000350
C                                                                       00000360
C        A      CONTAINS THE UPPER TRIANGLE OF THE INVERSE OF           00000370
C               THE ORIGINAL MATRIX.  THE STRICT LOWER TRIANGLE         00000380
C               IS NEVER REFERENCED.                                    00000390
C                                                                       00000400
C        DET    COMPLEX*16(2)                                           00000410
C               DETERMINANT OF ORIGINAL MATRIX.                         00000420
C               DETERMINANT = DET(1) * 10.0**DET(2)                     00000430
C               WITH 1.0 .LE. DABS(DET(1)) .LT. 10.0                    00000440
C               OR DET(1) = 0.0.                                        00000450
C                                                                       00000460
C     ERROR CONDITION                                                   00000470
C                                                                       00000480
C        A DIVISION BY ZERO MAY OCCUR IF THE INVERSE IS REQUESTED       00000490
C        AND  ZSICO  HAS SET RCOND .EQ. 0.0                             00000500
C        OR  ZSIFA  HAS SET  INFO .NE. 0 .                              00000510
C                                                                       00000520
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000530
C     JAMES BUNCH, UNIV. CALIF. SAN DIEGO, ARGONNE NAT. LAB             00000540
C                                                                       00000550
C     SUBROUTINES AND FUNCTIONS                                         00000560
C                                                                       00000570
C     BLAS ZAXPY,ZCOPY,ZDOTU,ZSWAP                                      00000580
C     FORTRAN DABS,DCMPLX,IABS,MOD                                      00000590
C                                                                       00000600
C     INTERNAL VARIABLES.                                               00000610
C                                                                       00000620
      COMPLEX*16 AK,AKP1,AKKP1,ZDOTU,D,T,TEMP                           00000630
      DOUBLE PRECISION TEN                                              00000640
      INTEGER J,JB,K,KM1,KS,KSTEP                                       00000650
      LOGICAL NOINV,NODET                                               00000660
C                                                                       00000670
      COMPLEX*16 ZDUM                                                   00000680
      DOUBLE PRECISION CABS1                                            00000690
      DOUBLE PRECISION DREAL,DIMAG                                      00000700
      COMPLEX*16 ZDUMR,ZDUMI                                            00000710
      DREAL(ZDUMR) = ZDUMR                                              00000720
      DIMAG(ZDUMI) = (0.0D0,-1.0D0)*ZDUMI                               00000730
      CABS1(ZDUM) = DABS(DREAL(ZDUM)) + DABS(DIMAG(ZDUM))               00000740
C                                                                       00000750
      NOINV = MOD(JOB,10) .EQ. 0                                        00000760
      NODET = MOD(JOB,100)/10 .EQ. 0                                    00000770
C                                                                       00000780
      IF (NODET) GO TO 100                                              00000790
         DET(1) = (1.0D0,0.0D0)                                         00000800
         DET(2) = (0.0D0,0.0D0)                                         00000810
         TEN = 10.0D0                                                   00000820
         T = (0.0D0,0.0D0)                                              00000830
         DO 90 K = 1, N                                                 00000840
            D = A(K,K)                                                  00000850
C                                                                       00000860
C           CHECK IF 1 BY 1                                             00000870
C                                                                       00000880
            IF (KPVT(K) .GT. 0) GO TO 30                                00000890
C                                                                       00000900
C              2 BY 2 BLOCK                                             00000910
C              USE DET (D  T)  =  (D/T * C - T) * T                     00000920
C                      (T  C)                                           00000930
C              TO AVOID UNDERFLOW/OVERFLOW TROUBLES.                    00000940
C              TAKE TWO PASSES THROUGH SCALING.  USE  T  FOR FLAG.      00000950
C                                                                       00000960
               IF (CABS1(T) .NE. 0.0D0) GO TO 10                        00000970
                  T = A(K,K+1)                                          00000980
                  D = (D/T)*A(K+1,K+1) - T                              00000990
               GO TO 20                                                 00001000
   10          CONTINUE                                                 00001010
                  D = T                                                 00001020
                  T = (0.0D0,0.0D0)                                     00001030
   20          CONTINUE                                                 00001040
   30       CONTINUE                                                    00001050
C                                                                       00001060
            DET(1) = D*DET(1)                                           00001070
            IF (CABS1(DET(1)) .EQ. 0.0D0) GO TO 80                      00001080
   40          IF (CABS1(DET(1)) .GE. 1.0D0) GO TO 50                   00001090
                  DET(1) = DCMPLX(TEN,0.0D0)*DET(1)                     00001100
                  DET(2) = DET(2) - (1.0D0,0.0D0)                       00001110
               GO TO 40                                                 00001120
   50          CONTINUE                                                 00001130
   60          IF (CABS1(DET(1)) .LT. TEN) GO TO 70                     00001140
                  DET(1) = DET(1)/DCMPLX(TEN,0.0D0)                     00001150
                  DET(2) = DET(2) + (1.0D0,0.0D0)                       00001160
               GO TO 60                                                 00001170
   70          CONTINUE                                                 00001180
   80       CONTINUE                                                    00001190
   90    CONTINUE                                                       00001200
  100 CONTINUE                                                          00001210
C                                                                       00001220
C     COMPUTE INVERSE(A)                                                00001230
C                                                                       00001240
      IF (NOINV) GO TO 230                                              00001250
         K = 1                                                          00001260
  110    IF (K .GT. N) GO TO 220                                        00001270
            KM1 = K - 1                                                 00001280
            IF (KPVT(K) .LT. 0) GO TO 140                               00001290
C                                                                       00001300
C              1 BY 1                                                   00001310
C                                                                       00001320
               A(K,K) = (1.0D0,0.0D0)/A(K,K)                            00001330
               IF (KM1 .LT. 1) GO TO 130                                00001340
                  CALL ZCOPY(KM1,A(1,K),1,WORK,1)                       00001350
                  DO 120 J = 1, KM1                                     00001360
                     A(J,K) = ZDOTU(J,A(1,J),1,WORK,1)                  00001370
                     CALL ZAXPY(J-1,WORK(J),A(1,J),1,A(1,K),1)          00001380
  120             CONTINUE                                              00001390
                  A(K,K) = A(K,K) + ZDOTU(KM1,WORK,1,A(1,K),1)          00001400
  130          CONTINUE                                                 00001410
               KSTEP = 1                                                00001420
            GO TO 180                                                   00001430
  140       CONTINUE                                                    00001440
C                                                                       00001450
C              2 BY 2                                                   00001460
C                                                                       00001470
               T = A(K,K+1)                                             00001480
               AK = A(K,K)/T                                            00001490
               AKP1 = A(K+1,K+1)/T                                      00001500
               AKKP1 = A(K,K+1)/T                                       00001510
               D = T*(AK*AKP1 - (1.0D0,0.0D0))                          00001520
               A(K,K) = AKP1/D                                          00001530
               A(K+1,K+1) = AK/D                                        00001540
               A(K,K+1) = -AKKP1/D                                      00001550
               IF (KM1 .LT. 1) GO TO 170                                00001560
                  CALL ZCOPY(KM1,A(1,K+1),1,WORK,1)                     00001570
                  DO 150 J = 1, KM1                                     00001580
                     A(J,K+1) = ZDOTU(J,A(1,J),1,WORK,1)                00001590
                     CALL ZAXPY(J-1,WORK(J),A(1,J),1,A(1,K+1),1)        00001600
  150             CONTINUE                                              00001610
                  A(K+1,K+1) = A(K+1,K+1)                               00001620
     *                         + ZDOTU(KM1,WORK,1,A(1,K+1),1)           00001630
                  A(K,K+1) = A(K,K+1) + ZDOTU(KM1,A(1,K),1,A(1,K+1),1)  00001640
                  CALL ZCOPY(KM1,A(1,K),1,WORK,1)                       00001650
                  DO 160 J = 1, KM1                                     00001660
                     A(J,K) = ZDOTU(J,A(1,J),1,WORK,1)                  00001670
                     CALL ZAXPY(J-1,WORK(J),A(1,J),1,A(1,K),1)          00001680
  160             CONTINUE                                              00001690
                  A(K,K) = A(K,K) + ZDOTU(KM1,WORK,1,A(1,K),1)          00001700
  170          CONTINUE                                                 00001710
               KSTEP = 2                                                00001720
  180       CONTINUE                                                    00001730
C                                                                       00001740
C           SWAP                                                        00001750
C                                                                       00001760
            KS = IABS(KPVT(K))                                          00001770
            IF (KS .EQ. K) GO TO 210                                    00001780
               CALL ZSWAP(KS,A(1,KS),1,A(1,K),1)                        00001790
               DO 190 JB = KS, K                                        00001800
                  J = K + KS - JB                                       00001810
                  TEMP = A(J,K)                                         00001820
                  A(J,K) = A(KS,J)                                      00001830
                  A(KS,J) = TEMP                                        00001840
  190          CONTINUE                                                 00001850
               IF (KSTEP .EQ. 1) GO TO 200                              00001860
                  TEMP = A(KS,K+1)                                      00001870
                  A(KS,K+1) = A(K,K+1)                                  00001880
                  A(K,K+1) = TEMP                                       00001890
  200          CONTINUE                                                 00001900
  210       CONTINUE                                                    00001910
            K = K + KSTEP                                               00001920
         GO TO 110                                                      00001930
  220    CONTINUE                                                       00001940
  230 CONTINUE                                                          00001950
      RETURN                                                            00001960
      END                                                               00001970
