*#**********************************************************************

      SUBROUTINE ZSPCO(AP,N,KPVT,RCOND,Z)                               00000010

      INTEGER N,KPVT(1)                                                 00000020
      COMPLEX*16 AP(1),Z(1)                                             00000030
      DOUBLE PRECISION RCOND                                            00000040
C                                                                       00000050
C     ZSPCO FACTORS A COMPLEX*16 SYMMETRIC MATRIX STORED IN PACKED      00000060
C     FORM BY ELIMINATION WITH SYMMETRIC PIVOTING AND ESTIMATES         00000070
C     THE CONDITION OF THE MATRIX.                                      00000080
C                                                                       00000090
C     IF  RCOND  IS NOT NEEDED, ZSPFA IS SLIGHTLY FASTER.               00000100
C     TO SOLVE  A*X = B , FOLLOW ZSPCO BY ZSPSL.                        00000110
C     TO COMPUTE  INVERSE(A)*C , FOLLOW ZSPCO BY ZSPSL.                 00000120
C     TO COMPUTE  INVERSE(A) , FOLLOW ZSPCO BY ZSPDI.                   00000130
C     TO COMPUTE  DETERMINANT(A) , FOLLOW ZSPCO BY ZSPDI.               00000140
C                                                                       00000150
C     ON ENTRY                                                          00000160
C                                                                       00000170
C        AP      COMPLEX*16 (N*(N+1)/2)                                 00000180
C                THE PACKED FORM OF A SYMMETRIC MATRIX  A .  THE        00000190
C                COLUMNS OF THE UPPER TRIANGLE ARE STORED SEQUENTIALLY  00000200
C                IN A ONE-DIMENSIONAL ARRAY OF LENGTH  N*(N+1)/2 .      00000210
C                SEE COMMENTS BELOW FOR DETAILS.                        00000220
C                                                                       00000230
C        N       INTEGER                                                00000240
C                THE ORDER OF THE MATRIX  A .                           00000250
C                                                                       00000260
C     ON RETURN                                                         00000270
C                                                                       00000280
C        AP      A BLOCK DIAGONAL MATRIX AND THE MULTIPLIERS WHICH      00000290
C                WERE USED TO OBTAIN IT STORED IN PACKED FORM.          00000300
C                THE FACTORIZATION CAN BE WRITTEN  A = U*D*TRANS(U)     00000310
C                WHERE  U  IS A PRODUCT OF PERMUTATION AND UNIT         00000320
C                UPPER TRIANGULAR MATRICES , TRANS(U) IS THE            00000330
C                TRANSPOSE OF  U , AND  D  IS BLOCK DIAGONAL            00000340
C                WITH 1 BY 1 AND 2 BY 2 BLOCKS.                         00000350
C                                                                       00000360
C        KPVT    INTEGER(N)                                             00000370
C                AN INTEGER VECTOR OF PIVOT INDICES.                    00000380
C                                                                       00000390
C        RCOND   DOUBLE PRECISION                                       00000400
C                AN ESTIMATE OF THE RECIPROCAL CONDITION OF  A .        00000410
C                FOR THE SYSTEM  A*X = B , RELATIVE PERTURBATIONS       00000420
C                IN  A  AND  B  OF SIZE  EPSILON  MAY CAUSE             00000430
C                RELATIVE PERTURBATIONS IN  X  OF SIZE  EPSILON/RCOND . 00000440
C                IF  RCOND  IS SO SMALL THAT THE LOGICAL EXPRESSION     00000450
C                           1.0 + RCOND .EQ. 1.0                        00000460
C                IS TRUE, THEN  A  MAY BE SINGULAR TO WORKING           00000470
C                PRECISION.  IN PARTICULAR,  RCOND  IS ZERO  IF         00000480
C                EXACT SINGULARITY IS DETECTED OR THE ESTIMATE          00000490
C                UNDERFLOWS.                                            00000500
C                                                                       00000510
C        Z       COMPLEX*16(N)                                          00000520
C                A WORK VECTOR WHOSE CONTENTS ARE USUALLY UNIMPORTANT.  00000530
C                IF  A  IS CLOSE TO A SINGULAR MATRIX, THEN  Z  IS      00000540
C                AN APPROXIMATE NULL VECTOR IN THE SENSE THAT           00000550
C                NORM(A*Z) = RCOND*NORM(A)*NORM(Z) .                    00000560
C                                                                       00000570
C     PACKED STORAGE                                                    00000580
C                                                                       00000590
C          THE FOLLOWING PROGRAM SEGMENT WILL PACK THE UPPER            00000600
C          TRIANGLE OF A SYMMETRIC MATRIX.                              00000610
C                                                                       00000620
C                K = 0                                                  00000630
C                DO 20 J = 1, N                                         00000640
C                   DO 10 I = 1, J                                      00000650
C                      K = K + 1                                        00000660
C                      AP(K) = A(I,J)                                   00000670
C             10    CONTINUE                                            00000680
C             20 CONTINUE                                               00000690
C                                                                       00000700
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000710
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000720
C                                                                       00000730
C     SUBROUTINES AND FUNCTIONS                                         00000740
C                                                                       00000750
C     LINPACK ZSPFA                                                     00000760
C     BLAS ZAXPY,ZDOTU,ZDSCAL,DZASUM                                    00000770
C     FORTRAN DABS,DMAX1,DCMPLX,IABS                                    00000780
C                                                                       00000790
C     INTERNAL VARIABLES                                                00000800
C                                                                       00000810
      COMPLEX*16 AK,AKM1,BK,BKM1,ZDOTU,DENOM,EK,T                       00000820
      DOUBLE PRECISION ANORM,S,DZASUM,YNORM                             00000830
      INTEGER I,IJ,IK,IKM1,IKP1,INFO,J,JM1,J1                           00000840
      INTEGER K,KK,KM1K,KM1KM1,KP,KPS,KS                                00000850
C                                                                       00000860
      COMPLEX*16 ZDUM,ZDUM2,CSIGN1                                      00000870
      DOUBLE PRECISION CABS1                                            00000880
      DOUBLE PRECISION DREAL,DIMAG                                      00000890
      COMPLEX*16 ZDUMR,ZDUMI                                            00000900
      DREAL(ZDUMR) = ZDUMR                                              00000910
      DIMAG(ZDUMI) = (0.0D0,-1.0D0)*ZDUMI                               00000920
      CABS1(ZDUM) = DABS(DREAL(ZDUM)) + DABS(DIMAG(ZDUM))               00000930
      CSIGN1(ZDUM,ZDUM2) = CABS1(ZDUM)*(ZDUM2/CABS1(ZDUM2))             00000940
C                                                                       00000950
C     FIND NORM OF A USING ONLY UPPER HALF                              00000960
C                                                                       00000970
      J1 = 1                                                            00000980
      DO 30 J = 1, N                                                    00000990
         Z(J) = DCMPLX(DZASUM(J,AP(J1),1),0.0D0)                        00001000
         IJ = J1                                                        00001010
         J1 = J1 + J                                                    00001020
         JM1 = J - 1                                                    00001030
         IF (JM1 .LT. 1) GO TO 20                                       00001040
         DO 10 I = 1, JM1                                               00001050
            Z(I) = DCMPLX(DREAL(Z(I))+CABS1(AP(IJ)),0.0D0)              00001060
            IJ = IJ + 1                                                 00001070
   10    CONTINUE                                                       00001080
   20    CONTINUE                                                       00001090
   30 CONTINUE                                                          00001100
      ANORM = 0.0D0                                                     00001110
      DO 40 J = 1, N                                                    00001120
         ANORM = DMAX1(ANORM,DREAL(Z(J)))                               00001130
   40 CONTINUE                                                          00001140
C                                                                       00001150
C     FACTOR                                                            00001160
C                                                                       00001170
      CALL ZSPFA(AP,N,KPVT,INFO)                                        00001180
C                                                                       00001190
C     RCOND = 1/(NORM(A)*(ESTIMATE OF NORM(INVERSE(A)))) .              00001200
C     ESTIMATE = NORM(Z)/NORM(Y) WHERE  A*Z = Y  AND  A*Y = E .         00001210
C     THE COMPONENTS OF  E  ARE CHOSEN TO CAUSE MAXIMUM LOCAL           00001220
C     GROWTH IN THE ELEMENTS OF W  WHERE  U*D*W = E .                   00001230
C     THE VECTORS ARE FREQUENTLY RESCALED TO AVOID OVERFLOW.            00001240
C                                                                       00001250
C     SOLVE U*D*W = E                                                   00001260
C                                                                       00001270
      EK = (1.0D0,0.0D0)                                                00001280
      DO 50 J = 1, N                                                    00001290
         Z(J) = (0.0D0,0.0D0)                                           00001300
   50 CONTINUE                                                          00001310
      K = N                                                             00001320
      IK = (N*(N - 1))/2                                                00001330
   60 IF (K .EQ. 0) GO TO 120                                           00001340
         KK = IK + K                                                    00001350
         IKM1 = IK - (K - 1)                                            00001360
         KS = 1                                                         00001370
         IF (KPVT(K) .LT. 0) KS = 2                                     00001380
         KP = IABS(KPVT(K))                                             00001390
         KPS = K + 1 - KS                                               00001400
         IF (KP .EQ. KPS) GO TO 70                                      00001410
            T = Z(KPS)                                                  00001420
            Z(KPS) = Z(KP)                                              00001430
            Z(KP) = T                                                   00001440
   70    CONTINUE                                                       00001450
         IF (CABS1(Z(K)) .NE. 0.0D0) EK = CSIGN1(EK,Z(K))               00001460
         Z(K) = Z(K) + EK                                               00001470
         CALL ZAXPY(K-KS,Z(K),AP(IK+1),1,Z(1),1)                        00001480
         IF (KS .EQ. 1) GO TO 80                                        00001490
            IF (CABS1(Z(K-1)) .NE. 0.0D0) EK = CSIGN1(EK,Z(K-1))        00001500
            Z(K-1) = Z(K-1) + EK                                        00001510
            CALL ZAXPY(K-KS,Z(K-1),AP(IKM1+1),1,Z(1),1)                 00001520
   80    CONTINUE                                                       00001530
         IF (KS .EQ. 2) GO TO 100                                       00001540
            IF (CABS1(Z(K)) .LE. CABS1(AP(KK))) GO TO 90                00001550
               S = CABS1(AP(KK))/CABS1(Z(K))                            00001560
               CALL ZDSCAL(N,S,Z,1)                                     00001570
               EK = DCMPLX(S,0.0D0)*EK                                  00001580
   90       CONTINUE                                                    00001590
            IF (CABS1(AP(KK)) .NE. 0.0D0) Z(K) = Z(K)/AP(KK)            00001600
            IF (CABS1(AP(KK)) .EQ. 0.0D0) Z(K) = (1.0D0,0.0D0)          00001610
         GO TO 110                                                      00001620
  100    CONTINUE                                                       00001630
            KM1K = IK + K - 1                                           00001640
            KM1KM1 = IKM1 + K - 1                                       00001650
            AK = AP(KK)/AP(KM1K)                                        00001660
            AKM1 = AP(KM1KM1)/AP(KM1K)                                  00001670
            BK = Z(K)/AP(KM1K)                                          00001680
            BKM1 = Z(K-1)/AP(KM1K)                                      00001690
            DENOM = AK*AKM1 - 1.0D0                                     00001700
            Z(K) = (AKM1*BK - BKM1)/DENOM                               00001710
            Z(K-1) = (AK*BKM1 - BK)/DENOM                               00001720
  110    CONTINUE                                                       00001730
         K = K - KS                                                     00001740
         IK = IK - K                                                    00001750
         IF (KS .EQ. 2) IK = IK - (K + 1)                               00001760
      GO TO 60                                                          00001770
  120 CONTINUE                                                          00001780
      S = 1.0D0/DZASUM(N,Z,1)                                           00001790
      CALL ZDSCAL(N,S,Z,1)                                              00001800
C                                                                       00001810
C     SOLVE TRANS(U)*Y = W                                              00001820
C                                                                       00001830
      K = 1                                                             00001840
      IK = 0                                                            00001850
  130 IF (K .GT. N) GO TO 160                                           00001860
         KS = 1                                                         00001870
         IF (KPVT(K) .LT. 0) KS = 2                                     00001880
         IF (K .EQ. 1) GO TO 150                                        00001890
            Z(K) = Z(K) + ZDOTU(K-1,AP(IK+1),1,Z(1),1)                  00001900
            IKP1 = IK + K                                               00001910
            IF (KS .EQ. 2)                                              00001920
     *         Z(K+1) = Z(K+1) + ZDOTU(K-1,AP(IKP1+1),1,Z(1),1)         00001930
            KP = IABS(KPVT(K))                                          00001940
            IF (KP .EQ. K) GO TO 140                                    00001950
               T = Z(K)                                                 00001960
               Z(K) = Z(KP)                                             00001970
               Z(KP) = T                                                00001980
  140       CONTINUE                                                    00001990
  150    CONTINUE                                                       00002000
         IK = IK + K                                                    00002010
         IF (KS .EQ. 2) IK = IK + (K + 1)                               00002020
         K = K + KS                                                     00002030
      GO TO 130                                                         00002040
  160 CONTINUE                                                          00002050
      S = 1.0D0/DZASUM(N,Z,1)                                           00002060
      CALL ZDSCAL(N,S,Z,1)                                              00002070
C                                                                       00002080
      YNORM = 1.0D0                                                     00002090
C                                                                       00002100
C     SOLVE U*D*V = Y                                                   00002110
C                                                                       00002120
      K = N                                                             00002130
      IK = N*(N - 1)/2                                                  00002140
  170 IF (K .EQ. 0) GO TO 230                                           00002150
         KK = IK + K                                                    00002160
         IKM1 = IK - (K - 1)                                            00002170
         KS = 1                                                         00002180
         IF (KPVT(K) .LT. 0) KS = 2                                     00002190
         IF (K .EQ. KS) GO TO 190                                       00002200
            KP = IABS(KPVT(K))                                          00002210
            KPS = K + 1 - KS                                            00002220
            IF (KP .EQ. KPS) GO TO 180                                  00002230
               T = Z(KPS)                                               00002240
               Z(KPS) = Z(KP)                                           00002250
               Z(KP) = T                                                00002260
  180       CONTINUE                                                    00002270
            CALL ZAXPY(K-KS,Z(K),AP(IK+1),1,Z(1),1)                     00002280
            IF (KS .EQ. 2) CALL ZAXPY(K-KS,Z(K-1),AP(IKM1+1),1,Z(1),1)  00002290
  190    CONTINUE                                                       00002300
         IF (KS .EQ. 2) GO TO 210                                       00002310
            IF (CABS1(Z(K)) .LE. CABS1(AP(KK))) GO TO 200               00002320
               S = CABS1(AP(KK))/CABS1(Z(K))                            00002330
               CALL ZDSCAL(N,S,Z,1)                                     00002340
               YNORM = S*YNORM                                          00002350
  200       CONTINUE                                                    00002360
            IF (CABS1(AP(KK)) .NE. 0.0D0) Z(K) = Z(K)/AP(KK)            00002370
            IF (CABS1(AP(KK)) .EQ. 0.0D0) Z(K) = (1.0D0,0.0D0)          00002380
         GO TO 220                                                      00002390
  210    CONTINUE                                                       00002400
            KM1K = IK + K - 1                                           00002410
            KM1KM1 = IKM1 + K - 1                                       00002420
            AK = AP(KK)/AP(KM1K)                                        00002430
            AKM1 = AP(KM1KM1)/AP(KM1K)                                  00002440
            BK = Z(K)/AP(KM1K)                                          00002450
            BKM1 = Z(K-1)/AP(KM1K)                                      00002460
            DENOM = AK*AKM1 - 1.0D0                                     00002470
            Z(K) = (AKM1*BK - BKM1)/DENOM                               00002480
            Z(K-1) = (AK*BKM1 - BK)/DENOM                               00002490
  220    CONTINUE                                                       00002500
         K = K - KS                                                     00002510
         IK = IK - K                                                    00002520
         IF (KS .EQ. 2) IK = IK - (K + 1)                               00002530
      GO TO 170                                                         00002540
  230 CONTINUE                                                          00002550
      S = 1.0D0/DZASUM(N,Z,1)                                           00002560
      CALL ZDSCAL(N,S,Z,1)                                              00002570
      YNORM = S*YNORM                                                   00002580
C                                                                       00002590
C     SOLVE TRANS(U)*Z = V                                              00002600
C                                                                       00002610
      K = 1                                                             00002620
      IK = 0                                                            00002630
  240 IF (K .GT. N) GO TO 270                                           00002640
         KS = 1                                                         00002650
         IF (KPVT(K) .LT. 0) KS = 2                                     00002660
         IF (K .EQ. 1) GO TO 260                                        00002670
            Z(K) = Z(K) + ZDOTU(K-1,AP(IK+1),1,Z(1),1)                  00002680
            IKP1 = IK + K                                               00002690
            IF (KS .EQ. 2)                                              00002700
     *         Z(K+1) = Z(K+1) + ZDOTU(K-1,AP(IKP1+1),1,Z(1),1)         00002710
            KP = IABS(KPVT(K))                                          00002720
            IF (KP .EQ. K) GO TO 250                                    00002730
               T = Z(K)                                                 00002740
               Z(K) = Z(KP)                                             00002750
               Z(KP) = T                                                00002760
  250       CONTINUE                                                    00002770
  260    CONTINUE                                                       00002780
         IK = IK + K                                                    00002790
         IF (KS .EQ. 2) IK = IK + (K + 1)                               00002800
         K = K + KS                                                     00002810
      GO TO 240                                                         00002820
  270 CONTINUE                                                          00002830
C     MAKE ZNORM = 1.0                                                  00002840
      S = 1.0D0/DZASUM(N,Z,1)                                           00002850
      CALL ZDSCAL(N,S,Z,1)                                              00002860
      YNORM = S*YNORM                                                   00002870
C                                                                       00002880
      IF (ANORM .NE. 0.0D0) RCOND = YNORM/ANORM                         00002890
      IF (ANORM .EQ. 0.0D0) RCOND = 0.0D0                               00002900
      RETURN                                                            00002910
      END                                                               00002920
