*#**********************************************************************

      SUBROUTINE ZSPDI(AP,N,KPVT,DET,WORK,JOB)                          00000010

      INTEGER N,JOB                                                     00000020
      COMPLEX*16 AP(1),WORK(1),DET(2)                                   00000030
      INTEGER KPVT(1)                                                   00000040
C                                                                       00000050
C     ZSPDI COMPUTES THE DETERMINANT AND INVERSE                        00000060
C     OF A COMPLEX*16 SYMMETRIC MATRIX USING THE FACTORS FROM ZSPFA,    00000070
C     WHERE THE MATRIX IS STORED IN PACKED FORM.                        00000080
C                                                                       00000090
C     ON ENTRY                                                          00000100
C                                                                       00000110
C        AP      COMPLEX*16 (N*(N+1)/2)                                 00000120
C                THE OUTPUT FROM ZSPFA.                                 00000130
C                                                                       00000140
C        N       INTEGER                                                00000150
C                THE ORDER OF THE MATRIX A.                             00000160
C                                                                       00000170
C        KPVT    INTEGER(N)                                             00000180
C                THE PIVOT VECTOR FROM ZSPFA.                           00000190
C                                                                       00000200
C        WORK    COMPLEX*16(N)                                          00000210
C                WORK VECTOR.  CONTENTS IGNORED.                        00000220
C                                                                       00000230
C        JOB     INTEGER                                                00000240
C                JOB HAS THE DECIMAL EXPANSION  AB  WHERE               00000250
C                   IF  B .NE. 0, THE INVERSE IS COMPUTED,              00000260
C                   IF  A .NE. 0, THE DETERMINANT IS COMPUTED,          00000270
C                                                                       00000280
C                FOR EXAMPLE, JOB = 11  GIVES BOTH.                     00000290
C                                                                       00000300
C     ON RETURN                                                         00000310
C                                                                       00000320
C        VARIABLES NOT REQUESTED BY JOB ARE NOT USED.                   00000330
C                                                                       00000340
C        AP     CONTAINS THE UPPER TRIANGLE OF THE INVERSE OF           00000350
C               THE ORIGINAL MATRIX, STORED IN PACKED FORM.             00000360
C               THE COLUMNS OF THE UPPER TRIANGLE ARE STORED            00000370
C               SEQUENTIALLY IN A ONE-DIMENSIONAL ARRAY.                00000380
C                                                                       00000390
C        DET    COMPLEX*16(2)                                           00000400
C               DETERMINANT OF ORIGINAL MATRIX.                         00000410
C               DETERMINANT = DET(1) * 10.0**DET(2)                     00000420
C               WITH 1.0 .LE. DABS(DET(1)) .LT. 10.0                    00000430
C               OR DET(1) = 0.0.                                        00000440
C                                                                       00000450
C     ERROR CONDITION                                                   00000460
C                                                                       00000470
C        A DIVISION BY ZERO WILL OCCUR IF THE INVERSE IS REQUESTED      00000480
C        AND  ZSPCO  HAS SET RCOND .EQ. 0.0                             00000490
C        OR  ZSPFA  HAS SET  INFO .NE. 0 .                              00000500
C                                                                       00000510
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000520
C     JAMES BUNCH, UNIV. CALIF. SAN DIEGO, ARGONNE NAT. LAB.            00000530
C                                                                       00000540
C     SUBROUTINES AND FUNCTIONS                                         00000550
C                                                                       00000560
C     BLAS ZAXPY,ZCOPY,ZDOTU,ZSWAP                                      00000570
C     FORTRAN DABS,DCMPLX,IABS,MOD                                      00000580
C                                                                       00000590
C     INTERNAL VARIABLES.                                               00000600
C                                                                       00000610
      COMPLEX*16 AK,AKKP1,AKP1,ZDOTU,D,T,TEMP                           00000620
      DOUBLE PRECISION TEN                                              00000630
      INTEGER IJ,IK,IKP1,IKS,J,JB,JK,JKP1                               00000640
      INTEGER K,KK,KKP1,KM1,KS,KSJ,KSKP1,KSTEP                          00000650
      LOGICAL NOINV,NODET                                               00000660
C                                                                       00000670
      COMPLEX*16 ZDUM                                                   00000680
      DOUBLE PRECISION CABS1                                            00000690
      DOUBLE PRECISION DREAL,DIMAG                                      00000700
      COMPLEX*16 ZDUMR,ZDUMI                                            00000710
      DREAL(ZDUMR) = ZDUMR                                              00000720
      DIMAG(ZDUMI) = (0.0D0,-1.0D0)*ZDUMI                               00000730
      CABS1(ZDUM) = DABS(DREAL(ZDUM)) + DABS(DIMAG(ZDUM))               00000740
C                                                                       00000750
      NOINV = MOD(JOB,10) .EQ. 0                                        00000760
      NODET = MOD(JOB,100)/10 .EQ. 0                                    00000770
C                                                                       00000780
      IF (NODET) GO TO 110                                              00000790
         DET(1) = (1.0D0,0.0D0)                                         00000800
         DET(2) = (0.0D0,0.0D0)                                         00000810
         TEN = 10.0D0                                                   00000820
         T = (0.0D0,0.0D0)                                              00000830
         IK = 0                                                         00000840
         DO 100 K = 1, N                                                00000850
            KK = IK + K                                                 00000860
            D = AP(KK)                                                  00000870
C                                                                       00000880
C           CHECK IF 1 BY 1                                             00000890
C                                                                       00000900
            IF (KPVT(K) .GT. 0) GO TO 30                                00000910
C                                                                       00000920
C              2 BY 2 BLOCK                                             00000930
C              USE DET (D  T)  =  (D/T * C - T) * T                     00000940
C                      (T  C)                                           00000950
C              TO AVOID UNDERFLOW/OVERFLOW TROUBLES.                    00000960
C              TAKE TWO PASSES THROUGH SCALING.  USE  T  FOR FLAG.      00000970
C                                                                       00000980
               IF (CABS1(T) .NE. 0.0D0) GO TO 10                        00000990
                  IKP1 = IK + K                                         00001000
                  KKP1 = IKP1 + K                                       00001010
                  T = AP(KKP1)                                          00001020
                  D = (D/T)*AP(KKP1+1) - T                              00001030
               GO TO 20                                                 00001040
   10          CONTINUE                                                 00001050
                  D = T                                                 00001060
                  T = (0.0D0,0.0D0)                                     00001070
   20          CONTINUE                                                 00001080
   30       CONTINUE                                                    00001090
C                                                                       00001100
            IF (NODET) GO TO 90                                         00001110
               DET(1) = D*DET(1)                                        00001120
               IF (CABS1(DET(1)) .EQ. 0.0D0) GO TO 80                   00001130
   40             IF (CABS1(DET(1)) .GE. 1.0D0) GO TO 50                00001140
                     DET(1) = DCMPLX(TEN,0.0D0)*DET(1)                  00001150
                     DET(2) = DET(2) - (1.0D0,0.0D0)                    00001160
                  GO TO 40                                              00001170
   50             CONTINUE                                              00001180
   60             IF (CABS1(DET(1)) .LT. TEN) GO TO 70                  00001190
                     DET(1) = DET(1)/DCMPLX(TEN,0.0D0)                  00001200
                     DET(2) = DET(2) + (1.0D0,0.0D0)                    00001210
                  GO TO 60                                              00001220
   70             CONTINUE                                              00001230
   80          CONTINUE                                                 00001240
   90       CONTINUE                                                    00001250
            IK = IK + K                                                 00001260
  100    CONTINUE                                                       00001270
  110 CONTINUE                                                          00001280
C                                                                       00001290
C     COMPUTE INVERSE(A)                                                00001300
C                                                                       00001310
      IF (NOINV) GO TO 240                                              00001320
         K = 1                                                          00001330
         IK = 0                                                         00001340
  120    IF (K .GT. N) GO TO 230                                        00001350
            KM1 = K - 1                                                 00001360
            KK = IK + K                                                 00001370
            IKP1 = IK + K                                               00001380
            IF (KPVT(K) .LT. 0) GO TO 150                               00001390
C                                                                       00001400
C              1 BY 1                                                   00001410
C                                                                       00001420
               AP(KK) = (1.0D0,0.0D0)/AP(KK)                            00001430
               IF (KM1 .LT. 1) GO TO 140                                00001440
                  CALL ZCOPY(KM1,AP(IK+1),1,WORK,1)                     00001450
                  IJ = 0                                                00001460
                  DO 130 J = 1, KM1                                     00001470
                     JK = IK + J                                        00001480
                     AP(JK) = ZDOTU(J,AP(IJ+1),1,WORK,1)                00001490
                     CALL ZAXPY(J-1,WORK(J),AP(IJ+1),1,AP(IK+1),1)      00001500
                     IJ = IJ + J                                        00001510
  130             CONTINUE                                              00001520
                  AP(KK) = AP(KK) + ZDOTU(KM1,WORK,1,AP(IK+1),1)        00001530
  140          CONTINUE                                                 00001540
               KSTEP = 1                                                00001550
            GO TO 190                                                   00001560
  150       CONTINUE                                                    00001570
C                                                                       00001580
C              2 BY 2                                                   00001590
C                                                                       00001600
               KKP1 = IKP1 + K                                          00001610
               T = AP(KKP1)                                             00001620
               AK = AP(KK)/T                                            00001630
               AKP1 = AP(KKP1+1)/T                                      00001640
               AKKP1 = AP(KKP1)/T                                       00001650
               D = T*(AK*AKP1 - (1.0D0,0.0D0))                          00001660
               AP(KK) = AKP1/D                                          00001670
               AP(KKP1+1) = AK/D                                        00001680
               AP(KKP1) = -AKKP1/D                                      00001690
               IF (KM1 .LT. 1) GO TO 180                                00001700
                  CALL ZCOPY(KM1,AP(IKP1+1),1,WORK,1)                   00001710
                  IJ = 0                                                00001720
                  DO 160 J = 1, KM1                                     00001730
                     JKP1 = IKP1 + J                                    00001740
                     AP(JKP1) = ZDOTU(J,AP(IJ+1),1,WORK,1)              00001750
                     CALL ZAXPY(J-1,WORK(J),AP(IJ+1),1,AP(IKP1+1),1)    00001760
                     IJ = IJ + J                                        00001770
  160             CONTINUE                                              00001780
                  AP(KKP1+1) = AP(KKP1+1)                               00001790
     *                         + ZDOTU(KM1,WORK,1,AP(IKP1+1),1)         00001800
                  AP(KKP1) = AP(KKP1)                                   00001810
     *                       + ZDOTU(KM1,AP(IK+1),1,AP(IKP1+1),1)       00001820
                  CALL ZCOPY(KM1,AP(IK+1),1,WORK,1)                     00001830
                  IJ = 0                                                00001840
                  DO 170 J = 1, KM1                                     00001850
                     JK = IK + J                                        00001860
                     AP(JK) = ZDOTU(J,AP(IJ+1),1,WORK,1)                00001870
                     CALL ZAXPY(J-1,WORK(J),AP(IJ+1),1,AP(IK+1),1)      00001880
                     IJ = IJ + J                                        00001890
  170             CONTINUE                                              00001900
                  AP(KK) = AP(KK) + ZDOTU(KM1,WORK,1,AP(IK+1),1)        00001910
  180          CONTINUE                                                 00001920
               KSTEP = 2                                                00001930
  190       CONTINUE                                                    00001940
C                                                                       00001950
C           SWAP                                                        00001960
C                                                                       00001970
            KS = IABS(KPVT(K))                                          00001980
            IF (KS .EQ. K) GO TO 220                                    00001990
               IKS = (KS*(KS - 1))/2                                    00002000
               CALL ZSWAP(KS,AP(IKS+1),1,AP(IK+1),1)                    00002010
               KSJ = IK + KS                                            00002020
               DO 200 JB = KS, K                                        00002030
                  J = K + KS - JB                                       00002040
                  JK = IK + J                                           00002050
                  TEMP = AP(JK)                                         00002060
                  AP(JK) = AP(KSJ)                                      00002070
                  AP(KSJ) = TEMP                                        00002080
                  KSJ = KSJ - (J - 1)                                   00002090
  200          CONTINUE                                                 00002100
               IF (KSTEP .EQ. 1) GO TO 210                              00002110
                  KSKP1 = IKP1 + KS                                     00002120
                  TEMP = AP(KSKP1)                                      00002130
                  AP(KSKP1) = AP(KKP1)                                  00002140
                  AP(KKP1) = TEMP                                       00002150
  210          CONTINUE                                                 00002160
  220       CONTINUE                                                    00002170
            IK = IK + K                                                 00002180
            IF (KSTEP .EQ. 2) IK = IK + K + 1                           00002190
            K = K + KSTEP                                               00002200
         GO TO 120                                                      00002210
  230    CONTINUE                                                       00002220
  240 CONTINUE                                                          00002230
      RETURN                                                            00002240
      END                                                               00002250
