*#**********************************************************************

      SUBROUTINE ZSPFA(AP,N,KPVT,INFO)                                  00000010

      INTEGER N,KPVT(1),INFO                                            00000020
      COMPLEX*16 AP(1)                                                  00000030
C                                                                       00000040
C     ZSPFA FACTORS A COMPLEX*16 SYMMETRIC MATRIX STORED IN             00000050
C     PACKED FORM BY ELIMINATION WITH SYMMETRIC PIVOTING.               00000060
C                                                                       00000070
C     TO SOLVE  A*X = B , FOLLOW ZSPFA BY ZSPSL.                        00000080
C     TO COMPUTE  INVERSE(A)*C , FOLLOW ZSPFA BY ZSPSL.                 00000090
C     TO COMPUTE  DETERMINANT(A) , FOLLOW ZSPFA BY ZSPDI.               00000100
C     TO COMPUTE  INVERSE(A) , FOLLOW ZSPFA BY ZSPDI.                   00000110
C                                                                       00000120
C     ON ENTRY                                                          00000130
C                                                                       00000140
C        AP      COMPLEX*16 (N*(N+1)/2)                                 00000150
C                THE PACKED FORM OF A SYMMETRIC MATRIX  A .  THE        00000160
C                COLUMNS OF THE UPPER TRIANGLE ARE STORED SEQUENTIALLY  00000170
C                IN A ONE-DIMENSIONAL ARRAY OF LENGTH  N*(N+1)/2 .      00000180
C                SEE COMMENTS BELOW FOR DETAILS.                        00000190
C                                                                       00000200
C        N       INTEGER                                                00000210
C                THE ORDER OF THE MATRIX  A .                           00000220
C                                                                       00000230
C     ON RETURN                                                         00000240
C                                                                       00000250
C        AP      A BLOCK DIAGONAL MATRIX AND THE MULTIPLIERS WHICH      00000260
C                WERE USED TO OBTAIN IT STORED IN PACKED FORM.          00000270
C                THE FACTORIZATION CAN BE WRITTEN  A = U*D*TRANS(U)     00000280
C                WHERE  U  IS A PRODUCT OF PERMUTATION AND UNIT         00000290
C                UPPER TRIANGULAR MATRICES , TRANS(U) IS THE            00000300
C                TRANSPOSE OF  U , AND  D  IS BLOCK DIAGONAL            00000310
C                WITH 1 BY 1 AND 2 BY 2 BLOCKS.                         00000320
C                                                                       00000330
C        KPVT    INTEGER(N)                                             00000340
C                AN INTEGER VECTOR OF PIVOT INDICES.                    00000350
C                                                                       00000360
C        INFO    INTEGER                                                00000370
C                = 0  NORMAL VALUE.                                     00000380
C                = K  IF THE K-TH PIVOT BLOCK IS SINGULAR. THIS IS      00000390
C                     NOT AN ERROR CONDITION FOR THIS SUBROUTINE,       00000400
C                     BUT IT DOES INDICATE THAT ZSPSL OR ZSPDI MAY      00000410
C                     DIVIDE BY ZERO IF CALLED.                         00000420
C                                                                       00000430
C     PACKED STORAGE                                                    00000440
C                                                                       00000450
C          THE FOLLOWING PROGRAM SEGMENT WILL PACK THE UPPER            00000460
C          TRIANGLE OF A SYMMETRIC MATRIX.                              00000470
C                                                                       00000480
C                K = 0                                                  00000490
C                DO 20 J = 1, N                                         00000500
C                   DO 10 I = 1, J                                      00000510
C                      K = K + 1                                        00000520
C                      AP(K)  = A(I,J)                                  00000530
C             10    CONTINUE                                            00000540
C             20 CONTINUE                                               00000550
C                                                                       00000560
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000570
C     JAMES BUNCH, UNIV. CALIF. SAN DIEGO, ARGONNE NAT. LAB.            00000580
C                                                                       00000590
C     SUBROUTINES AND FUNCTIONS                                         00000600
C                                                                       00000610
C     BLAS ZAXPY,ZSWAP,IZAMAX                                           00000620
C     FORTRAN DABS,DMAX1,DSQRT                                          00000630
C                                                                       00000640
C     INTERNAL VARIABLES                                                00000650
C                                                                       00000660
      COMPLEX*16 AK,AKM1,BK,BKM1,DENOM,MULK,MULKM1,T                    00000670
      DOUBLE PRECISION ABSAKK,ALPHA,COLMAX,ROWMAX                       00000680
      INTEGER IZAMAX,IJ,IJJ,IK,IKM1,IM,IMAX,IMAXP1,IMIM,IMJ,IMK         00000690
      INTEGER J,JJ,JK,JKM1,JMAX,JMIM,K,KK,KM1,KM1K,KM1KM1,KM2,KSTEP     00000700
      LOGICAL SWAP                                                      00000710
C                                                                       00000720
      COMPLEX*16 ZDUM                                                   00000730
      DOUBLE PRECISION CABS1                                            00000740
      DOUBLE PRECISION DREAL,DIMAG                                      00000750
      COMPLEX*16 ZDUMR,ZDUMI                                            00000760
      DREAL(ZDUMR) = ZDUMR                                              00000770
      DIMAG(ZDUMI) = (0.0D0,-1.0D0)*ZDUMI                               00000780
      CABS1(ZDUM) = DABS(DREAL(ZDUM)) + DABS(DIMAG(ZDUM))               00000790
C                                                                       00000800
C     INITIALIZE                                                        00000810
C                                                                       00000820
C     ALPHA IS USED IN CHOOSING PIVOT BLOCK SIZE.                       00000830
      ALPHA = (1.0D0 + DSQRT(17.0D0))/8.0D0                             00000840
C                                                                       00000850
      INFO = 0                                                          00000860
C                                                                       00000870
C     MAIN LOOP ON K, WHICH GOES FROM N TO 1.                           00000880
C                                                                       00000890
      K = N                                                             00000900
      IK = (N*(N - 1))/2                                                00000910
   10 CONTINUE                                                          00000920
C                                                                       00000930
C        LEAVE THE LOOP IF K=0 OR K=1.                                  00000940
C                                                                       00000950
C     ...EXIT                                                           00000960
         IF (K .EQ. 0) GO TO 200                                        00000970
         IF (K .GT. 1) GO TO 20                                         00000980
            KPVT(1) = 1                                                 00000990
            IF (CABS1(AP(1)) .EQ. 0.0D0) INFO = 1                       00001000
C     ......EXIT                                                        00001010
            GO TO 200                                                   00001020
   20    CONTINUE                                                       00001030
C                                                                       00001040
C        THIS SECTION OF CODE DETERMINES THE KIND OF                    00001050
C        ELIMINATION TO BE PERFORMED.  WHEN IT IS COMPLETED,            00001060
C        KSTEP WILL BE SET TO THE SIZE OF THE PIVOT BLOCK, AND          00001070
C        SWAP WILL BE SET TO .TRUE. IF AN INTERCHANGE IS                00001080
C        REQUIRED.                                                      00001090
C                                                                       00001100
         KM1 = K - 1                                                    00001110
         KK = IK + K                                                    00001120
         ABSAKK = CABS1(AP(KK))                                         00001130
C                                                                       00001140
C        DETERMINE THE LARGEST OFF-DIAGONAL ELEMENT IN                  00001150
C        COLUMN K.                                                      00001160
C                                                                       00001170
         IMAX = IZAMAX(K-1,AP(IK+1),1)                                  00001180
         IMK = IK + IMAX                                                00001190
         COLMAX = CABS1(AP(IMK))                                        00001200
         IF (ABSAKK .LT. ALPHA*COLMAX) GO TO 30                         00001210
            KSTEP = 1                                                   00001220
            SWAP = .FALSE.                                              00001230
         GO TO 90                                                       00001240
   30    CONTINUE                                                       00001250
C                                                                       00001260
C           DETERMINE THE LARGEST OFF-DIAGONAL ELEMENT IN               00001270
C           ROW IMAX.                                                   00001280
C                                                                       00001290
            ROWMAX = 0.0D0                                              00001300
            IMAXP1 = IMAX + 1                                           00001310
            IM = IMAX*(IMAX - 1)/2                                      00001320
            IMJ = IM + 2*IMAX                                           00001330
            DO 40 J = IMAXP1, K                                         00001340
               ROWMAX = DMAX1(ROWMAX,CABS1(AP(IMJ)))                    00001350
               IMJ = IMJ + J                                            00001360
   40       CONTINUE                                                    00001370
            IF (IMAX .EQ. 1) GO TO 50                                   00001380
               JMAX = IZAMAX(IMAX-1,AP(IM+1),1)                         00001390
               JMIM = JMAX + IM                                         00001400
               ROWMAX = DMAX1(ROWMAX,CABS1(AP(JMIM)))                   00001410
   50       CONTINUE                                                    00001420
            IMIM = IMAX + IM                                            00001430
            IF (CABS1(AP(IMIM)) .LT. ALPHA*ROWMAX) GO TO 60             00001440
               KSTEP = 1                                                00001450
               SWAP = .TRUE.                                            00001460
            GO TO 80                                                    00001470
   60       CONTINUE                                                    00001480
            IF (ABSAKK .LT. ALPHA*COLMAX*(COLMAX/ROWMAX)) GO TO 70      00001490
               KSTEP = 1                                                00001500
               SWAP = .FALSE.                                           00001510
            GO TO 80                                                    00001520
   70       CONTINUE                                                    00001530
               KSTEP = 2                                                00001540
               SWAP = IMAX .NE. KM1                                     00001550
   80       CONTINUE                                                    00001560
   90    CONTINUE                                                       00001570
         IF (DMAX1(ABSAKK,COLMAX) .NE. 0.0D0) GO TO 100                 00001580
C                                                                       00001590
C           COLUMN K IS ZERO.  SET INFO AND ITERATE THE LOOP.           00001600
C                                                                       00001610
            KPVT(K) = K                                                 00001620
            INFO = K                                                    00001630
         GO TO 190                                                      00001640
  100    CONTINUE                                                       00001650
         IF (KSTEP .EQ. 2) GO TO 140                                    00001660
C                                                                       00001670
C           1 X 1 PIVOT BLOCK.                                          00001680
C                                                                       00001690
            IF (.NOT.SWAP) GO TO 120                                    00001700
C                                                                       00001710
C              PERFORM AN INTERCHANGE.                                  00001720
C                                                                       00001730
               CALL ZSWAP(IMAX,AP(IM+1),1,AP(IK+1),1)                   00001740
               IMJ = IK + IMAX                                          00001750
               DO 110 JJ = IMAX, K                                      00001760
                  J = K + IMAX - JJ                                     00001770
                  JK = IK + J                                           00001780
                  T = AP(JK)                                            00001790
                  AP(JK) = AP(IMJ)                                      00001800
                  AP(IMJ) = T                                           00001810
                  IMJ = IMJ - (J - 1)                                   00001820
  110          CONTINUE                                                 00001830
  120       CONTINUE                                                    00001840
C                                                                       00001850
C           PERFORM THE ELIMINATION.                                    00001860
C                                                                       00001870
            IJ = IK - (K - 1)                                           00001880
            DO 130 JJ = 1, KM1                                          00001890
               J = K - JJ                                               00001900
               JK = IK + J                                              00001910
               MULK = -AP(JK)/AP(KK)                                    00001920
               T = MULK                                                 00001930
               CALL ZAXPY(J,T,AP(IK+1),1,AP(IJ+1),1)                    00001940
               IJJ = IJ + J                                             00001950
               AP(JK) = MULK                                            00001960
               IJ = IJ - (J - 1)                                        00001970
  130       CONTINUE                                                    00001980
C                                                                       00001990
C           SET THE PIVOT ARRAY.                                        00002000
C                                                                       00002010
            KPVT(K) = K                                                 00002020
            IF (SWAP) KPVT(K) = IMAX                                    00002030
         GO TO 190                                                      00002040
  140    CONTINUE                                                       00002050
C                                                                       00002060
C           2 X 2 PIVOT BLOCK.                                          00002070
C                                                                       00002080
            KM1K = IK + K - 1                                           00002090
            IKM1 = IK - (K - 1)                                         00002100
            IF (.NOT.SWAP) GO TO 160                                    00002110
C                                                                       00002120
C              PERFORM AN INTERCHANGE.                                  00002130
C                                                                       00002140
               CALL ZSWAP(IMAX,AP(IM+1),1,AP(IKM1+1),1)                 00002150
               IMJ = IKM1 + IMAX                                        00002160
               DO 150 JJ = IMAX, KM1                                    00002170
                  J = KM1 + IMAX - JJ                                   00002180
                  JKM1 = IKM1 + J                                       00002190
                  T = AP(JKM1)                                          00002200
                  AP(JKM1) = AP(IMJ)                                    00002210
                  AP(IMJ) = T                                           00002220
                  IMJ = IMJ - (J - 1)                                   00002230
  150          CONTINUE                                                 00002240
               T = AP(KM1K)                                             00002250
               AP(KM1K) = AP(IMK)                                       00002260
               AP(IMK) = T                                              00002270
  160       CONTINUE                                                    00002280
C                                                                       00002290
C           PERFORM THE ELIMINATION.                                    00002300
C                                                                       00002310
            KM2 = K - 2                                                 00002320
            IF (KM2 .EQ. 0) GO TO 180                                   00002330
               AK = AP(KK)/AP(KM1K)                                     00002340
               KM1KM1 = IKM1 + K - 1                                    00002350
               AKM1 = AP(KM1KM1)/AP(KM1K)                               00002360
               DENOM = 1.0D0 - AK*AKM1                                  00002370
               IJ = IK - (K - 1) - (K - 2)                              00002380
               DO 170 JJ = 1, KM2                                       00002390
                  J = KM1 - JJ                                          00002400
                  JK = IK + J                                           00002410
                  BK = AP(JK)/AP(KM1K)                                  00002420
                  JKM1 = IKM1 + J                                       00002430
                  BKM1 = AP(JKM1)/AP(KM1K)                              00002440
                  MULK = (AKM1*BK - BKM1)/DENOM                         00002450
                  MULKM1 = (AK*BKM1 - BK)/DENOM                         00002460
                  T = MULK                                              00002470
                  CALL ZAXPY(J,T,AP(IK+1),1,AP(IJ+1),1)                 00002480
                  T = MULKM1                                            00002490
                  CALL ZAXPY(J,T,AP(IKM1+1),1,AP(IJ+1),1)               00002500
                  AP(JK) = MULK                                         00002510
                  AP(JKM1) = MULKM1                                     00002520
                  IJJ = IJ + J                                          00002530
                  IJ = IJ - (J - 1)                                     00002540
  170          CONTINUE                                                 00002550
  180       CONTINUE                                                    00002560
C                                                                       00002570
C           SET THE PIVOT ARRAY.                                        00002580
C                                                                       00002590
            KPVT(K) = 1 - K                                             00002600
            IF (SWAP) KPVT(K) = -IMAX                                   00002610
            KPVT(K-1) = KPVT(K)                                         00002620
  190    CONTINUE                                                       00002630
         IK = IK - (K - 1)                                              00002640
         IF (KSTEP .EQ. 2) IK = IK - (K - 2)                            00002650
         K = K - KSTEP                                                  00002660
      GO TO 10                                                          00002670
  200 CONTINUE                                                          00002680
      RETURN                                                            00002690
      END                                                               00002700
