*#**********************************************************************

      SUBROUTINE ZTRCO(T,LDT,N,RCOND,Z,JOB)                             00000010

      INTEGER LDT,N,JOB                                                 00000020
      COMPLEX*16 T(LDT,1),Z(1)                                          00000030
      DOUBLE PRECISION RCOND                                            00000040
C                                                                       00000050
C     ZTRCO ESTIMATES THE CONDITION OF A COMPLEX*16 TRIANGULAR MATRIX.  00000060
C                                                                       00000070
C     ON ENTRY                                                          00000080
C                                                                       00000090
C        T       COMPLEX*16(LDT,N)                                      00000100
C                T CONTAINS THE TRIANGULAR MATRIX. THE ZERO             00000110
C                ELEMENTS OF THE MATRIX ARE NOT REFERENCED, AND         00000120
C                THE CORRESPONDING ELEMENTS OF THE ARRAY CAN BE         00000130
C                USED TO STORE OTHER INFORMATION.                       00000140
C                                                                       00000150
C        LDT     INTEGER                                                00000160
C                LDT IS THE LEADING DIMENSION OF THE ARRAY T.           00000170
C                                                                       00000180
C        N       INTEGER                                                00000190
C                N IS THE ORDER OF THE SYSTEM.                          00000200
C                                                                       00000210
C        JOB     INTEGER                                                00000220
C                = 0         T  IS LOWER TRIANGULAR.                    00000230
C                = NONZERO   T  IS UPPER TRIANGULAR.                    00000240
C                                                                       00000250
C     ON RETURN                                                         00000260
C                                                                       00000270
C        RCOND   DOUBLE PRECISION                                       00000280
C                AN ESTIMATE OF THE RECIPROCAL CONDITION OF  T .        00000290
C                FOR THE SYSTEM  T*X = B , RELATIVE PERTURBATIONS       00000300
C                IN  T  AND  B  OF SIZE  EPSILON  MAY CAUSE             00000310
C                RELATIVE PERTURBATIONS IN  X  OF SIZE  EPSILON/RCOND . 00000320
C                IF  RCOND  IS SO SMALL THAT THE LOGICAL EXPRESSION     00000330
C                           1.0 + RCOND .EQ. 1.0                        00000340
C                IS TRUE, THEN  T  MAY BE SINGULAR TO WORKING           00000350
C                PRECISION.  IN PARTICULAR,  RCOND  IS ZERO  IF         00000360
C                EXACT SINGULARITY IS DETECTED OR THE ESTIMATE          00000370
C                UNDERFLOWS.                                            00000380
C                                                                       00000390
C        Z       COMPLEX*16(N)                                          00000400
C                A WORK VECTOR WHOSE CONTENTS ARE USUALLY UNIMPORTANT.  00000410
C                IF  T  IS CLOSE TO A SINGULAR MATRIX, THEN  Z  IS      00000420
C                AN APPROXIMATE NULL VECTOR IN THE SENSE THAT           00000430
C                NORM(A*Z) = RCOND*NORM(A)*NORM(Z) .                    00000440
C                                                                       00000450
C     LINPACK. THIS VERSION DATED 08/14/78 .                            00000460
C     CLEVE MOLER, UNIVERSITY OF NEW MEXICO, ARGONNE NATIONAL LAB.      00000470
C                                                                       00000480
C     SUBROUTINES AND FUNCTIONS                                         00000490
C                                                                       00000500
C     BLAS ZAXPY,ZDSCAL,DZASUM                                          00000510
C     FORTRAN DABS,DMAX1,DCMPLX,DCONJG                                  00000520
C                                                                       00000530
C     INTERNAL VARIABLES                                                00000540
C                                                                       00000550
      COMPLEX*16 W,WK,WKM,EK                                            00000560
      DOUBLE PRECISION TNORM,YNORM,S,SM,DZASUM                          00000570
      INTEGER I1,J,J1,J2,K,KK,L                                         00000580
      LOGICAL LOWER                                                     00000590
      COMPLEX*16 ZDUM,ZDUM1,ZDUM2,CSIGN1                                00000600
      DOUBLE PRECISION CABS1                                            00000610
      DOUBLE PRECISION DREAL,DIMAG                                      00000620
      COMPLEX*16 ZDUMR,ZDUMI                                            00000630
      DREAL(ZDUMR) = ZDUMR                                              00000640
      DIMAG(ZDUMI) = (0.0D0,-1.0D0)*ZDUMI                               00000650
      CABS1(ZDUM) = DABS(DREAL(ZDUM)) + DABS(DIMAG(ZDUM))               00000660
      CSIGN1(ZDUM1,ZDUM2) = CABS1(ZDUM1)*(ZDUM2/CABS1(ZDUM2))           00000670
C                                                                       00000680
      LOWER = JOB .EQ. 0                                                00000690
C                                                                       00000700
C     COMPUTE 1-NORM OF T                                               00000710
C                                                                       00000720
      TNORM = 0.0D0                                                     00000730
      DO 10 J = 1, N                                                    00000740
         L = J                                                          00000750
         IF (LOWER) L = N + 1 - J                                       00000760
         I1 = 1                                                         00000770
         IF (LOWER) I1 = J                                              00000780
         TNORM = DMAX1(TNORM,DZASUM(L,T(I1,J),1))                       00000790
   10 CONTINUE                                                          00000800
C                                                                       00000810
C     RCOND = 1/(NORM(T)*(ESTIMATE OF NORM(INVERSE(T)))) .              00000820
C     ESTIMATE = NORM(Z)/NORM(Y) WHERE  T*Z = Y  AND  CTRANS(T)*Y = E . 00000830
C     CTRANS(T)  IS THE CONJUGATE TRANSPOSE OF T .                      00000840
C     THE COMPONENTS OF  E  ARE CHOSEN TO CAUSE MAXIMUM LOCAL           00000850
C     GROWTH IN THE ELEMENTS OF Y .                                     00000860
C     THE VECTORS ARE FREQUENTLY RESCALED TO AVOID OVERFLOW.            00000870
C                                                                       00000880
C     SOLVE CTRANS(T)*Y = E                                             00000890
C                                                                       00000900
      EK = (1.0D0,0.0D0)                                                00000910
      DO 20 J = 1, N                                                    00000920
         Z(J) = (0.0D0,0.0D0)                                           00000930
   20 CONTINUE                                                          00000940
      DO 100 KK = 1, N                                                  00000950
         K = KK                                                         00000960
         IF (LOWER) K = N + 1 - KK                                      00000970
         IF (CABS1(Z(K)) .NE. 0.0D0) EK = CSIGN1(EK,-Z(K))              00000980
         IF (CABS1(EK-Z(K)) .LE. CABS1(T(K,K))) GO TO 30                00000990
            S = CABS1(T(K,K))/CABS1(EK-Z(K))                            00001000
            CALL ZDSCAL(N,S,Z,1)                                        00001010
            EK = DCMPLX(S,0.0D0)*EK                                     00001020
   30    CONTINUE                                                       00001030
         WK = EK - Z(K)                                                 00001040
         WKM = -EK - Z(K)                                               00001050
         S = CABS1(WK)                                                  00001060
         SM = CABS1(WKM)                                                00001070
         IF (CABS1(T(K,K)) .EQ. 0.0D0) GO TO 40                         00001080
            WK = WK/DCONJG(T(K,K))                                      00001090
            WKM = WKM/DCONJG(T(K,K))                                    00001100
         GO TO 50                                                       00001110
   40    CONTINUE                                                       00001120
            WK = (1.0D0,0.0D0)                                          00001130
            WKM = (1.0D0,0.0D0)                                         00001140
   50    CONTINUE                                                       00001150
         IF (KK .EQ. N) GO TO 90                                        00001160
            J1 = K + 1                                                  00001170
            IF (LOWER) J1 = 1                                           00001180
            J2 = N                                                      00001190
            IF (LOWER) J2 = K - 1                                       00001200
            DO 60 J = J1, J2                                            00001210
               SM = SM + CABS1(Z(J)+WKM*DCONJG(T(K,J)))                 00001220
               Z(J) = Z(J) + WK*DCONJG(T(K,J))                          00001230
               S = S + CABS1(Z(J))                                      00001240
   60       CONTINUE                                                    00001250
            IF (S .GE. SM) GO TO 80                                     00001260
               W = WKM - WK                                             00001270
               WK = WKM                                                 00001280
               DO 70 J = J1, J2                                         00001290
                  Z(J) = Z(J) + W*DCONJG(T(K,J))                        00001300
   70          CONTINUE                                                 00001310
   80       CONTINUE                                                    00001320
   90    CONTINUE                                                       00001330
         Z(K) = WK                                                      00001340
  100 CONTINUE                                                          00001350
      S = 1.0D0/DZASUM(N,Z,1)                                           00001360
      CALL ZDSCAL(N,S,Z,1)                                              00001370
C                                                                       00001380
      YNORM = 1.0D0                                                     00001390
C                                                                       00001400
C     SOLVE T*Z = Y                                                     00001410
C                                                                       00001420
      DO 130 KK = 1, N                                                  00001430
         K = N + 1 - KK                                                 00001440
         IF (LOWER) K = KK                                              00001450
         IF (CABS1(Z(K)) .LE. CABS1(T(K,K))) GO TO 110                  00001460
            S = CABS1(T(K,K))/CABS1(Z(K))                               00001470
            CALL ZDSCAL(N,S,Z,1)                                        00001480
            YNORM = S*YNORM                                             00001490
  110    CONTINUE                                                       00001500
         IF (CABS1(T(K,K)) .NE. 0.0D0) Z(K) = Z(K)/T(K,K)               00001510
         IF (CABS1(T(K,K)) .EQ. 0.0D0) Z(K) = (1.0D0,0.0D0)             00001520
         I1 = 1                                                         00001530
         IF (LOWER) I1 = K + 1                                          00001540
         IF (KK .GE. N) GO TO 120                                       00001550
            W = -Z(K)                                                   00001560
            CALL ZAXPY(N-KK,W,T(I1,K),1,Z(I1),1)                        00001570
  120    CONTINUE                                                       00001580
  130 CONTINUE                                                          00001590
C     MAKE ZNORM = 1.0                                                  00001600
      S = 1.0D0/DZASUM(N,Z,1)                                           00001610
      CALL ZDSCAL(N,S,Z,1)                                              00001620
      YNORM = S*YNORM                                                   00001630
C                                                                       00001640
      IF (TNORM .NE. 0.0D0) RCOND = YNORM/TNORM                         00001650
      IF (TNORM .EQ. 0.0D0) RCOND = 0.0D0                               00001660
      RETURN                                                            00001670
      END                                                               00001680
