C*****  ACOR    Auto-Correlation (Optimal-Domain)    MTHADV EXT. REL 1.0
C
C    ** COPYRIGHT 1986 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL ACOR (A,C,N,M)
C
C       where,
C
C       A       Real input vector of length 2*M.
C
C       C       Real output vector.
C
C       N       Integer input element count for C,
C               number of lags.
C
C       M       Integer input element count for A.
C
C
C  DESCRIPTION
C
C       This routine performs an auto-correlation on a vector
C       using either time-domain or frequency-domain techniques,
C       whichever performs faster for the given vector lengths.
C       For time-domain computations, ACORT is called.  For frequency-
C       domain computations, ACORF is called.
C
C            C(j) = SUM[A(j+i-1)*A(i)]    for i=1,M-j+1 and j=1,N
C
C       M must be a power of two and less than or equal to 2**21.
C
C       Although vector A has M elements, space for an additional
C       M elements must be allowed for performing the FFT.  At
C       the end of the operation, vector A is modified.
C
C       Local array NN defines, for each power of two, the largest
C       value of N for which the time-domain technique will be selected.
C       Use utility ACORNN, or some other method, to define the optimal
C       values for a particular installation.
C
C
C  EXAMPLE
C
C       CALL ACOR (A,C,6,8)
C
C       Input Operands:
C
C       A =   1.000
C             2.000
C             3.000
C             4.000
C             5.000
C             6.000
C             7.000
C             8.000
C           -99.000
C           -99.000
C           -99.000
C           -99.000
C           -99.000
C           -99.000
C           -99.000
C           -99.000
C
C       Output Operands:
C
C       C =  204.00
C            168.00
C            133.00
C            100.00
C             70.00
C             44.00
C
C  HISTORY
C         1) Dec 86     L. Tarvestad    Original.
C         2) Nov 87     P. Crose        rev. for VAX                    0076
C
C-----------------------------------------------------------------------
C
      SUBROUTINE ACOR(A,C,N,M)
C
      REAL A(1),C(1)
      INTEGER N,M,NN(21),IPOW2,ITMP
C
C THESE NN TUNED FOR VAX.  ACTUAL TIMINGS PERFORMED UP TO N=32768.
C (P. Crose, QTC, 11/20/87)
      DATA NN /
     +      2,      4,      8,      16,      32,    64,    65,    65,
     +     70,     75,     75,      75,      75,    75,    75,    75,
     +     75,     75,     75,      75,      75/
C
C-----------------------------------------------------------------------
C
      IF (N.LE.0 .OR. M.LE.0) GO TO 30
C
C SELECT OPTIMAL TECHNIQUE
      ITMP = 1
      DO 10 IPOW2 = 1,21
        IF (M.EQ.ITMP) GO TO 12
        ITMP = 2*ITMP
10    CONTINUE
      GO TO 30
12    IF (N.GT.NN(IPOW2)) GO TO 20
C
C HERE FOR TIME-DOMAIN TECHNIQUE
      CALL ACORT(A,C,N,M)
      GO TO 30
C
C HERE FOR FREQUENCY-DOMAIN TECHNIQUE
20    CALL ACORF(A,C,N,M)
C
30    RETURN
      END
C
