C*****  AMX000  N FUNCTION FOR CFFTM            REV 1.0     JAN 88
C
C  PURPOSE:
C       FINDS THE SMALLEST VALID NUMBER, M, FOR USE IN CFFTM THAT IS
C       GREATER THAN OR EQUAL TO A GIVEN NUMBER, N.
C
C  LANGUAGE:
C       FORTRAN 77
C
C  HISTORY:
C       ORIGINAL                JAN 88          R.D. COLEMAN, QTC
C
C  CALLING FORMAT:
C       CALL AMX000 (N, M)
C
C  PARAMETERS:
C       N       INTEGER INPUT SCALAR
C
C       M       INTEGER OUTPUT SCALAR
C
C  DESCRIPTION:
C       GIVEN THE INTEGER INPUT, N, THE FUNCTION RETURNS THE INTEGER
C       M SUCH THAT M IS THE SMALLEST NUMBER GREATER THAN OR EQUAL TO
C       N SUCH THAT M = 2**I * 3**J * 5**K * 7**L WHERE I, J, K, AND L
C       ARE NON-NEGATIVE INTEGERS.
C
C  SUBPROGRAMS CALLED:
C       AMX003
C
C  ERROR CONDITIONS:
C       NONE.
C
C-----------------------------------------------------------------------
C
      SUBROUTINE AMX000 (N, M)
C
      INTEGER MAX
      PARAMETER (MAX = 316)
C
      INTEGER NUM(MAX), IFAC(30)
      INTEGER I, I1, I2, M, N, NF
C
      DATA (NUM(I), I = 1, 190) /
     &        2,    3,    4,    5,    6,    7,    8,    9,   10,   12,
     &       14,   15,   16,   18,   20,   21,   24,   25,   27,   28,
     &       30,   32,   35,   36,   40,   42,   45,   48,   49,   50,
     &       54,   56,   60,   63,   64,   70,   72,   75,   80,   81,
     &       84,   90,   96,   98,  100,  105,  108,  112,  120,  125,
     &      126,  128,  135,  140,  144,  147,  150,  160,  162,  168,
     &      175,  180,  189,  192,  196,  200,  210,  216,  224,  225,
     &      240,  243,  245,  250,  252,  256,  270,  280,  288,  294,
     &      300,  315,  320,  324,  336,  343,  350,  360,  375,  378,
     &      384,  392,  400,  405,  420,  432,  441,  448,  450,  480,
     &      486,  490,  500,  504,  512,  525,  540,  560,  567,  576,
     &      588,  600,  625,  630,  640,  648,  672,  675,  686,  700,
     &      720,  729,  735,  750,  756,  768,  784,  800,  810,  840,
     &      864,  875,  882,  896,  900,  945,  960,  972,  980, 1000,
     &     1008, 1024, 1029, 1050, 1080, 1120, 1125, 1134, 1152, 1176,
     &     1200, 1215, 1225, 1250, 1260, 1280, 1296, 1323, 1344, 1350,
     &     1372, 1400, 1440, 1458, 1470, 1500, 1512, 1536, 1568, 1575,
     &     1600, 1620, 1680, 1701, 1715, 1728, 1750, 1764, 1792, 1800,
     &     1875, 1890, 1920, 1944, 1960, 2000, 2016, 2025, 2048, 2058/
      DATA (NUM(I), I = 191, 316) /
     &     2100, 2160, 2187, 2205, 2240, 2250, 2268, 2304, 2352, 2400,
     &     2401, 2430, 2450, 2500, 2520, 2560, 2592, 2625, 2646, 2688,
     &     2700, 2744, 2800, 2835, 2880, 2916, 2940, 3000, 3024, 3072,
     &     3087, 3125, 3136, 3150, 3200, 3240, 3360, 3375, 3402, 3430,
     &     3456, 3500, 3528, 3584, 3600, 3645, 3675, 3750, 3780, 3840,
     &     3888, 3920, 3969, 4000, 4032, 4050, 4096, 4116, 4200, 4320,
     &     4374, 4375, 4410, 4480, 4500, 4536, 4608, 4704, 4725, 4800,
     &     4802, 4860, 4900, 5000, 5040, 5103, 5120, 5145, 5184, 5250,
     &     5292, 5376, 5400, 5488, 5600, 5625, 5670, 5760, 5832, 5880,
     &     6000, 6048, 6075, 6125, 6144, 6174, 6250, 6272, 6300, 6400,
     &     6480, 6561, 6615, 6720, 6750, 6804, 6860, 6912, 7000, 7056,
     &     7168, 7200, 7203, 7290, 7350, 7500, 7560, 7680, 7776, 7840,
     &     7875, 7938, 8000, 8064, 8100, 8192/
C
C-----------------------------------------------------------------------
C
      IF (N .GT. NUM(MAX)) GO TO 200
C
      I1 = 0
      I2 = MAX
  100 CONTINUE
      I = (I1 + I2) / 2
      M = NUM(I)
      IF      (M .LT. N) THEN
         I1 = I
      ELSE IF (M .GT. N) THEN
         I2 = I
      ELSE
         GO TO 800
      ENDIF
      IF (I2 .GT. I1+1) GO TO 100
C
      M = NUM(I2)
      GO TO 800
C
  200 CONTINUE
      M = N - 1
  210 CONTINUE
         M = M + 1
         CALL AMX003 (M, IFAC, NF)
         IF (NF .EQ. 0) GO TO 210
C
  800 CONTINUE
      RETURN
      END
C
