C****** AMX009  HPSORT   INDEXED HEAP SORT ROUTINE        MTADV EXT    REL 1.0
C
C      ** COPYRIGHT 1988  QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C        CALL HPSORT (A, INDEX, N )
C
C        where,
C
C        A        Real Input array of length N.  The array being sorted.
C
C        INDEX    Integer Input/Output array of length N.  The index table.
C                 Used as initial and final order.  If INDEX(1) is zero, then
C                 INDEX is intialized to consequtive integers from 1 to N.
C
C        N        Integer Input Scaler.  The length of each trace.
C
C  DESCRIPTION
C
C        This subroutine will apply the heap sort algorithm to sort an array
C        into ascending order.  The array itself is unaltered.  Instead, an
C        index table is manipulated such that A(INDEX(j)) is in ascending
C        order for j=1,N.   If INDEX(1) is nonzero the index array is used
C        to specify the initial order of the array.
C
C        A Heap Sort algorithm sorts the data in two passes.  The first pass
C        arranges the data into a heap (a binary tree in which the value of
C        each parent node is greater than both of its children).  The second
C        pass carries out the final sort by pulling the greatest element off
C        of the top of the heap.  This is an N*ln(N) process on the average
C        case as well as the worst case.
C
C  REFERENCE
C
C        Press W. H., et. al., 1986, Numerical Recipes (Cambridge University
C        Press), chapter 8.
C
C  HISTORY
C        (1) MAY 88           T.G. Mattson           Original
C
C-----------------------------------------------------------------------
C
       SUBROUTINE AMX009 (A, INDEX, N)
       INTEGER N, INDEX(*), I, J, IR, L, INDXT
       REAL    A(*), Q
C
C-----------------------------------------------------------------------
C
C  Initialize the index table if appropriate.
C
        IF( INDEX(1) .EQ. 0) THEN
            DO 100 I=1,N
                INDEX(I) = I
 100        CONTINUE
        ENDIF
C
C  Begin heap sort.  The index L will be decremented to 1 during the heap
C  creation.   The index IR will be decremented to 1 during the sort off the
C  top of the heap.
C
        L  = N/2 + 1
        IR = N
 10     CONTINUE
            IF (L .GT. 1) THEN
C
C  Heap creation - get next element to place in the heap
C
                L     = L - 1
                INDXT = INDEX(L)
                Q     = A(INDXT)
            ELSE
C
C  Heap Sort - pull the elements off the top of the heap
C
                INDXT     = INDEX(IR)
                Q         = A(INDXT)
                INDEX(IR) = INDEX(1)
                IR        = IR-1
C
C  Sort Termination Test
C
                IF (IR .EQ. 1 ) THEN
                   INDEX(1) = INDXT
                   RETURN
                ENDIF
            ENDIF
C
C  The following code is used to both create the heap and to rearrange the
C  heap as the greatest elements are pulled off.   This involves "sifting down"
C  Q till it reaches its proper position.
C
            I = L
            J = L + L
 20         IF (J .LE. IR)THEN
C
C  Compare Q to the greater of the next two elements in the heap.
C
               IF ( J .LT. IR)THEN
                  IF ( A(INDEX(J)) .LT. A(INDEX(J+1)) ) J = J+1
               ENDIF
               IF ( Q .LT. A(INDEX(J)) ) THEN
                  INDEX(I) = INDEX(J)
                  I        = J
                  J        = J + J
               ELSE
C
C  If Q found its final resting place, set J for sift down termination
C
                  J = IR + 1
               ENDIF
            GO TO 20
            ENDIF
C
            INDEX(I) = INDXT
        GO TO 10
C
        END
