C*****  BLKMAN  Blackman Window Multiply          MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL BLKMAN (A,IA,C,IC,N)
C
C       where,
C
C       A       Real input vector.
C
C       IA      Integer input stride for vector A.
C
C       C       Real output vector.
C
C       IC      Integer input stride for vector C.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine multiplies a vector by a Blackman window.
C
C            C(i) = A(i) * [0.42 - 0.5*COS((i-1)*(2*PI/N))
C                   + 0.08*COS((i-1)*(4*PI/N))]    for i=1,N
C
C       where
C
C            PI = 3.14159...
C
C       Also see the descriptions for HAMM and HANN, two other
C       routines used for conditioning signals prior to
C       performing an FFT.
C
C
C  REFERENCE
C
C       R. B. Blackman and J. W. Tukey.  1958.  The measurement
C       of power spectra.  New York: Dover Publications.
C
C       L. R. Rabiner and B. Gold.  1975.  Theory and applica-
C       tion of digital signal processing.  Englewood Cliffs
C       NJ: Prentice-Hall.
C
C
C  EXAMPLE
C
C       CALL BLKMAN (A,1,C,1,5)
C
C       Input Operands:
C
C       A = 1.000
C           2.000
C           3.000
C           4.000
C           5.000
C
C
C      Output Operands:
C
C      C =  0.000
C           0.401
C           2.548
C           3.397
C           1.004
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE BLKMAN(A,IA,C,IC,N)
C
      INTEGER IA,IC,N,II,KK,M
      REAL A(1),C(1),PI,THETA
      IF (N.LE.0) GO TO 40
      PI = 8.0 * ATAN(1.0) / FLOAT(N)
      II = 1
      KK = 1
      DO 30 M=1,N
        THETA = PI * FLOAT(M-1)
        C(KK) = A(II) * (0.42 - 0.50*COS(THETA) +
     +          0.08*COS(THETA+THETA))
        II = II+IA
        KK = KK+IC
30    CONTINUE
40    RETURN
      END
