C*****  CAXPY  Complex Scalar Times a Vector Plus a Vector    MATH ADV REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CAXPY (N,CA,CX,INCX,CY,INCY)
C
C       where,
C
C       N       Integer input element count.
C
C       CA      Complex input scalar.
C
C       CX      Complex input vector.
C
C       INCX    Integer input stride for vector CX.
C
C       CY      Complex input/output vector.
C
C       INCY    Integer input stride for vector CY.
C
C
C  DESCRIPTION
C
C       This routine multiplies the elements of a complex vector CX
C       by a complex scalar CA and adds the elements of another
C       complex vector CY.  The results are stored back in complex
C       vector CY.
C
C       CY(i) = (CA * CX(i)) + CY(i)      for i=1,N
C
C  REFERENCE
C
C       J.J. Dongarra and C.B. Moler, J.R. Bunch, G.W. Stewart.  1979.
C       LINPACK Users' Guide.  Appendix A: Basic Linear Algebra Subprograms.
C       SIAM
C
C
C  EXAMPLE
C
C       CALL CAXPY (2,CA,CX,1,CY,1)
C
C       Input Operands:
C
C       CA =  (1.000,2.000)
C
C       CX =  (1.000,-2.000)
C             (3.000,4.000)
C
C       CY = (10.000,20.000)
C            (30.000,40.000)
C
C       Output Operands:
C
C       CY = (15.000,20.000)
C            (25.000,50.000)
C
C  HISTORY
C         1) Jan 88     L. Shanbeck     Original.
C
C
      SUBROUTINE CAXPY(N,CA,CX,INCX,CY,INCY)
C
      COMPLEX CA,CX(1),CY(1)
      INTEGER N,INCX,INCY,II,KK,M
      IF (N.LE.0 .OR. CA.EQ.(0.0,0.0)) GO TO 40
      II = 1
      KK = 1
      IF (INCX.LT.0) II = (-N+1)*INCX + 1
      IF (INCY.LT.0) KK = (-N+1)*INCY + 1
      DO 10 M=1,N
        CY(KK) = CA*CX(II) + CY(KK)
        II = II+INCX
        KK = KK+INCY
10    CONTINUE
40    RETURN
      END
