C*****  CDOTC    Complex Vector Dot Product Conjugate Function  MATH ADV REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CW = CDOTC (N,CX,INCX,CY,INCY)
C
C       where,
C
C       N       Integer input element count.
C
C       CX      Complex input vector.
C
C       INCX    Integer input stride for vector CX.
C
C       CY      Complex output vector.
C
C       INCY    Integer input stride for vector CY.
C
C
C  DESCRIPTION
C
C       This function returns the dot product of the conjugated elements
C       of vector CX and the unconjugated elements of vector CY.
C
C       CDOTC = sum of CONJG(CX(i))*CY(i)     for i=1,N
C
C  REFERENCE
C
C       J.J. Dongarra and C.B. Moler, J.R. Bunch, G.W. Stewart.  1979.
C       LINPACK Users' Guide.  Appendix A: Basic Linear Algebra Subprograms.
C       SIAM
C
C
C  EXAMPLE
C
C       CW = CDOTC (2,CX,1,CY,1)
C
C       Input Operands:
C
C       CX =  (1.000,2.000)
C             (3.000,4.000)
C
C       CY =  (3.000,6.000)
C             (-12.000,9.000)
C
C       Output Result:
C
C       CW = (15.000,75.000)
C
C  HISTORY
C         1) Jan 88     L. Shanbeck     Original.
C
C
      COMPLEX FUNCTION CDOTC(N,CX,INCX,CY,INCY)
C
      COMPLEX CX(1),CY(1),CTEMP
      INTEGER N,INCX,INCY,II,KK,M
C
      CTEMP = (0.0,0.0)
      IF (N.LE.0) GO TO 40
      II = 1
      KK = 1
      IF (INCX.LT.0) II = (-N+1)*INCX + 1
      IF (INCY.LT.0) KK = (-N+1)*INCY + 1
      DO 10 M=1,N
        CTEMP = CTEMP + CONJG(CX(II))*CY(KK)
        II = II+INCX
        KK = KK+INCY
10    CONTINUE
40    CDOTC = CTEMP
      RETURN
      END
