C*****  CDOTPR  Complex Dot Product               MATH ADVANTAGE REL 3.0
C
C    ** COPYRIGHT 1984-1985 QUANTITATIVE TECHNOLOGY CORPORATION **
C
C  CALL FORMAT
C
C       CALL CDOTPR (A,IA,B,IB,C,N)
C
C       where,
C
C       A       Complex input vector.
C
C       IA      Integer input stride for vector A.
C
C       B       Complex input vector.
C
C       IB      Integer input stride for vector B.
C
C       C       Complex output scalar.
C
C       N       Integer input element count.
C
C
C  DESCRIPTION
C
C       This routine computes the dot product of two
C       complex vectors, A and B, and stores the results
C       in complex scalar C.
C
C            real(C) = SUM[real(A(i))*real(B(i))
C                          - imag(A(i))*imag(B(i))]
C            imag(C) = SUM[real(A(i))*imag(B(i))
C                          + imag(A(i))*real(B(i))]
C            for i=1,N
C
C  REFERENCE
C
C       J. H. Matthews.  1982.  Basic complex variables for
C       mathematics and engineering.  New York: Allyn and
C       Bacon.
C
C
C  EXAMPLE
C
C       CALL CDOTPR (A,2,B,2,C,2)
C
C       Input Operands:
C
C       A = (1.000,2.000)
C           (3.000,4.000)
C
C       B = (  3.000,6.000)
C           (-12.000,9.000)
C
C       Output Operands:
C
C       C = (-81.000,-9.000)
C
C  HISTORY
C         1) Oct 84     D. Cooper       Original.
C
      SUBROUTINE CDOTPR(A,IA,B,IB,C,N)
C
      INTEGER IA,IB,N,II,JJ,M
      REAL A(1),B(1),C(1),SUMI,SUMR
      IF (N.LE.0) GO TO 12
      II = 1
      JJ = 1
      SUMR = 0.0
      SUMI = 0.0
      DO 10 M=1,N
        SUMR = SUMR + A(II)*B(JJ) - A(II+1)*B(JJ+1)
        SUMI = SUMI + A(II)*B(JJ+1) + A(II+1)*B(JJ)
        II = II+IA
        JJ = JJ+IB
10    CONTINUE
      C(1) = SUMR
      C(2) = SUMI
12    RETURN
      END
